/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.starter.repository.TemplateGroupRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplatePropertyRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateRelationRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateGroupService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemService;
import com.bizunited.platform.kuiper.starter.service.internal.AbstractTemplateService;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentRelation;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="TemplateGroupServiceImpl")
public class TemplateGroupServiceImpl
extends AbstractTemplateService
implements TemplateGroupService {
    @Autowired
    private TemplateGroupRepository templateGroupRepository;
    @Autowired
    private TemplatePropertyRepository templatePropertyRepository;
    @Autowired
    private TemplateRelationRepository templateRelationRepository;
    @Autowired
    private NebulaStaticPersistentService nebulaStaticPersistentService;
    @Autowired
    private TemplateItemService templateItemService;

    @Override
    @Transactional
    public TemplateGroupEntity initStaticGroups(TemplateEntity parentTemplate, PersistentRelation parentRelation, PersistentClass persistentClass) {
        List persistentOneToManyRelations;
        List relations;
        String parentClassName = parentRelation.getPersistentClassName();
        TemplateGroupEntity templateGroup = new TemplateGroupEntity();
        templateGroup.setPropertyClassName(parentRelation.getPropertyClass());
        String propertyName = parentRelation.getPropertyName();
        Validate.notBlank((CharSequence)propertyName, (String)"\u5206\u7ec4\u9879\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((propertyName.length() <= 64 ? 1 : 0) != 0, (String)"\u5c5e\u6027\u540d[%s]\u7684\u957f\u5ea6\u9700\u8981\u5c0f\u4e8e64\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
        templateGroup.setParentClassName(parentClassName);
        templateGroup.setPkage(persistentClass.getPkage());
        templateGroup.setRepositoryEntity(persistentClass.getRepositoryEntity());
        templateGroup.setSimpleClassName(persistentClass.getSimpleClassName());
        templateGroup.setType("static");
        templateGroup.setParentTableName("");
        templateGroup.setTableName("");
        templateGroup.setParentTemplate(parentTemplate);
        templateGroup.setId(null);
        templateGroup.setParentTableName("");
        templateGroup.setQueryService("");
        templateGroup.setPropertyDesc(parentRelation.getPropertyDesc());
        templateGroup.setPropertyName(propertyName);
        this.templateGroupRepository.save(templateGroup);
        Set<TemplatePropertyEntity> templateProperties = this.initStaticProperties(persistentClass.getProperties());
        templateGroup.setProperties(templateProperties);
        if (!templateProperties.isEmpty()) {
            templateProperties.stream().forEach(item -> item.setCurrentGroup(templateGroup));
            this.templatePropertyRepository.saveAll(templateProperties);
            templateGroup.setProperties(templateProperties);
        }
        if ((relations = persistentClass.getRelations()) == null || relations.isEmpty()) {
            return templateGroup;
        }
        List<PersistentRelation> currentManyToRelations = relations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.ManyToOne || item.getRelationType() == PersistentRelation.RelationType.ManyToMany).collect(Collectors.toList());
        Set<TemplateRelationEntity> templateRelations = this.initStaticRelations(parentClassName, currentManyToRelations);
        templateGroup.setRelations(templateRelations);
        if (!templateRelations.isEmpty()) {
            templateRelations.stream().forEach(item -> item.setCurrentGroup(templateGroup));
            this.templateRelationRepository.saveAll(templateRelations);
            templateGroup.setRelations(templateRelations);
        }
        if ((persistentOneToManyRelations = relations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toList())) != null && !persistentOneToManyRelations.isEmpty()) {
            HashSet<TemplateItemEntity> items = new HashSet<TemplateItemEntity>();
            for (PersistentRelation persistentOneToManyRelationItem : persistentOneToManyRelations) {
                String oneToManyPersistentClassName = persistentOneToManyRelationItem.getPropertyClass();
                PersistentClass oneToManyPersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(oneToManyPersistentClassName);
                Validate.notNull((Object)oneToManyPersistentClass, (String)"\u5728\u521d\u59cb\u5316\u4e3b\u9759\u6001\u6a21\u578b\u65f6\u53d1\u73b0NULL\u5173\u8054\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u8868\u5355\u5f15\u64ce\u5f00\u53d1\u56e2\u961f!!", (Object[])new Object[0]);
                TemplateItemEntity currentTemplateItem = this.templateItemService.initStaticItems(null, templateGroup, persistentOneToManyRelationItem, oneToManyPersistentClass);
                items.add(currentTemplateItem);
            }
            templateGroup.setItemRelations(items);
        }
        return templateGroup;
    }

    private Set<TemplateRelationEntity> initStaticRelations(String parentClassName, List<PersistentRelation> persistentRelations) {
        LinkedHashSet<TemplateRelationEntity> templateRelations = new LinkedHashSet<TemplateRelationEntity>();
        for (PersistentRelation persistentRelationItem : persistentRelations) {
            TemplateRelationEntity relationModel = super.initTemplateRelationEntity(persistentRelationItem, parentClassName);
            templateRelations.add(relationModel);
        }
        return templateRelations;
    }

    private Set<TemplatePropertyEntity> initStaticProperties(List<PersistentProperty> persistentProperties) {
        LinkedHashSet<TemplatePropertyEntity> templateProperties = new LinkedHashSet<TemplatePropertyEntity>();
        for (PersistentProperty persistentProperty : persistentProperties) {
            TemplatePropertyEntity propertyEntity = super.initTemplatePropertyEntity(persistentProperty);
            templateProperties.add(propertyEntity);
        }
        return templateProperties;
    }

    @Override
    @Transactional
    public TemplateGroupEntity initDynamicGroups(TemplateGroupEntity templateGroup, TemplateEntity parentTemplate) {
        String propertyName = templateGroup.getPropertyName();
        Validate.notBlank((CharSequence)propertyName, (String)"\u5206\u7ec4\u6570\u636e\u8868\u7684\u5c5e\u6027\u540d\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String propertyClassName = templateGroup.getPropertyClassName();
        if (StringUtils.isBlank((CharSequence)propertyClassName)) {
            propertyClassName = "java.lang.String";
            templateGroup.setPropertyClassName(propertyClassName);
        }
        String propertyDesc = templateGroup.getPropertyDesc();
        Validate.notBlank((CharSequence)propertyDesc, (String)"\u5206\u7ec4\u6570\u636e\u8868\u7684\u5c5e\u6027\u8bf4\u660e\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        String groupType = templateGroup.getType();
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)groupType, (CharSequence)"dynamic"), (String)"\u5206\u7ec4\u6570\u636e\u8868\u7684\u7c7b\u578b\u5fc5\u987b\u662f\u52a8\u6001\u6570\u636e\u8868\uff08dynamic\uff09", (Object[])new Object[0]);
        String groupTableName = templateGroup.getTableName();
        Validate.notBlank((CharSequence)groupTableName, (String)"\u5206\u7ec4\u6570\u636e\u8868\u7684\u6570\u636e\u8bf4\u660e\u4fe1\u606f\u5fc5\u987b\u6307\u5b9a!!", (Object[])new Object[0]);
        templateGroup.setId(null);
        templateGroup.setParentTemplate(parentTemplate);
        String parentTableName = parentTemplate.getTableName();
        templateGroup.setParentTableName(parentTableName);
        templateGroup.setRepositoryEntity(Boolean.valueOf(true));
        templateGroup.setSimpleClassName("");
        templateGroup.setQueryService("");
        templateGroup.setParentClassName("");
        templateGroup.setPkage("");
        this.templateGroupRepository.save(templateGroup);
        Set templateProperties = templateGroup.getProperties();
        this.initDynamicProperties(templateGroup, templateProperties);
        Set templateRelations = templateGroup.getRelations();
        this.initDynamicRelations(templateGroup, templateRelations);
        Set templateItems = templateGroup.getItemRelations();
        if (templateItems != null && !templateItems.isEmpty()) {
            for (TemplateItemEntity templateItem : templateItems) {
                this.templateItemService.initDynamicItems(templateItem, null, templateGroup, groupTableName);
            }
        }
        return templateGroup;
    }

    @Override
    public TemplateGroupEntity findParentById(String templateGroupId) {
        if (StringUtils.isBlank((CharSequence)templateGroupId)) {
            return null;
        }
        return this.templateGroupRepository.findParentById(templateGroupId);
    }

    private void initDynamicProperties(TemplateGroupEntity currentGroup, Set<TemplatePropertyEntity> properties) {
        for (TemplatePropertyEntity templateProperty : properties) {
            templateProperty.setId(null);
            templateProperty.setCurrentTemplate(null);
            templateProperty.setCurrentGroup(currentGroup);
            templateProperty.setCurrentItem(null);
            this.templatePropertyRepository.save(templateProperty);
        }
    }

    private void initDynamicRelations(TemplateGroupEntity currentGroup, Set<TemplateRelationEntity> relations) {
        if (relations == null || relations.isEmpty()) {
            return;
        }
        for (TemplateRelationEntity templateRelation : relations) {
            templateRelation.setId(null);
            templateRelation.setCurrentGroup(currentGroup);
            templateRelation.setCurrentItem(null);
            templateRelation.setCurrentTemplate(null);
            templateRelation.setQueryService("");
            this.templateRelationRepository.save(templateRelation);
        }
    }
}

