/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import com.bizunited.platform.kuiper.starter.repository.TemplateItemExcelRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateItemExcelService;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="TemplateItemExcelServiceImpl")
public class TemplateItemExcelServiceImpl
implements TemplateItemExcelService {
    @Autowired
    private TemplateItemExcelRepository templateItemExcelRepository;
    @Autowired
    private NebulaFileService fileUpdateService;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public TemplateItemExcelEntity save(TemplateItemExcelEntity templateItemExcelEntity) {
        Validate.notNull((Object)templateItemExcelEntity, (String)"\u521b\u5efa\u65f6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateItemExcelEntity.getTemplateId(), (String)"\u521b\u5efa\u65f6\u8868\u5355\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateItemExcelEntity.getTemplateItemId(), (String)"\u521b\u5efa\u65f6\u8868\u5355\u660e\u7ec6\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateItemExcelEntity.getFileName(), (String)"\u521b\u5efa\u65f6\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateItemExcelEntity.getOriginalFileName(), (String)"\u521b\u5efa\u65f6\u4e0a\u4f20\u6587\u4ef6\u539f\u59cb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateItemExcelEntity.getFilePath(), (String)"\u521b\u5efa\u65f6\u4e0a\u4f20\u6587\u4ef6\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)templateItemExcelEntity.getCreateDate(), (String)"\u521b\u5efa\u65f6\u4e0a\u4f20\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TemplateItemExcelEntity exist = this.templateItemExcelRepository.findByTemplateItemId(templateItemExcelEntity.getTemplateItemId());
        if (null != exist) {
            this.delete(exist.getId());
        }
        return (TemplateItemExcelEntity)this.templateItemExcelRepository.save(templateItemExcelEntity);
    }

    @Override
    public List<TemplateItemExcelEntity> findByTemplate(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return new ArrayList<TemplateItemExcelEntity>();
        }
        return this.templateItemExcelRepository.findByTemplateId(templateId);
    }

    @Override
    public List<TemplateItemExcelEntity> findByTemplateGroup(String templateGroupId) {
        if (StringUtils.isBlank((CharSequence)templateGroupId)) {
            return new ArrayList<TemplateItemExcelEntity>();
        }
        return this.templateItemExcelRepository.findByTemplateGroupId(templateGroupId);
    }

    @Override
    public TemplateItemExcelEntity findByTemplateItem(String templateItemId) {
        if (StringUtils.isBlank((CharSequence)templateItemId)) {
            return null;
        }
        return this.templateItemExcelRepository.findByTemplateItemId(templateItemId);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void delete(String templateItemExcelEntityId) {
        TemplateItemExcelEntity excelEntity = this.templateItemExcelRepository.findById(templateItemExcelEntityId).orElse(null);
        if (excelEntity == null) {
            return;
        }
        this.fileUpdateService.deleteFile(excelEntity.getFilePath(), excelEntity.getOriginalFileName(), excelEntity.getFileName());
        this.templateItemExcelRepository.deleteById(templateItemExcelEntityId);
        this.templateItemExcelRepository.flush();
    }
}

