/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.migrate;

import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import com.bizunited.platform.kuiper.entity.ListTemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.service.FrontFileSevice;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.ListTemplateService;
import com.bizunited.platform.kuiper.starter.service.TemplateEventService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemExcelService;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import com.bizunited.platform.kuiper.starter.service.migrate.TemplateMigrateExportService;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="TemplateMigrateExportServiceImpl")
public class TemplateMigrateExportServiceImpl
implements TemplateMigrateExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateMigrateExportServiceImpl.class);
    @Autowired
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private TemplateLayoutService templateLayoutService;
    @Autowired
    private TemplateEventService templateEventService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private FrontFileSevice frontFileSevice;
    @Autowired
    private TemplateItemExcelService templateItemExcelService;
    @Autowired
    private ListTemplateService listTemplateService;

    @Override
    public byte[] export(String[] templateFormIds, String[] listTemplateIds, String[] frontFileIds, Boolean[] exportItems) {
        int frontFileSize;
        Validate.isTrue((templateFormIds != null && templateFormIds.length > 0 || listTemplateIds != null && listTemplateIds.length > 0 || frontFileIds != null && frontFileIds.length > 0 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u9700\u8981\u5bfc\u51fa\u4e00\u4e2a\u8868\u5355\u6a21\u677f\u6216\u8005\u5217\u8868\u6a21\u677f\u6216\u8005\u524d\u7aef\u5934\u51fd\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        int formSize = templateFormIds == null ? 0 : templateFormIds.length;
        int listSize = listTemplateIds == null ? 0 : listTemplateIds.length;
        int n = frontFileSize = frontFileIds == null ? 0 : frontFileIds.length;
        if (formSize > 0) {
            Validate.notNull((Object)exportItems, (String)"\u5f53\u8fdb\u884c\u8868\u5355\u6a21\u677f\u7684\u5bfc\u51fa\u65f6\uff0c\u5fc5\u987b\u8bbe\u5b9a\u6bcf\u4e00\u4e2a\u8868\u5355\u9700\u8981\u5bfc\u51fa\u7684\u6a21\u677f\u5e03\u5c40\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((formSize * 3 == exportItems.length ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u8868\u5355\u6a21\u677f\u7684\u5bfc\u51fa\u65f6\uff0c\u5fc5\u987b\u8bbe\u5b9a\u6bcf\u4e00\u4e2a\u8868\u5355\u9700\u8981\u5bfc\u51fa\u7684\u6a21\u677f\u5e03\u5c40\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((this.templateService.countByIds(templateFormIds) == formSize ? 1 : 0) != 0, (String)"\u6307\u5b9a\u5bfc\u51fa\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f\u4e0e\u6570\u636e\u5e93\u5b58\u50a8\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        }
        if (listSize > 0) {
            Validate.isTrue((this.listTemplateService.countByIds(listTemplateIds) == listSize ? 1 : 0) != 0, (String)"\u6307\u5b9a\u5bfc\u51fa\u7684\u5217\u8868\u6a21\u677f\u4fe1\u606f\u4e0e\u6570\u636e\u5e93\u5b58\u50a8\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        }
        if (frontFileSize > 0) {
            Validate.isTrue((this.frontFileSevice.countByIds(frontFileIds) == frontFileSize ? 1 : 0) != 0, (String)"\u6307\u5b9a\u5bfc\u51fa\u7684\u524d\u7aef\u5934\u51fd\u6570\u4fe1\u606f\u4e0e\u6570\u636e\u5e93\u5b58\u50a8\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        }
        byte[] fullZipBytes = null;
        try (ByteArrayOutputStream fullZipBis = new ByteArrayOutputStream();
             ZipOutputStream zipf = new ZipOutputStream(fullZipBis);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeInt(formSize);
            oos.writeInt(listSize);
            oos.writeInt(frontFileSize);
            if (formSize > 0 && templateFormIds != null) {
                this.handleTemplateFormExport(zipf, oos, templateFormIds, exportItems);
                this.handleTemplateEventFilesExport(zipf, templateFormIds);
            }
            if (listSize > 0 && listTemplateIds != null) {
                this.handleListTemplateExport(zipf, oos, listTemplateIds);
            }
            if (frontFileSize > 0 && frontFileIds != null) {
                this.handleFrontFileExport(zipf, oos, frontFileIds);
            }
            String zipFileName = "serial.in";
            byte[] bosBytes = bos.toByteArray();
            this.writeToZip(zipf, "", zipFileName, bosBytes);
            zipf.finish();
            fullZipBytes = fullZipBis.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        return fullZipBytes;
    }

    private void handleTemplateFormExport(ZipOutputStream zipf, ObjectOutputStream oos, String[] templateFormIds, Boolean[] exportItems) throws IOException {
        for (int index = 0; templateFormIds != null && index < templateFormIds.length; ++index) {
            String fileRename;
            TemplateItemExcelEntity current;
            String templateFormId = templateFormIds[index];
            boolean exportPc = exportItems[index * 3];
            boolean exportMobile = exportItems[index * 3 + 1];
            boolean exportPrinter = exportItems[index * 3 + 2];
            TemplateEntity currentTemplate = this.templateService.findDetailsById(templateFormId);
            Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateFormId});
            String templateId = currentTemplate.getId();
            HashSet visibilites = this.templateVisibilityService.findDetailsByTemplateId(templateFormId);
            if (visibilites == null) {
                visibilites = Sets.newHashSet();
            }
            Collection cvisibilites = this.kuiperToolkitService.copyCollectionByWhiteList(visibilites, TemplateVisibilityEntity.class, TemplateVisibilityEntity.class, HashSet.class, ArrayList.class, new String[]{"template", "attributes", "buttons"});
            currentTemplate.setVisibility(new HashSet(cvisibilites));
            HashSet events = this.templateEventService.findDetailsByTemplateId(templateFormId);
            if (events == null) {
                events = Sets.newHashSet();
            }
            Collection cevents = this.kuiperToolkitService.copyCollectionByWhiteList(events, TemplateEventEntity.class, TemplateEventEntity.class, HashSet.class, ArrayList.class, new String[]{"template"});
            currentTemplate.setEvent(new HashSet(cevents));
            Set<TemplateLayoutEntity> templateLayouts = this.templateLayoutService.findByTemplateId(templateId);
            Validate.notNull(templateLayouts, (String)"\u8868\u5355\u6a21\u677f[%s]\u672a\u53d1\u73b0\u4efb\u4f55\u5e03\u5c40\u7ed3\u6784\u4fe1\u606f\uff0c\u65e0\u6cd5\u8fdb\u884c\u5bfc\u51fa\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateId});
            Validate.isTrue((!templateLayouts.isEmpty() ? 1 : 0) != 0, (String)"\u8868\u5355\u6a21\u677f[%s]\u672a\u53d1\u73b0\u4efb\u4f55\u5e03\u5c40\u7ed3\u6784\u4fe1\u606f\uff0c\u65e0\u6cd5\u8fdb\u884c\u5bfc\u51fa\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateId});
            int exportLayoutSize = 0;
            for (TemplateLayoutEntity currentLayout : templateLayouts) {
                if (!(currentLayout.getLayoutType() == 1 && exportPc || currentLayout.getLayoutType() == 2 && exportMobile) && (currentLayout.getLayoutType() != 3 || !exportPrinter)) continue;
                ++exportLayoutSize;
            }
            Validate.isTrue((exportLayoutSize > 0 ? 1 : 0) != 0, (String)String.format("\u5f53\u524d\u8868\u5355\u6a21\u677f[%s]\u81f3\u5c11\u9700\u8981\u6307\u5b9a\u4e00\u4e2a\u5e03\u5c40\u7ed3\u6784\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!", currentTemplate.getName()), (Object[])new Object[0]);
            oos.writeObject(currentTemplate);
            oos.writeInt(exportLayoutSize);
            List<TemplateItemExcelEntity> itemExcels = this.templateItemExcelService.findByTemplate(templateId);
            int itemExcelsCount = itemExcels == null ? 0 : itemExcels.size();
            oos.writeInt(itemExcelsCount);
            for (TemplateLayoutEntity currentLayout : templateLayouts) {
                if (currentLayout.getLayoutType() == 1 && !exportPc || currentLayout.getLayoutType() == 2 && !exportMobile || currentLayout.getLayoutType() == 3 && !exportPrinter) continue;
                current = (TemplateLayoutEntity)this.kuiperToolkitService.copyObjectByWhiteList(currentLayout, TemplateLayoutEntity.class, HashSet.class, LinkedList.class, new String[0]);
                oos.writeObject(current);
                String relativePath = current.getRelativePath();
                fileRename = current.getFileName();
                byte[] templateLayoutContents = this.nebulaFileService.readFileContent(relativePath, fileRename);
                Validate.notNull((Object)templateLayoutContents, (String)"\u672a\u83b7\u53d6\u5230\u6a21\u677f\u6587\u4ef6[%s]\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7cfb\u7edf\uff01\uff01", (Object[])new Object[]{fileRename});
                this.writeToZip(zipf, relativePath, fileRename, templateLayoutContents);
            }
            for (TemplateItemExcelEntity itemExcel : itemExcels) {
                current = (TemplateItemExcelEntity)this.kuiperToolkitService.copyObjectByWhiteList(itemExcel, TemplateItemExcelEntity.class, HashSet.class, LinkedList.class, new String[0]);
                oos.writeObject(current);
                String filePath = itemExcel.getFilePath();
                fileRename = itemExcel.getFileName();
                byte[] itemExcelContents = this.nebulaFileService.readFileContent(filePath, fileRename);
                Validate.notNull((Object)itemExcelContents, (String)"\u672a\u83b7\u53d6\u5230excel\u6a21\u677f\u6587\u4ef6[%s]\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7cfb\u7edf\uff01\uff01", (Object[])new Object[]{fileRename});
                this.writeToZip(zipf, filePath, fileRename, itemExcelContents);
            }
        }
    }

    private void handleTemplateEventFilesExport(ZipOutputStream zipf, String[] templateFormIds) throws IOException {
        String templateFormId;
        List<TemplateEventEntity> templateEvents;
        if (templateFormIds == null || templateFormIds.length == 0) {
            return;
        }
        String[] stringArray = templateFormIds;
        int n = stringArray.length;
        for (int i = 0; i < n && (templateEvents = this.templateEventService.findByTemplateId(templateFormId = stringArray[i])) != null; ++i) {
            for (TemplateEventEntity templateEvent : templateEvents) {
                String relativePath = templateEvent.getRelativePath();
                String fileRename = templateEvent.getFileName();
                byte[] contents = this.nebulaFileService.readFileContent(relativePath, fileRename);
                this.writeToZip(zipf, relativePath, fileRename, contents);
            }
        }
    }

    private void handleListTemplateExport(ZipOutputStream zipf, ObjectOutputStream oos, String[] listTemplateIds) throws IOException {
        for (int index = 0; listTemplateIds != null && index < listTemplateIds.length; ++index) {
            String listTemplateId = listTemplateIds[index];
            ListTemplateEntity currentListTemplate = this.listTemplateService.findDetailsById(listTemplateId);
            Validate.notNull((Object)currentListTemplate, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5217\u8868\u6a21\u677f\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{listTemplateId});
            currentListTemplate = (ListTemplateEntity)this.kuiperToolkitService.copyObjectByWhiteList(currentListTemplate, ListTemplateEntity.class, HashSet.class, LinkedList.class, new String[0]);
            oos.writeObject(currentListTemplate);
            String fileName = currentListTemplate.getFileName();
            String relativePath = currentListTemplate.getRelativePath();
            byte[] contents = this.nebulaFileService.readFileContent(relativePath, fileName);
            this.writeToZip(zipf, relativePath, fileName, contents);
        }
    }

    private void handleFrontFileExport(ZipOutputStream zipf, ObjectOutputStream oos, String[] frontFileIds) throws IOException {
        for (int index = 0; index < frontFileIds.length; ++index) {
            String frontFileId = frontFileIds[index];
            FrontFileEntity currentFrontFile = this.frontFileSevice.findById(frontFileId);
            Validate.notNull((Object)currentFrontFile, (String)"\u5e76\u672a\u627e\u5230\u7f16\u53f7[%s]\u7684\u524d\u7aef\u5934\u51fd\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{frontFileId});
            String relativePath = currentFrontFile.getFilePath();
            String fileRename = currentFrontFile.getFileName();
            byte[] templateLayoutContents = this.nebulaFileService.readFileContent(relativePath, fileRename);
            Validate.notNull((Object)templateLayoutContents, (String)"\u672a\u627e\u5230\u6307\u5b9a\u6587\u4ef6\u7684\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
            oos.writeObject(currentFrontFile);
            this.writeToZip(zipf, relativePath, fileRename, templateLayoutContents);
        }
    }

    private void writeToZip(ZipOutputStream zipf, String relativePath, String fileRename, byte[] contents) throws IOException {
        String fullRelativePath = StringUtils.isBlank((CharSequence)relativePath) ? fileRename : StringUtils.join((Object[])new String[]{relativePath, "/", fileRename});
        if (fullRelativePath.indexOf(47) == 0 || fullRelativePath.indexOf(92) == 0) {
            fullRelativePath = StringUtils.substring((String)fullRelativePath, (int)1);
        }
        try (ByteArrayInputStream layoutcis = new ByteArrayInputStream(contents);){
            ZipEntry zipEntry = new ZipEntry(fullRelativePath);
            zipf.putNextEntry(zipEntry);
            int maxLen = 9060;
            byte[] fileContents = new byte[maxLen];
            int realLen = 0;
            while ((realLen = ((InputStream)layoutcis).read(fileContents, 0, maxLen)) != -1) {
                zipf.write(fileContents, 0, realLen);
            }
        }
    }
}

