/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.configuration;

import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.invoke.handle.request.PrincipalHandle;
import com.bizunited.platform.core.service.invoke.handle.request.TransactionalHandle;
import com.bizunited.platform.core.service.serviceable.handle.ServicableInvokeHandle;
import com.bizunited.platform.core.service.serviceable.handle.SpringMVCResponseHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.StaticFormDetailsRecordHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.StaticInstanceActivityUpdateHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.StaticInstanceDetailsLogUpdateHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class StaticFormProxyConfig {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PrincipalHandle principalHandle;
    @Autowired
    private TransactionalHandle transactionalHandle;
    @Autowired
    private ServicableInvokeHandle servicableInvokeHandle;
    @Autowired
    private StaticInstanceActivityUpdateHandle staticInstanceActivityUpdateHandle;
    @Autowired
    private StaticInstanceDetailsLogUpdateHandle staticInstanceDetailsLogUpdateHandle;
    @Autowired
    private SpringMVCResponseHandle springMVCResponseHandle;

    @Bean(value={"WriteServicableProxy"})
    @Scope(value="prototype")
    @ConditionalOnMissingBean(name={"WriteServicableProxy"})
    public InvokeProxy getWriteServicableProxy() {
        InvokeProxy.Build build = new InvokeProxy.Build();
        build.addClassLoader(this.applicationContext.getClassLoader());
        build.addInvokeRequestFilter(new InvokeRequestHandle[]{this.principalHandle, this.transactionalHandle, this.getBeforeStaticFormDetailsRecordHandle(), this.servicableInvokeHandle});
        build.addInvokeResponseFilter(new InvokeResponseHandle[]{this.getAfterStaticFormDetailsRecordHandle(), this.staticInstanceDetailsLogUpdateHandle, this.staticInstanceActivityUpdateHandle, this.springMVCResponseHandle});
        return build.build();
    }

    @Bean(value={"ReadServicableProxy"})
    @Scope(value="prototype")
    public InvokeProxy getReadServicableProxy() {
        InvokeProxy.Build build = new InvokeProxy.Build();
        build.addClassLoader(this.applicationContext.getClassLoader());
        build.addInvokeRequestFilter(new InvokeRequestHandle[]{this.principalHandle, this.servicableInvokeHandle});
        build.addInvokeResponseFilter(new InvokeResponseHandle[]{this.springMVCResponseHandle});
        return build.build();
    }

    @Bean(value={"BeforeStaticFormDetailsRecordHandle"})
    public StaticFormDetailsRecordHandle getBeforeStaticFormDetailsRecordHandle() {
        StaticFormDetailsRecordHandle formDetailsRecordHandle = new StaticFormDetailsRecordHandle();
        formDetailsRecordHandle.setbefore(true);
        return formDetailsRecordHandle;
    }

    @Bean(value={"AfterStaticFormDetailsRecordHandle"})
    public StaticFormDetailsRecordHandle getAfterStaticFormDetailsRecordHandle() {
        StaticFormDetailsRecordHandle formDetailsRecordHandle = new StaticFormDetailsRecordHandle();
        formDetailsRecordHandle.setbefore(false);
        return formDetailsRecordHandle;
    }
}

