/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import com.bizunited.platform.kuiper.starter.service.FrontFileSevice;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/kuiper/frontFiles"})
public class FrontFileController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontFileController.class);
    @Autowired
    private FrontFileSevice frontFileSevice;

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public ResponseModel create(@RequestParam @ApiParam(name="frontFileStr", value="\u5b9e\u4f53json") String frontFileStr, @RequestParam @ApiParam(name="fileContent", value="\u6587\u4ef6\u5185\u5bb9") String fileContent) {
        try {
            FrontFileEntity frontFileEntity = this.frontFileSevice.create(frontFileStr, fileContent);
            return this.buildHttpResultW(frontFileEntity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539")
    @PatchMapping(value={"/update"})
    public ResponseModel update(@RequestParam @ApiParam(name="frontFileStr", value="\u5b9e\u4f53json") String frontFileStr, @RequestParam @ApiParam(name="fileContent", value="\u6587\u4ef6\u5185\u5bb9") String fileContent) {
        try {
            FrontFileEntity frontFileEntity = this.frontFileSevice.update(frontFileStr, fileContent);
            return this.buildHttpResultW(frontFileEntity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@RequestParam @ApiParam(name="name", value="name") String name, @RequestParam @ApiParam(name="classify", value="classify") String classify, @RequestParam @ApiParam(name="status", value="status") Integer status, Pageable pageable) {
        try {
            Page<FrontFileEntity> page = this.frontFileSevice.queryPage(pageable, name, classify, status);
            return this.buildHttpResultW(page, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    public ResponseModel disable(@RequestParam @ApiParam(name="frontFileId", value="frontFileId") String frontFileId) {
        try {
            FrontFileEntity frontFileEntity = this.frontFileSevice.disable(frontFileId);
            return this.buildHttpResultW(frontFileEntity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u542f\u7528\u7528")
    @PostMapping(value={"/enable"})
    public ResponseModel enable(@RequestParam @ApiParam(name="frontFileId", value="frontFileId") String frontFileId) {
        try {
            FrontFileEntity frontFileEntity = this.frontFileSevice.enable(frontFileId);
            return this.buildHttpResultW(frontFileEntity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9")
    @GetMapping(value={"/findContentById"})
    public ResponseModel findContentById(@RequestParam @ApiParam(name="frontFileId", value="frontFileId") String frontFileId) {
        try {
            String content = this.frontFileSevice.findContentById(frontFileId);
            return this.buildHttpResultW(content, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u540d\u79f0\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9")
    @GetMapping(value={"/findContentByName"})
    public ResponseModel findContentByName(@RequestParam @ApiParam(name="frontFileName", value="frontFileName") String frontFileName) {
        try {
            String content = this.frontFileSevice.findContentByName(frontFileName);
            return this.buildHttpResultW(content, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

