/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.core.repository.internal.PageRepositoryImpl;
import com.bizunited.platform.kuiper.entity.ListTemplateEntity;
import com.bizunited.platform.kuiper.starter.repository.internal.ListTemplateRepositoryCustom;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="ListTemplateRepositoryImpl")
public class ListTemplateRepositoryImpl
implements ListTemplateRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String CVERSION = "cversion";
    private static final String MESS_MODIFY_START = "modifyStart";
    private static final String MESS_MODIFY_END = "modifyEnd";

    @Override
    public Page<ListTemplateEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        String projectName;
        Object modifyEnd;
        Object modifyStart;
        Object name;
        Object cversion;
        StringBuilder hql = new StringBuilder("from ListTemplateEntity le left join fetch le.creator c where 1= 1  ");
        StringBuilder countHql = new StringBuilder("select count(*) from ListTemplateEntity le where 1 = 1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Object code = conditions.get("code");
        if (code != null) {
            condition.append(" AND le.code like CONCAT('%', :code, '%')");
            parameters.put("code", code);
        }
        if ((cversion = conditions.get(CVERSION)) != null) {
            condition.append(" AND le.cversion = :cversion ");
            parameters.put(CVERSION, cversion);
        }
        if ((name = conditions.get("name")) != null) {
            condition.append(" AND le.name like CONCAT('%', :name, '%')");
            parameters.put("name", name);
        }
        if ((modifyStart = conditions.get(MESS_MODIFY_START)) != null) {
            condition.append(" AND DATE_FORMAT ( le.modifyTime, '%Y-%m-%d' ) >= :modifyStart ");
            parameters.put(MESS_MODIFY_START, modifyStart);
        }
        if ((modifyEnd = conditions.get(MESS_MODIFY_END)) != null) {
            condition.append(" AND DATE_FORMAT ( le.modifyTime, '%Y-%m-%d' ) <= :modifyEnd ");
            parameters.put(MESS_MODIFY_END, modifyEnd);
        }
        if (StringUtils.isNotBlank((CharSequence)(projectName = (String)conditions.get("projectName")))) {
            condition.append(" AND le.projectName = :projectName");
            parameters.put("projectName", projectName);
        } else {
            condition.append(" AND (le.projectName = '' or le.projectName is null)");
        }
        hql.append((CharSequence)condition).append(" order by le.createTime desc ");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }
}

