/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.core.repository.internal.PageRepositoryImpl;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.starter.repository.internal.TemplateRepositoryCustom;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="TemplateRepositoryImpl")
public class TemplateRepositoryImpl
implements TemplateRepositoryCustom,
PageRepositoryImpl {
    private static final String MESS_DEFAULT_VERSION = "isDefault";
    private static final String MESS_DOMAIN = "domain";
    private static final String MESS_PROJECT_NAME = "projectName";
    private static final String MESS_CVERSION = "cversion";
    private static final String MESS_CODE = "code";
    private static final String MESS_TSTATUS = "tstatus";
    private static final String MESS_TYPE = "type";
    private static final String MESS_CREATE_START = "createStart";
    private static final String MESS_CREATE_END = "createEnd";
    private static final String MESS_MODIFY_START = "modifyStart";
    private static final String MESS_MODIFY_END = "modifyEnd";
    private static final String MESS_NAME = "name";
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<TemplateEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        String projectName;
        String name;
        Object createEnd;
        Object createStart;
        String modifyEnd;
        String modifyStart;
        String type;
        Object tstatus;
        String code;
        String cversion;
        String domain;
        StringBuilder hql = new StringBuilder("from TemplateEntity te left join fetch te.creator c left join fetch te.maintainers tem where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from TemplateEntity te where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        Object isDefault = conditions.get(MESS_DEFAULT_VERSION);
        if (isDefault != null) {
            condition.append(" AND te.defaultVersion = :defaultVersion ");
            parameter.put("defaultVersion", isDefault);
        }
        if (StringUtils.isNotBlank((CharSequence)(domain = (String)conditions.get(MESS_DOMAIN)))) {
            condition.append(" AND te.domain = :domain ");
            parameter.put(MESS_DOMAIN, domain);
        }
        if (StringUtils.isNotBlank((CharSequence)(cversion = (String)conditions.get(MESS_CVERSION)))) {
            condition.append(" AND te.cversion = :cversion ");
            parameter.put(MESS_CVERSION, cversion);
        }
        if (StringUtils.isNotBlank((CharSequence)(code = (String)conditions.get(MESS_CODE)))) {
            condition.append(" AND te.code = :code ");
            parameter.put(MESS_CODE, code);
        }
        if ((tstatus = conditions.get(MESS_TSTATUS)) != null) {
            condition.append(" AND te.tstatus = :tstatus ");
            parameter.put(MESS_TSTATUS, tstatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(type = (String)conditions.get(MESS_TYPE)))) {
            condition.append(" AND te.type = :type ");
            parameter.put(MESS_TYPE, type);
        }
        if (StringUtils.isNotBlank((CharSequence)(modifyStart = (String)conditions.get(MESS_MODIFY_START)))) {
            condition.append(" AND  DATE_FORMAT ( te.modifyTime, '%Y-%m-%d' ) >= :modifyStart ");
            parameter.put(MESS_MODIFY_START, modifyStart);
        }
        if (StringUtils.isNotBlank((CharSequence)(modifyEnd = (String)conditions.get(MESS_MODIFY_END)))) {
            condition.append(" AND DATE_FORMAT ( te.modifyTime, '%Y-%m-%d' ) <= :modifyEnd ");
            parameter.put(MESS_MODIFY_END, modifyEnd);
        }
        if ((createStart = conditions.get(MESS_CREATE_START)) != null) {
            condition.append(" AND te.createTime >= :createStart ");
            parameter.put(MESS_CREATE_START, createStart);
        }
        if ((createEnd = conditions.get(MESS_CREATE_END)) != null) {
            condition.append(" AND te.createTime <= :createEnd ");
            parameter.put(MESS_CREATE_END, createEnd);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = (String)conditions.get(MESS_NAME)))) {
            condition.append(" AND te.name like CONCAT('%',:name,'%') ");
            parameter.put(MESS_NAME, name);
        }
        if (StringUtils.isNotBlank((CharSequence)(projectName = (String)conditions.get(MESS_PROJECT_NAME)))) {
            condition.append(" AND te.projectName = :projectName ");
            parameter.put(MESS_PROJECT_NAME, projectName);
        } else {
            condition.append(" AND (te.projectName = '' or te.projectName is null)");
        }
        hql.append((CharSequence)condition).append(" ORDER BY te.createTime desc ");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }
}

