/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository.template.migrate;

import com.bizunited.platform.core.repository.internal.PageRepositoryImpl;
import com.bizunited.platform.kuiper.entity.TemplateMigrateImportEntity;
import com.bizunited.platform.kuiper.starter.repository.template.migrate.TemplateMigrateImportRepositoryCustom;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="TemplateMigrateImportRepositoryImpl")
public class TemplateMigrateImportRepositoryImpl
implements TemplateMigrateImportRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String FILENAME = "fileName";
    private static final String CREATOR = "creator";
    private static final String EXECUTOR = "executor";
    private static final String EXECUTED = "executed";

    @Override
    public Page<TemplateMigrateImportEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        String projectName;
        Object executor;
        Object executed;
        Object creator;
        Object fileName;
        StringBuilder hql = new StringBuilder("from TemplateMigrateImportEntity u left join fetch u.creator left join fetch u.executor where 1 = 1");
        StringBuilder countHql = new StringBuilder("select count(1) from TemplateMigrateImportEntity u  left join u.creator left join u.executor  where 1 = 1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Object code = conditions.get("code");
        if (code != null) {
            condition.append(" AND u.code = :code ");
            parameters.put("code", code);
        }
        if ((fileName = conditions.get(FILENAME)) != null) {
            condition.append(" AND u.fileName = :fileName ");
            parameters.put(FILENAME, fileName);
        }
        if ((creator = conditions.get(CREATOR)) != null) {
            condition.append(" AND u.creator.account = :creator ");
            parameters.put(CREATOR, creator);
        }
        if ((executed = conditions.get(EXECUTED)) != null) {
            condition.append(" AND u.executed = :executed ");
            parameters.put(EXECUTED, executed);
        }
        if ((executor = conditions.get(EXECUTOR)) != null) {
            condition.append(" AND u.executor.account = :executor ");
            parameters.put(EXECUTOR, executor);
        }
        if (StringUtils.isNotBlank((CharSequence)(projectName = (String)conditions.get("projectName")))) {
            condition.append(" AND u.projectName = :projectName ");
            parameters.put("projectName", projectName);
        } else {
            condition.append(" AND (u.projectName = '' or u.projectName is null) ");
        }
        hql.append((CharSequence)condition).append(" order by u.createTime desc ");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }
}

