/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.init;

import com.bizunited.platform.core.service.init.InitProcessService;
import com.bizunited.platform.kuiper.starter.service.FromDetailsImportService;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FromDetailsImportProcess;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="FormDataDetialsInitProcess")
public class FormDataDetialsInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDataDetialsInitProcess.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private FromDetailsImportService fromDetailsImportService;

    public boolean doProcess() {
        return true;
    }

    public void init() {
        String[] beanNames = this.applicationContext.getBeanNamesForType(FromDetailsImportProcess.class);
        if (beanNames == null || beanNames.length == 0) {
            return;
        }
        for (String beanName : beanNames) {
            Object springBean = this.applicationContext.getBean(beanName);
            String targetClassName = this.recursionFindClass(springBean.getClass());
            this.fromDetailsImportService.putProcessClassNames(targetClassName);
        }
    }

    private String recursionFindClass(Class<?> targetClass) {
        ClassLoader classLoader = this.applicationContext.getClassLoader();
        if (SpringProxy.class.isAssignableFrom(targetClass)) {
            String cglibClassName = targetClass.getName();
            String realClassName = null;
            if (StringUtils.indexOf((CharSequence)cglibClassName, (CharSequence)"$$") != -1) {
                realClassName = cglibClassName.split("\\$\\$")[0];
            } else if (StringUtils.indexOf((CharSequence)cglibClassName, (CharSequence)"$") != -1) {
                realClassName = cglibClassName.split("\\$")[0];
            }
            if (realClassName == null) {
                return null;
            }
            try {
                classLoader.loadClass(realClassName);
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug(e.getMessage());
            }
            return realClassName;
        }
        return targetClass.getName();
    }
}

