/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.instances.handle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.InstanceActivityLogEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.RelationsTypeEnum;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityLogService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractInstanceDetailsLogUpdateHandle
implements InvokeResponseHandle {
    private static final String PROPERTIES = "properties";
    private static final String RELATIONS = "relations";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String CHANGE_TYPE = "changeType";
    private static final String UPDATE = "UPDATE";
    private static final String PROPERTY_CLASS_NAME = "propertyClassName";
    private static final String SPECIAL_EXPRESSION = "$[?(@.id = '";
    private static final String BEFORE_VALUE = "beforeValue";
    private static final String AFTER_VALUE = "afterValue";
    @Autowired
    private TemplateService templateService;
    @Autowired
    private InstanceActivityLogService instanceActivityLogService;

    private JSONArray getPropertyArray(JSONObject details, String propertyName) {
        Object relationValues = JSONPath.eval((Object)details, (String)("$['" + propertyName + "']"));
        JSONArray relations = null;
        relations = relationValues instanceof JSONArray ? (JSONArray)relationValues : new JSONArray();
        return relations;
    }

    private JSONObject getPropertyObject(JSONObject details, String propertyName) {
        Object relationValue = JSONPath.eval((Object)details, (String)("$['" + propertyName + "']"));
        JSONObject relation = null;
        relation = relationValue instanceof JSONObject ? (JSONObject)relationValue : new JSONObject();
        return relation;
    }

    void handle(JSONObject beforeDetails, JSONObject afterDetails, String templateId, UserVo creator, String activityId, ServicableMethodEntity entity) {
        TemplateEntity currentTemplate = this.templateService.findDetailsById(templateId);
        Validate.notNull((Object)currentTemplate, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (Object[])new Object[0]);
        JSONObject changeTemplate = new JSONObject();
        Set templateProperties = currentTemplate.getProperties();
        JSONArray changeProperties = this.analysisProperties(beforeDetails, afterDetails, templateProperties);
        if (changeProperties != null && !changeProperties.isEmpty()) {
            changeTemplate.put(PROPERTIES, (Object)changeProperties);
        }
        Set relations = currentTemplate.getRelations();
        JSONArray changeRelations = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)relations)) {
            for (TemplateRelationEntity relationItem : relations) {
                String propertyName = relationItem.getPropertyName();
                JSONObject relationObject = null;
                if (StringUtils.equals((CharSequence)relationItem.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation())) {
                    JSONArray beforeRelations = this.getPropertyArray(beforeDetails, propertyName);
                    JSONArray afterRelations = this.getPropertyArray(afterDetails, propertyName);
                    relationObject = this.analysisManyToManyRelation(beforeRelations, afterRelations, relationItem);
                } else if (StringUtils.equals((CharSequence)relationItem.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation())) {
                    JSONObject beforeRelation = this.getPropertyObject(beforeDetails, propertyName);
                    JSONObject afterRelation = this.getPropertyObject(afterDetails, propertyName);
                    relationObject = this.analysisManyToOneRelation(beforeRelation, afterRelation, relationItem);
                }
                if (relationObject == null) continue;
                changeRelations.add(relationObject);
            }
        }
        if (!changeRelations.isEmpty()) {
            changeTemplate.put(RELATIONS, (Object)changeRelations);
        }
        Set items = currentTemplate.getItemRelations();
        JSONArray changeItems = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)items)) {
            for (TemplateItemEntity item : items) {
                JSONArray afterItems;
                String itemName = item.getPropertyName();
                JSONArray beforeItems = this.getPropertyArray(beforeDetails, itemName);
                JSONObject itemObject = this.analysisItem(beforeItems, afterItems = this.getPropertyArray(afterDetails, itemName), item);
                if (itemObject == null) continue;
                changeItems.add((Object)itemObject);
            }
        }
        if (!changeItems.isEmpty()) {
            changeTemplate.put("items", (Object)changeItems);
        }
        Set groups = currentTemplate.getGroupRelations();
        JSONArray changeGroups = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)groups)) {
            for (TemplateGroupEntity groupItem : groups) {
                JSONObject afterGroup;
                String groupName = groupItem.getPropertyName();
                JSONObject beforeGroup = this.getPropertyObject(beforeDetails, groupName);
                JSONObject groupObject = this.analysisGroup(beforeGroup, afterGroup = this.getPropertyObject(afterDetails, groupName), groupItem);
                if (groupObject == null) continue;
                changeGroups.add((Object)groupObject);
            }
        }
        if (!changeGroups.isEmpty()) {
            changeTemplate.put("groups", (Object)changeGroups);
        }
        if (changeTemplate.isEmpty()) {
            return;
        }
        InstanceActivityLogEntity instanceActivityLog = new InstanceActivityLogEntity();
        instanceActivityLog.setCreateTime(new Date());
        UserEntity creatorEntity = new UserEntity();
        creatorEntity.setId(creator.getId());
        instanceActivityLog.setCreator(creatorEntity);
        InstanceActivityEntity currentActivity = new InstanceActivityEntity();
        currentActivity.setId(activityId);
        instanceActivityLog.setInstanceActivity(currentActivity);
        if (entity != null) {
            instanceActivityLog.setQueryDetailsService(entity.getRecordQuery());
            instanceActivityLog.setUpdateDetailsService(entity.getRecordUpdate());
        }
        this.instanceActivityLogService.create(instanceActivityLog, changeTemplate);
    }

    private JSONObject analysisGroup(JSONObject beforeGroup, JSONObject afterGroup, TemplateGroupEntity templateGroup) {
        JSONObject changeGroup = new JSONObject();
        String propertyName = templateGroup.getPropertyName();
        changeGroup.put(PROPERTY_NAME, (Object)propertyName);
        changeGroup.put(CHANGE_TYPE, (Object)UPDATE);
        Set templateProperties = templateGroup.getProperties();
        JSONArray changeProperties = this.analysisProperties(beforeGroup, afterGroup, templateProperties);
        if (!CollectionUtils.isEmpty((Collection)changeProperties)) {
            changeGroup.put(PROPERTIES, (Object)changeProperties);
        }
        Set templateRelations = templateGroup.getRelations();
        JSONArray changeRelations = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)templateRelations)) {
            for (TemplateRelationEntity templateRelation : templateRelations) {
                String relationPropertyName = templateRelation.getPropertyName();
                JSONObject relationObject = null;
                if (StringUtils.equals((CharSequence)templateRelation.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation())) {
                    JSONArray beforeRelations = this.getPropertyArray(beforeGroup, propertyName);
                    JSONArray afterRelations = this.getPropertyArray(afterGroup, propertyName);
                    relationObject = this.analysisManyToManyRelation(beforeRelations, afterRelations, templateRelation);
                } else if (StringUtils.equals((CharSequence)templateRelation.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation())) {
                    JSONObject beforeRelation = this.getPropertyObject(beforeGroup, relationPropertyName);
                    JSONObject afterRelation = this.getPropertyObject(afterGroup, relationPropertyName);
                    relationObject = this.analysisManyToOneRelation(beforeRelation, afterRelation, templateRelation);
                }
                if (relationObject == null) continue;
                changeRelations.add(relationObject);
            }
        }
        if (!changeRelations.isEmpty()) {
            changeGroup.put(RELATIONS, (Object)changeRelations);
        }
        Set templateItems = templateGroup.getItemRelations();
        JSONArray changeItems = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)templateItems)) {
            for (TemplateItemEntity templateItem : templateItems) {
                JSONArray afterItems;
                String itemName = templateItem.getPropertyName();
                JSONArray beforeItems = this.getPropertyArray(beforeGroup, itemName);
                JSONObject itemObject = this.analysisItem(beforeItems, afterItems = this.getPropertyArray(afterGroup, itemName), templateItem);
                if (itemObject == null) continue;
                changeItems.add((Object)itemObject);
            }
        }
        if (!changeItems.isEmpty()) {
            changeGroup.put("items", (Object)changeItems);
        }
        if (CollectionUtils.isEmpty((Collection)changeProperties) || !changeRelations.isEmpty() || !changeItems.isEmpty()) {
            return changeGroup;
        }
        return null;
    }

    private JSONObject analysisItem(JSONArray beforeItems, JSONArray afterItems, TemplateItemEntity templateItem) {
        String itemPropertyName;
        String id;
        String propertyClassName = templateItem.getPropertyClassName();
        String propertyName = templateItem.getPropertyName();
        JSONObject changeObjects = new JSONObject();
        changeObjects.put(PROPERTY_CLASS_NAME, (Object)propertyClassName);
        changeObjects.put(PROPERTY_NAME, (Object)propertyName);
        HashSet beforeItemIdArrays = Sets.newHashSet();
        HashSet afterItemIdArrays = Sets.newHashSet();
        if (beforeItems != null) {
            Object beforeItemArrayValue = JSONPath.eval((Object)beforeItems, (String)"$['id']");
            JSONArray beforeItemArray = null;
            if (beforeItemArrayValue instanceof JSONArray) {
                beforeItemArray = (JSONArray)beforeItemArrayValue;
            }
            HashSet hashSet = beforeItemIdArrays = beforeItemArray != null ? Sets.newHashSet((Object[])beforeItemArray.toArray(new Object[0])) : Sets.newHashSet();
        }
        if (afterItems != null) {
            Object afterItemArrayObject = JSONPath.eval((Object)afterItems, (String)"$['id']");
            JSONArray afterItemArray = null;
            if (afterItemArrayObject instanceof JSONArray) {
                afterItemArray = (JSONArray)afterItemArrayObject;
            }
            afterItemIdArrays = afterItemArray != null ? Sets.newHashSet((Object[])afterItemArray.toArray(new Object[0])) : Sets.newHashSet();
        }
        Sets.SetView deleteIds = Sets.difference((Set)beforeItemIdArrays, (Set)afterItemIdArrays);
        LinkedHashSet deleteItems = Sets.newLinkedHashSet();
        if (deleteIds != null && !deleteIds.isEmpty()) {
            deleteIds.stream().forEach(itemId -> {
                JSONArray items = (JSONArray)JSONPath.eval((Object)beforeItems, (String)(SPECIAL_EXPRESSION + itemId + "')]"));
                deleteItems.add(items.getJSONObject(0));
            });
        }
        Sets.SetView newIds = Sets.difference((Set)afterItemIdArrays, (Set)beforeItemIdArrays);
        LinkedHashSet newItems = Sets.newLinkedHashSet();
        if (newIds != null && !newIds.isEmpty()) {
            newIds.stream().forEach(itemId -> {
                JSONArray items = (JSONArray)JSONPath.eval((Object)afterItems, (String)(SPECIAL_EXPRESSION + itemId + "')]"));
                newItems.add(items.getJSONObject(0));
            });
        }
        Sets.SetView updateIds = Sets.intersection((Set)afterItemIdArrays, (Set)beforeItemIdArrays);
        LinkedHashSet updateItems = Sets.newLinkedHashSet();
        if (updateIds != null && !updateIds.isEmpty()) {
            updateIds.stream().forEach(itemId -> {
                JSONArray items = (JSONArray)JSONPath.eval((Object)afterItems, (String)(SPECIAL_EXPRESSION + itemId + "')]"));
                updateItems.add(items.getJSONObject(0));
            });
        }
        Set templateProperties = templateItem.getProperties();
        Set templateRelations = templateItem.getRelations();
        JSONArray datas = new JSONArray();
        if (deleteItems != null && !deleteItems.isEmpty()) {
            for (JSONObject deleteItem : deleteItems) {
                JSONArray deletePropertiesChanges;
                JSONObject deleteChange = new JSONObject();
                id = deleteItem.getString("id");
                deleteChange.put("id", (Object)id);
                deleteChange.put(CHANGE_TYPE, (Object)"DELETE");
                if (templateProperties != null && !templateProperties.isEmpty() && !(deletePropertiesChanges = this.analysisProperties(deleteItem, new JSONObject(), templateProperties)).isEmpty()) {
                    deleteChange.put(PROPERTIES, (Object)deletePropertiesChanges);
                }
                if (templateRelations != null && !templateRelations.isEmpty()) {
                    JSONArray deleteRelationsChanges = new JSONArray();
                    for (TemplateRelationEntity templateRelationItem : templateRelations) {
                        JSONObject deleteRelationsChange = null;
                        itemPropertyName = templateRelationItem.getPropertyName();
                        if (StringUtils.equals((CharSequence)templateRelationItem.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation())) {
                            JSONArray deleteJSONArray = deleteItem.getJSONArray(itemPropertyName);
                            deleteRelationsChange = this.analysisManyToManyRelation(deleteJSONArray == null ? new JSONArray() : deleteJSONArray, new JSONArray(), templateRelationItem);
                        } else if (StringUtils.equals((CharSequence)templateRelationItem.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation())) {
                            JSONObject deleteJSONObject = deleteItem.getJSONObject(itemPropertyName);
                            deleteRelationsChange = this.analysisManyToOneRelation(deleteJSONObject == null ? new JSONObject() : deleteJSONObject, new JSONObject(), templateRelationItem);
                        }
                        if (deleteRelationsChange == null) continue;
                        deleteRelationsChanges.add(deleteRelationsChange);
                    }
                    if (!deleteRelationsChanges.isEmpty()) {
                        deleteChange.put(RELATIONS, (Object)deleteRelationsChanges);
                    }
                }
                datas.add((Object)deleteChange);
            }
        }
        if (newItems != null && !newItems.isEmpty()) {
            for (JSONObject newItem : newItems) {
                JSONArray newPropertiesChanges;
                JSONObject newChange = new JSONObject();
                id = newItem.getString("id");
                newChange.put("id", (Object)id);
                newChange.put(CHANGE_TYPE, (Object)"NEW");
                if (templateProperties != null && !templateProperties.isEmpty() && (newPropertiesChanges = this.analysisProperties(new JSONObject(), newItem, templateProperties)) != null && !newPropertiesChanges.isEmpty()) {
                    newChange.put(PROPERTIES, (Object)newPropertiesChanges);
                }
                if (templateRelations != null && !templateRelations.isEmpty()) {
                    JSONArray newRelationsChanges = new JSONArray();
                    for (TemplateRelationEntity templateRelationItem : templateRelations) {
                        JSONObject newRelationsChange = null;
                        itemPropertyName = templateRelationItem.getPropertyName();
                        if (StringUtils.equals((CharSequence)templateRelationItem.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation())) {
                            JSONArray newJSONArray = newItem.getJSONArray(itemPropertyName);
                            newRelationsChange = this.analysisManyToManyRelation(new JSONArray(), newJSONArray == null ? new JSONArray() : newJSONArray, templateRelationItem);
                        } else if (StringUtils.equals((CharSequence)templateRelationItem.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation())) {
                            JSONObject newJSONObject = newItem.getJSONObject(itemPropertyName);
                            newRelationsChange = this.analysisManyToOneRelation(new JSONObject(), newJSONObject == null ? new JSONObject() : newJSONObject, templateRelationItem);
                        }
                        if (newRelationsChange == null) continue;
                        newRelationsChanges.add(newRelationsChange);
                    }
                    if (!newRelationsChanges.isEmpty()) {
                        newChange.put(RELATIONS, (Object)newRelationsChanges);
                    }
                }
                datas.add((Object)newChange);
            }
        }
        if (updateItems != null && !updateItems.isEmpty()) {
            for (JSONObject updateItem : updateItems) {
                JSONArray updatePropertiesChanges;
                boolean isUpdateItem = false;
                JSONObject updateChange = new JSONObject();
                String id2 = updateItem.getString("id");
                JSONArray beforeUpdateItems = (JSONArray)JSONPath.eval((Object)beforeItems, (String)(SPECIAL_EXPRESSION + id2 + "')]"));
                updateChange.put("id", (Object)id2);
                updateChange.put(CHANGE_TYPE, (Object)UPDATE);
                if (templateProperties != null && !templateProperties.isEmpty() && (updatePropertiesChanges = this.analysisProperties(beforeUpdateItems.getJSONObject(0), updateItem, templateProperties)) != null && !updatePropertiesChanges.isEmpty()) {
                    isUpdateItem = true;
                    updateChange.put(PROPERTIES, (Object)updatePropertiesChanges);
                }
                if (templateRelations != null && !templateRelations.isEmpty()) {
                    JSONArray updateRelationsChanges = new JSONArray();
                    for (TemplateRelationEntity templateRelationItem : templateRelations) {
                        JSONObject updateRelationsChange = null;
                        String itemPropertyName2 = templateRelationItem.getPropertyName();
                        if (StringUtils.equals((CharSequence)templateRelationItem.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation())) {
                            JSONArray afterUpdateJSONArray = updateItem.getJSONArray(itemPropertyName2);
                            JSONArray beforeUpdateJSONArray = beforeUpdateItems.getJSONObject(0).getJSONArray(itemPropertyName2);
                            updateRelationsChange = this.analysisManyToManyRelation(beforeUpdateJSONArray == null ? new JSONArray() : beforeUpdateJSONArray, afterUpdateJSONArray == null ? new JSONArray() : afterUpdateJSONArray, templateRelationItem);
                        } else if (StringUtils.equals((CharSequence)templateRelationItem.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation())) {
                            JSONObject afterUpdateJSONObject = updateItem.getJSONObject(itemPropertyName2);
                            JSONObject beforeUpdateJSONObject = beforeUpdateItems.getJSONObject(0).getJSONObject(itemPropertyName2);
                            updateRelationsChange = this.analysisManyToOneRelation(beforeUpdateJSONObject == null ? new JSONObject() : beforeUpdateJSONObject, afterUpdateJSONObject == null ? new JSONObject() : afterUpdateJSONObject, templateRelationItem);
                        }
                        if (updateRelationsChange == null) continue;
                        updateRelationsChanges.add(updateRelationsChange);
                    }
                    if (!updateRelationsChanges.isEmpty()) {
                        isUpdateItem = true;
                        updateChange.put(RELATIONS, (Object)updateRelationsChanges);
                    }
                }
                if (!isUpdateItem) continue;
                datas.add((Object)updateChange);
            }
        }
        if (!datas.isEmpty()) {
            changeObjects.put("datas", (Object)datas);
            return changeObjects;
        }
        return null;
    }

    private JSONObject analysisManyToOneRelation(JSONObject beforeRelation, JSONObject afterRelation, TemplateRelationEntity templateRelation) {
        String afterRelationValue;
        String propertyClassName = templateRelation.getPropertyClassName();
        String propertyName = templateRelation.getPropertyName();
        String propertyDbName = templateRelation.getPropertyDbName();
        String beforeRelationValue = beforeRelation.getString("id");
        if (!StringUtils.equals((CharSequence)beforeRelationValue, (CharSequence)(afterRelationValue = afterRelation.getString("id")))) {
            JSONObject changeObject = new JSONObject();
            changeObject.put(PROPERTY_CLASS_NAME, (Object)propertyClassName);
            changeObject.put(PROPERTY_NAME, (Object)propertyName);
            changeObject.put("propertyDbName", (Object)propertyDbName);
            changeObject.put(CHANGE_TYPE, (Object)UPDATE);
            changeObject.put(BEFORE_VALUE, (Object)beforeRelationValue);
            changeObject.put(AFTER_VALUE, (Object)afterRelationValue);
            return changeObject;
        }
        return null;
    }

    private JSONObject analysisManyToManyRelation(JSONArray beforeRelation, JSONArray afterRelation, TemplateRelationEntity templateRelation) {
        LinkedHashSet afterRelationIdSets;
        LinkedHashSet beforeRelationIdSets;
        String propertyName = templateRelation.getPropertyName();
        String propertyClassName = templateRelation.getPropertyClassName();
        List beforeRelationIds = null;
        List afterRelationIds = null;
        if (beforeRelation != null && (beforeRelationIds = (List)JSONPath.eval((Object)beforeRelation, (String)StringUtils.join((Object[])new String[]{"$..id"}))) == null) {
            beforeRelationIds = Lists.newArrayList();
        }
        if (afterRelation != null && (afterRelationIds = (List)JSONPath.eval((Object)afterRelation, (String)StringUtils.join((Object[])new String[]{"$..id"}))) == null) {
            afterRelationIds = Lists.newArrayList();
        }
        if (Sets.difference((Set)(beforeRelationIdSets = Sets.newLinkedHashSet(beforeRelationIds)), (Set)(afterRelationIdSets = Sets.newLinkedHashSet(afterRelationIds))).isEmpty() && Sets.difference((Set)afterRelationIdSets, (Set)beforeRelationIdSets).isEmpty()) {
            return null;
        }
        JSONObject valueObject = new JSONObject();
        valueObject.put(PROPERTY_CLASS_NAME, (Object)propertyClassName);
        valueObject.put(PROPERTY_NAME, (Object)propertyName);
        valueObject.put(CHANGE_TYPE, (Object)UPDATE);
        if (beforeRelationIds != null && !beforeRelationIds.isEmpty()) {
            valueObject.put(BEFORE_VALUE, (Object)beforeRelationIds);
        }
        if (afterRelationIds != null && !afterRelationIds.isEmpty()) {
            valueObject.put(AFTER_VALUE, (Object)afterRelationIds);
        }
        return valueObject;
    }

    private JSONArray analysisProperties(JSONObject beforeProperties, JSONObject afterProperties, Set<TemplatePropertyEntity> templateProperties) {
        JSONArray changeResults = new JSONArray();
        for (TemplatePropertyEntity templateProperty : templateProperties) {
            String propertyClassName = templateProperty.getPropertyClassName();
            String propertyName = templateProperty.getPropertyName();
            String propertyDbName = templateProperty.getPropertyDbName();
            boolean isChange = false;
            Object beforeValue = null;
            Object afterValue = null;
            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.String")) {
                beforeValue = beforeProperties.getString(propertyName);
                afterValue = afterProperties.getString(propertyName);
                if (beforeValue == null && afterValue != null || beforeValue != null && afterValue == null) {
                    isChange = true;
                }
                if (StringUtils.equals((CharSequence)(beforeValue == null ? "" : beforeValue.toString()), (CharSequence)(afterValue == null ? "" : afterValue.toString()))) continue;
                isChange = true;
            } else if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Long") || StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"long")) {
                long afterLongValue;
                beforeValue = beforeProperties.getLong(propertyName);
                afterValue = afterProperties.getLong(propertyName);
                long beforeLongValue = beforeValue == null ? 0L : (Long)beforeValue;
                long l = afterLongValue = afterValue == null ? 0L : (Long)afterValue;
                if (beforeValue == null && afterValue != null || beforeValue != null && afterValue == null) {
                    isChange = true;
                }
                if (beforeLongValue == afterLongValue || beforeValue == null && afterValue == null) continue;
                isChange = true;
            } else if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Integer") || StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"int")) {
                int afterIntValue;
                beforeValue = beforeProperties.getInteger(propertyName);
                afterValue = afterProperties.getInteger(propertyName);
                int beforeIntValue = beforeValue == null ? 0 : (Integer)beforeValue;
                int n = afterIntValue = afterValue == null ? 0 : (Integer)afterValue;
                if (beforeValue == null && afterValue != null || beforeValue != null && afterValue == null) {
                    isChange = true;
                }
                if (beforeIntValue == afterIntValue || beforeValue == null && afterValue == null) continue;
                isChange = true;
            } else if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Short") || StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"short")) {
                short afterShortValue;
                beforeValue = beforeProperties.getShort(propertyName);
                afterValue = afterProperties.getShort(propertyName);
                short beforeShortValue = beforeValue == null ? (short)0 : (Short)beforeValue;
                short s = afterShortValue = afterValue == null ? (short)0 : (Short)afterValue;
                if (beforeValue == null && afterValue != null || beforeValue != null && afterValue == null) {
                    isChange = true;
                }
                if (beforeShortValue == afterShortValue || beforeValue == null && afterValue == null) continue;
                isChange = true;
            } else if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Byte") || StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"byte")) {
                byte afterByteValue;
                beforeValue = beforeProperties.getByte(propertyName);
                afterValue = afterProperties.getByte(propertyName);
                byte beforeByteValue = beforeValue == null ? (byte)0 : (Byte)beforeValue;
                byte by = afterByteValue = afterValue == null ? (byte)0 : (Byte)afterValue;
                if (beforeValue == null && afterValue != null || beforeValue != null && afterValue == null) {
                    isChange = true;
                }
                if (beforeByteValue == afterByteValue || beforeValue == null && afterValue == null) continue;
                isChange = true;
            } else if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Boolean") || StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"boolean")) {
                boolean afterBooleanValue;
                beforeValue = beforeProperties.getBoolean(propertyName);
                afterValue = afterProperties.getBoolean(propertyName);
                boolean beforeBooleanValue = beforeValue == null ? false : (Boolean)beforeValue;
                boolean bl = afterBooleanValue = afterValue == null ? false : (Boolean)afterValue;
                if (beforeValue == null && afterValue != null || beforeValue != null && afterValue == null) {
                    isChange = true;
                }
                if (beforeBooleanValue == afterBooleanValue || beforeValue == null && afterValue == null) continue;
                isChange = true;
            } else if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Float") || StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"float")) {
                float afterFloatValue;
                beforeValue = beforeProperties.getFloat(propertyName);
                afterValue = afterProperties.getFloat(propertyName);
                float beforeFloatValue = beforeValue == null ? 0.0f : ((Float)beforeValue).floatValue();
                float f = afterFloatValue = afterValue == null ? 0.0f : ((Float)afterValue).floatValue();
                if (beforeValue == null && afterValue != null || beforeValue != null && afterValue == null) {
                    isChange = true;
                }
                if (beforeFloatValue == afterFloatValue || beforeValue == null && afterValue == null) continue;
                isChange = true;
            } else if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Double") || StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"double")) {
                double afterDoubleValue;
                beforeValue = beforeProperties.getDouble(propertyName);
                afterValue = afterProperties.getDouble(propertyName);
                double beforeDoubleValue = beforeValue == null ? 0.0 : (Double)beforeValue;
                double d = afterDoubleValue = afterValue == null ? 0.0 : (Double)afterValue;
                if (beforeValue == null && afterValue != null || beforeValue != null && afterValue == null) {
                    isChange = true;
                }
                if (beforeDoubleValue == afterDoubleValue || beforeValue == null && afterValue == null) continue;
                isChange = true;
            } else if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.math.BigDecimal")) {
                float afterBigDecimalValue;
                beforeValue = beforeProperties.getBigDecimal(propertyName);
                afterValue = afterProperties.getBigDecimal(propertyName);
                float beforeBigDecimalValue = beforeValue == null ? BigDecimal.ZERO.floatValue() : ((BigDecimal)beforeValue).floatValue();
                float f = afterBigDecimalValue = afterValue == null ? BigDecimal.ZERO.floatValue() : ((BigDecimal)afterValue).floatValue();
                if (beforeValue == null && afterValue != null || beforeValue != null && afterValue == null) {
                    isChange = true;
                } else {
                    if (beforeBigDecimalValue == afterBigDecimalValue || beforeValue == null && afterValue == null) continue;
                    isChange = true;
                }
            } else if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.util.Date")) {
                long afterDateValue;
                beforeValue = beforeProperties.getDate(propertyName);
                long beforeDateValue = beforeValue == null ? 0L : ((Date)beforeValue).getTime();
                if (beforeDateValue == (afterDateValue = (afterValue = afterProperties.getDate(propertyName)) == null ? 0L : ((Date)afterValue).getTime()) || beforeValue == null && afterValue == null) continue;
                isChange = true;
            }
            JSONObject changeObject = new JSONObject();
            if (!isChange) continue;
            changeObject.put(PROPERTY_CLASS_NAME, (Object)propertyClassName);
            changeObject.put(PROPERTY_NAME, (Object)propertyName);
            changeObject.put("propertyDbName", (Object)propertyDbName);
            changeObject.put(CHANGE_TYPE, (Object)UPDATE);
            if (beforeValue != null) {
                changeObject.put(BEFORE_VALUE, beforeValue);
            }
            if (afterValue != null) {
                changeObject.put(AFTER_VALUE, afterValue);
            }
            changeResults.add((Object)changeObject);
        }
        return changeResults;
    }
}

