/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.instances.handle;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.InputParamsModel;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import com.bizunited.platform.kuiper.starter.service.instances.handle.AbstractInstanceDetailsLogUpdateHandle;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="StaticInstanceDetailsLogUpdateHandle")
public class StaticInstanceDetailsLogUpdateHandle
extends AbstractInstanceDetailsLogUpdateHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticInstanceDetailsLogUpdateHandle.class);
    @Autowired
    private InstanceActivityService instanceActivityService;
    @Autowired
    private ServicableMethodService servicableMethodService;
    @Autowired
    private UserService userService;

    public boolean handleException(InvokeProxyContext context) {
        return false;
    }

    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        if (context.isException()) {
            chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
        }
        InputParamsModel model = (InputParamsModel)context.getChainParam(InputParamsModel.class.getName());
        Validate.notNull((Object)model, (String)"\u9519\u8bef\u7684\u4ee3\u7406\u5668\u5165\u53c2\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ServicableMethodEntity entity = this.servicableMethodService.findDetailsByName(model.getServiceName());
        Validate.notNull((Object)entity, (String)"\u6839\u636e\u670d\u52a1\u540d%s\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u670d\u52a1\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{model.getServiceName()});
        String usedScope = entity.getUsedScope();
        if (StringUtils.equals((CharSequence)usedScope, (CharSequence)"READ")) {
            chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
        }
        String recordUpdate = entity.getRecordUpdate();
        String recordQuery = entity.getRecordQuery();
        if (StringUtils.isBlank((CharSequence)recordUpdate) || StringUtils.isBlank((CharSequence)recordQuery)) {
            LOGGER.warn("\u8b66\u544a\uff1a\u670d\u52a1\u6e90[{}]\u662f\u201c\u5199\u201d\u6027\u8d28\u7684\u670d\u52a1\u8fc7\u7a0b\uff0c\u4f46\u662f\u5e76\u672a\u8bbe\u5b9a\u5176\u6570\u636e\u6062\u590d\u4f7f\u7528\u7684recordUpdate\u3001recordQuery\u65b9\u6cd5\uff0c\u6570\u636e\u65e0\u6cd5\u8fdb\u884c\u6062\u590d\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u6e90\u5b9a\u4e49", (Object)model.getServiceName());
            chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
        }
        Object principalValue = context.getChainParam("principal");
        Validate.notNull((Object)principalValue, (String)"\u5728\u8bb0\u5f55\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u53d8\u66f4\u65f6\uff0c\u672a\u53d1\u73b0\u64cd\u4f5c\u4eba\u4fe1\u606f!!", (Object[])new Object[0]);
        String userName = principalValue.toString();
        UserVo creator = this.userService.findByAccount(userName);
        Validate.notNull((Object)creator, (String)"\u6700\u627e\u5230\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)model.getInstanceActivityId(), (String)"\u5b9e\u4f8b\u6d3b\u52a8id\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        InstanceActivityEntity activity = this.instanceActivityService.findDetailsById(model.getInstanceActivityId());
        Validate.notNull((Object)activity, (String)"\u6839\u636e\u4f20\u5165\u7684\u6d3b\u52a8id\uff0c\u672a\u80fd\u67e5\u8be2\u5230\u76f8\u5e94\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity template = activity.getTemplate();
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u5f53\u524d\u6d3b\u52a8\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f\uff08\u4e5f\u5c31\u662f\u8868\u5355\u5b9e\u4f8b\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\uff0c\u8bf7\u68c0\u67e5\u606f\uff09", (Object[])new Object[0]);
        JSONObject beforeDetails = (JSONObject)context.getChainParam("_beforeDetails");
        JSONObject afterDetails = (JSONObject)context.getChainParam("_afterDetails");
        Validate.isTrue((beforeDetails != null && afterDetails != null ? 1 : 0) != 0, (String)"\u6ca1\u6709\u53d1\u73b0\u53ef\u7528\u7684\u5bf9\u6bd4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2!!", (Object[])new Object[0]);
        this.handle(beforeDetails, afterDetails, template.getId(), creator, activity.getId(), entity);
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }
}

