/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import com.bizunited.platform.kuiper.starter.repository.TemplateLayoutRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="TemplateLayoutImpl")
public class TemplateLayoutServiceImpl
implements TemplateLayoutService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateLayoutServiceImpl.class);
    @Autowired
    private TemplateLayoutRepository templateLayoutRepository;
    @Autowired
    private NebulaFileService kuiperFileService;
    private static final String LAYOUTDIR = "/layout";
    private static final String EXTENDTYPE = ".txt";

    @Override
    @Transactional
    public TemplateLayoutEntity save(String templateId, Integer layoutType, Object layout) throws IOException {
        Validate.notBlank((CharSequence)templateId, (String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)layout, (String)"\u8868\u5355\u5e03\u5c40\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Integer currentLayoutType = 1;
        if (layoutType != null) {
            currentLayoutType = layoutType;
        }
        Validate.isTrue((currentLayoutType == 1 || currentLayoutType == 2 || currentLayoutType == 3 ? 1 : 0) != 0, (String)"\u76ee\u524d\u8868\u5355\u5e03\u5c40\u53ea\u652f\u6301pc\u7aef\u3001\u79fb\u52a8\u7aef\u548c\u6253\u5370\u7aef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new Serializable[]{templateId, "-type", currentLayoutType, EXTENDTYPE});
        byte[] objectContents = this.writeObjectToBytes(layout);
        this.kuiperFileService.saveFile(relativePath, fileName, fileName, objectContents);
        TemplateLayoutEntity templateLayout = this.findByTemplateId(templateId, currentLayoutType);
        if (null == templateLayout) {
            templateLayout = new TemplateLayoutEntity();
            templateLayout.setCreateTime(new Date());
            templateLayout.setRelativePath(relativePath);
            templateLayout.setFileName(fileName);
            templateLayout.setLayoutType(currentLayoutType);
            TemplateEntity currentTemplate = new TemplateEntity();
            currentTemplate.setId(templateId);
            templateLayout.setTemplate(currentTemplate);
        } else {
            templateLayout.setRelativePath(relativePath);
            templateLayout.setFileName(fileName);
            templateLayout.setCreateTime(new Date());
            templateLayout.setLayoutType(currentLayoutType);
        }
        this.templateLayoutRepository.save(templateLayout);
        return templateLayout;
    }

    private byte[] writeObjectToBytes(Object obj) {
        byte[] bytes = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             ObjectOutputStream sOut = new ObjectOutputStream(out);){
            sOut.writeObject(obj);
            sOut.flush();
            bytes = out.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new byte[0];
        }
        return bytes;
    }

    @Override
    @Transactional
    public void deleteByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return;
        }
        Set<TemplateLayoutEntity> templateLayouts = this.findByTemplateId(templateId);
        if (templateLayouts == null || templateLayouts.isEmpty()) {
            return;
        }
        for (TemplateLayoutEntity templateLayout : templateLayouts) {
            String fileName = templateLayout.getFileName();
            String relativePath = templateLayout.getRelativePath();
            this.kuiperFileService.deleteFile(relativePath, fileName, fileName);
        }
        this.templateLayoutRepository.deleteByTemplateId(templateId);
    }

    @Override
    @Transactional
    public void deleteByTemplateId(String templateId, Integer layoutType) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return;
        }
        TemplateLayoutEntity templateLayout = this.findByTemplateId(templateId, layoutType);
        if (templateLayout == null) {
            return;
        }
        String fileName = templateLayout.getFileName();
        String relativePath = templateLayout.getRelativePath();
        this.kuiperFileService.deleteFile(relativePath, fileName, fileName);
        this.templateLayoutRepository.deleteById(templateLayout.getId());
    }

    @Override
    public JSONObject findDetailsByTemplateId(String templateId, Integer layoutType) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return null;
        }
        TemplateLayoutEntity templateLayout = this.findByTemplateId(templateId, layoutType);
        if (templateLayout == null) {
            return null;
        }
        String fileName = templateLayout.getFileName();
        String relativePath = templateLayout.getRelativePath();
        byte[] fileContents = this.kuiperFileService.readFileContent(relativePath, fileName);
        if (fileContents == null || fileContents.length == 0) {
            return null;
        }
        return this.readBytesToJson(fileContents);
    }

    private JSONObject readBytesToJson(byte[] bytes) {
        Object layoutObject = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
             ObjectInputStream sIn = new ObjectInputStream(in);){
            layoutObject = sIn.readObject();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (layoutObject == null) {
            return null;
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)layoutObject));
    }

    @Override
    public Set<TemplateLayoutEntity> findByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return Sets.newHashSet();
        }
        return this.templateLayoutRepository.findByTemplateId(templateId);
    }

    @Override
    public TemplateLayoutEntity findByTemplateId(String templateId, Integer layoutType) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return null;
        }
        int currentLayoutType = 1;
        if (layoutType != null) {
            currentLayoutType = layoutType;
        }
        return this.templateLayoutRepository.findByTemplateIdAndType(templateId, currentLayoutType);
    }
}

