/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import com.bizunited.platform.rbac.server.service.redis.RedisMutexService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/kuiper/activities"})
public class InstanceActivityController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceActivityController.class);
    @Autowired
    private InstanceActivityService instanceActivityService;
    @Autowired
    private RedisMutexService redisMutexService;
    private static final String PREVIOUS_ACTIVITY = "previousActivity";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5728\u6307\u5b9a\u7684\u8868\u5355\u5b9e\u4f8b\u4e0b\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u6d3b\u52a8\u4fe1\u606f")
    @PostMapping(value={""})
    @CacheEvict(cacheNames={"instance", "activity"}, allEntries=true)
    public ResponseModel create(@ApiParam(name="activity", value="\u65b0\u521b\u5efa\u7684\u8868\u5355\u5b9e\u4f8b\u6d3b\u52a8\u5bf9\u8c61") @RequestBody InstanceActivityEntity activity) {
        Validate.notNull((Object)activity, (String)"\u9519\u8bef\u7684\u6d3b\u52a8\u53c2\u6570\u4fe1\u606f", (Object[])new Object[0]);
        InstanceEntity currentInstance = activity.getInstance();
        Validate.notNull((Object)currentInstance, (String)"\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u5fc5\u987b\u6709\u76f8\u5173\u7684\u5b9e\u4f8b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String instanceId = currentInstance.getId();
        Validate.notBlank((CharSequence)instanceId, (String)"\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u672a\u53d1\u73b0\u76f8\u5173\u5b9e\u4f8b\u7684\u6570\u636e\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        try {
            Principal principal = this.getPrincipal();
            this.redisMutexService.lock(instanceId);
            InstanceActivityEntity currentActivity = this.instanceActivityService.create(activity, principal);
            ResponseModel responseModel = this.buildHttpResultW(currentActivity, new String[0]);
            return responseModel;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel responseModel = this.buildHttpResultForException(e);
            return responseModel;
        }
        finally {
            this.redisMutexService.unlock(instanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u68c0\u67e5\u5e76\u89c6\u60c5\u51b5\u521b\u5efa\u4e00\u4e2a\u6307\u5b9a\u8868\u5355\u5b9e\u4f8b\u4e0b\u7684\u6d3b\u52a8\uff0c\u5982\u679ctaskCode\u6307\u5b9a\u7684\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff0c\u5219\u76f4\u63a5\u8fd4\u56de\u6d3b\u52a8\u57fa\u672c\u4fe1\u606f\uff1b\u5982\u679c\u4e0d\u5b58\u5728\u5219\u6839\u636einstanceId\u548cvisibilityName\u8fdb\u884c\u521b\u5efa \u5165\u53c2\u4e3ajson\u63a5\u53e3\uff0c\u9700\u8981\u4f20\u9012\u7684\u53c2\u6570\u5305\u62ectaskCode\uff1a\u6307\u5b9a\u7684\u5916\u90e8\u4e1a\u52a1\u7f16\u53f7\uff08\u53ef\u80fd\u5728\u672c\u7cfb\u7edf\u5b58\u5728\u4e5f\u53ef\u80fd\u4e0d\u5728\u672c\u7cfb\u7edf\u5b58\u5728\uff09\uff1binstanceId\uff1a\u5f53\u524d\u6d3b\u52a8\u5bf9\u5e94\u7684\u5b9e\u4f8b\u7f16\u53f7\uff1bvisibilityName\uff1a\u6307\u5b9a\u7684\u53ef\u89c1\u6027\u540d\u79f0\uff08\u5728instanceId\u5bf9\u5e94\u7684\u6a21\u677f\u4e2dvisibilityName\u662f\u552f\u4e00\u7684\uff09,\u4f8b\u5982\uff1aupdate\u3001view\u7b49", notes="\u8fd4\u56de\u53ef\u80fd\u5b58\u5728\u4e5f\u53ef\u80fd\u662f\u4f9d\u636einstanceId\u3001visibilityName\u65b0\u5efa\u7684\u6d3b\u52a8\u7f16\u53f7\u3002")
    @PostMapping(value={"/checkCreate"})
    @CacheEvict(cacheNames={"instance", "activity"}, allEntries=true)
    public ResponseModel create(@RequestBody JSONObject paramJson) {
        Validate.notNull((Object)paramJson, (String)"\u5fc5\u987b\u8fdb\u884c\u53c2\u6570\u4f20\u9012\uff0c\u8bf7\u67e5\u770bapi\u6587\u6863", (Object[])new Object[0]);
        String taskCode = paramJson.getString("taskCode");
        String instanceId = paramJson.getString("instanceId");
        String visibilityName = paramJson.getString("visibilityName");
        Validate.notBlank((CharSequence)instanceId, (String)"\u5728\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u5b9e\u4f8b\u7f16\u53f7\u540d\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        try {
            Principal principal = this.getPrincipal();
            this.redisMutexService.lock(instanceId);
            InstanceActivityEntity currentActivity = this.instanceActivityService.create(taskCode, instanceId, visibilityName, principal);
            ResponseModel responseModel = this.buildHttpResultW(currentActivity, new String[0]);
            return responseModel;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel responseModel = this.buildHttpResultForException(e);
            return responseModel;
        }
        finally {
            this.redisMutexService.unlock(instanceId);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6d3b\u52a8\u7f16\u53f7\uff0c\u67e5\u8be2\u6307\u5b9a\u7684\u6d3b\u52a8\u4fe1\u606f\u8be6\u60c5\u2014\u2014\u5305\u62ec\u5173\u8054\u4fe1\u606f")
    @GetMapping(value={"/findDetailsById"})
    @Cacheable(cacheNames={"activity"}, key="'findDetailsById_' + #id", condition="#id != ''", sync=true)
    public ResponseModel findDetailsById(@ApiParam(name="id", value="\u6307\u5b9a\u7684\u6d3b\u52a8\u7f16\u53f7\u4fe1\u606f") String id) {
        try {
            InstanceActivityEntity currentActivity = this.instanceActivityService.findDetailsById(id);
            return this.buildHttpResultW(currentActivity, new String[]{"template", "creator", "modifyer", PREVIOUS_ACTIVITY, "instance", "templateVisibility"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u8868\u5355\u5b9e\u4f8b\u7f16\u53f7\uff0c\u67e5\u8be2\u5176\u4e0b\u5df2\u7ecf\u53d1\u751f\u7684\u6d3b\u52a8\uff0c\u5e76\u6309\u7167\u6d3b\u52a8\u521b\u5efa\u5b9e\u4f8b\u53cd\u5e8f\u6392\u5217")
    @GetMapping(value={"/findDetailsByInstanceId"})
    @Cacheable(cacheNames={"activity"}, key="'findDetailsByInstanceId' + #instanceId", condition="#instanceId != ''", sync=true)
    public ResponseModel findDetailsByInstanceId(@ApiParam(name="instanceId", value="\u6307\u5b9a\u7684\u8868\u5355\u5b9e\u4f8b\u7f16\u53f7") String instanceId) {
        try {
            Set<InstanceActivityEntity> instanceActivities = this.instanceActivityService.findDetailsByInstanceId(instanceId);
            return this.buildHttpResultW(instanceActivities, new String[]{"template", "creator", "modifyer", PREVIOUS_ACTIVITY, "instance", "templateVisibility", PREVIOUS_ACTIVITY});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

