/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.service.DynamicTemplateService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.FormTemplateTypeEnum;
import com.bizunited.platform.kuiper.starter.common.enums.RelationsTypeEnum;
import com.bizunited.platform.kuiper.starter.repository.TemplateMaintainerRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplatePropertyRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateRelationRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateRepository;
import com.bizunited.platform.kuiper.starter.repository.table.TableOperateRepositoryCustom;
import com.bizunited.platform.kuiper.starter.service.DynamicTemplateDraftService;
import com.bizunited.platform.kuiper.starter.service.TemplateGroupService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import com.bizunited.platform.kuiper.starter.service.internal.AbstractTemplateService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DynamicTemplateServiceImpl")
public class DynamicTemplateServiceImpl
extends AbstractTemplateService
implements DynamicTemplateService {
    private static Map<String, String> classTypeMapping = new HashMap<String, String>();
    private static final String MAPPING = "%s_%s_mapping";
    private static final String DOUBLE = "double";
    private static final String FORMINSTANCE_ID = "formInstanceId";
    private static final Set<String> RETAINFIELDNAMES;
    private static final String TABLEFORMAT = "^[0-9|a-z|A-Z]{1}[0-9|a-z|A-Z|_]*$";
    @Autowired
    private TableOperateRepositoryCustom tableOperateRepositoryCustom;
    @Autowired
    private TemplateMaintainerRepository templateMaintainerRepository;
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    private TemplatePropertyRepository templatePropertyRepository;
    @Autowired
    private TemplateRelationRepository templateRelationRepository;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Autowired
    private TemplateItemService templateItemService;
    @Autowired
    private UserService userService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;
    @Autowired
    private DynamicTemplateDraftService dynamicTemplateDraftService;

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public TemplateEntity initDynamicTemplate(TemplateEntity template, Principal principal) {
        Validate.notNull((Object)template, (String)"\u57fa\u4e8e\u52a8\u6001\u6a21\u677f\u521b\u5efa\u6570\u636e\u8868\u65f6\uff0c\u52a8\u6001\u6a21\u677f\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String tableName = template.getTableName();
        Validate.notBlank((CharSequence)tableName, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u521b\u5efa\uff0c\u5fc5\u987b\u6307\u5b9a\u52a8\u6001\u6a21\u578b\u5bf9\u5e94\u7684\u6570\u636e\u8868!!", (Object[])new Object[0]);
        String id = template.getId();
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (String)"\u52a8\u6001\u8868\u5355\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u8868\u5355\u6a21\u677f\u7f16\u53f7!!", (Object[])new Object[0]);
        template.setId(null);
        String cversion = template.getCversion();
        Validate.notBlank((CharSequence)cversion, (String)"\u65b0\u7684\u52a8\u6001\u8868\u5355\u6a21\u677f\u7684\u7248\u672c\u53f7\u4fe1\u606f\u5fc5\u987b\u6307\u5b9a!!", (Object[])new Object[0]);
        String name = template.getName();
        Validate.notBlank((CharSequence)name, (String)"\u65b0\u7684\u52a8\u6001\u8868\u5355\u6a21\u677f\u7684\u540d\u79f0\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String type = template.getType();
        Validate.notBlank((CharSequence)type, (String)"\u52a8\u6001\u8868\u5355\u6a21\u677f\u7c7b\u578b\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String code = template.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u52a8\u6001\u6a21\u677f\u5fc5\u987b\u586b\u5199\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)FormTemplateTypeEnum.DYNAMIC.getType(), (CharSequence)template.getType()), (String)"\u8be5\u64cd\u4f5c\u53ea\u652f\u6301\u52a8\u6001\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set properties = template.getProperties();
        this.perfectingProperty(tableName, properties, false);
        Set relations = template.getRelations();
        if (relations != null && !relations.isEmpty()) {
            for (TemplateRelationEntity relation : relations) {
                this.perfectingRelation(tableName, relation, false);
            }
        }
        Set templateItems = template.getItemRelations();
        this.perfectingOneToManyRelation(template, null, tableName, templateItems, false);
        Set templateGroups = template.getGroupRelations();
        this.perfectingOneToOneRelation(templateGroups, tableName, false);
        this.validate(template);
        TemplateEntity currentTemplate = this.templateRepository.findByCodeAndCversion(code, cversion);
        Validate.isTrue((currentTemplate == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u7f16\u53f7\u548c\u7248\u672c\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        super.saveTemplate(template, principal);
        this.initDynamicProperties(template, template.getProperties());
        this.initDynamicRelations(template, template.getRelations());
        templateGroups = template.getGroupRelations();
        if (templateGroups != null && !templateGroups.isEmpty()) {
            for (TemplateGroupEntity templateGroup : templateGroups) {
                this.templateGroupService.initDynamicGroups(templateGroup, template);
            }
        }
        if ((templateItems = template.getItemRelations()) != null && !templateItems.isEmpty()) {
            for (TemplateItemEntity templateItem : templateItems) {
                this.templateItemService.initDynamicItems(templateItem, template, null, tableName);
            }
        }
        this.templateRepository.flush();
        Set<TemplateVisibilityEntity> templateVisibilities = this.templateVisibilityService.initDynamicTemplateVisibilities(template);
        template.setVisibility(templateVisibilities);
        this.tableOperateRepositoryCustom.createTable(template);
        this.dynamicTemplateDraftService.deleteByCode(template.getCode());
        return template;
    }

    private void initDynamicProperties(TemplateEntity currentTemplate, Set<TemplatePropertyEntity> properties) {
        for (TemplatePropertyEntity templateProperty : properties) {
            templateProperty.setId(null);
            templateProperty.setCurrentTemplate(currentTemplate);
            templateProperty.setCurrentGroup(null);
            templateProperty.setCurrentItem(null);
            this.templatePropertyRepository.save(templateProperty);
        }
    }

    private void initDynamicRelations(TemplateEntity currentTemplate, Set<TemplateRelationEntity> relations) {
        if (relations == null || relations.isEmpty()) {
            return;
        }
        for (TemplateRelationEntity templateRelation : relations) {
            templateRelation.setId(null);
            templateRelation.setCurrentGroup(null);
            templateRelation.setCurrentItem(null);
            templateRelation.setCurrentTemplate(currentTemplate);
            templateRelation.setQueryService("");
            this.templateRelationRepository.save(templateRelation);
        }
    }

    private void perfectingProperty(String parentTableName, Set<TemplatePropertyEntity> properties, boolean force) {
        if (!force) {
            Validate.isTrue((this.tableOperateRepositoryCustom.existTableName(parentTableName) == false ? 1 : 0) != 0, (String)"\u68c0\u6d4b\u5230\u6570\u636e\u8868'%s'\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u8868\u540d\uff0c\u6216\u8005\u4f7f\u7528\u5f3a\u5236\u66f4\u65b0(\u4e0d\u63a8\u8350)!", (Object[])new Object[]{parentTableName});
        }
        Validate.isTrue((properties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)"id")).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u4e3b\u8868\u7684id\u4e3b\u952e\u5c5e\u6027", (Object[])new Object[0]);
        properties.add(this.autoAppendPk());
        Validate.isTrue((properties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)FORMINSTANCE_ID)).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u4e3b\u8868\u7684formInstanceId\u8868\u5355\u5b9e\u4f8b\u5c5e\u6027", (Object[])new Object[0]);
        properties.add(this.autoAppendFormInstanceId());
        for (TemplatePropertyEntity templateProperty : properties) {
            String propertyName = templateProperty.getPropertyName();
            Validate.notBlank((CharSequence)propertyName, (String)"\u4e00\u822c\u5c5e\u6027\u540d\u79f0\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            Validate.isTrue((propertyName.length() <= 64 ? 1 : 0) != 0, (String)"\u5728\u521d\u59cb\u5316\u65f6\u53d1\u73b0\u5b57\u6bb5[%s]\u7684\u957f\u5ea6\u8d85\u8fc7\u4e8664\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
            String propertyDesc = templateProperty.getPropertyDesc();
            Validate.notBlank((CharSequence)propertyDesc, (String)"\u4e00\u822c\u5c5e\u6027\u8bf4\u660e\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            String propertyDbName = templateProperty.getPropertyDbName();
            Validate.notBlank((CharSequence)propertyDbName, (String)"\u4e00\u822c\u5c5e\u6027'%s'\u7684\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[]{propertyDbName});
            Validate.isTrue((propertyDbName.length() <= 64 ? 1 : 0) != 0, (String)"\u5728\u521d\u59cb\u5316\u65f6\u53d1\u73b0\u5b57\u6bb5\u7684\u6570\u636e\u5e93\u5c5e\u6027[%s]\u7684\u957f\u5ea6\u8d85\u8fc7\u4e8664\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
            Validate.matchesPattern((CharSequence)propertyDbName, (String)TABLEFORMAT, (String)"\u5b57\u6bb5\u540d\u53ea\u80fd\u4f7f\u7528\u6570\u5b57\u3001\u5b57\u6bcd\uff08\u652f\u6301\u5927\u5c0f\u5199\uff09\u548c\u201c_\u201d\u7b26\u53f7[%s]", (Object[])new Object[]{propertyDbName});
        }
    }

    private void perfectingRelation(String parentTableName, TemplateRelationEntity relation, boolean force) {
        String propertyClassName;
        String targetTableName = relation.getTargetTableName();
        Validate.notBlank((CharSequence)targetTableName, (String)"\u5173\u8054\u4fe1\u606f\u5fc5\u987b\u8bbe\u5b9a\u6570\u636e\u8868!!", (Object[])new Object[0]);
        String propertyName = relation.getPropertyName();
        Validate.notBlank((CharSequence)propertyName, (String)"\u5173\u8054\u5c5e\u6027\u540d\u79f0\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String propertyDesc = relation.getPropertyDesc();
        Validate.notBlank((CharSequence)propertyDesc, (String)"\u5173\u8054\u5c5e\u6027\u8bf4\u660e\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String relationType = relation.getRelationType();
        Validate.notBlank((CharSequence)relationType, (String)"\u5173\u8054\u5c5e\u6027\u7c7b\u578b\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.equals((CharSequence)relationType, (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation()) || StringUtils.equals((CharSequence)relationType, (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation()) ? 1 : 0) != 0, (String)"\u5173\u8054\u5c5e\u6027\u7c7b\u578b\u53ea\u80fd\u662fManyToOne\u6216\u8005ManyToMany", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)relationType, (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation())) {
            String propertyDbName = relation.getPropertyDbName();
            Validate.notBlank((CharSequence)propertyDbName, (String)"\u5173\u8054\u5c5e\u6027'%s'\u7684\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[]{propertyName});
            Validate.matchesPattern((CharSequence)propertyDbName, (String)TABLEFORMAT, (String)"\u5b57\u6bb5\u540d\u53ea\u80fd\u4f7f\u7528\u6570\u5b57\u3001\u5b57\u6bcd\uff08\u652f\u6301\u5927\u5c0f\u5199\uff09\u548c\u201c_\u201d\u7b26\u53f7[%s]", (Object[])new Object[]{propertyDbName});
        }
        if (StringUtils.isBlank((CharSequence)(propertyClassName = relation.getPropertyClassName()))) {
            relation.setPropertyClassName(String.class.getName());
        }
        Validate.isTrue((boolean)this.tableOperateRepositoryCustom.existTableName(targetTableName), (String)"\u68c0\u6d4b\u5230\u6570\u636e\u8868%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{targetTableName});
        if (StringUtils.equals((CharSequence)relation.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation()) && !force) {
            List sortedNames = Arrays.stream(new String[]{parentTableName, targetTableName}).sorted().collect(Collectors.toList());
            String mappingTable = String.format(MAPPING, sortedNames.get(0), sortedNames.get(1));
            Validate.isTrue((this.tableOperateRepositoryCustom.existTableName(mappingTable) == false ? 1 : 0) != 0, (String)"\u68c0\u6d4b\u5230\u6570\u636e\u8868'%s'\u5df2\u5b58\u5728,\u8bf7\u66f4\u6362\u6570\u636e\u8868\u540d\uff0c\u6216\u8005\u4f7f\u7528\u5f3a\u5236\u66f4\u65b0(\u4e0d\u63a8\u8350)!!", (Object[])new Object[]{mappingTable});
        }
    }

    private void perfectingOneToManyRelation(TemplateEntity parentTemplate, TemplateGroupEntity parentGroup, String parentTableName, Set<TemplateItemEntity> templateOneToManyItems, boolean force) {
        if (templateOneToManyItems == null || templateOneToManyItems.isEmpty()) {
            return;
        }
        for (TemplateItemEntity templateOneToManyItem : templateOneToManyItems) {
            String tableName = templateOneToManyItem.getTableName();
            Validate.notBlank((CharSequence)tableName, (String)"\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u660e\u7ec6\u7f16\u8f91\u8868\u6ca1\u6709\u8bbe\u5b9a\u6570\u636e\u8868\u540d!!", (Object[])new Object[0]);
            Validate.matchesPattern((CharSequence)tableName, (String)TABLEFORMAT, (String)"\u6570\u636e\u8868\u53ea\u80fd\u4f7f\u7528\u6570\u5b57\u3001\u5b57\u6bcd\uff08\u652f\u6301\u5927\u5c0f\u5199\uff09\u548c\u201c_\u201d\u7b26\u53f7[%s]\uff01", (Object[])new Object[]{tableName});
            templateOneToManyItem.setParentTableName(parentTableName);
            if (!force) {
                Validate.isTrue((this.tableOperateRepositoryCustom.existTableName(tableName) == false ? 1 : 0) != 0, (String)"\u68c0\u6d4b\u5230\u6570\u636e\u8868'%s'\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u8868\u540d\uff0c\u6216\u8005\u4f7f\u7528\u5f3a\u5236\u66f4\u65b0(\u4e0d\u63a8\u8350)!!", (Object[])new Object[]{tableName});
            }
            Set oneToManyProperties = templateOneToManyItem.getProperties();
            Validate.notNull((Object)oneToManyProperties, (String)"\u8bf7\u81f3\u5c11\u4e3a\u660e\u7ec6\u8868\uff08%s\uff09\u8bbe\u5b9a\u4e00\u4e2a\u4e00\u822c\u5c5e\u6027!", (Object[])new Object[]{tableName});
            Validate.isTrue((!oneToManyProperties.isEmpty() ? 1 : 0) != 0, (String)"\u8bf7\u81f3\u5c11\u4e3a\u660e\u7ec6\u8868\uff08%s\uff09\u8bbe\u5b9a\u4e00\u4e2a\u4e00\u822c\u5c5e\u6027\uff01", (Object[])new Object[]{tableName});
            Validate.isTrue((oneToManyProperties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)"id")).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u660e\u7ec6\u7f16\u8f91\u8868\uff08%s\uff09\u7684id\u4e3b\u952e\u5c5e\u6027", (Object[])new Object[]{tableName});
            oneToManyProperties.add(this.autoAppendPk());
            LinkedHashSet<TemplateRelationEntity> omRelations = templateOneToManyItem.getRelations();
            if (omRelations != null && !omRelations.isEmpty()) {
                for (TemplateRelationEntity relation : omRelations) {
                    this.perfectingRelation(parentTableName, relation, force);
                }
            }
            if (omRelations == null) {
                omRelations = new LinkedHashSet<TemplateRelationEntity>();
                templateOneToManyItem.setRelations(omRelations);
            }
            TemplateRelationEntity backRelation = this.autoAppendBackRelation(parentTableName, parentTemplate, parentGroup, templateOneToManyItem);
            String backRelationDbName = backRelation.getPropertyDbName();
            Validate.isTrue((omRelations.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)backRelationDbName)).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u660e\u7ec6\u7f16\u8f91\u8868\uff08%s\uff09\u548c\u4e3b\u8868\u7684\u5173\u8054\u5c5e\u6027\uff08%s\uff09!", (Object[])new Object[]{tableName, backRelationDbName});
            omRelations.add(backRelation);
        }
    }

    private void perfectingOneToOneRelation(Set<TemplateGroupEntity> templateGroups, String parentTableName, boolean force) {
        if (templateGroups == null || templateGroups.isEmpty()) {
            return;
        }
        for (TemplateGroupEntity templateGroup : templateGroups) {
            String tableName = templateGroup.getTableName();
            Validate.notBlank((CharSequence)tableName, (String)"\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u5206\u7ec4\u4fe1\u606f\u8868\u6ca1\u6709\u8bbe\u5b9a\u6570\u636e\u8868\u540d!!", (Object[])new Object[0]);
            Validate.matchesPattern((CharSequence)tableName, (String)TABLEFORMAT, (String)"\u6570\u636e\u8868\u53ea\u80fd\u4f7f\u7528\u6570\u5b57\u3001\u5b57\u6bcd\uff08\u652f\u6301\u5927\u5c0f\u5199\uff09\u548c \u201c_\u201d\u7b26\u53f7[%s]", (Object[])new Object[]{tableName});
            templateGroup.setParentTableName(parentTableName);
            if (!force) {
                Validate.isTrue((this.tableOperateRepositoryCustom.existTableName(tableName) == false ? 1 : 0) != 0, (String)"\u68c0\u6d4b\u5230\u6570\u636e\u8868'%s'\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u8868\u540d\uff0c\u6216\u8005\u4f7f\u7528\u5f3a\u5236\u66f4\u65b0(\u4e0d\u63a8\u8350)!!", (Object[])new Object[]{tableName});
            }
            Set properties = templateGroup.getProperties();
            Validate.notNull((Object)properties, (String)"\u8bf7\u81f3\u5c11\u4e3a\u5206\u7ec4\u8868\uff08%s\uff09\u8bbe\u5b9a\u4e00\u4e2a\u4e00\u822c\u5c5e\u6027!", (Object[])new Object[]{tableName});
            Validate.isTrue((!properties.isEmpty() ? 1 : 0) != 0, (String)"\u8bf7\u81f3\u5c11\u4e3a\u5206\u7ec4\u8868\uff08%s\uff09 \u8bbe\u5b9a\u4e00\u4e2a\u4e00\u822c\u5c5e\u6027", (Object[])new Object[]{tableName});
            Validate.isTrue((properties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)"id")).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u5206\u7ec4\u8868\u7684id\u4e3b\u952e\u5c5e\u6027", (Object[])new Object[0]);
            properties.add(this.autoAppendPk());
            LinkedHashSet<TemplateRelationEntity> ooRelations = templateGroup.getRelations();
            if (ooRelations != null && !ooRelations.isEmpty()) {
                for (TemplateRelationEntity relation : ooRelations) {
                    this.perfectingRelation(tableName, relation, force);
                }
            }
            if (ooRelations == null) {
                ooRelations = new LinkedHashSet<TemplateRelationEntity>();
                templateGroup.setRelations(ooRelations);
            }
            TemplateRelationEntity backRelation = this.autoAppendBackRelation(parentTableName, null, templateGroup, null);
            String backRelationDbName = backRelation.getPropertyDbName();
            Validate.isTrue((ooRelations.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)backRelationDbName)).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u660e\u7ec6\u7f16\u8f91\u8868 \uff08%s\uff09\u548c\u4e3b\u8868\u7684\u5173\u8054\u5c5e\u6027\uff08%s\uff09", (Object[])new Object[]{tableName, backRelationDbName});
            ooRelations.add(backRelation);
            Set templateItems = templateGroup.getItemRelations();
            this.perfectingOneToManyRelation(null, templateGroup, tableName, templateItems, force);
        }
    }

    private void validate(TemplateEntity template) {
        Set itemsRelations;
        Set templateProperties = template.getProperties();
        templateProperties.forEach(item -> {
            String cfr_ignored_0 = (String)Validate.notBlank((CharSequence)item.getPropertyName(), (String)"\u53c2\u6570\u540d\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        });
        List<String> propertyDbNames = templateProperties.stream().map(TemplatePropertyEntity::getPropertyDbName).sorted().collect(Collectors.toList());
        List<String> propertyClassNames = templateProperties.stream().map(TemplatePropertyEntity::getPropertyClassName).sorted().collect(Collectors.toList());
        List<String> propertyNames = templateProperties.stream().map(TemplatePropertyEntity::getPropertyName).sorted().collect(Collectors.toList());
        Set templateRelations = template.getRelations();
        if (templateRelations != null && !templateRelations.isEmpty()) {
            templateRelations.forEach(item -> {
                String cfr_ignored_0 = (String)Validate.notBlank((CharSequence)item.getPropertyName(), (String)"\u5173\u8054\u53c2\u6570\u540d\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
            });
            propertyDbNames.addAll(templateRelations.stream().filter(item -> StringUtils.equals((CharSequence)item.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation())).map(TemplateRelationEntity::getPropertyDbName).sorted().collect(Collectors.toList()));
            propertyNames.addAll(templateRelations.stream().map(TemplateRelationEntity::getPropertyName).sorted().collect(Collectors.toList()));
        }
        this.validateCollections(propertyDbNames, propertyClassNames, propertyNames);
        Set templateGroups = template.getGroupRelations();
        if (templateGroups != null && !templateGroups.isEmpty()) {
            for (TemplateGroupEntity templateGroupItem : templateGroups) {
                Set groupProperties = templateGroupItem.getProperties();
                groupProperties.forEach(item -> {
                    String cfr_ignored_0 = (String)Validate.notBlank((CharSequence)item.getPropertyName(), (String)"\u68c0\u9a8c\u5206\u7ec4\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u53c2\u6570\u540d\u6ca1\u6709\u586b\u5199!!", (Object[])new Object[0]);
                });
                List<String> groupPropertyDbNames = templateProperties.stream().map(TemplatePropertyEntity::getPropertyDbName).sorted().collect(Collectors.toList());
                List<String> groupPropertyClassNames = templateProperties.stream().map(TemplatePropertyEntity::getPropertyClassName).sorted().collect(Collectors.toList());
                List<String> groupPropertyNames = templateProperties.stream().map(TemplatePropertyEntity::getPropertyName).sorted().collect(Collectors.toList());
                Set groupRelations = templateGroupItem.getRelations();
                if (groupRelations != null && !groupRelations.isEmpty()) {
                    groupRelations.forEach(item -> {
                        String cfr_ignored_0 = (String)Validate.notBlank((CharSequence)item.getPropertyName(), (String)"\u68c0\u9a8c\u5206\u7ec4\u5173\u8054\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u53c2\u6570\u540d\u6ca1\u6709\u586b\u5199!!", (Object[])new Object[0]);
                    });
                    groupPropertyDbNames.addAll(groupRelations.stream().filter(item -> StringUtils.equals((CharSequence)item.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation())).map(TemplateRelationEntity::getPropertyDbName).sorted().collect(Collectors.toList()));
                    groupPropertyNames.addAll(groupRelations.stream().map(TemplateRelationEntity::getPropertyName).sorted().collect(Collectors.toList()));
                }
                this.validateCollections(groupPropertyDbNames, groupPropertyClassNames, groupPropertyNames);
                Set templateItems = templateGroupItem.getItemRelations();
                if (templateItems == null || templateItems.isEmpty()) continue;
                for (TemplateItemEntity templateItem : templateItems) {
                    Set itemProperties = templateItem.getProperties();
                    itemProperties.forEach(item -> {
                        String cfr_ignored_0 = (String)Validate.notBlank((CharSequence)item.getPropertyName(), (String)"\u5206\u6790\u660e\u7ec6\u7f16\u8f91\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u53c2\u6570\u540d\u6ca1\u6709\u586b\u5199!!", (Object[])new Object[0]);
                    });
                    List<String> itemPropertyDbNames = itemProperties.stream().map(TemplatePropertyEntity::getPropertyDbName).sorted().collect(Collectors.toList());
                    List<String> itemPropertyClassNames = itemProperties.stream().map(TemplatePropertyEntity::getPropertyClassName).sorted().collect(Collectors.toList());
                    List<String> itemPropertyNames = itemProperties.stream().map(TemplatePropertyEntity::getPropertyName).sorted().collect(Collectors.toList());
                    Set itemRelations = templateItem.getRelations();
                    if (itemRelations != null && !itemRelations.isEmpty()) {
                        itemRelations.forEach(item -> {
                            String cfr_ignored_0 = (String)Validate.notBlank((CharSequence)item.getPropertyName(), (String)"\u5206\u6790\u660e\u7ec6\u7f16\u8f91\u5173\u8054\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u53c2\u6570\u540d\u6ca1\u6709\u586b\u5199!!", (Object[])new Object[0]);
                        });
                        itemPropertyDbNames.addAll(itemRelations.stream().filter(item -> StringUtils.equals((CharSequence)item.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation())).map(TemplateRelationEntity::getPropertyDbName).sorted().collect(Collectors.toList()));
                        itemPropertyNames.addAll(itemRelations.stream().map(TemplateRelationEntity::getPropertyName).sorted().collect(Collectors.toList()));
                    }
                    this.validateCollections(itemPropertyDbNames, itemPropertyClassNames, itemPropertyNames);
                }
            }
        }
        if ((itemsRelations = template.getItemRelations()) != null && !itemsRelations.isEmpty()) {
            for (TemplateItemEntity templateItem : itemsRelations) {
                Set itemProperties = templateItem.getProperties();
                itemProperties.forEach(item -> {
                    String cfr_ignored_0 = (String)Validate.notBlank((CharSequence)item.getPropertyName(), (String)"\u5206\u6790\u660e\u7ec6\u7f16\u8f91\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u53c2\u6570\u540d\u6ca1\u6709\u586b\u5199!!", (Object[])new Object[0]);
                });
                List<String> itemPropertyDbNames = itemProperties.stream().map(TemplatePropertyEntity::getPropertyDbName).sorted().collect(Collectors.toList());
                List<String> itemPropertyClassNames = itemProperties.stream().map(TemplatePropertyEntity::getPropertyClassName).sorted().collect(Collectors.toList());
                List<String> itemPropertyNames = itemProperties.stream().map(TemplatePropertyEntity::getPropertyName).sorted().collect(Collectors.toList());
                Set itemRelations = templateItem.getRelations();
                if (itemRelations != null && !itemRelations.isEmpty()) {
                    itemRelations.forEach(item -> {
                        String cfr_ignored_0 = (String)Validate.notBlank((CharSequence)item.getPropertyName(), (String)"\u5206\u6790\u660e\u7ec6\u7f16\u8f91\u5173\u8054\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u53c2\u6570\u540d\u6ca1\u6709\u586b\u5199!!", (Object[])new Object[0]);
                    });
                    itemPropertyDbNames.addAll(itemRelations.stream().filter(item -> StringUtils.equals((CharSequence)item.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation())).map(TemplateRelationEntity::getPropertyDbName).sorted().collect(Collectors.toList()));
                    itemPropertyNames.addAll(itemRelations.stream().map(TemplateRelationEntity::getPropertyName).sorted().collect(Collectors.toList()));
                }
                this.validateCollections(itemPropertyDbNames, itemPropertyClassNames, itemPropertyNames);
            }
        }
    }

    private void validateCollections(List<String> propertyDbNames, List<String> propertyClassNames, List<String> propertyNames) {
        this.validateDuplicate(propertyDbNames);
        this.validateDuplicate(propertyNames);
        Sets.SetView intersections = Sets.intersection(RETAINFIELDNAMES, new HashSet<String>(propertyDbNames));
        if (!CollectionUtils.isEmpty((Collection)intersections)) {
            String intersectionValue = Arrays.toString(intersections.toArray((Object[])new String[0]));
            throw new IllegalArgumentException(String.format("\u53d1\u73b0\u4fdd\u7559\u5b57\u88ab\u4f7f\u7528\u5728\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u4e2d\uff1a%s", intersectionValue));
        }
        intersections = Sets.intersection(RETAINFIELDNAMES, new HashSet<String>(propertyNames));
        if (!CollectionUtils.isEmpty((Collection)intersections)) {
            String intersectionValue = Arrays.toString(intersections.toArray((Object[])new String[0]));
            throw new IllegalArgumentException(String.format("\u53d1\u73b0\u4fdd\u7559\u5b57\u88ab\u4f7f\u7528\u5728\u5b57\u6bb5\u540d\u4e2d\uff1a%s", intersectionValue));
        }
        propertyClassNames.forEach(item -> {
            if (classTypeMapping.get(item) == null) {
                throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7684\u7c7b\u578b: %s (\u5982\u679c\u662f\u57fa\u7840\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528\u5bf9\u5e94\u7684\u4e3b\u7c7b\u578b)", item));
            }
        });
    }

    private void validateDuplicate(List<String> properties) {
        ArrayList<String> destProperties = new ArrayList<String>(properties);
        ArrayList duplicateProperties = new ArrayList();
        int index = 0;
        while (index < destProperties.size()) {
            String currentProperty = (String)destProperties.get(index);
            if (duplicateProperties.contains(currentProperty)) {
                throw new IllegalArgumentException(String.format("\u5728\u4e00\u7ec4\u4e0d\u80fd\u91cd\u590d\u7684\u5b57\u6bb5\u5b9a\u4e49\u4e2d\uff0c\u53d1\u73b0\u91cd\u590d\u7684\u5b57\u6bb5\u540d%s\uff0c\u8bf7\u68c0\u67e5!!", currentProperty));
            }
            duplicateProperties.add(destProperties.remove(index));
        }
    }

    private TemplatePropertyEntity autoAppendPk() {
        TemplatePropertyEntity pk = new TemplatePropertyEntity();
        pk.setIndex(Integer.valueOf(0));
        pk.setNullable(Boolean.valueOf(false));
        pk.setPropertyClassName(String.class.getName());
        pk.setPropertyDbName("id");
        pk.setPropertyDesc("\u4e3b\u952e");
        pk.setPropertyName("id");
        pk.setPrimaryKey(Boolean.valueOf(true));
        pk.setMaxLen(Integer.valueOf(255));
        pk.setUnique(Boolean.valueOf(false));
        return pk;
    }

    private TemplatePropertyEntity autoAppendFormInstanceId() {
        TemplatePropertyEntity formInstanceId = new TemplatePropertyEntity();
        formInstanceId.setIndex(Integer.valueOf(0));
        formInstanceId.setNullable(Boolean.valueOf(false));
        formInstanceId.setPropertyClassName(String.class.getName());
        formInstanceId.setPropertyDbName("form_instance_id");
        formInstanceId.setPropertyDesc("\u8868\u5355\u5b9e\u4f8b\u7f16\u53f7");
        formInstanceId.setPropertyName(FORMINSTANCE_ID);
        formInstanceId.setUnique(Boolean.valueOf(true));
        formInstanceId.setMaxLen(Integer.valueOf(255));
        return formInstanceId;
    }

    private TemplateRelationEntity autoAppendBackRelation(String parentTableName, TemplateEntity currentTemplate, TemplateGroupEntity currentGroup, TemplateItemEntity currentItem) {
        TemplateRelationEntity relation = new TemplateRelationEntity();
        relation.setBackProperty(Boolean.valueOf(true));
        relation.setCurrentGroup(currentGroup);
        relation.setCurrentItem(currentItem);
        relation.setCurrentTemplate(currentTemplate);
        relation.setIndex(Integer.valueOf(0));
        relation.setNullable(Boolean.valueOf(false));
        relation.setPropertyClassName(String.class.getName());
        relation.setPropertyDbName(String.format("%s_id", parentTableName));
        relation.setPropertyDesc("\u660e\u7ec6\u5173\u8054");
        relation.setPropertyName(String.format("%s_id", parentTableName));
        relation.setRelationType(RelationsTypeEnum.MANY_TO_ONE.getRelation());
        relation.setTargetTableName(parentTableName);
        return relation;
    }

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public TemplateEntity upgrade(String templateId, TemplateEntity newTemplate, String newVersion, Principal principal) {
        Set templateItems;
        Set templateGroups;
        Set oldItems;
        Set oldGroups;
        Set newRelations;
        Set oldRelations;
        Set newProperties;
        Validate.notNull((Object)principal, (String)"\u5fc5\u987b\u6307\u5b9a\u64cd\u4f5c\u8005\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateId, (String)"\u53c2\u7167\u52a8\u6001\u6a21\u677f\u7684\u7f16\u53f7\u5fc5\u987b\u8fdb\u884c\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)newVersion, (String)"\u5347\u7ea7\u65f6,\u65b0\u7684\u7248\u672c\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        TemplateEntity oldTemplate = this.templateService.findDetailsById(templateId);
        Validate.notNull((Object)oldTemplate, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u539f\u59cb\u52a8\u6001\u6a21\u677f\u53c2\u7167\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)oldTemplate.getType(), (CharSequence)FormTemplateTypeEnum.DYNAMIC.getType()), (String)"\u53c2\u7167\u6a21\u677f\u3010%s\u3011\u5fc5\u987b\u662f\u201c\u52a8\u6001\u201d\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{templateId});
        String tableName = oldTemplate.getTableName();
        Validate.notBlank((CharSequence)tableName, (String)"\u9519\u8bef\u7684\u4e1a\u52a1\u6570\u636e\u8868\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List<TemplateEntity> oldTemplates = this.templateRepository.findByCode(oldTemplate.getCode());
        Validate.isTrue((oldTemplates != null && !oldTemplates.isEmpty() ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230\u539f\u6709\u6a21\u677f\u4e2d\u7684\u7f16\u53f7\u5bf9\u5e94\u7684\u4efb\u4f55\u5386\u53f2\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        TemplateEntity lastTemplate = oldTemplates.get(0);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)templateId, (CharSequence)lastTemplate.getId()), (String)"\u52a8\u6001\u6a21\u677f\u5347\u7ea7\u65f6\uff0c\u53ea\u80fd\u53c2\u7167\u6700\u65b0\u7684\u6a21\u677f\u8fdb\u884c\u5347\u7ea7!", (Object[])new Object[0]);
        Validate.notNull((Object)newTemplate, (String)"\u65b0\u6a21\u677f\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)newTemplate.getId()), (String)"\u65b0\u6a21\u677f\u7684id\u7f16\u53f7\u4e0d\u80fd\u4f20\u5165", (Object[])new Object[0]);
        TemplateEntity exsitTemplate = this.templateRepository.findByCodeAndCversion(oldTemplate.getCode(), newVersion);
        Validate.isTrue((exsitTemplate == null ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u7248\u672c\u7f16\u53f7\u4fe1\u606f\u5df2\u7ecf\u5728\u6307\u5b9a\u7684code[%s]\u4e2d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6307\u5b9a\u7248\u672c\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[]{newTemplate.getCode()});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)newTemplate.getType(), (CharSequence)FormTemplateTypeEnum.DYNAMIC.getType()), (String)"\u8be5\u5347\u7ea7\u65b9\u6cd5\u53ea\u9002\u7528\u4e8e\u201c\u52a8\u6001\u8868\u5355\u6a21\u677f\u201d!!", (Object[])new Object[0]);
        Set oldProperties = oldTemplate.getProperties();
        if (oldProperties == null) {
            oldProperties = Sets.newHashSet();
            oldTemplate.setProperties(oldProperties);
        }
        if ((newProperties = newTemplate.getProperties()) == null) {
            newProperties = Sets.newHashSet();
            newTemplate.setProperties(newProperties);
        }
        if ((oldRelations = oldTemplate.getRelations()) == null) {
            oldRelations = Sets.newHashSet();
            oldTemplate.setRelations(oldRelations);
        }
        if ((newRelations = newTemplate.getRelations()) == null) {
            newRelations = Sets.newHashSet();
            newTemplate.setRelations(newRelations);
        }
        this.perfectingUpgradeProperty(tableName, newProperties);
        this.validatePropertiesAndRelations(tableName, oldProperties, newProperties, oldRelations, newRelations);
        Set newGroups = newTemplate.getGroupRelations();
        if (newGroups == null) {
            newGroups = Sets.newHashSet();
            newTemplate.setGroupRelations(newGroups);
        }
        if ((oldGroups = oldTemplate.getGroupRelations()) == null) {
            oldGroups = Sets.newHashSet();
            oldTemplate.setGroupRelations(oldGroups);
        }
        this.perfectingUpgradeOneToOneRelation(newGroups, oldGroups, tableName);
        this.validateGroups(oldGroups, newGroups);
        Set newItems = newTemplate.getItemRelations();
        if (newItems == null) {
            newItems = Sets.newHashSet();
            newTemplate.setItemRelations(newItems);
        }
        if ((oldItems = oldTemplate.getItemRelations()) == null) {
            oldItems = Sets.newHashSet();
            oldTemplate.setItemRelations(oldItems);
        }
        this.perfectingUpgradeOneToManyRelation(newTemplate, null, tableName, newItems, oldItems);
        this.validateItems(newItems, oldItems);
        UserVo user = this.userService.findByAccount(principal.getName());
        Validate.notNull((Object)user, (String)"\u672a\u627e\u5230\u4efb\u4f55\u521b\u5efa\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserEntity usere = new UserEntity();
        usere.setId(user.getId());
        newTemplate.setCreator(usere);
        newTemplate.setCreateTime(new Date());
        newTemplate.setCversion(newVersion);
        newTemplate.setTableName(tableName);
        this.templateRepository.save(newTemplate);
        this.initDynamicProperties(newTemplate, newProperties);
        Set relations = newTemplate.getRelations();
        if (relations != null && !relations.isEmpty()) {
            this.initDynamicRelations(newTemplate, relations);
        }
        if ((templateGroups = newTemplate.getGroupRelations()) != null && !templateGroups.isEmpty()) {
            for (TemplateGroupEntity templateGroup : templateGroups) {
                this.templateGroupService.initDynamicGroups(templateGroup, newTemplate);
            }
        }
        if ((templateItems = newTemplate.getItemRelations()) != null && !templateItems.isEmpty()) {
            for (TemplateItemEntity templateItem : templateItems) {
                this.templateItemService.initDynamicItems(templateItem, newTemplate, null, tableName);
            }
        }
        String newTemplateId = newTemplate.getId();
        super.upgradeTemplateLayout(templateId, newTemplateId, newTemplate);
        super.upgradeTemplateEvent(templateId, newTemplateId, newTemplate);
        super.upgradeTemplateVisibility(templateId, newTemplateId, newTemplate);
        this.tableOperateRepositoryCustom.upgradeTable(oldTemplate, newTemplate);
        this.templateService.updateDefaultVersion(newTemplateId);
        Set<String> maintainers = this.templateMaintainerRepository.findByTemplateId(templateId);
        if (!CollectionUtils.isEmpty(maintainers)) {
            for (String maintainerId : maintainers) {
                this.templateMaintainerRepository.binding(newTemplateId, maintainerId);
            }
        }
        return newTemplate;
    }

    private void validateGroups(Set<TemplateGroupEntity> oldTemplateGroups, Set<TemplateGroupEntity> newTemplateGroups) {
        List oldGroupPropertyListNames = newTemplateGroups.stream().map(TemplateGroupEntity::getPropertyName).collect(Collectors.toList());
        this.validateDuplicate(new LinkedList<String>(oldGroupPropertyListNames));
        Set newGroupPropertyNames = newTemplateGroups.stream().map(TemplateGroupEntity::getPropertyName).collect(Collectors.toSet());
        Set oldGroupPropertyNames = oldTemplateGroups.stream().map(TemplateGroupEntity::getPropertyName).collect(Collectors.toSet());
        Validate.isTrue((boolean)Sets.difference(oldGroupPropertyNames, newGroupPropertyNames).isEmpty(), (String)"\u5728\u8fdb\u884c\u6a21\u677f\u5347\u7ea7\u65f6\uff0c\u5206\u7ec4\u4fe1\u606f\u53ea\u5141\u8bb8\u65b0\u589e\u4e0d\u5141\u8bb8\u5220\u9664!!", (Object[])new Object[0]);
        Map<String, TemplateGroupEntity> oldMappingGroups = oldTemplateGroups.stream().collect(Collectors.toMap(TemplateGroupEntity::getPropertyName, item -> item));
        for (TemplateGroupEntity newTemplateGroup : newTemplateGroups) {
            Set oldItems;
            TemplateGroupEntity oldTemplateGroup = oldMappingGroups.get(newTemplateGroup.getPropertyName());
            String groupTableName = newTemplateGroup.getTableName();
            if (oldTemplateGroup == null) continue;
            Set newGroupProperties = newTemplateGroup.getProperties();
            Set newGroupRelations = newTemplateGroup.getRelations();
            Set oldGroupProperties = oldTemplateGroup.getProperties();
            Set oldGroupRelations = oldTemplateGroup.getRelations();
            this.validatePropertiesAndRelations(groupTableName, oldGroupProperties, newGroupProperties, oldGroupRelations, newGroupRelations);
            Set newItems = newTemplateGroup.getItemRelations();
            if (newItems == null) {
                newItems = Sets.newHashSet();
            }
            if ((oldItems = oldTemplateGroup.getItemRelations()) == null) {
                oldItems = Sets.newHashSet();
            }
            this.validateItems(newItems, oldItems);
        }
    }

    private void validateItems(Set<TemplateItemEntity> newItems, Set<TemplateItemEntity> oldItems) {
        List<String> newItemNames = newItems.stream().map(TemplateItemEntity::getPropertyName).collect(Collectors.toList());
        this.validateDuplicate(newItemNames);
        Map<String, TemplateItemEntity> oldMappingItems = oldItems.stream().collect(Collectors.toMap(TemplateItemEntity::getPropertyName, item -> item));
        for (TemplateItemEntity newItem : newItems) {
            String propertyName = newItem.getPropertyName();
            String itemTableName = newItem.getTableName();
            Validate.notBlank((CharSequence)itemTableName, (String)"\u660e\u7ec6\u8868\u5fc5\u987b\u6307\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            TemplateItemEntity oldItem = oldMappingItems.get(propertyName);
            if (oldItem == null) continue;
            Set oldItemProperties = oldItem.getProperties();
            Set newItemProperties = newItem.getProperties();
            Set oldItemRelations = oldItem.getRelations();
            Set newItemRelations = newItem.getRelations();
            this.validatePropertiesAndRelations(itemTableName, oldItemProperties, newItemProperties, oldItemRelations, newItemRelations);
        }
    }

    private void validatePropertiesAndRelations(String tableName, Set<TemplatePropertyEntity> oldProperties, Set<TemplatePropertyEntity> newProperties, Set<TemplateRelationEntity> oldRelations, Set<TemplateRelationEntity> newRelations) {
        Sets.SetView appendedRelationNames;
        List<String> newPropertyListNames = newProperties.stream().map(TemplatePropertyEntity::getPropertyName).collect(Collectors.toList());
        List<String> newRelationListNames = newRelations.stream().map(TemplateRelationEntity::getPropertyName).collect(Collectors.toList());
        this.validateDuplicate(newPropertyListNames);
        this.validateDuplicate(newRelationListNames);
        Set oldPropertyNames = oldProperties.stream().map(TemplatePropertyEntity::getPropertyName).collect(Collectors.toSet());
        Set newPropertyNames = newProperties.stream().map(TemplatePropertyEntity::getPropertyName).collect(Collectors.toSet());
        Set oldRelationNames = oldRelations.stream().map(TemplateRelationEntity::getPropertyName).collect(Collectors.toSet());
        Set newRelationNames = newRelations.stream().map(TemplateRelationEntity::getPropertyName).collect(Collectors.toSet());
        Validate.isTrue((newProperties.stream().filter(item -> !StringUtils.isBlank((CharSequence)item.getId())).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5347\u7ea7\u65f6\uff0c\u6240\u6709\u4e00\u822c\u5c5e\u6027\u7684id\u7f16\u53f7\u90fd\u4e0d\u80fd\u4f20\u5165", (Object[])new Object[0]);
        Validate.isTrue((newRelations.stream().filter(item -> !StringUtils.isBlank((CharSequence)item.getId())).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5347\u7ea7\u65f6\uff0c\u6240\u6709\u5173\u8054\u5c5e\u6027\u7684id\u7f16\u53f7\u90fd\u4e0d\u80fd\u4f20\u5165", (Object[])new Object[0]);
        Map<String, TemplatePropertyEntity> newMappingProperties = newProperties.stream().collect(Collectors.toMap(TemplatePropertyEntity::getPropertyName, item -> item));
        Map<String, TemplateRelationEntity> newMappingRelations = newRelations.stream().collect(Collectors.toMap(TemplateRelationEntity::getPropertyName, item -> item));
        Validate.isTrue((boolean)Sets.difference(oldPropertyNames, newPropertyNames).isEmpty(), (String)"\u4e00\u822c\u5c5e\u6027\u53ea\u80fd\u8fdb\u884c\u65b0\u589e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u3002\u8bf7\u68c0\u67e5\u3010%s\u3011", (Object[])new Object[]{tableName});
        Validate.isTrue((boolean)Sets.difference(oldRelationNames, newRelationNames).isEmpty(), (String)"\u5173\u8054\u5c5e\u6027\u53ea\u80fd\u8fdb\u884c\u65b0\u589e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u3002\u8bf7\u68c0\u67e5\u3010%s\u3011", (Object[])new Object[]{tableName});
        Set oldNullProperties = oldProperties.stream().filter(TemplatePropertyEntity::getNullable).map(TemplatePropertyEntity::getPropertyName).collect(Collectors.toSet());
        for (Object oldNullPropertyName : oldNullProperties) {
            TemplatePropertyEntity newTemplateProperty = newMappingProperties.get(oldNullPropertyName);
            Validate.notNull((Object)newTemplateProperty, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u4e00\u822c\u5c5e\u6027\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)newTemplateProperty.getNullable(), (String)"\u6307\u5b9a\u7684\u4e00\u822c\u5c5e\u6027\u5728\u5347\u7ea7\u65f6\uff0c\u4e0d\u80fd\u88ab\u4ece not null able\u8bbe\u7f6e\u4e3anull able\uff0c\u8bf7\u68c0\u67e5\u3010%s\u3011", (Object[])new Object[]{oldNullPropertyName});
        }
        Set oldNullRelations = oldRelations.stream().filter(TemplateRelationEntity::getNullable).map(TemplateRelationEntity::getPropertyName).collect(Collectors.toSet());
        for (String oldNullRelationName : oldNullRelations) {
            TemplateRelationEntity newTemplateRelation = newMappingRelations.get(oldNullRelationName);
            Validate.notNull((Object)newTemplateRelation, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u5173\u8054\u5c5e\u6027\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)newTemplateRelation.getNullable(), (String)"\u6307\u5b9a\u7684\u5173\u8054\u5c5e\u6027\u5728\u5347\u7ea7\u65f6\uff0c\u4e0d\u80fd\u88ab\u4ece not null able\u8bbe\u7f6e\u4e3anull able\uff0c\u8bf7\u68c0\u67e5\u3010%s\u3011", (Object[])new Object[]{oldNullRelationName});
        }
        Sets.SetView appendedPropertyNames = Sets.difference(newPropertyNames, oldPropertyNames);
        if (!appendedPropertyNames.isEmpty()) {
            for (String appendedPropertyName : appendedPropertyNames) {
                TemplatePropertyEntity item2 = newMappingProperties.get(appendedPropertyName);
                Validate.isTrue((boolean)item2.getNullable(), (String)"\u65b0\u589e\u4e00\u822c\u5b57\u6bb5%s\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u4e3a not nullable\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{appendedPropertyName});
            }
        }
        if (!(appendedRelationNames = Sets.difference(newRelationNames, oldRelationNames)).isEmpty()) {
            for (String appendedRelationName : appendedRelationNames) {
                TemplateRelationEntity item3 = newMappingRelations.get(appendedRelationName);
                Validate.isTrue((boolean)item3.getNullable(), (String)"\u65b0\u589e\u7684\u5173\u8054\u5b57\u6bb5%s\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u4e3a not nullable\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{appendedRelationName});
            }
        }
        Set oldStringProperties = oldProperties.stream().filter(item -> StringUtils.equals((CharSequence)String.class.getName(), (CharSequence)item.getPropertyClassName())).collect(Collectors.toSet());
        for (TemplatePropertyEntity oldStringProperty : oldStringProperties) {
            Integer oldMaxLen = oldStringProperty.getMaxLen();
            if (oldMaxLen == null) {
                oldMaxLen = 255;
            }
            String propertyName = oldStringProperty.getPropertyName();
            TemplatePropertyEntity newTemplateProperty = newMappingProperties.get(propertyName);
            Validate.notNull((Object)newTemplateProperty, (String)"\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ba1\u7406\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5\u3010%s\u3011", (Object[])new Object[]{propertyName});
            Integer newMaxLen = newTemplateProperty.getMaxLen();
            Validate.isTrue((newMaxLen >= oldMaxLen ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u6a21\u677f\u5347\u7ea7\u65f6\uff0c\u5b57\u7b26\u4e32\u5c5e\u6027\u5b57\u6bb5\u7684\u957f\u5ea6\u53ea\u80fd\u589e\u52a0\u4e0d\u80fd\u51cf\u5c11\uff0c\u8bf7\u68c0\u67e5%s\u3010%s\u3011", (Object[])new Object[]{propertyName, tableName});
        }
    }

    private void perfectingUpgradeProperty(String parentTableName, Set<TemplatePropertyEntity> newProperties) {
        Validate.isTrue((boolean)this.tableOperateRepositoryCustom.existTableName(parentTableName), (String)"\u68c0\u6d4b\u5230\u4e3b\u4e1a\u52a1\u6570\u636e\u8868'%s'\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{parentTableName});
        Validate.isTrue((newProperties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)"id")).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u5347\u7ea7\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u4e3b\u8868\u7684id\u4e3b\u952e\u5c5e\u6027", (Object[])new Object[0]);
        newProperties.add(this.autoAppendPk());
        Validate.isTrue((newProperties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)FORMINSTANCE_ID)).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u5347\u7ea7\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u4e3b\u8868\u7684formInstanceId\u8868\u5355\u5b9e\u4f8b\u5c5e\u6027", (Object[])new Object[0]);
        newProperties.add(this.autoAppendFormInstanceId());
        for (TemplatePropertyEntity newProperty : newProperties) {
            String propertyName = newProperty.getPropertyName();
            Validate.notBlank((CharSequence)propertyName, (String)"\u4e00\u822c\u5c5e\u6027\u540d\u79f0\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            String propertyDesc = newProperty.getPropertyDesc();
            Validate.notBlank((CharSequence)propertyDesc, (String)"\u4e00\u822c\u5c5e\u6027\u8bf4\u660e\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
            String propertyDbName = newProperty.getPropertyDbName();
            Validate.notBlank((CharSequence)propertyDbName, (String)"\u4e00\u822c\u5c5e\u6027'%s'\u7684\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[]{propertyDbName});
        }
    }

    private void perfectingUpgradeRelation(String parentTableName, TemplateRelationEntity newRelation, TemplateRelationEntity oldRelation) {
        String propertyClassName;
        String targetTableName = newRelation.getTargetTableName();
        Validate.notBlank((CharSequence)targetTableName, (String)"\u5173\u8054\u4fe1\u606f\u5fc5\u987b\u8bbe\u5b9a\u6570\u636e\u8868!!", (Object[])new Object[0]);
        String propertyName = newRelation.getPropertyName();
        Validate.notBlank((CharSequence)propertyName, (String)"\u5173\u8054\u5c5e\u6027\u540d\u79f0\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String propertyDesc = newRelation.getPropertyDesc();
        Validate.notBlank((CharSequence)propertyDesc, (String)"\u5173\u8054\u5c5e\u6027\u8bf4\u660e\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String relationType = newRelation.getRelationType();
        Validate.notBlank((CharSequence)relationType, (String)"\u5173\u8054\u5c5e\u6027\u7c7b\u578b\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.equals((CharSequence)relationType, (CharSequence)RelationsTypeEnum.MANY_TO_ONE.getRelation()) || StringUtils.equals((CharSequence)relationType, (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation()) ? 1 : 0) != 0, (String)"\u5173\u8054\u5c5e\u6027\u7c7b\u578b\u53ea\u80fd\u662fManyToOne\u6216\u8005ManyToMany", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)relationType, (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation())) {
            String propertyDbName = newRelation.getPropertyDbName();
            Validate.notBlank((CharSequence)propertyDbName, (String)"\u5173\u8054\u5c5e\u6027'%s'\u7684\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[]{propertyName});
        }
        if (StringUtils.isBlank((CharSequence)(propertyClassName = newRelation.getPropertyClassName()))) {
            newRelation.setPropertyClassName(String.class.getName());
        }
        Validate.isTrue((boolean)this.tableOperateRepositoryCustom.existTableName(targetTableName), (String)"\u68c0\u6d4b\u5230\u6570\u636e\u8868%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{targetTableName});
        if (oldRelation == null && StringUtils.equals((CharSequence)newRelation.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation())) {
            List sortedNames = Arrays.stream(new String[]{parentTableName, targetTableName}).sorted().collect(Collectors.toList());
            String mappingTable = String.format(MAPPING, sortedNames.get(0), sortedNames.get(1));
            Validate.isTrue((this.tableOperateRepositoryCustom.existTableName(mappingTable) == false ? 1 : 0) != 0, (String)"\u68c0\u6d4b\u5230\u6570\u636e\u8868 '%s'\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u8868\u540d!!", (Object[])new Object[]{mappingTable});
        } else if (oldRelation != null && StringUtils.equals((CharSequence)newRelation.getRelationType(), (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation())) {
            List sortedNames = Arrays.stream(new String[]{parentTableName, targetTableName}).sorted().collect(Collectors.toList());
            String mappingTable = String.format(MAPPING, sortedNames.get(0), sortedNames.get(1));
            Validate.isTrue((boolean)this.tableOperateRepositoryCustom.existTableName(mappingTable), (String)"\u68c0\u6d4b\u5230\u6570\u636e\u8868'%s'\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{mappingTable});
        }
    }

    private void perfectingUpgradeOneToManyRelation(TemplateEntity parentTemplate, TemplateGroupEntity parentGroup, String parentTableName, Set<TemplateItemEntity> newItems, Set<TemplateItemEntity> oldItems) {
        if (CollectionUtils.isEmpty(oldItems)) {
            return;
        }
        Map<String, TemplateItemEntity> oldItemsMapping = oldItems.stream().collect(Collectors.toMap(TemplateItemEntity::getTableName, item -> item));
        for (TemplateItemEntity newItem : newItems) {
            String tableName = newItem.getTableName();
            Validate.notBlank((CharSequence)tableName, (String)"\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u660e\u7ec6\u7f16\u8f91\u8868\u6ca1\u6709\u8bbe\u5b9a\u6570\u636e\u8868\u540d!!", (Object[])new Object[0]);
            Validate.matchesPattern((CharSequence)tableName, (String)TABLEFORMAT, (String)"\u6570\u636e\u8868\u53ea\u80fd\u4f7f\u7528\u6570\u5b57\u3001\u5b57\u6bcd\uff08\u652f\u6301\u5927\u5c0f\u5199\uff09\u548c\u201c_\u201d\u7b26\u53f7[%s]", (Object[])new Object[]{tableName});
            newItem.setParentTableName(parentTableName);
            Set oneToManyProperties = newItem.getProperties();
            Validate.notNull((Object)oneToManyProperties, (String)"\u8bf7\u81f3\u5c11\u4e3a\u660e\u7ec6\u8868\uff08%s\uff09\u8bbe\u5b9a\u4e00\u4e2a\u4e00\u822c\u5c5e\u6027", (Object[])new Object[]{tableName});
            Validate.isTrue((!oneToManyProperties.isEmpty() ? 1 : 0) != 0, (String)"\u8bf7\u81f3\u5c11\u4e3a\u660e\u7ec6\u8868\uff08%s\uff09\u8bbe\u5b9a\u4e00\u4e2a\u4e00\u822c\u5c5e\u6027", (Object[])new Object[]{tableName});
            Validate.isTrue((oneToManyProperties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)"id")).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u660e\u7ec6\u7f16\u8f91\u8868\uff08%s\uff09\u7684id\u4e3b\u952e\u5c5e\u6027", (Object[])new Object[]{tableName});
            oneToManyProperties.add(this.autoAppendPk());
            LinkedHashSet<TemplateRelationEntity> omRelations = newItem.getRelations();
            TemplateItemEntity oldItem = oldItemsMapping.get(tableName);
            if (omRelations != null && !omRelations.isEmpty()) {
                Object oldRelations;
                Map<Object, Object> oldRelationMappings = Maps.newHashMap();
                if (oldItem != null && (oldRelations = oldItem.getRelations()) != null && !oldRelations.isEmpty()) {
                    oldRelationMappings = oldRelations.stream().collect(Collectors.toMap(TemplateRelationEntity::getPropertyName, item -> item));
                }
                oldRelations = omRelations.iterator();
                while (oldRelations.hasNext()) {
                    TemplateRelationEntity relation = (TemplateRelationEntity)oldRelations.next();
                    String propertyName = relation.getPropertyName();
                    this.perfectingUpgradeRelation(tableName, relation, (TemplateRelationEntity)oldRelationMappings.get(propertyName));
                }
            }
            if (omRelations == null) {
                omRelations = new LinkedHashSet<TemplateRelationEntity>();
                newItem.setRelations(omRelations);
            }
            TemplateRelationEntity backRelation = this.autoAppendBackRelation(parentTableName, parentTemplate, parentGroup, newItem);
            String backRelationDbName = backRelation.getPropertyDbName();
            Validate.isTrue((omRelations.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)backRelationDbName)).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u660e\u7ec6\u7f16\u8f91\u8868\uff08%s\uff09\u548c\u4e3b\u8868\u7684\u5173\u8054\u5c5e\u6027\uff08%s\uff09", (Object[])new Object[]{tableName, backRelationDbName});
            omRelations.add(backRelation);
        }
        Set oldItemNames = oldItems.stream().map(TemplateItemEntity::getPropertyName).collect(Collectors.toSet());
        Set newItemNames = newItems.stream().map(TemplateItemEntity::getPropertyName).collect(Collectors.toSet());
        Sets.SetView appendItemNames = Sets.difference(newItemNames, oldItemNames);
        Set appendItems = newItems.stream().filter(item -> appendItemNames.contains((Object)item.getPropertyName())).collect(Collectors.toSet());
        for (TemplateItemEntity appendItem : appendItems) {
            String tableName = appendItem.getTableName();
            Validate.isTrue((this.tableOperateRepositoryCustom.existTableName(tableName) == false ? 1 : 0) != 0, (String)"\u68c0\u6d4b\u5230\u6570\u636e\u8868'%s'\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u8868\u540d!!", (Object[])new Object[]{tableName});
        }
    }

    private void perfectingUpgradeOneToOneRelation(Set<TemplateGroupEntity> newGroups, Set<TemplateGroupEntity> oldGroups, String parentTableName) {
        Map<Object, Object> oldGroupMappings = Maps.newHashMap();
        if (oldGroups != null) {
            oldGroupMappings = oldGroups.stream().collect(Collectors.toMap(TemplateGroupEntity::getTableName, item -> item));
        }
        for (TemplateGroupEntity newGroup : newGroups) {
            Object oldGroupRelations;
            String tableName = newGroup.getTableName();
            Validate.notBlank((CharSequence)tableName, (String)"\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u5206\u7ec4\u4fe1\u606f\u8868\u6ca1\u6709\u8bbe\u5b9a\u6570\u636e\u8868\u540d!!", (Object[])new Object[0]);
            Validate.matchesPattern((CharSequence)tableName, (String)TABLEFORMAT, (String)"\u6570\u636e\u8868\u53ea\u80fd\u4f7f\u7528\u6570\u5b57\u3001\u5b57\u6bcd\uff08\u652f\u6301\u5927\u5c0f\u5199\uff09\u548c\u201c_\u201d\u7b26\u53f7[%s]", (Object[])new Object[]{tableName});
            newGroup.setParentTableName(parentTableName);
            Set properties = newGroup.getProperties();
            Validate.notNull((Object)properties, (String)"\u8bf7\u81f3\u5c11\u4e3a\u5206\u7ec4\u8868\uff08%s\uff09\u8bbe\u5b9a\u4e00\u4e2a\u4e00\u822c\u5c5e\u6027", (Object[])new Object[]{tableName});
            Validate.isTrue((!properties.isEmpty() ? 1 : 0) != 0, (String)"\u8bf7\u81f3\u5c11\u4e3a\u5206\u7ec4\u8868\uff08%s\uff09\u8bbe\u5b9a\u4e00\u4e2a\u4e00\u822c\u5c5e\u6027", (Object[])new Object[]{tableName});
            Validate.isTrue((properties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)"id")).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u5347\u7ea7\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u5206\u7ec4\u8868\u7684id\u4e3b\u952e\u5c5e\u6027", (Object[])new Object[0]);
            properties.add(this.autoAppendPk());
            LinkedHashSet<TemplateRelationEntity> newRelations = newGroup.getRelations();
            TemplateGroupEntity oldGroup = (TemplateGroupEntity)oldGroupMappings.get(tableName);
            if (newRelations == null) {
                newRelations = new LinkedHashSet<TemplateRelationEntity>();
                newGroup.setRelations(newRelations);
            }
            Map<Object, Object> oldGroupRelationMappings = Maps.newHashMap();
            if (oldGroup != null && (oldGroupRelations = oldGroup.getRelations()) != null) {
                oldGroupRelationMappings = oldGroupRelations.stream().collect(Collectors.toMap(TemplateRelationEntity::getPropertyName, item -> item));
            }
            oldGroupRelations = newRelations.iterator();
            while (oldGroupRelations.hasNext()) {
                TemplateRelationEntity relation = (TemplateRelationEntity)oldGroupRelations.next();
                TemplateRelationEntity oldGroupRelation = (TemplateRelationEntity)oldGroupRelationMappings.get(relation.getPropertyName());
                this.perfectingUpgradeRelation(tableName, relation, oldGroupRelation);
            }
            TemplateRelationEntity backRelation = this.autoAppendBackRelation(parentTableName, null, newGroup, null);
            String backRelationDbName = backRelation.getPropertyDbName();
            Validate.isTrue((newRelations.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyDbName(), (CharSequence)backRelationDbName)).count() == 0L ? 1 : 0) != 0, (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u53ef\u8bbe\u5b9a\u660e\u7ec6\u7f16\u8f91\u8868\uff08%s\uff09\u548c\u4e3b\u8868\u7684\u5173\u8054\u5c5e\u6027\uff08%s\uff09", (Object[])new Object[]{tableName, backRelationDbName});
            newRelations.add(backRelation);
            Set templateItems = newGroup.getItemRelations();
            Set oldItems = null;
            if (oldGroup != null) {
                oldItems = oldGroup.getItemRelations();
            }
            this.perfectingUpgradeOneToManyRelation(null, newGroup, tableName, templateItems, oldItems);
        }
        Set oldGroupNames = oldGroups.stream().map(TemplateGroupEntity::getPropertyName).collect(Collectors.toSet());
        Set newGroupNames = newGroups.stream().map(TemplateGroupEntity::getPropertyName).collect(Collectors.toSet());
        Sets.SetView appendGroupNames = Sets.difference(newGroupNames, oldGroupNames);
        Set appendGroups = newGroups.stream().filter(item -> appendGroupNames.contains((Object)item.getPropertyName())).collect(Collectors.toSet());
        for (TemplateGroupEntity templateGroup : appendGroups) {
            String tableName = templateGroup.getTableName();
            Validate.isTrue((this.tableOperateRepositoryCustom.existTableName(tableName) == false ? 1 : 0) != 0, (String)"\u68c0\u6d4b\u5230\u6570\u636e\u8868'%s'\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u8868\u540d!!", (Object[])new Object[]{tableName});
        }
    }

    public TemplateEntity findStructByTemplateId(String templateId) {
        Validate.notBlank((CharSequence)templateId, (String)"\u4f20\u5165\u7684\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity template = this.templateService.findDetailsById(templateId);
        Validate.notNull((Object)template, (String)"\u6839\u636e\u6a21\u677fID\u672a\u80fd\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        template.setId(null);
        template.setCversion(null);
        this.cleanProps(template.getProperties());
        this.cleanRelations(template.getRelations());
        this.cleanItems(template.getItemRelations());
        this.cleanGroups(template.getGroupRelations());
        return template;
    }

    private void cleanProps(Set<TemplatePropertyEntity> props) {
        if (!CollectionUtils.isEmpty(props)) {
            props.removeIf(e -> {
                e.setId(null);
                return StringUtils.equalsIgnoreCase((CharSequence)e.getPropertyName(), (CharSequence)"id") || StringUtils.equalsIgnoreCase((CharSequence)e.getPropertyName(), (CharSequence)FORMINSTANCE_ID);
            });
        }
    }

    private void cleanRelations(Set<TemplateRelationEntity> relations) {
        if (!CollectionUtils.isEmpty(relations)) {
            relations.removeIf(e -> {
                e.setId(null);
                return e.getBackProperty();
            });
        }
    }

    private void cleanItems(Set<TemplateItemEntity> items) {
        if (!CollectionUtils.isEmpty(items)) {
            items.stream().forEach(item -> {
                item.setId(null);
                this.cleanProps(item.getProperties());
                this.cleanRelations(item.getRelations());
            });
        }
    }

    private void cleanGroups(Set<TemplateGroupEntity> groups) {
        if (!CollectionUtils.isEmpty(groups)) {
            groups.stream().forEach(group -> {
                group.setId(null);
                this.cleanProps(group.getProperties());
                this.cleanRelations(group.getRelations());
                this.cleanItems(group.getItemRelations());
            });
        }
    }

    static {
        classTypeMapping.put(String.class.getName(), "varchar");
        classTypeMapping.put(Integer.class.getName(), "int");
        classTypeMapping.put(Long.class.getName(), "bigint");
        classTypeMapping.put(Float.class.getName(), "float");
        classTypeMapping.put(BigDecimal.class.getName(), DOUBLE);
        classTypeMapping.put(Double.class.getName(), DOUBLE);
        classTypeMapping.put(Boolean.class.getName(), "bit");
        classTypeMapping.put(Date.class.getName(), "timestamp");
        RETAINFIELDNAMES = Sets.newHashSet((Object[])new String[]{"add", "all", "alter", "analyze", "and", "as", "asc", "asensitive", "before", "between", "bigint", "binary", "blob", "both", "by", "call", "cascade", "case", "create", "change", "char", "character", "check", "collate", "column", "condition", "connection", "constraint", "continue", "convert", "cross", "current_date", "current_time", "current_timestamp", "current_user", "cursor", "database", "databases", "day_hour", "day_microsecond", "day_minute", "day_second", "dec", "decimal", "declare", "default", "delayed", "delete", "desc", "describe", "deterministic", "distinct", "distinctrow", "div", DOUBLE, "drop", "dual", "each", "else", "elseif", "enclosed", "escaped", "exists", "exit", "explain", "false", "fetch", "float", "float4", "float8", "for", "force", "foreign", "from", "fulltext", "goto", "grant", "group", "having", "high_priority", "hour_microsecond", "hour_minute", "hour_second", "if", "ignore", "in", "index", "infile", "inner", "inout", "insensitive", "insert", "int", "int1", "int2", "int3", "int4", "int8", "integer", "interval", "into", "is", "iterate", "join", "key", "keys", "kill", "label", "leading", "leave", "left", "like", "limit", "linear", "lines", "load", "localtime", "localtimestamp", "lock", "long", "longblob", "longtext", "loop", "low_priority", "match", "mediumblob", "mediumint", "mediumtext", "middleint", "minute_microsecond", "minute_second", "mod", "modifies", "natural", "not", "no_write_to_binlog", "null", "numeric", "on", "optimize", "option", "optionally", "or", "order", "out", "outer", "outfile", "precision", "primary", "procedure", "purge", "raid0", "range", "read", "reads", "real", "references", "regexp", "release", "rename", "repeat", "replace", "require", "restrict", "return", "revoke", "right", "rlike", "schema", "second_microsecond", "select", "sensitive", "separator", "set", "show", "smallint", "spatial", "specific", "sql", "sqlexception", "sqlstate", "sqlwarning", "sql_big_result", "sql_calc_found_rows", "sql_small_result", "ssl", "starting", "straight_join", "table", "terminated", "then", "tinyblob", "tinyint", "tinytext", "to", "trailing", "trigger", "true", "undo", "union", "unique", "unlock", "unsigned", "update", "usage", "use", "using", "utc_date", "utc_time", "utc_timestamp", "values", "varbinary", "varchar", "varcharacter", "varying", "when", "where", "while", "with", "write", "x509", "xor", "year_month", "zerofill"});
    }
}

