/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.InputParamsModel;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.entity.InstanceViewEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.service.InstanceService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.InstanceRepository;
import com.bizunited.platform.kuiper.starter.repository.internal.InstanceViewRepositoryCustom;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="InstanceServiceImpl")
public class InstanceServiceImpl
implements InstanceService {
    @Autowired
    private InstanceRepository instanceRepository;
    @Autowired
    private InstanceViewRepositoryCustom instanceViewRepositoryCustom;
    @Autowired
    private UserService userService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;
    @Autowired
    private TemplateLayoutService templateLayoutService;
    @Autowired
    private InstanceActivityService instanceActivityService;
    @Autowired
    private ServicableMethodService servicableMethodService;
    @Autowired
    private ApplicationContext ctx;

    @Transactional
    public InstanceEntity create(InstanceEntity instance, String taskCode, Principal principal) {
        Validate.notNull((Object)instance, (String)"\u8981\u521b\u5efa\u5b9e\u4f8b\u7684\u57fa\u672c\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)instance.getId()), (String)"\u521b\u5efa\u5b9e\u4f8b\u65f6\uff0c\u5176id\u4fe1\u606f\u4e0d\u80fd\u4f20\u5165", (Object[])new Object[0]);
        instance.setId(null);
        Validate.notNull((Object)principal, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String userAccount = principal.getName();
        Validate.notBlank((CharSequence)userAccount, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u7528\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(userAccount);
        Validate.notNull((Object)user, (String)"\u672a\u53d1\u73b0\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity template = instance.getTemplate();
        Validate.notNull((Object)template, (String)"\u672a\u627e\u8bbe\u5b9a\u7684\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        return this.createInstance(template.getId(), taskCode, user, principal);
    }

    @Transactional
    public InstanceEntity create(String templateCode, String cversion, String taskCode, Principal principal) {
        Validate.notBlank((CharSequence)templateCode, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cversion, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u677f\u4e1a\u52a1\u7248\u672c\u53f7", (Object[])new Object[0]);
        Validate.notNull((Object)principal, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String userAccount = principal.getName();
        Validate.notBlank((CharSequence)userAccount, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u7528\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        TemplateEntity template = this.templateService.findByCodeAndCversion(templateCode, cversion);
        Validate.notNull((Object)template, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u7248", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(userAccount);
        Validate.notNull((Object)user, (String)"\u672a\u53d1\u73b0\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return this.createInstance(template.getId(), taskCode, user, principal);
    }

    @Transactional
    public InstanceEntity create(String templateCode, String taskCode, Principal principal) {
        Validate.notBlank((CharSequence)templateCode, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        List templates = this.templateService.findByCode(templateCode);
        Validate.notEmpty((Collection)templates, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7\u7684\u4efb\u4f55\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notNull((Object)principal, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String userAccount = principal.getName();
        Validate.notBlank((CharSequence)userAccount, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u7528\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(userAccount);
        Validate.notNull((Object)user, (String)"\u672a\u53d1\u73b0\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (templates.size() == 1) {
            return this.createInstance(((TemplateEntity)templates.get(0)).getId(), taskCode, user, principal);
        }
        TemplateEntity currentTemplate = templates.stream().filter(TemplateEntity::getDefaultVersion).findFirst().orElse(null);
        if (currentTemplate == null) {
            currentTemplate = templates.stream().sorted(Comparator.comparing(TemplateEntity::getCreateTime).reversed()).findFirst().orElse(null);
        }
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return this.createInstance(currentTemplate.getId(), taskCode, user, principal);
    }

    private InstanceEntity createInstance(String currentTemplateId, String taskCode, UserVo user, Principal principal) {
        Validate.notBlank((CharSequence)currentTemplateId, (String)"\u672a\u627e\u8bbe\u5b9a\u7684\u6a21\u677f\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        TemplateEntity currentTemplate = this.templateService.findById(currentTemplateId);
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u6a21\u677fid\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        JSONObject templateLayout = this.templateLayoutService.findDetailsByTemplateId(currentTemplateId, 1);
        Validate.notNull((Object)templateLayout, (String)"\u5f53\u524d\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\uff0c\u8fd8\u672a\u786e\u8ba4\u5e03\u5c40\u4fe1\u606f\uff0c\u65e0\u6cd5\u521b\u5efa\u5b9e\u4f8b\u3002\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((currentTemplate.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u6a21\u677f\u7684\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff08\u6a21\u677f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7981\u7528\uff09!", (Object[])new Object[0]);
        Date currentTime = new Date();
        InstanceEntity currentInstance = new InstanceEntity();
        currentInstance.setCreateTime(currentTime);
        UserEntity usere = new UserEntity();
        usere.setId(user.getId());
        currentInstance.setCreator(usere);
        currentInstance.setDomain(currentTemplate.getDomain());
        currentInstance.setPorjectName(currentTemplate.getPorjectName());
        currentInstance.setTemplate(currentTemplate);
        this.instanceRepository.save(currentInstance);
        TemplateVisibilityEntity visibility = this.templateVisibilityService.findByTemplateIdAndVisibilityName(currentTemplate.getId(), "create");
        Validate.notNull((Object)visibility, (String)"\u8868\u5355\u5b9e\u4f8b\u53c2\u8003\u7684\u6a21\u677f\u4e0b\uff0c\u6ca1\u6709\u540d\u79f0\u4e3a\u201ccreate\u201d\u7684\u53ef\u89c1\u6027\u914d\u7f6e(\u6d3b\u52a8)\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        InstanceActivityEntity activity = new InstanceActivityEntity();
        activity.setInstance(currentInstance);
        activity.setCreateTime(currentTime);
        UserEntity creatore = new UserEntity();
        creatore.setId(user.getId());
        activity.setCreator(creatore);
        UserEntity modifyere = new UserEntity();
        modifyere.setId(user.getId());
        activity.setModifyer(modifyere);
        activity.setModifyTime(currentTime);
        activity.setPreviousActivity(null);
        activity.setTemplate(currentTemplate);
        activity.setTemplateVisibility(visibility);
        if (!StringUtils.isBlank((CharSequence)taskCode)) {
            activity.setTaskCode(taskCode);
        }
        this.instanceActivityService.create(activity, principal);
        currentInstance.setActivities(Arrays.asList(activity));
        return currentInstance;
    }

    @Transactional
    public InstanceEntity create(String templateCode, String taskCode, Principal principal, String serviceName, JSONObject formData, Map<String, Object> params) {
        Validate.notNull((Object)formData, (String)"\u4f20\u5165\u7684\u8868\u5355\u6570\u636e\u4e0d\u53ef\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        InstanceEntity currentInstance = this.create(templateCode, taskCode, principal);
        String currentInstanceId = currentInstance.getId();
        List activities = currentInstance.getActivities();
        Validate.notNull((Object)activities, (String)"\u6ca1\u6709\u6210\u529f\u521b\u5efa\u8868\u5355\u6d3b\u52a8\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((activities.size() == 1 ? 1 : 0) != 0, (String)"\u672a\u77e5\u7684\u5b9e\u4f8b\u521d\u59cb\u5316\u9519\u8bef\uff08\u521b\u5efa\u4e86\u591a\u4e2a\u6d3b\u52a8\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        InstanceActivityEntity currentActivity = (InstanceActivityEntity)activities.get(0);
        String currentActivityId = currentActivity.getId();
        TemplateEntity currentTemplate = currentInstance.getTemplate();
        Validate.notNull((Object)currentTemplate, (String)"\u9519\u8bef\u7684\u521b\u5efa\u8fc7\u7a0b\uff0c\u672a\u53d1\u73b0\u5173\u8054\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        String templateId = currentTemplate.getId();
        Validate.notBlank((CharSequence)templateId, (String)"\u9519\u8bef\u7684\u521b\u5efa\u8fc7\u7a0b\uff0c\u672a\u53d1\u73b0\u5173\u8054\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        String templateType = currentTemplate.getType();
        Validate.isTrue((StringUtils.equals((CharSequence)templateType, (CharSequence)"dynamic") || StringUtils.equals((CharSequence)templateType, (CharSequence)"static") ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u6a21\u677f\u7c7b\u578b[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateType});
        HashMap<String, InputParamsModel> paramMapping = new HashMap<String, InputParamsModel>();
        params.put("opType", "create");
        params.put("instanceActivityId", currentActivityId);
        params.put("formInstanceId", currentInstanceId);
        params.put("formData", formData);
        if (StringUtils.equals((CharSequence)templateType, (CharSequence)"dynamic")) {
            InvokeProxy dynamicFormWriteProxy = (InvokeProxy)this.ctx.getBean("DynamicFormWriteProxy");
            try {
                dynamicFormWriteProxy.doHandle(paramMapping);
            }
            catch (InvokeProxyException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Validate.notBlank((CharSequence)serviceName, (String)"\u670d\u52a1\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ServicableMethodEntity entity = this.servicableMethodService.findDetailsByName(serviceName);
        Validate.notNull((Object)entity, (String)"\u6839\u636e\u670d\u52a1\u540d%s\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u670d\u52a1\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{serviceName});
        paramMapping.put(InputParamsModel.class.getName(), new InputParamsModel());
        try {
            if (StringUtils.equals((CharSequence)entity.getUsedScope(), (CharSequence)"WRITE")) {
                this.servicableMethodService.writeInvoke(paramMapping);
            } else {
                this.servicableMethodService.readInvoke(paramMapping);
            }
        }
        catch (InvokeProxyException e) {
            throw new IllegalArgumentException(e);
        }
        return currentInstance;
    }

    public InstanceEntity findDetailsById(String instanceId) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return null;
        }
        return this.instanceRepository.findDetailsById(instanceId);
    }

    public Page<InstanceViewEntity> findByConditions(String code, String instanceId, String cversion, String domain, String templateName, String projectName, Date beginCreateTime, Date endCreateTime, String userName, Pageable pageable) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            conditions.put("code", code);
        }
        if (StringUtils.isNotBlank((CharSequence)instanceId)) {
            conditions.put("instanceId", instanceId);
        }
        if (StringUtils.isNotBlank((CharSequence)cversion)) {
            conditions.put("cversion", cversion);
        }
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            conditions.put("domain", domain);
        }
        if (StringUtils.isNotBlank((CharSequence)templateName)) {
            conditions.put("templateName", templateName);
        }
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            conditions.put("projectName", projectName);
        }
        if (beginCreateTime != null) {
            conditions.put("beginCreateTime", beginCreateTime);
        }
        if (endCreateTime != null) {
            conditions.put("endCreateTime", endCreateTime);
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            conditions.put("userName", userName);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.instanceViewRepositoryCustom.queryPage(pageable, conditions);
    }

    public InstanceEntity findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4f20\u5165\u7684\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Optional op = this.instanceRepository.findById(id);
        return op.orElse(null);
    }

    public int countByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return 0;
        }
        return this.instanceRepository.countByTemplateId(templateId);
    }

    public Page<InstanceEntity> findByTemplateId(String templateId, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        return this.instanceRepository.findByTemplateId(templateId, pageable);
    }
}

