package com.bizunited.platform.kuiper.starter.common.excel;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * excel列解析注解(导入导出均需要使用)
 *
 * @author Keller
 * @create 2020/8/24
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface NebulaExcelColumn {

  /**
   * 列标题
   * 导出时使用
   */
  String title() default "";

  /**
   * 列顺序
   * 导入与导出时使用
   */
  int order();

  /**
   * 时间格式, 例如"yyyy-MM-dd HH:mm:ss"
   * 导入与导出时使用
   */
  String format() default "";

  /**
   * 错误提示信息
   * 导入时使用
   */
  String errorMessage() default "";

  /**
   * 自定义验证正则
   * 导入时使用
   */
  String regex() default "";
}
