package com.bizunited.platform.kuiper.starter.common.excel.reader;

import com.bizunited.platform.kuiper.starter.common.excel.IRecordInterceptor;

/**
 * excel读取接口
 *
 * @author Keller
 * @create 2020/8/24
 */
public interface IExcelReader {

    /***
     * 读取excel工作簿
     *
     * @param sheetIndex
     *            读取工作簿索引，传空则按顺序读取所有工作簿
     * @param rowBeginIndex
     *            行开始索引
     * @param columnBeginIndex
     *            列开始索引
     * @param columnEndIndex
     *            列结束索引
     * @param classs
     *            每一列对应的类型
     * @param interceptor
     *            行记录拦截器
     * @throws UnsupportedOperationException
     *             基于事件的读取器不支持该方法
     */
    public void readSheet(Integer sheetIndex, int rowBeginIndex, int columnBeginIndex, int columnEndIndex, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor);

    /***
     * 读取某些行
     *
     * @param sheetIndex
     *            读取工作簿索引，传空则按顺序读取所有工作簿
     * @param columnBeginIndex
     *            列开始索引
     * @param columnEndIndex
     *            列结束索引
     * @param rowIndexs
     *            需要读取的行集
     * @param classs
     *            每一列对应的类型
     * @throws UnsupportedOperationException
     *             不支持该方法
     */
    public void readSheet(Integer sheetIndex, int columnBeginIndex, int columnEndIndex, int[] rowIndexs, Class<?>[] classs, IRecordInterceptor<Object[]> interceptor) throws UnsupportedOperationException;

    /***
     * 读取sheet的某一行
     *
     * @param sheetIndex
     *            读取工作簿索引
     * @param rowIndex
     *            行索引
     * @param columnBeginIndex
     *            列开始索引
     * @param columnEndIndex
     *            列结束索引
     * @param classs
     *            每一列对应的类型
     * @return 一行的数据
     * @throws UnsupportedOperationException
     *             不支持该方法
     */
    public Object[] readRow(Integer sheetIndex, int rowIndex, int columnBeginIndex, int columnEndIndex, Class<?>[] classs) throws UnsupportedOperationException;

}
