package com.bizunited.platform.kuiper.starter.configuration;

import com.bizunited.platform.core.service.invoke.InvokeProxyBuilder;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.invoke.handle.request.PrincipalHandle;
import com.bizunited.platform.core.service.invoke.handle.request.TransactionalHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.StaticFormDetailsRequestHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.StaticFormDetailsResponseHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.StaticInstanceDetailsLogUpdateHandle;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

/**
 * 该配置信息，是对表单引擎中使用的服务源链式代理调用进行的必要配置描述——静态表单使用
 * @author yinwenjie
 */
@Configuration
public class StaticFormProxyConfig {
  @Autowired
  private ApplicationContext applicationContext;
  /**
   * 这是一个已经预定义好的给静态表单相关服务源使用的链式调用器，
   * 通过这个调用器，技术人员可以监控服务源方法在调用前后的数据详情变化，并将数据变化写入变化日志中</br>
   * 该链式调用构建器，可以由@NebulaServiceMethod注解的requestHandleGroup属性进行配置
   * @return
   */
  @SuppressWarnings("unchecked")
  @Bean("staticInstanceDetailsLogHandle")
  @Scope("prototype")
  public InvokeProxyBuilder getWriteServicableProxy() {
    InvokeProxyBuilder build = new InvokeProxyBuilder();
    Class<? extends InvokeRequestHandle> invokeRequestHandleClasses[] = new Class[] {PrincipalHandle.class , TransactionalHandle.class , StaticFormDetailsRequestHandle.class};
    build.addInvokeRequestTypeFilter(invokeRequestHandleClasses);
    Class<? extends InvokeResponseHandle> invokeResponseHandleClasses[] = new Class[] {StaticFormDetailsResponseHandle.class , StaticInstanceDetailsLogUpdateHandle.class};
    build.addInvokeResponseTypeFilter(invokeResponseHandleClasses);
    // 可能的invokeRequestHandleBinding
    build.setInvokeRequestHandleBinding(requestHandleClass -> this.applicationContext.getBean(requestHandleClass));
    // 可能的invokeResponseHandleBinding
    build.setInvokeResponseHandleBinding(responseHandleClass -> this.applicationContext.getBean(responseHandleClass));
    
    return build;
  }
}