package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import com.bizunited.platform.kuiper.starter.service.FrontFileSevice;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/v1/kuiper/frontFiles")
public class FrontFileController extends BaseController {

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(FrontFileController.class);

  @Autowired
  private FrontFileSevice frontFileSevice;

  @ApiOperation(value = "创建")
  @PostMapping(value="")
  public ResponseModel create(@RequestParam @ApiParam(name="frontFileStr" , value="实体json") String frontFileStr, @RequestParam @ApiParam(name="fileContent" , value="文件内容") String fileContent) {
    try {
      FrontFileEntity frontFileEntity = frontFileSevice.create(frontFileStr,fileContent);
      return this.buildHttpResultW(frontFileEntity);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "修改")
  @PatchMapping(value="/update")
  public ResponseModel update(@RequestParam @ApiParam(name="frontFileStr" , value="实体json") String frontFileStr,@RequestParam @ApiParam(name="fileContent" , value="文件内容") String fileContent) {
    try {
      FrontFileEntity frontFileEntity = frontFileSevice.update(frontFileStr,fileContent);
      return this.buildHttpResultW(frontFileEntity);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "分页查询")
  @GetMapping(value="/findByConditions")
  public ResponseModel findByConditions(@RequestParam @ApiParam(name="name" , value="name") String name, @RequestParam @ApiParam(name="classify" , value="classify") String classify, @RequestParam @ApiParam(name="status" , value="status") Integer status, Pageable pageable) {
    try {
      Page<FrontFileEntity> page = frontFileSevice.queryPage(pageable,name,classify,status);
      return this.buildHttpResultW(page);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "禁用")
  @PostMapping(value="/disable")
  public ResponseModel disable(@RequestParam @ApiParam(name="frontFileId" , value="frontFileId") String frontFileId) {
    try {
      FrontFileEntity frontFileEntity = frontFileSevice.disable(frontFileId);
      return this.buildHttpResultW(frontFileEntity);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "启用用")
  @PostMapping(value="/enable")
  public ResponseModel enable(@RequestParam @ApiParam(name="frontFileId" , value="frontFileId") String frontFileId) {
    try {
      FrontFileEntity frontFileEntity = frontFileSevice.enable(frontFileId);
      return this.buildHttpResultW(frontFileEntity);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "根据ID获取文件内容")
  @GetMapping(value="/findContentById")
  public ResponseModel findContentById(@RequestParam @ApiParam(name="frontFileId" , value="frontFileId") String frontFileId) {
    try {
      String content = frontFileSevice.findContentById(frontFileId);
      return this.buildHttpResultW(content);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "根据名称获取文件内容")
  @GetMapping(value = "/findContentByName")
  public ResponseModel findContentByName(
      @RequestParam @ApiParam(name = "frontFileName", value = "frontFileName") String frontFileName) {
    try {
      String content = frontFileSevice.findContentByName(frontFileName);
      return this.buildHttpResultW(content);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "不分页查询")
  @GetMapping(value="/findAllByConditions")
  public ResponseModel findAllByConditions(@RequestParam @ApiParam(name="name", value="name") String name, @RequestParam @ApiParam(name="classify", value="classify") String classify, @RequestParam @ApiParam(name="status", value="status") Integer status) {
    try {
      List<FrontFileEntity> fronts = frontFileSevice.findAllByConditions(name, classify, status);
      return this.buildHttpResultW(fronts);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
}