package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.InstanceContextEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceContextService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author: Paul Chan
 * @Date: 2019-04-19 14:39
 * @Description:
 */
@RestController
@RequestMapping("/v1/kuiper/instanceContexts")
public class InstanceContextController extends BaseController {

  private static final  Logger LOGGER = LoggerFactory.getLogger(InstanceContextController.class);

  @Autowired
  private InstanceContextService instanceContextService;

  /**
   * 批量保存表单实例上下文明细
   * @param instanceContexts
   * @param instanceId
   * @return
   */
  @PostMapping("")
  @ApiOperation(value = "保存表单实例上下文明细", notes = "保存表单实例上下文明细")
  public ResponseModel save(@RequestBody @ApiParam(name = "表单实例上下文明细", required = true) List<InstanceContextEntity> instanceContexts,
                            @RequestParam(name = "instanceId") @ApiParam(value = "表单实例ID", required = true) String instanceId){
    try {
      List<InstanceContextEntity> savedInstanceContexts = instanceContextService.save(instanceId, instanceContexts);
      return this.buildHttpResultW(savedInstanceContexts);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根绝name查询表单实例上下文明细
   * @param instanceId
   * @return
   */
  @GetMapping("/findByInstanceId")
  @ApiOperation(value = "查询表单实例上下文明细", notes = "查询表单实例上下文明细")
  public ResponseModel findByInstanceId(@RequestParam(name = "instanceId") @ApiParam(value = "表单实例ID", required = true) String instanceId) {
    try {
      List<InstanceContextEntity> instanceContexts = instanceContextService.findByInstanceId(instanceId);
      return this.buildHttpResultW(instanceContexts, "");
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 查询表单实例上下文明细
   * @param instanceId
   * @return
   */
  @GetMapping("/findByInstanceIdAndName")
  @ApiOperation(value = "根绝name查询表单实例上下文明细", notes = "根绝name查询表单实例上下文明细")
  public ResponseModel findByInstanceIdAndName(@RequestParam(name = "instanceId") @ApiParam(value = "表单实例ID", required = true) String instanceId,
                                               @RequestParam(name = "name") @ApiParam(value = "上下文明细名称", required = true) String name) {
    try {
      InstanceContextEntity instanceContext = instanceContextService.findByInstanceIdAndName(instanceId, name);
      return this.buildHttpResultW(instanceContext, "");
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据表单实例ID和上下文name删除上下文value
   * @param instanceId 表单实例ID
   * @param name 上下文name
   * @return
   */
  @DeleteMapping("/deleteByInstanceIdAndName")
  @ApiOperation(value = "根据表单实例删除上下文的值", notes = "根据表单实例ID和上下文name删除上下文value")
  public ResponseModel deleteByInstanceIdAndName(@RequestParam(name = "instanceId") @ApiParam(value = "表单实例ID", required = true) String instanceId,
                                                 @RequestParam(name = "name") @ApiParam(value = "上下文明细名称", required = true) String name){
    try {
      instanceContextService.deleteByInstanceIdAndName(instanceId, name);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }


}
