package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.MigrateExportEntity;
import com.bizunited.platform.kuiper.starter.service.migrate.MigrateExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import static com.bizunited.platform.common.constant.MigrateDataConstants.EXPORT_FILENAME_DATE_FORMAT;
import static com.bizunited.platform.common.constant.MigrateDataConstants.ZIP_FILE_SUBFIX;

@Api(value = "MigrateExportController")
@RequestMapping("/v1/kuiper/migrateExports")
@RestController("kuiperMigrateExportController")
public class MigrateExportController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(MigrateExportController.class);

  @Autowired
  private MigrateExportService migrateExportService;

  /**
   * 根据数据类型查询导出日志
   *
   * @param dataType
   * @return
   */
  @GetMapping("findDetailsByDataType")
  @ApiOperation("根据数据类型查询导出日志")
  public ResponseModel findDetailsByDataType(Integer dataType) {
    try {
      List<MigrateExportEntity> exports = migrateExportService.findDetailsByDataType(dataType);
      return buildHttpResultW(exports, "createUser");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 导出列表模版数据
   *
   * @param ids
   * @return
   */
  @GetMapping("exportListTempate")
  @ApiOperation("导出列表模版数据")
  public void exportListTempate(@RequestParam(value = "ids", required = false) @ApiParam("数据ID集合") String[] ids,
                                HttpServletRequest request, HttpServletResponse response) {
    try {
      byte[] bytes = migrateExportService.exportListTempate(ids);
      Validate.isTrue(ArrayUtils.isNotEmpty(bytes), "没有任何下载信息，很大几率原因是导出逻辑出现错误!!");
      String time = new SimpleDateFormat(EXPORT_FILENAME_DATE_FORMAT).format(new Date());
      String fileName = StringUtils.join("列表模版-", time, ".", ZIP_FILE_SUBFIX);
      writeResponseFile(request, response, bytes, fileName);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      printResponseModel(buildHttpResultForException(e), response);
    }
  }

  /**
   * 导出页面流数据
   *
   * @param ids
   * @param request
   * @param response
   */
  @GetMapping("exportPageFlow")
  @ApiOperation("导出页面流数据")
  public void exportPageFlow(@RequestParam(value = "ids", required = false) @ApiParam("数据ID集合") String[] ids,
                             HttpServletRequest request, HttpServletResponse response) {
    try {
      byte[] bytes = migrateExportService.exportPageFlow(ids);
      Validate.isTrue(ArrayUtils.isNotEmpty(bytes), "没有任何下载信息，很大几率原因是导出逻辑出现错误!!");
      String time = new SimpleDateFormat(EXPORT_FILENAME_DATE_FORMAT).format(new Date());
      String fileName = StringUtils.join("页面流-", time, ".", ZIP_FILE_SUBFIX);
      writeResponseFile(request, response, bytes, fileName);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      printResponseModel(buildHttpResultForException(e), response);
    }
  }

  /**
   * 导出表单模版数据
   */
  @ApiOperation("导出表单模版数据")
  @GetMapping("exportFormTemplate")
  public void exportFormTemplate(@RequestParam(value = "ids", required = false) @ApiParam("数据ID集合") String[] ids,
                                 HttpServletRequest request, HttpServletResponse response) {
    try {
      byte[] bytes = migrateExportService.exportFormTemplate(ids);
      Validate.isTrue(ArrayUtils.isNotEmpty(bytes), "没有任何下载信息，很大几率原因是导出逻辑出现错误!!");
      String time = new SimpleDateFormat(EXPORT_FILENAME_DATE_FORMAT).format(new Date());
      String fileName = StringUtils.join("表单模版-", time, ".", ZIP_FILE_SUBFIX);
      writeResponseFile(request, response, bytes, fileName);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      printResponseModel(buildHttpResultForException(e), response);
    }
  }

  @ApiOperation(value = "传入导出的函数ID则按照传入的数据ID来导出，否则导出全部")
  @GetMapping("/exportFrontFile")
  public void exportFrontFile(@ApiParam(name="frontFileIds", value = "指定导出的页面函数ID集合" , required = false) @RequestParam(name="frontFileIds" , required = false) String[] frontFileIds, HttpServletRequest request, HttpServletResponse response) {
    try {
      byte[] bytes = this.migrateExportService.exportFrontFile(frontFileIds);
      Validate.isTrue(bytes != null && bytes.length != 0, "没有任何下载信息，很大几率原因是导出逻辑出现错误!!");
      String time = new SimpleDateFormat(EXPORT_FILENAME_DATE_FORMAT).format(new Date());
      String fileName = StringUtils.join("页面函数-", time, ".", ZIP_FILE_SUBFIX);
      writeResponseFile(request, response, bytes, fileName);
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      this.printResponseModel(this.buildHttpResultForException(e), response);
    }
  }
}