package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.MigrateImportEntity;
import com.bizunited.platform.kuiper.starter.service.migrate.MigrateImportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 迁入管理
 * @author: yanwe
 * @date: 03/Sep/2019 14:22
 */
@Api(value = "MigrateImportController")
@RequestMapping("/v1/kuiper/migrationsImport")
@RestController("kuiperMigrateImportController")
public class MigrateImportController extends BaseController {

  @Autowired private MigrateImportService migrateImportService;

  /** 日志 */
  private static final Logger LOGGER = LoggerFactory.getLogger(MigrateImportController.class);

  /**
   * 上传迁入文件
   * @param file
   * @return
   */
  @ApiOperation(value = "上传迁入文件")
  @RequestMapping(value = "/upload", method = RequestMethod.POST)
  public ResponseModel upload(@RequestParam(name = "file", required = true) @ApiParam(required = true, value = "迁入文件对象") MultipartFile file,
                              @RequestParam @ApiParam("迁移数据类型,1:编码规则，2：数据视图，3：全局参数，4：数据字典，5：远端服务源，" +
                                  "6：表单模版，7：列表模版，8：全局函数") Integer dataType) {
    try {
      MigrateImportEntity entity = migrateImportService.upload(file, dataType);
      return this.buildHttpResultW(entity, "creator", "executor");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据ID执行导入
   * @param id
   * @param mode
   * @return
   */
  @PostMapping("execute")
  @ApiOperation("根据ID执行导入")
  public ResponseModel execute(@RequestParam @ApiParam("导入ID") String id,
                               @RequestParam(defaultValue = "0") @ApiParam("导入执行模式0：已存在跳过，1：已存在新增，2：已存在更新") Integer mode) {
    try {
      MigrateImportEntity migrateImport = migrateImportService.execute(id, mode);
      return buildHttpResultW(migrateImport, "detail");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  @ApiOperation("根据ID查询详情")
  @GetMapping("findDetailsById")
  public ResponseModel findDetailsById(@RequestParam(required = true) @ApiParam(value = "主键ID", required = true) String id) {
    try {
      MigrateImportEntity migrateImport = migrateImportService.findDetailsById(id);
      return buildHttpResultW(migrateImport, "detail");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 根据数据类型查询导入日志
   * @param dataType
   * @return
   */
  @GetMapping("findDetailsByDataType")
  @ApiOperation("根据数据类型查询导入日志")
  public ResponseModel findDetailsByDataType(Integer dataType) {
    try {
      List<MigrateImportEntity> migrateImports = migrateImportService.findDetailsByDataType(dataType);
      return buildHttpResultW(migrateImports, "createUser", "executeUser");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

}
