package com.bizunited.platform.kuiper.starter.controller;


import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.starter.service.TemplateEventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;


@Api(value = "TemplateEventController", tags = {"模板事件相关接口"})
@RestController
@RequestMapping("/v1/kuiper/templateEvents")
public class TemplateEventController extends BaseController {
  /** 日志 */
  private static final Logger LOGGER = LoggerFactory.getLogger(TemplateEventController.class);

  @Autowired
  private TemplateEventService templateEventService;

  @ApiOperation(value = "根据指定模板的id,查询已有的模板事件信息", notes = "该方法必须包含指定模板的id,且不能为空,返回所有的前后端事件")
  @ApiImplicitParams({@ApiImplicitParam(name = "templateId", value = "指定的模板id", required = true),})
  @GetMapping("/findByTemplateId")
  public ResponseModel findByTemplateId(@RequestParam(value = "templateId") String templateId) {
    try {
      List<TemplateEventEntity> result = templateEventService.findByTemplateId(templateId);
      return this.buildHttpResultW(result);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
  
  @ApiOperation(value = "根据指定事件id,查询事件详情信息", notes = "该方法必须包含事件的id,且不能为空,返回指定的事件详情")
  @ApiImplicitParams({@ApiImplicitParam(name = "id", value = "选定的事件id", required = true)})
  @GetMapping("/findDetailById")
  public ResponseModel findDetailById(@RequestParam(value = "id") String id) {
    try {
      TemplateEventEntity result = templateEventService.findDetailById(id);
      return this.buildHttpResultW(result, "template");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
  
  @ApiOperation(value = "根据指定模板id,查询所有事件详情信息", notes = "该方法必须包含模板的id,且不能为空,返回该模板所有的事件详情")
  @ApiImplicitParams({@ApiImplicitParam(name = "templateId", value = "指定模板id", required = true)})
  @GetMapping("/findDetailsByTemplateId")
  public ResponseModel findDetailsByTemplateId(@RequestParam(value = "templateId") String templateId) {
    try {
      Set<TemplateEventEntity> result = templateEventService.findDetailsByTemplateId(templateId);
      return this.buildHttpResultW(result, "template");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
