package com.bizunited.platform.kuiper.starter.controller;

import java.util.Set;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateOprtLogEntity;
import com.bizunited.platform.kuiper.starter.service.TemplateOprtLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;



@Api(value = "TemplateOprtLogController")
@RestController
@RequestMapping("/v1/kuiper/templates/oprtLog")
public class TemplateOprtLogController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(TemplateOprtLogController.class);
  
  @Autowired
  private TemplateOprtLogService templateOprtLogService;
  
  
  /**
   * 根据模板id查询当前模板的操作日志集
   * @param templateId
   * @return
   */
  @GetMapping("/findByTemplateId")
  public ResponseModel findByTemplateId(@ApiParam(name="templateId" , value="表单模板id") String templateId) {
    try {
      Set<TemplateOprtLogEntity> result = this.templateOprtLogService.findByTemplateId(templateId);
      return this.buildHttpResultW(result, "template","oprtUser");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
