package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.FromDetailsImportEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * @author yinwenjie
 */
@Repository("FromDetailsImportRepository")
public interface FromDetailsImportRepository
    extends
    JpaRepository<FromDetailsImportEntity, String>,
    JpaSpecificationExecutor<FromDetailsImportEntity> {
  
  /**
   * 查询指定的数据批量导入模板
   * @param instanceId 实例信息
   */
  @Query(" from FromDetailsImportEntity fdi where "
      + " fdi.listTempleteCode = :listTempleteCode AND "
      + " fdi.listTempleteVersion = :listTempleteVersion AND "
      + " fdi.buttonCode = :buttonCode  ")
  public FromDetailsImportEntity findByCodeAndVersionAndButtonCode(@Param("listTempleteCode") String listTempleteCode ,
                                                                   @Param("listTempleteVersion") String listTempleteVersion ,
                                                                   @Param("buttonCode") String buttonCode);
  public FromDetailsImportEntity findByListTempleteCodeAndListTempleteVersionAndButtonCode(@Param("listTempleteCode") String listTempleteCode ,
                                                      @Param("listTempleteVersion") String listTempleteVersion ,
                                                      @Param("buttonCode") String buttonCode);

  /**
   * 根据文件名称和相对路径查询
   * @param fileName
   * @param relativePath
   * @return
   */
  @Query(" from FromDetailsImportEntity fdi where fdi.fileName = :fileName and fdi.relativePath = :relativePath")
  FromDetailsImportEntity findByFileNameAndRelativePath(@Param("fileName") String fileName, @Param("relativePath") String relativePath);
}