package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.kuiper.entity.InstanceEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

/**
 * 表单实例持久化自定义接口
 * @Author: Paul Chan
 * @Date: 2019-12-19 18:46
 */
@Repository("InstanceRepositoryCustom")
public interface InstanceRepositoryCustom {

  /**
   * 根据模版ID分页查询
   * @param templateId
   * @param pageable
   * @return
   */
  Page<InstanceEntity> findByTemplateId(String templateId, Pageable pageable);

}
