package com.bizunited.platform.kuiper.starter.repository.table;

import com.bizunited.platform.kuiper.entity.TemplateEntity;
import java.util.List;

public interface TableOperateRepositoryCustom {
  /**
   * 根据给定的动态模板，基于主数据源创建主业务动态模型（数据表）</br>
   * 包括主数据表和外键关联，oneToMany关联性质的明细数据表、OneToOne性质的分组数据表、ManyToOne的外键关联、ManyToMany的映射性质数据表。
   * @param template 当前给定的需要新创建的动态模板信息
   */
  public void createTable(TemplateEntity template);

  /**
   * 查询数据库中是否已有指定的数据表名
   * @param tableName
   * @return
   */
  public Boolean existTableName(String tableName);
  
  /**
   * 根据给定的已经存在的动态模板，基于主数据源对这个模板中的新字段、新关联进行升级操作<br>
   * 为了保证已经基于当前数据表常见的实例的运行安全，数据表的升级过程新增的字段不能是“必填”，
   * 且只能进行新增操作字段和关联信息（数据表）操作，
   * 已存在字段不允许修改（只允许必填字段到非必填字段的修改，字符串形式的字段长度可以改大，但是不允许改小）或者删除操作。
   * @param sourcetTemplate 给定的已存在于数据库的，升级前的模板信息
   * @param targetTemplate 给定的已存在于数据库的，升级后的模板信息
   */
  public void upgradeTable(TemplateEntity sourcetTemplate , TemplateEntity targetTemplate);

  /**
   * 执行原生SQL语句
   * @param sql
   */
  void executeNativeSQL(String sql);

  /**
   * 执行查询语句并返还结果
   * @param querySql
   * @return
   */
  List<?> executeQuerySql(String querySql);
}