package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.DynamicTemplateDraftEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * 动态模板草稿功能的服务层接口定义
 * @author saturn
 */
public interface DynamicTemplateDraftService {
  /**
   * 在创建一个新的动态模板草稿模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  void createValidation(DynamicTemplateDraftEntity dynamicTemplateDraftEntity);
  /**
   * 创建一个新的动态模板草稿模型对象
   */
  DynamicTemplateDraftEntity create(DynamicTemplateDraftEntity dynamicTemplateDraftEntity, String json);
  /**
   * 更新一个已有的动态模板草稿模型对象
   */
  DynamicTemplateDraftEntity update(DynamicTemplateDraftEntity dynamicTemplateDraft, String json);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  DynamicTemplateDraftEntity findDetailsById(String id);

  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  void deleteById(String id);

  /**
   * 根据业务编码删除草稿
   * @param code
   */
  void deleteByCode(String code);

  /**
   * 分页查询动态模版的草稿
   * @param pageable
   * @param templateTable
   * @return
   */
  Page<DynamicTemplateDraftEntity> findByConditions(Pageable pageable, String templateTable);

  /**
   * 根据主键ID获取模版草稿的json数据
   * @param id
   * @return
   */
  String findJsonById(String id);
}