package com.bizunited.platform.kuiper.starter.service;

import java.security.Principal;
import java.util.Map;
import java.util.Set;

import com.bizunited.platform.kuiper.entity.FromDetailsImportEntity;

/**
 * 基于表单引擎，列表引擎，对业务数据通过xls文件的方式进行导入，并关联相关表单实例的服务
 * @author yinwenjie
 */
public interface FromDetailsImportService {
  /**
   * 执行基于表单引擎、列表引起的业务数据导入过程，业务侧技术人员，只需要关注如何将xls/xlsx文件中的内容进行校验和对象转换 
   * @param fileBytes 当前导入的文件内容，该文件必须是xls或者xlsx文件，否则会报错
   * @param params 在进行xls信息导入时，可以由调用者根据实际的业务处理场景，传入自定义的K-V结构的外部参数，这些K-V结构的参数都记录在这里
   * @param principal 当前操作者信息
   * @param templateCode 导入业务数据后，将为业务数据创建表单实例，该templateCode指向将要创建表单实例时所参照的模板
   * @param templateVersion 导入业务数据后，将为业务数据创建表单实例，该templateVersion指向将要创建表单实例时所参照的模板版本（该参数可以不传入，如果不传入，则会使用指定模板的默认版本，如果没有设置默认版本，则会抛出异常）
   * @param processClassName 用于处理本次xls业务数据导入所使用的完成导入处理类
   */
  public void imports(byte[] fileBytes , Map<String, Object> params , Principal principal , String templateCode , String templateVersion , String processClassName);
  
  /**
   * 通过该接口，系统将可以返回该进程中已经被扫描到的所有业务数据导入处理器的类名信息
   * @return
   */
  public Set<String> findProcessClassNames();
  
  /**
   * 通过该接口，操作者可以添加一个新的业务数据导入处理器的类名信息
   */
  public void putProcessClassNames(String processClassNames);
  
  /**
   * 该功能为指定的列表模板、基于指定的进行业务数据批量导入功能的按钮，上传xls、xlsx格式的模板文件使用。</br>
   * 以保证使用该功能进行业务数据批量导入的xls、xlsx文件的统一性
   * @param fileBytes 模板文件的文件内容
   * @param originalFilename 模板文件的原始文件名
   * @param listTemplateCode 对应的列表模板业务编号
   * @param listTemplateVersion 对应的列表模板版本信息
   * @param buttonCode 对应的列表模板中进行业务数据批量导入功能的按钮code
   */
  public FromDetailsImportEntity importTemplate(byte[] fileBytes , String listTemplateCode , String listTemplateVersion , String buttonCode , String originalFilename);

  /**
   * 根据文件名称和相对路径查询
   * @param fileName
   * @param relativeLocal
   * @return
   */
  FromDetailsImportEntity findByFileNameAndRelativeLocal(String fileName, String relativeLocal);
}
