package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.PageEntity;
import com.bizunited.platform.kuiper.entity.PageFlowEntity;

import java.util.Set;

/**
 * 页面流页面数据的服务接口定义
 * @Author: TanBoQiuYun
 * @Date: 2019/12/31 17:26
 */
public interface PageService {


  /**
   * 处理可能的增、修改、删除页面流页面数据信息情况（通过页面编码做为唯一值进行比较来新增、修改、删除）
   * @param pageFlowEntity
   * @param pages
   * @return
   */
  Set<PageEntity> save(PageFlowEntity pageFlowEntity, Set<PageEntity> pages);

  /**
   * 按照数页面ID进行查询明细查询，查询的明细包含页面下的所有关联信息
   * @param id
   * @return
   */
  PageEntity findDetailsById(String id);

  /**
   * 根据页面流code和页面code查询详情
   * @param code
   * @param pageFlowCode
   * @return
   */
  PageEntity findDetailsByCodeAndPageFlowCode(String code, String pageFlowCode);

  /**
   * 按照页面流编码进查询页面列表详情
   * @param pageFlowCode
   * @return
   */
  Set<PageEntity> findDetailsByPageFlowCode(String pageFlowCode);


  /**
   * 按照页面流ID进查询页面列表详情
   * @param pageFlowId
   * @return
   */
  Set<PageEntity> findDetailsByPageFlowId(String pageFlowId);

  /**
   * 按照数页面流编码进行查询，查询的明细不包含关联信息
   * @param pageFlowCode
   * @return
   */
  Set<PageEntity> findByPageFlowCode(String pageFlowCode);


  /**
   * 根据页面流ID删除页面
   * @param pageFlowId
   */
  void deleteByPageFlowId(String pageFlowId);
}
