package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentRelation;

public interface TemplateGroupService {
  /**
   * 初始化静态模板中的“分组”信息，包括分组信息中的一般属性信息、和关联属性信息（关联属性信息只包括ManyToOne关系、ManyToMany关系和OneToMany关系）
   * @param templateId 模板id
   * @param persistentClass 当前这个分组对应的静态模型描述类信息
   */
  public TemplateGroupEntity initStaticGroups(TemplateEntity parentTemplate , PersistentRelation parentRelation , PersistentClass persistentClass);
  
  /**
   * 初始化动态模板中的分组信息
   * @param templateGroup 当前的分组信息
   * @param parentTemplate 上一级动态模板
   * @return
   */
  public TemplateGroupEntity initDynamicGroups(TemplateGroupEntity templateGroup , TemplateEntity parentTemplate);

  /**
   * 根据ID查询分组信息（包括父级表单信息）
   * @param templateGroupId
   * @return
   */
  TemplateGroupEntity findParentById(String templateGroupId);
}
