package com.bizunited.platform.kuiper.starter.service.instances.handle;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 基于动态实例明细变化的日志记录
 * @author yinwenjie
 */
@Component("DynamicInstanceDetailsLogUpdateHandle")
public class DynamicInstanceDetailsLogUpdateHandle  extends AbstractInstanceDetailsLogUpdateHandle {
  @Autowired
  private InstanceActivityService instanceActivityService;

  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.InvokeResponseHandle#handleException(com.bizunited.platform.core.service.invoke.ServicableContext)
   */
  @Override
  public boolean handleException(InvokeProxyContext context) {
    return false;
  }
  
  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.InvokeResponseHandle#doHandle(com.bizunited.platform.core.service.invoke.ServicableContext, com.bizunited.platform.core.service.invoke.HandleChain)
   */
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    InvokeParams invokeParams = context.getParams();
    if(context.isException()) {
      chain.doHandle(context, ChainLogic.CONTINUE);
      return;
    }
    
    // 准备用户信息
    Object principalValue = invokeParams.getInvokeParam("principal");
    Validate.notNull(principalValue , "在记录当前表单实例变更时，未发现操作人信息!!");
    String userName = principalValue.toString();
    Validate.notBlank(userName , "未找到操作者信息，请检查!!");
    // 准备实例和模板
    Object instanceActivityIdValue = invokeParams.getInvokeParam("instanceActivityId");
    Validate.notNull(instanceActivityIdValue , "未发现指定的活动实例编号，请检查");
    String instanceActivityId = instanceActivityIdValue.toString();
    InstanceActivityEntity activity = instanceActivityService.findById(instanceActivityId);
    Validate.notNull(activity, "根据传入的活动id，未能查询到相应活动信息，请检查!!");
    TemplateEntity template = activity.getTemplate();
    Validate.notNull(template , "未找到当前活动对应的模板信息（也就是表单实例对应的模板信，请检查息）");
    // 执行比对过程
    JSONObject beforeDetails = (JSONObject)invokeParams.getInvokeParam("_beforeDetails");
    JSONObject afterDetails = (JSONObject)invokeParams.getInvokeParam("_afterDetails");
    Validate.isTrue(beforeDetails != null && afterDetails != null , "没有发现可用的对比信息，请检查传参!!");
    
    this.handle(beforeDetails , afterDetails , template.getId(), userName, instanceActivityId);
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
}