package com.bizunited.platform.kuiper.starter.service.instances.handle;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * 该处理器用于在WRITE性质的服务方法之后，调用查询静态表单详情的方法
 * 然后将查询出来的数据，以json的形式放于上下文中，便于表单日志功能做数据对比</p>
 */
public class StaticFormDetailsResponseHandle implements InvokeResponseHandle {

  private static final Logger LOGGER = LoggerFactory.getLogger(StaticFormDetailsResponseHandle.class);
  /**
   * 用于存储后置处理得到的查询结果值的key
   */
  private static final String AFTER_DETAILS = "_afterDetails";
  /**
   * 柯伊伯表单引擎服务工具类
   */
  @Autowired
  @Qualifier("KuiperToolkitService")
  private KuiperToolkitService kuiperToolkitService;
  @Autowired
  private ServicableMethodService servicableMethodService;

  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.InvokeRequestHandle#doHandle(com.bizunited.platform.core.service.invoke.InvokeProxyContext, com.bizunited.platform.core.service.invoke.HandleChain)
   */
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    /*
     * 可参考StaticFormDetailsRequestHandle.doHandle的处理过程
     * */
    
    InvokeParams invokeParams = context.getParams();
    String detailsServiceName = invokeParams.getInvokeParam("detailsServiceName") == null?"":invokeParams.getInvokeParam("detailsServiceName").toString();
    if(StringUtils.isBlank(detailsServiceName)) {
      this.doHandle(context, chain);
      return;
    }
    ServicableMethodInfo methodInfo = servicableMethodService.findDetailsByName(detailsServiceName);
    Validate.notNull(methodInfo , "未找到指定的服务方法信息[%s]，请检查!!" , detailsServiceName);
    
    // 确认查询数据详情的依据，如果没有任何依据，也不会执行数据记录
    Object instanceIdValue = invokeParams.getInvokeParam("instanceId");
    Object taskcodeValue = invokeParams.getInvokeParam("taskcode");
    Object instanceActivityIdValue = invokeParams.getInvokeParam("instanceActivityId");
    if((instanceIdValue == null || StringUtils.isBlank(instanceIdValue.toString()))
        && (taskcodeValue == null || StringUtils.isBlank(taskcodeValue.toString()))
        && (instanceActivityIdValue == null || StringUtils.isBlank(instanceActivityIdValue.toString()))) {
      this.doHandle(context, chain);
      return;
    }
    
    //获取当前操作传入的表单数据
    InvokeParams newInvokeParams = new InvokeParams();
    if(instanceIdValue != null && !StringUtils.isBlank(instanceIdValue.toString())) {
      newInvokeParams.putInvokeParam("instanceid", instanceIdValue);
    }
    if(taskcodeValue != null && !StringUtils.isBlank(taskcodeValue.toString())) {
      newInvokeParams.putInvokeParam("taskcode", taskcodeValue);
    }
    if(instanceActivityIdValue != null && !StringUtils.isBlank(instanceActivityIdValue.toString())) {
      newInvokeParams.putInvokeParam("instanceActivityId", instanceActivityIdValue);
    }
    Object result = this.servicableMethodService.invoke(detailsServiceName, newInvokeParams);
    Object jsonResult = JSON.toJSON(result);
    LOGGER.debug("后置数据：{}", result);
    invokeParams.putInvokeParam(AFTER_DETAILS, jsonResult);
    
    // 继续下一个处理节点
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
  
  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.InvokeResponseHandle#handleException(com.bizunited.platform.core.service.invoke.InvokeProxyContext)
   */
  @Override
  public boolean handleException(InvokeProxyContext context) {
    return false;
  }
}
