package com.bizunited.platform.kuiper.starter.service.instances.handle;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 基于静态实例明细变化的日志记录
 * @author yinwenjie
 */
@Component("StaticInstanceDetailsLogUpdateHandle")
public class StaticInstanceDetailsLogUpdateHandle extends AbstractInstanceDetailsLogUpdateHandle {
  @Autowired
  private InstanceActivityService instanceActivityService;
  @Autowired
  private ServicableMethodService servicableMethodService;

  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.InvokeResponseHandle#handleException(com.bizunited.platform.core.service.invoke.ServicableContext)
   */
  @Override
  public boolean handleException(InvokeProxyContext context) {
    return false;
  }
  
  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.InvokeResponseHandle#doHandle(com.bizunited.platform.core.service.invoke.ServicableContext, com.bizunited.platform.core.service.invoke.HandleChain)
   */
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    InvokeParams invokeParams = context.getParams();
    Object serviceNameValue = invokeParams.getInvokeParam("serviceName");
    if(serviceNameValue == null || StringUtils.isBlank(serviceNameValue.toString())) {
      chain.doHandle(context, ChainLogic.CONTINUE);
      return;
    }
    // 确认服务信息
    String serviceName = serviceNameValue.toString();
    ServicableMethodInfo methodInfo = servicableMethodService.findDetailsByName(serviceName);
    Validate.notNull(methodInfo , "未找到指定的服务方法信息[%s]，请检查!!" , serviceName);
    // 准备用户信息
    Object principalValue = invokeParams.getInvokeParam("principal");
    Validate.notNull(principalValue , "未发现任何用户登录信息!!");
    String account = principalValue.toString();
    // 准备实例和模板
    Object instanceActivityIdValue = invokeParams.getInvokeParam("instanceActivityId");
    Validate.notNull(instanceActivityIdValue , "未发现指定的活动实例编号，请检查");
    String instanceActivityId = instanceActivityIdValue.toString();
    InstanceActivityEntity activity = instanceActivityService.findById(instanceActivityId);
    Validate.notNull(activity, "根据传入的活动id，未能查询到相应活动信息，请检查!!");
    TemplateEntity template = activity.getTemplate();
    Validate.notNull(template , "未找到当前活动对应的模板信息（也就是表单实例对应的模板信，请检查息）");
    // 执行比对过程
    JSONObject beforeDetails = (JSONObject)invokeParams.getInvokeParam("_beforeDetails");
    JSONObject afterDetails = (JSONObject)invokeParams.getInvokeParam("_afterDetails");
    Validate.isTrue(beforeDetails != null && afterDetails != null , "没有发现可用的对比信息，请检查传参!!");
    
    this.handle(beforeDetails , afterDetails, template.getId(), account, instanceActivityId);
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
}