package com.bizunited.platform.kuiper.starter.service.migrate;


import com.bizunited.platform.kuiper.entity.MigrateExportEntity;

import java.util.List;

/**
 * 基础工具套件中的关键数据迁移-迁出服务的定义在这里
 * @author yinwenjie
 */
public interface MigrateExportService {

  /**
   * 保存导出日志
   * @param export
   * @return
   */
  MigrateExportEntity save(MigrateExportEntity export);

  /**
   * 根据数据类型查询导出日志
   * @param dataType
   * @return
   */
  List<MigrateExportEntity> findDetailsByDataType(Integer dataType);

  /**
   * 导出列表模版
   * @param ids
   * @return
   */
  byte[] exportListTempate(String[] ids);

  /**
   * 导出页面流数据
   * @param ids
   * @return
   */
  byte[] exportPageFlow(String[] ids);

  /**
   * 导出模版数据
   * @param ids
   * @return
   */
  byte[] exportFormTemplate(String[] ids);

  /**
   * 导出页面函数
   * @param frontFileIds
   * @return
   */
  byte[] exportFrontFile(String[] frontFileIds);
}
