/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.service.DynamicInstanceService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/kuiper/dynamicInstatnces"})
public class DynamicInstanceController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicInstanceController.class);
    @Autowired
    private DynamicInstanceService dynamicInstanceService;

    @ApiOperation(value="\u83b7\u53d6\u5b9e\u4f8b\u57fa\u672c\u4fe1\u606f\uff0c\u4e0d\u5bf9\u4efb\u4f55\u5173\u8054\u4fe1\u606f\u8fdb\u884c\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formInstanceId", value="\u6307\u5b9a\u7684\u5b9e\u4f8bid", required=true)})
    @GetMapping(value={"/findByFormInstanceId"})
    public ResponseModel findByFormInstanceId(@RequestParam(value="formInstanceId") String formInstanceId) {
        try {
            JSONObject json = this.dynamicInstanceService.findByFormInstanceId(formInstanceId);
            return this.buildHttpResultW(json, new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value=" \u6839\u636e\u5b9e\u4f8bID\u4fe1\u606f\uff0c\u83b7\u53d6\u5b9e\u4f8b\u7684\u8be6\u60c5\uff0c\u5305\u542b\u6240\u6709\u53ef\u80fd\u7684\u5173\u8054\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formInstanceId", value="\u6307\u5b9a\u7684\u5b9e\u4f8bid", required=true)})
    @GetMapping(value={"/findDetailsByFormInstanceId"})
    public ResponseModel findDetailsByFormInstanceId(@RequestParam(value="formInstanceId") String formInstanceId) {
        try {
            JSONObject json = this.dynamicInstanceService.findDetailsByFormInstanceId(formInstanceId);
            return this.buildHttpResultW(json, new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539\u8868\u5355\u6a21\u677f\u4fe1\u606f\u4e1a\u52a1\u6570\u636e\uff0c\u81f3\u5c11\u9700\u8981\u62c6\u5206\u4f20\u5165\u7684json\u5c5e\u6027\uff1a\u8868\u5355\u5b9e\u4f8bid(formInstanceId)\u3001\u5b9e\u4f8b\u6d3b\u52a8id\uff08instanceActivityId\uff09,\u5176\u5b83json\u4fe1\u606f\u6309\u7167\u6570\u636e\u8981\u6c42\u4f20\u5165")
    @RequestMapping(value={""}, method={RequestMethod.POST, RequestMethod.PATCH})
    public ResponseModel save(@RequestBody @ApiParam(name="inputData", value="\u8868\u5355\u6a21\u677f\u4e1a\u52a1\u6570\u636e\u4fe1\u606f") JSONObject inputData, HttpServletRequest request) {
        try {
            JSONObject data = JSONObject.parseObject((String)JSON.toJSONString((Object)inputData.get((Object)"jsonData")));
            JSONObject invokeParamsObj = inputData.getJSONObject("invokeParams");
            Validate.notNull((Object)invokeParamsObj, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            data.put("instanceActivityId", (Object)invokeParamsObj.getString("instanceActivityId"));
            if (StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)RequestMethod.POST.name())) {
                this.dynamicInstanceService.create(data);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)RequestMethod.PATCH.name())) {
                this.dynamicInstanceService.update(data);
            }
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

