/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.FromDetailsImportEntity;
import com.bizunited.platform.kuiper.starter.service.FromDetailsImportService;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/kuiper/fromDetailsImports"})
public class FromDetailsImportController
extends BaseController {
    @Autowired
    private FromDetailsImportService fromDetailsImportService;
    @Autowired
    private VenusFileService venusFileService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FromDetailsImportController.class);

    @ApiOperation(value="\u6267\u884c\u57fa\u4e8e\u8868\u5355\u5f15\u64ce\u3001\u5217\u8868\u5f15\u8d77\u7684\u4e1a\u52a1\u6570\u636e\u5bfc\u5165\u8fc7\u7a0b\uff0c\u4e1a\u52a1\u4fa7\u6280\u672f\u4eba\u5458\uff0c\u53ea\u9700\u8981\u5173\u6ce8\u5982\u4f55\u5c06xls/xlsx\u6587\u4ef6\u4e2d\u7684\u5185\u5bb9\u8fdb\u884c\u6821\u9a8c\u548c\u5bf9\u8c61\u8f6c\u6362")
    @PostMapping(value={""})
    public ResponseModel imports(@RequestParam(name="file", required=true) @ApiParam(required=true, name="file", value="\u4e0a\u4f20\u7684xls/xlsx\u6587\u4ef6\u4fe1\u606f\uff0c\u76ee\u524d\u53ea\u652f\u6301\u5355\u4e2a\u6587\u4ef6\u7684\u4e0a\u4f20") MultipartFile file, @RequestParam(name="templateCode", required=true) @ApiParam(required=true, name="templateCode", value="\u5bfc\u5165\u4e1a\u52a1\u6570\u636e\u540e\uff0c\u5c06\u4e3a\u4e1a\u52a1\u6570\u636e\u521b\u5efa\u8868\u5355\u5b9e\u4f8b\uff0c\u8be5templateCode\u6307\u5411\u5c06\u8981\u521b\u5efa\u8868\u5355\u5b9e\u4f8b\u65f6\u6240\u53c2\u7167\u7684\u6a21\u677f") String templateCode, @RequestParam(name="templateVersion", required=false) @ApiParam(required=false, name="templateVersion", value="\u5bfc\u5165\u4e1a\u52a1\u6570\u636e\u540e\uff0c\u5c06\u4e3a\u4e1a\u52a1\u6570\u636e\u521b\u5efa\u8868\u5355\u5b9e\u4f8b\uff0c\u8be5templateVersion\u6307\u5411\u5c06\u8981\u521b\u5efa\u8868\u5355\u5b9e\u4f8b\u65f6\u6240\u53c2\u7167\u7684\u6a21\u677f\u7248\u672c\uff08\u8be5\u53c2\u6570\u53ef\u4ee5\u4e0d\u4f20\u5165\uff0c\u5982\u679c\u4e0d\u4f20\u5165\uff0c\u5219\u4f1a\u4f7f\u7528\u6307\u5b9a\u6a21\u677f\u7684\u9ed8\u8ba4\u7248\u672c\uff0c\u5982\u679c\u6ca1\u6709\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c\uff0c\u5219\u4f1a\u629b\u51fa\u5f02\u5e38\uff09") String templateVersion, @RequestParam(name="processClassName", required=true) @ApiParam(required=true, name="processClassName", value="\u7528\u4e8e\u5904\u7406\u672c\u6b21xls\u4e1a\u52a1\u6570\u636e\u5bfc\u5165\u6240\u4f7f\u7528\u7684\u5b8c\u6210\u5bfc\u5165\u5904\u7406\u7c7b") String processClassName, HttpServletRequest request, Principal principal) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String[] values = request.getParameterValues(name);
                if (values != null && values.length == 1) {
                    params.put(name, values[0]);
                    continue;
                }
                if (values == null || values.length <= 1) continue;
                params.put(name, values);
            }
        }
        try {
            this.fromDetailsImportService.imports(file.getBytes(), params, principal, templateCode, templateVersion, processClassName);
            return this.buildHttpResult();
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u8be5\u63a5\u53e3\uff0c\u7cfb\u7edf\u5c06\u53ef\u4ee5\u8fd4\u56de\u8be5\u8fdb\u7a0b\u4e2d\u5df2\u7ecf\u88ab\u626b\u63cf\u5230\u7684\u6240\u6709\u4e1a\u52a1\u6570\u636e\u5bfc\u5165\u5904\u7406\u5668\u7684\u7c7b\u540d\u4fe1\u606f")
    @GetMapping(value={"/findProcessClassNames"})
    public ResponseModel findProcessClassNames() {
        try {
            Set<String> results = this.fromDetailsImportService.findProcessClassNames();
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8be5\u529f\u80fd\u4e3a\u6307\u5b9a\u7684\u5217\u8868\u6a21\u677f\u3001\u57fa\u4e8e\u6307\u5b9a\u7684\u8fdb\u884c\u4e1a\u52a1\u6570\u636e\u6279\u91cf\u5bfc\u5165\u529f\u80fd\u7684\u6309\u94ae\uff0c\u4e0a\u4f20xls\u3001xlsx\u683c\u5f0f\u7684\u6a21\u677f\u6587\u4ef6\u4f7f\u7528\u3002\u4ee5\u4fdd\u8bc1\u4f7f\u7528\u8be5\u529f\u80fd\u8fdb\u884c\u4e1a\u52a1\u6570\u636e\u6279\u91cf\u5bfc\u5165\u7684xls\u3001xlsx\u6587\u4ef6\u7684\u7edf\u4e00\u6027")
    @PostMapping(value={"/importTemplate"})
    public ResponseModel importTemplate(@RequestParam(name="file", required=true) @ApiParam(required=true, name="file", value="\u4e0a\u4f20\u7684xls/xlsx\uff08\u6a21\u677f\uff09\u6587\u4ef6\u4fe1\u606f\uff0c\u76ee\u524d\u53ea\u652f\u6301\u5355\u4e2a\u6587\u4ef6\u7684\u4e0a\u4f20") MultipartFile file, @RequestParam(name="listTemplateCode", required=true) @ApiParam(required=true, name="listTemplateCode", value="\u5bf9\u5e94\u7684\u5217\u8868\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7") String listTemplateCode, @RequestParam(name="listTemplateVersion", required=true) @ApiParam(required=true, name="listTemplateVersion", value="\u5bf9\u5e94\u7684\u5217\u8868\u6a21\u677f\u7248\u672c\u4fe1\u606f") String listTemplateVersion, @RequestParam(name="buttonCode", required=true) @ApiParam(required=true, name="buttonCode", value="\u5bf9\u5e94\u7684\u5217\u8868\u6a21\u677f\u4e2d\u8fdb\u884c\u4e1a\u52a1\u6570\u636e\u6279\u91cf\u5bfc\u5165\u529f\u80fd\u7684\u6309\u94aecode") String buttonCode) {
        try {
            byte[] fileBytes = file.getBytes();
            String originalFilename = file.getOriginalFilename();
            FromDetailsImportEntity result = this.fromDetailsImportService.importTemplate(fileBytes, listTemplateCode, listTemplateVersion, buttonCode, originalFilename);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u7ed9\u5b9a\u7684\u6587\u4ef6\u8def\u5f84\u548c\u6587\u4ef6\u540d\uff0c\u4e0b\u8f7d\u4e00\u822c\u6027\u6587\u4ef6\u3002")
    @RequestMapping(value={"/downloadTemplate"}, method={RequestMethod.GET})
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="relativeLocal", value="\u76f8\u5bf9\u8def\u5f84", required=true) @RequestParam(value="relativeLocal") String relativeLocal, @ApiParam(name="fileName", value="\u6587\u4ef6\u540d\uff08\u91cd\u547d\u540d\u540e\u7684\uff09", required=true) @RequestParam(value="fileName") String fileName) throws IOException {
        FromDetailsImportEntity ordinaryFile = this.fromDetailsImportService.findByFileNameAndRelativeLocal(fileName, relativeLocal);
        if (ordinaryFile == null) {
            return;
        }
        byte[] bytes = this.venusFileService.readFileContent(relativeLocal, fileName);
        if (bytes == null) {
            return;
        }
        String downloadFileName = ordinaryFile.getOriginalFilename();
        if (StringUtils.isBlank((CharSequence)downloadFileName)) {
            downloadFileName = ordinaryFile.getFileName();
        }
        this.writeResponseFile(request, response, bytes, downloadFileName);
    }

    @ApiOperation(value="\u6309\u7167\u7ed9\u5b9a\u7684\u5217\u8868\u7f16\u7801\uff0c\u5217\u8868\u7248\u672c\u4ee5\u53ca\u6309\u94ae\u7684\u7f16\u53f7\uff0c\u67e5\u8be2\u5bfc\u5165\u6a21\u677f\u6587\u4ef6")
    @RequestMapping(value={"/downloadTemplateByCode"}, method={RequestMethod.GET})
    public void downloadTemplateByCode(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="listTemplateCode", value="\u5217\u8868\u7f16\u7801", required=true) @RequestParam(value="listTemplateCode") String listTemplateCode, @ApiParam(name="listTemplateVersion", value="\u5217\u8868\u7248\u672c\u53f7", required=true) @RequestParam(value="listTemplateVersion") String listTemplateVersion, @ApiParam(name="buttonCode", value="\u6309\u94ae\u7f16\u7801", required=true) @RequestParam(value="buttonCode") String buttonCode) {
        FromDetailsImportEntity ordinaryFile = this.fromDetailsImportService.findByCodeAndVersionAndButtonCode(listTemplateCode, listTemplateVersion, buttonCode);
        if (ordinaryFile == null) {
            return;
        }
        byte[] bytes = this.venusFileService.readFileContent(ordinaryFile.getRelativePath(), ordinaryFile.getFileName());
        if (bytes == null) {
            return;
        }
        String downloadFileName = ordinaryFile.getOriginalFilename();
        if (StringUtils.isBlank((CharSequence)downloadFileName)) {
            downloadFileName = ordinaryFile.getFileName();
        }
        this.writeResponseFile(request, response, bytes, downloadFileName);
    }

    @ApiOperation(value="\u6309\u7167\u7ed9\u5b9a\u7684\u5217\u8868\u7f16\u7801\uff0c\u5217\u8868\u7248\u672c\u4ee5\u53ca\u6309\u94ae\u7684\u7f16\u53f7\uff0c\u67e5\u8be2\u5bfc\u5165\u6a21\u677f\u6587\u4ef6")
    @GetMapping(value={"/findTemplateByCode"})
    public ResponseModel findTemplateByCode(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="listTemplateCode", value="\u5217\u8868\u7f16\u7801", required=true) @RequestParam(value="listTemplateCode") String listTemplateCode, @ApiParam(name="listTemplateVersion", value="\u5217\u8868\u7248\u672c\u53f7", required=true) @RequestParam(value="listTemplateVersion") String listTemplateVersion, @ApiParam(name="buttonCode", value="\u6309\u94ae\u7f16\u7801", required=true) @RequestParam(value="buttonCode") String buttonCode) {
        try {
            FromDetailsImportEntity entity = this.fromDetailsImportService.findByCodeAndVersionAndButtonCode(listTemplateCode, listTemplateVersion, buttonCode);
            return this.buildHttpResultW(entity, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

