/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.PageEntity;
import com.bizunited.platform.kuiper.starter.service.PageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="PageController", tags={"\u9875\u9762\u6d41\u9875\u9762\u6570\u636e\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
@RestController
@RequestMapping(value={"/v1/kuiper/pages"})
public class PageController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageController.class);
    @Autowired
    private PageService pageService;
    private static final String[] PAGE_PROPERTIES_W = new String[]{"pageFlow", "events"};

    @GetMapping(value={"findDetailsByPageFlowCode"})
    @ApiOperation(value="\u6309\u7167\u9875\u9762\u6d41\u7f16\u7801\u8fdb\u67e5\u8be2\u9875\u9762\u5217\u8868\u8be6\u60c5")
    public ResponseModel findDetailsByPageFlowCode(@ApiParam(name="pageFlowCode", value="\u6307\u5b9a\u7684\u9875\u9762\u7f16\u7801", required=true) @RequestParam(value="pageFlowCode") String pageFlowCode) {
        try {
            Set<PageEntity> result = this.pageService.findDetailsByPageFlowCode(pageFlowCode);
            return this.buildHttpResultW(result, PAGE_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsById"})
    @ApiOperation(value="\u6309\u7167\u6570\u9875\u9762ID\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u542b\u9875\u9762\u4e0b\u7684\u6240\u6709\u5173\u8054\u4fe1\u606f")
    public ResponseModel findDetailsById(@ApiParam(value="\u9875\u9762ID", required=true) @RequestParam(value="id") String id) {
        try {
            PageEntity result = this.pageService.findDetailsById(id);
            return this.buildHttpResultW(result, PAGE_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByCodeAndPageFlowCode"})
    @ApiOperation(value="\u6839\u636e\u9875\u9762\u6d41code\u548c\u9875\u9762code\u67e5\u8be2\u8be6\u60c5\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u542b\u9875\u9762\u4e0b\u7684\u6240\u6709\u5173\u8054\u4fe1\u606f")
    public ResponseModel findDetailsByCodeAndPageFlowCode(@ApiParam(name="code", value="\u6307\u5b9a\u7684\u9875\u9762\u7f16\u7801", required=true) @RequestParam(value="code") String code, @ApiParam(name="pageFlowCode", value="\u6307\u5b9a\u7684\u9875\u9762\u6d41\u7f16\u7801", required=true) @RequestParam(value="pageFlowCode") String pageFlowCode) {
        try {
            PageEntity result = this.pageService.findDetailsByCodeAndPageFlowCode(code, pageFlowCode);
            return this.buildHttpResultW(result, PAGE_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByPageFlowCode"})
    @ApiOperation(value="\u6309\u7167\u6570\u9875\u9762\u6d41\u7f16\u7801\u8fdb\u884c\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u4e0d\u5305\u542b\u5173\u8054\u4fe1\u606f\u4ee5\u53ca\u6587\u4ef6\u5185\u5bb9")
    public ResponseModel findByPageFlowCode(@ApiParam(value="\u9875\u9762\u6d41\u7f16\u7801", required=true) @RequestParam(value="pageFlowCode") String pageFlowCode) {
        try {
            Set<PageEntity> result = this.pageService.findByPageFlowCode(pageFlowCode);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

