/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.kuiper.entity.PageFlowEntity;
import com.bizunited.platform.kuiper.starter.repository.internal.PageFlowRepositoryCustom;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="PageFlowRepositoryImpl")
public class PageFlowRepositoryImpl
implements PageFlowRepositoryCustom,
PageRepositoryImpl {
    private static final String PAGE_FLOW_NAME = "name";
    private static final String PAGE_FLOW_CODE = "code";
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PlatformContext platformContext;

    @Override
    public Page<PageFlowEntity> findByConditions(PageFlowEntity pageFlow, Pageable pageable) {
        StringBuilder hql = new StringBuilder("from PageFlowEntity pf left join fetch pf.pages where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from PageFlowEntity pf where 1=1 ");
        StringBuilder condition = new StringBuilder();
        condition.append(" and pf.projectName=:projectName ");
        HashMap<String, String> parameter = new HashMap<String, String>(9);
        parameter.put("projectName", this.platformContext.getAppName());
        if (pageFlow != null) {
            if (StringUtils.isNotBlank((CharSequence)pageFlow.getName())) {
                condition.append(" AND pf.name like CONCAT(CONCAT('%', :name), '%') ");
                parameter.put(PAGE_FLOW_NAME, pageFlow.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)pageFlow.getCode())) {
                condition.append(" AND pf.code like CONCAT(CONCAT('%', :code), '%') ");
                parameter.put(PAGE_FLOW_CODE, pageFlow.getCode());
            }
        }
        hql.append((CharSequence)condition).append(" order by pf.createTime desc ");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }
}

