/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository.table;

import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.starter.repository.table.TableOperateRepositoryCustom;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="TableOperateRepositoryImpl")
public class TableOperateRepositoryImpl
implements TableOperateRepositoryCustom {
    private static final String TABLE_AND_FIELD_PATTERN = "^[A-Za-z_]{1}[\\w]+$";
    private static final String TABLE_ERROR = "\u9519\u8bef\u7684\u6570\u636e\u8868\u540d\uff0c\u6570\u636e\u8868\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u5927\u4e8e\u4e24\u4f4d\uff0c\u4e14\u53ea\u5305\u62ec\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff1b\u5e76\u4e14\u4e0d\u80fd\u542b\u6709\u6570\u636e\u5e93\u4fdd\u7559\u5173\u952e\u5b57";
    private static final String FIELD_ERROR = "\u9519\u8bef\u7684\u6570\u636e\u5b57\u6bb5\u540d\uff0c\u6570\u636e\u5b57\u6bb5\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u5927\u4e8e\u4e24\u4f4d\uff0c\u4e14\u53ea\u5305\u62ec\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff1b\u5e76\u4e14\u4e0d\u80fd\u542b\u6709\u6570\u636e\u5e93\u4fdd\u7559\u5173\u952e\u5b57";
    private static final String TAG_SEPARATOR = "line.separator";
    private static final String MESS_REF_MANYTOONE = "ManyToOne";
    private static final String MESS_REF_MANYTOMANY = "ManyToMany";
    private static final String MESS_REF_VARCHAR = "varchar";
    private static final String MESS_REF_ENGINE = ") ENGINE=InnoDB DEFAULT CHARSET=utf8;";
    private static final String OP_CREATE_TABLE = "CREATE TABLE `";
    private static final String[] RETAINFIELDNAMES = new String[]{"add", "all", "alter", "analyze", "and", "as", "asc", "asensitive", "before", "between", "bigint", "binary", "blob", "both", "by", "call", "cascade", "case", "create", "change", "char", "character", "check", "collate", "column", "condition", "connection", "constraint", "continue", "convert", "cross", "current_date", "current_time", "current_timestamp", "current_user", "cursor", "database", "databases", "day_hour", "day_microsecond", "day_minute", "day_second", "dec", "decimal", "declare", "default", "delayed", "delete", "desc", "describe", "deterministic", "distinct", "distinctrow", "div", "double", "drop", "dual", "each", "else", "elseif", "enclosed", "escaped", "exists", "exit", "explain", "false", "fetch", "float", "float4", "float8", "for", "force", "foreign", "from", "fulltext", "goto", "grant", "group", "having", "high_priority", "hour_microsecond", "hour_minute", "hour_second", "if", "ignore", "in", "index", "infile", "inner", "inout", "insensitive", "insert", "int", "int1", "int2", "int3", "int4", "int8", "integer", "interval", "into", "is", "iterate", "join", "key", "keys", "kill", "label", "leading", "leave", "left", "like", "limit", "linear", "lines", "load", "localtime", "localtimestamp", "lock", "long", "longblob", "longtext", "loop", "low_priority", "match", "mediumblob", "mediumint", "mediumtext", "middleint", "minute_microsecond", "minute_second", "mod", "modifies", "natural", "not", "no_write_to_binlog", "null", "numeric", "on", "optimize", "option", "optionally", "or", "order", "out", "outer", "outfile", "precision", "primary", "procedure", "purge", "raid0", "range", "read", "reads", "real", "references", "regexp", "release", "rename", "repeat", "replace", "require", "restrict", "return", "revoke", "right", "rlike", "schema", "second_microsecond", "select", "sensitive", "separator", "set", "show", "smallint", "spatial", "specific", "sql", "sqlexception", "sqlstate", "sqlwarning", "sql_big_result", "sql_calc_found_rows", "sql_small_result", "ssl", "starting", "straight_join", "table", "terminated", "then", "tinyblob", "tinyint", "tinytext", "to", "trailing", "trigger", "true", "undo", "union", "unique", "unlock", "unsigned", "update", "usage", "use", "using", "utc_date", "utc_time", "utc_timestamp", "values", "varbinary", "varchar", "varcharacter", "varying", "when", "where", "while", "with", "write", "x509", "xor", "year_month", "zerofill"};
    private static Map<String, String> classTypeMapping = new HashMap<String, String>();
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    private void validateTemplate(TemplateEntity template) {
        Validate.notNull((Object)template, (String)"\u52a8\u6001\u6a21\u677f\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String resouceTableName = template.getTableName();
        Validate.matchesPattern((CharSequence)resouceTableName, (String)TABLE_AND_FIELD_PATTERN, (String)TABLE_ERROR, (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equalsAnyIgnoreCase((CharSequence)resouceTableName, (CharSequence[])RETAINFIELDNAMES) ? 1 : 0) != 0, (String)TABLE_ERROR, (Object[])new Object[0]);
        Set properties = template.getProperties();
        this.validateProperties(properties);
        Set groups = template.getGroupRelations();
        this.validateGroups(groups);
        Set items = template.getItemRelations();
        this.validateItems(items);
    }

    private void validateGroups(Set<TemplateGroupEntity> groups) {
        if (groups == null) {
            return;
        }
        for (TemplateGroupEntity templateGroupItem : groups) {
            String tableName = templateGroupItem.getTableName();
            Validate.matchesPattern((CharSequence)tableName, (String)TABLE_AND_FIELD_PATTERN, (String)TABLE_ERROR, (Object[])new Object[0]);
            Validate.isTrue((!StringUtils.equalsAnyIgnoreCase((CharSequence)tableName, (CharSequence[])RETAINFIELDNAMES) ? 1 : 0) != 0, (String)TABLE_ERROR, (Object[])new Object[0]);
            Set properties = templateGroupItem.getProperties();
            this.validateProperties(properties);
            Set items = templateGroupItem.getItemRelations();
            this.validateItems(items);
        }
    }

    private void validateItems(Set<TemplateItemEntity> items) {
        if (items == null) {
            return;
        }
        for (TemplateItemEntity templateItem : items) {
            String tableName = templateItem.getTableName();
            Validate.matchesPattern((CharSequence)tableName, (String)TABLE_AND_FIELD_PATTERN, (String)TABLE_ERROR, (Object[])new Object[0]);
            Validate.isTrue((!StringUtils.equalsAnyIgnoreCase((CharSequence)tableName, (CharSequence[])RETAINFIELDNAMES) ? 1 : 0) != 0, (String)TABLE_ERROR, (Object[])new Object[0]);
            Set properties = templateItem.getProperties();
            this.validateProperties(properties);
        }
    }

    private void validateProperties(Set<TemplatePropertyEntity> properties) {
        if (properties == null) {
            return;
        }
        for (TemplatePropertyEntity templateProperty : properties) {
            String propertyDbName = templateProperty.getPropertyDbName();
            Validate.matchesPattern((CharSequence)propertyDbName, (String)TABLE_AND_FIELD_PATTERN, (String)FIELD_ERROR, (Object[])new Object[0]);
            Validate.isTrue((!StringUtils.equalsAnyIgnoreCase((CharSequence)propertyDbName, (CharSequence[])RETAINFIELDNAMES) ? 1 : 0) != 0, (String)FIELD_ERROR, (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public void createTable(TemplateEntity template) {
        Set<TemplateRelationEntity> manyToManyRelations;
        Set<TemplateRelationEntity> manyToOneRelations;
        this.validateTemplate(template);
        String resouceTableName = template.getTableName();
        Set properties = template.getProperties();
        StringBuilder sqlDdl = new StringBuilder();
        sqlDdl.append(OP_CREATE_TABLE + resouceTableName + "` (").append(System.getProperty(TAG_SEPARATOR));
        sqlDdl.append(this.createTableProperties(properties)).append(System.getProperty(TAG_SEPARATOR));
        Set relations = template.getRelations();
        if (relations != null && !relations.isEmpty() && (manyToOneRelations = relations.stream().filter(item -> item.getRelationType().equals(MESS_REF_MANYTOONE)).collect(Collectors.toSet())) != null && !manyToOneRelations.isEmpty()) {
            sqlDdl.append(this.createManyToOneRelations(manyToOneRelations)).append(System.getProperty(TAG_SEPARATOR));
        }
        sqlDdl.append("  PRIMARY KEY (`id`) ").append(System.getProperty(TAG_SEPARATOR));
        sqlDdl.append(MESS_REF_ENGINE).append(System.getProperty(TAG_SEPARATOR));
        LinkedList<String> manyToManyMappingSqls = new LinkedList<String>();
        if (relations != null && !relations.isEmpty() && (manyToManyRelations = relations.stream().filter(item -> item.getRelationType().equals(MESS_REF_MANYTOMANY)).collect(Collectors.toSet())) != null && !manyToManyRelations.isEmpty()) {
            this.createManyToManyRelations(resouceTableName, manyToManyRelations, manyToManyMappingSqls);
        }
        Set oneToManyRelations = template.getItemRelations();
        LinkedList<String> oneToManySqls = new LinkedList<String>();
        this.createItems(oneToManyRelations, manyToManyMappingSqls, oneToManySqls);
        Set oneToOneRelations = template.getGroupRelations();
        LinkedList<String> oneToOneSqls = new LinkedList<String>();
        this.createGroups(oneToOneRelations, manyToManyMappingSqls, oneToOneSqls, oneToManySqls);
        Query sqlQuery = this.entityManager.createNativeQuery(sqlDdl.toString());
        sqlQuery.executeUpdate();
        for (String oneToOneSql : oneToOneSqls) {
            sqlQuery = this.entityManager.createNativeQuery(oneToOneSql);
            sqlQuery.executeUpdate();
        }
        for (String oneToManySql : oneToManySqls) {
            sqlQuery = this.entityManager.createNativeQuery(oneToManySql);
            sqlQuery.executeUpdate();
        }
        for (String manyToManyMappingSql : manyToManyMappingSqls) {
            sqlQuery = this.entityManager.createNativeQuery(manyToManyMappingSql);
            sqlQuery.executeUpdate();
        }
    }

    private String createTableProperties(Set<TemplatePropertyEntity> properties) {
        Validate.isTrue((properties != null && !properties.isEmpty() ? 1 : 0) != 0, (String)"\u5728\u6784\u5efa\u4e00\u822c\u5c5e\u6027\u521b\u5efa\u8bed\u53e5\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f20\u5165\u7a7a\u96c6\u5408\u63cf\u8ff0", (Object[])new Object[0]);
        StringBuilder sqlDdl = new StringBuilder();
        for (TemplatePropertyEntity templateProperty : properties) {
            Integer maxLen = templateProperty.getMaxLen();
            if (maxLen == null) {
                maxLen = 255;
            }
            String propertyDbName = templateProperty.getPropertyDbName();
            String propertyClassName = templateProperty.getPropertyClassName();
            Boolean nullable = templateProperty.getNullable();
            Boolean unique = templateProperty.getUnique();
            Boolean primaryKey = templateProperty.getPrimaryKey();
            sqlDdl.append(this.buildSqlPropertyLine(propertyDbName, propertyClassName, maxLen, nullable)).append(System.getProperty(TAG_SEPARATOR));
            if (!Boolean.TRUE.equals(unique) || Boolean.TRUE.equals(primaryKey)) continue;
            sqlDdl.append(this.buildSqlUkLine(propertyDbName)).append(System.getProperty(TAG_SEPARATOR));
        }
        return sqlDdl.toString();
    }

    private String createManyToOneRelations(Set<TemplateRelationEntity> relations) {
        Validate.isTrue((relations != null && !relations.isEmpty() ? 1 : 0) != 0, (String)"\u5728\u6784\u5efaManyToOne\u5173\u8054\u5c5e\u6027\u521b\u5efa\u8bed\u53e5\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f20\u5165\u7a7a\u96c6\u5408\u63cf\u8ff0", (Object[])new Object[0]);
        StringBuilder sqlDdl = new StringBuilder();
        for (TemplateRelationEntity templateRelationItem : relations) {
            String relationType = templateRelationItem.getRelationType();
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)relationType, (CharSequence)MESS_REF_MANYTOONE), (String)"\u53d1\u73b0\u5173\u8054\u7c7b\u578b\u9519\u8bef\u7684\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            String propertyDbName = templateRelationItem.getPropertyDbName();
            String propertyClassName = templateRelationItem.getPropertyClassName();
            String targetTableName = templateRelationItem.getTargetTableName();
            Validate.notBlank((CharSequence)targetTableName, (String)"\u5728\u5904\u7406\u5173\u8054\u5173\u7cfb\u65f6\uff0c\u53d1\u73b0`%s`\uff08ManyToOne\uff09\u6ca1\u6709\u586b\u5199\u76ee\u6807\u6570\u636e\u8868\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyDbName});
            if (StringUtils.isBlank((CharSequence)propertyClassName)) {
                propertyClassName = "java.lang.String";
            }
            Integer maxLen = 255;
            Boolean nullable = templateRelationItem.getNullable();
            String targetPkName = "id";
            sqlDdl.append(this.buildSqlPropertyLine(propertyDbName, propertyClassName, maxLen, nullable)).append(System.getProperty(TAG_SEPARATOR));
            sqlDdl.append(this.buildSqlFkLine(propertyDbName, targetTableName, targetPkName)).append(System.getProperty(TAG_SEPARATOR));
        }
        return sqlDdl.toString();
    }

    private void createManyToManyRelations(String resouceTableName, Set<TemplateRelationEntity> relations, List<String> mappingTableSqlDdls) {
        Validate.isTrue((relations != null ? 1 : 0) != 0, (String)"\u5728\u6784\u5efaManyToMany\u5173\u8054\u5c5e\u6027\u521b\u5efa\u8bed\u53e5\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f20\u5165\u7a7a\u96c6\u5408\u63cf\u8ff0", (Object[])new Object[0]);
        for (TemplateRelationEntity templateRelationItem : relations) {
            StringBuilder sqlDdl = new StringBuilder();
            String relationType = templateRelationItem.getRelationType();
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)relationType, (CharSequence)MESS_REF_MANYTOMANY), (String)"\u53d1\u73b0\u5173\u8054\u7c7b\u578b\u9519\u8bef\u7684\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            String targetTableName = templateRelationItem.getTargetTableName();
            Validate.notBlank((CharSequence)targetTableName, (String)"\u786e\u5b9a\u7684ManyToMany\u5173\u7cfb\uff0c\u5176\u76ee\u6807\u6570\u636e\u8868\u540d\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8868\u3010%s\u3011\u7684\u8bbe\u5b9a!!", (Object[])new Object[]{resouceTableName});
            String targetPkName = "id";
            String resoucePkName = "id";
            List sortedNames = Arrays.asList(resouceTableName, targetTableName).stream().sorted().collect(Collectors.toList());
            String mappingTable = String.format("%s_%s_mapping", sortedNames.get(0), sortedNames.get(1));
            String mappingResourceKey = String.format("%s_%s", resouceTableName, resoucePkName);
            String mappingTargetKey = String.format("%s_%s", targetTableName, targetPkName);
            String mappingResourceFk = UUID.randomUUID().toString();
            mappingResourceFk = StringUtils.join((Object[])new String[]{"FK_", mappingResourceFk}).toUpperCase().replaceAll("\\-", "");
            String mappingTargetFk = UUID.randomUUID().toString();
            mappingTargetFk = StringUtils.join((Object[])new String[]{"FK_", mappingTargetFk}).toUpperCase().replaceAll("\\-", "");
            sqlDdl.append(OP_CREATE_TABLE + mappingTable + "` (").append(System.getProperty(TAG_SEPARATOR));
            sqlDdl.append("  `" + mappingResourceKey + "` varchar(255) NOT NULL,").append(System.getProperty(TAG_SEPARATOR));
            sqlDdl.append("  `" + mappingTargetKey + "` varchar(255) NOT NULL,").append(System.getProperty(TAG_SEPARATOR));
            sqlDdl.append("  PRIMARY KEY (`" + mappingResourceKey + "`,`" + mappingTargetKey + "`),").append(System.getProperty(TAG_SEPARATOR));
            sqlDdl.append("  CONSTRAINT `" + mappingResourceFk + "` FOREIGN KEY (`" + mappingResourceKey + "`) REFERENCES `" + resouceTableName + "` (`" + resoucePkName + "`),").append(System.getProperty(TAG_SEPARATOR));
            sqlDdl.append("  CONSTRAINT `" + mappingTargetFk + "` FOREIGN KEY (`" + mappingTargetKey + "`) REFERENCES `" + targetTableName + "` (`" + targetPkName + "`) ").append(System.getProperty(TAG_SEPARATOR));
            sqlDdl.append(MESS_REF_ENGINE).append(System.getProperty(TAG_SEPARATOR));
            mappingTableSqlDdls.add(sqlDdl.toString());
        }
    }

    private void createItems(Set<TemplateItemEntity> oneToManyRelations, List<String> manyToManyMappingSqls, List<String> oneToManySqls) {
        if (oneToManyRelations == null || oneToManyRelations.isEmpty()) {
            return;
        }
        for (TemplateItemEntity oneToManyItem : oneToManyRelations) {
            Set<TemplateRelationEntity> manyToManyRelations;
            Set<TemplateRelationEntity> manyToOneRelations;
            StringBuilder oneToManySqlDdl = new StringBuilder();
            String currentTableName = oneToManyItem.getTableName();
            Validate.notBlank((CharSequence)currentTableName, (String)"\u5728\u6784\u5efa\u660e\u7ec6\u7f16\u8f91\u9879\u65f6\uff0c\u672a\u53d1\u73b0\u660e\u7ec6\u7f16\u8f91\u9879\u5bf9\u5e94\u7684\u6570\u636e\u8868\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            oneToManySqlDdl.append(OP_CREATE_TABLE + currentTableName + "` (").append(System.getProperty(TAG_SEPARATOR));
            Set oneToManyProperties = oneToManyItem.getProperties();
            oneToManySqlDdl.append(this.createTableProperties(oneToManyProperties)).append(System.getProperty(TAG_SEPARATOR));
            LinkedHashSet omRlations = oneToManyItem.getRelations();
            if (omRlations == null) {
                omRlations = new LinkedHashSet();
            }
            if (omRlations != null && !omRlations.isEmpty() && (manyToOneRelations = omRlations.stream().filter(item -> item.getRelationType().equals(MESS_REF_MANYTOONE)).collect(Collectors.toSet())) != null && !manyToOneRelations.isEmpty()) {
                oneToManySqlDdl.append(this.createManyToOneRelations(manyToOneRelations)).append(System.getProperty(TAG_SEPARATOR));
            }
            oneToManySqlDdl.append("  PRIMARY KEY (`id`) ").append(System.getProperty(TAG_SEPARATOR));
            oneToManySqlDdl.append(MESS_REF_ENGINE).append(System.getProperty(TAG_SEPARATOR));
            oneToManySqls.add(oneToManySqlDdl.toString());
            if (omRlations == null || omRlations.isEmpty() || (manyToManyRelations = omRlations.stream().filter(item -> item.getRelationType().equals(MESS_REF_MANYTOMANY)).collect(Collectors.toSet())) == null || manyToManyRelations.isEmpty()) continue;
            this.createManyToManyRelations(currentTableName, manyToManyRelations, manyToManyMappingSqls);
        }
    }

    private void createGroups(Set<TemplateGroupEntity> oneToOneRelations, List<String> manyToManyMappingSqls, List<String> oneToOneSqls, List<String> oneToManySqls) {
        if (oneToOneRelations != null && !oneToOneRelations.isEmpty()) {
            for (TemplateGroupEntity oneToOneGroup : oneToOneRelations) {
                Set<TemplateRelationEntity> manyToManyRelations;
                Set<TemplateRelationEntity> manyToOneRelations;
                Set ooRlations;
                StringBuilder oneToOneSqlDdl = new StringBuilder();
                String currentTableName = oneToOneGroup.getTableName();
                String parentTableName = oneToOneGroup.getParentTableName();
                Validate.notBlank((CharSequence)currentTableName, (String)"\u5728\u6784\u5efa\u5206\u7ec4\u9879\u65f6\uff0c\u672a\u53d1\u73b0\u5206\u7ec4\u9879\u5bf9\u5e94\u7684\u6570\u636e\u8868\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)parentTableName, (String)"\u5728\u6784\u5efa\u5206\u7ec4\u9879\u65f6\uff0c\u672a\u53d1\u73b0\u5206\u7ec4\u9879\u5bf9\u5e94\u7684\u4e0a\u5c42\u6570\u636e\u8868\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                oneToOneSqlDdl.append(OP_CREATE_TABLE + currentTableName + "` (").append(System.getProperty(TAG_SEPARATOR));
                Set oneToOneProperties = oneToOneGroup.getProperties();
                if (oneToOneProperties != null && !oneToOneProperties.isEmpty()) {
                    oneToOneSqlDdl.append(this.createTableProperties(oneToOneProperties)).append(System.getProperty(TAG_SEPARATOR));
                }
                if ((ooRlations = oneToOneGroup.getRelations()) != null && !ooRlations.isEmpty() && (manyToOneRelations = ooRlations.stream().filter(item -> item.getRelationType().equals(MESS_REF_MANYTOONE)).collect(Collectors.toSet())) != null && !manyToOneRelations.isEmpty()) {
                    oneToOneSqlDdl.append(this.createManyToOneRelations(manyToOneRelations)).append(System.getProperty(TAG_SEPARATOR));
                }
                oneToOneSqlDdl.append("  PRIMARY KEY (`id`) ").append(System.getProperty(TAG_SEPARATOR));
                oneToOneSqlDdl.append(MESS_REF_ENGINE).append(System.getProperty(TAG_SEPARATOR));
                oneToOneSqls.add(oneToOneSqlDdl.toString());
                if (ooRlations != null && !ooRlations.isEmpty() && (manyToManyRelations = ooRlations.stream().filter(item -> item.getRelationType().equals(MESS_REF_MANYTOMANY)).collect(Collectors.toSet())) != null && !manyToManyRelations.isEmpty()) {
                    this.createManyToManyRelations(currentTableName, manyToManyRelations, manyToManyMappingSqls);
                }
                Set currentOneToManyRelations = oneToOneGroup.getItemRelations();
                this.createItems(currentOneToManyRelations, manyToManyMappingSqls, oneToManySqls);
            }
        }
    }

    private String buildSqlFkLine(String propertyDbName, String targetTableName, String targetPropertyDbName) {
        String fkLine = null;
        String currentUuid = UUID.randomUUID().toString();
        String fkName = StringUtils.join((Object[])new String[]{"FK_", currentUuid}).toUpperCase().replaceAll("\\-", "");
        fkLine = String.format("  CONSTRAINT `%s` FOREIGN KEY (`%s`) REFERENCES `%s` (`%s`) , ", fkName, propertyDbName, targetTableName, targetPropertyDbName);
        return fkLine;
    }

    private String buildSqlUkLine(String propertyDbName) {
        String currentUuid = UUID.randomUUID().toString();
        String ukName = StringUtils.join((Object[])new String[]{"UK_", currentUuid}).toUpperCase().replaceAll("\\-", "");
        return String.format("  UNIQUE KEY `%s` (`%s`),", ukName, propertyDbName);
    }

    private String buildSqlPropertyLine(String propertyDbName, String propertyClassName, Integer maxlen, boolean nullable) {
        String dbType = classTypeMapping.get(propertyClassName);
        String field = StringUtils.equals((CharSequence)dbType, (CharSequence)MESS_REF_VARCHAR) ? String.format(" `%s` %s (%d) ", propertyDbName, dbType, maxlen) : String.format(" `%s` %s ", propertyDbName, dbType);
        field = nullable ? StringUtils.join((Object[])new String[]{field, " NULL , "}) : StringUtils.join((Object[])new String[]{field, " NOT NULL , "});
        return field;
    }

    @Override
    public Boolean existTableName(String tableName) {
        Validate.notBlank((CharSequence)tableName, (String)"\u6570\u636e\u8868\u7684\u540d\u5b57\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String querySql = " show tables like ?1 ;";
        Query query = this.entityManager.createNativeQuery(querySql);
        query.setParameter(1, (Object)tableName);
        List result = query.getResultList();
        return !CollectionUtils.isEmpty((Collection)result);
    }

    @Override
    public void upgradeTable(TemplateEntity sourceTemplate, TemplateEntity targetTemplate) {
        Query sqlQuery;
        LinkedList<String> mainTableUpgradeSqls = new LinkedList<String>();
        LinkedList<String> mappingTableUpgradeSqls = new LinkedList<String>();
        Set sourceProperties = sourceTemplate.getProperties();
        Set sourceRelations = sourceTemplate.getRelations();
        if (sourceRelations == null) {
            sourceRelations = Sets.newHashSet();
        }
        Set targetProperties = targetTemplate.getProperties();
        Set targetRelations = targetTemplate.getRelations();
        if (targetRelations == null) {
            targetRelations = Sets.newHashSet();
        }
        String resouceTableName = targetTemplate.getTableName();
        Validate.notBlank((CharSequence)resouceTableName, (String)"\u9519\u8bef\u7684\u6570\u636e\u8868\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.compareProperties(resouceTableName, sourceProperties, targetProperties, mainTableUpgradeSqls);
        this.compareRelations(resouceTableName, sourceRelations, targetRelations, mainTableUpgradeSqls, mappingTableUpgradeSqls);
        LinkedList<String> groupAlterTableSqls = new LinkedList<String>();
        LinkedList<String> oneToOneSqls = new LinkedList<String>();
        LinkedList<String> oneToManySqls = new LinkedList<String>();
        Set sourceGroups = sourceTemplate.getGroupRelations();
        if (sourceGroups == null) {
            sourceGroups = Sets.newHashSet();
        }
        Set targetGroups = targetTemplate.getGroupRelations();
        Set sourceGroupTableNames = sourceGroups.stream().map(TemplateGroupEntity::getTableName).collect(Collectors.toSet());
        Set targetGroupTableNames = targetGroups.stream().map(TemplateGroupEntity::getTableName).collect(Collectors.toSet());
        Validate.isTrue((boolean)Sets.difference(sourceGroupTableNames, targetGroupTableNames).isEmpty(), (String)"\u4e0d\u5141\u8bb8\u8fdb\u884c\u5206\u7ec4\u4fe1\u606f\u7684\u5220\u9664\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, TemplateGroupEntity> sourceMappingGroups = sourceGroups.stream().collect(Collectors.toMap(TemplateGroupEntity::getTableName, item -> item));
        if (targetGroups != null && !targetGroups.isEmpty()) {
            for (TemplateGroupEntity targetGroup : targetGroups) {
                String groupTableName = targetGroup.getTableName();
                TemplateGroupEntity sourceGroup = sourceMappingGroups.get(groupTableName);
                this.compareGroups(groupTableName, sourceGroup, targetGroup, groupAlterTableSqls, mappingTableUpgradeSqls, oneToOneSqls, oneToManySqls);
            }
        }
        LinkedList<String> itemAlterTableSqls = new LinkedList<String>();
        Set sourceTemplateItems = sourceTemplate.getItemRelations();
        if (sourceTemplateItems == null) {
            sourceTemplateItems = Sets.newHashSet();
        }
        Set targetTemplateItems = targetTemplate.getItemRelations();
        Set sourceItemsTableNames = sourceTemplateItems.stream().map(TemplateItemEntity::getTableName).collect(Collectors.toSet());
        Set targetItemsTableNames = targetTemplateItems.stream().map(TemplateItemEntity::getTableName).collect(Collectors.toSet());
        Validate.isTrue((boolean)Sets.difference(sourceItemsTableNames, targetItemsTableNames).isEmpty(), (String)"\u4e0d\u5141\u8bb8\u8fdb\u884c\u660e\u7ec6\u7f16\u8f91\u9879\u4fe1\u606f\u7684\u5220\u9664\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, TemplateItemEntity> sourceMappingItems = sourceTemplateItems.stream().collect(Collectors.toMap(TemplateItemEntity::getTableName, item -> item));
        if (targetTemplateItems != null && !targetTemplateItems.isEmpty()) {
            for (TemplateItemEntity targetItem : targetTemplateItems) {
                String tableName = targetItem.getTableName();
                TemplateItemEntity sourceItem = sourceMappingItems.get(tableName);
                this.compareItems(tableName, sourceItem, targetItem, itemAlterTableSqls, mappingTableUpgradeSqls, oneToManySqls);
            }
        }
        for (String mainTableUpgradeSql : mainTableUpgradeSqls) {
            sqlQuery = this.entityManager.createNativeQuery(mainTableUpgradeSql);
            sqlQuery.executeUpdate();
        }
        for (String itemAlterTableSql : itemAlterTableSqls) {
            sqlQuery = this.entityManager.createNativeQuery(itemAlterTableSql);
            sqlQuery.executeUpdate();
        }
        for (String groupAlterTableSql : groupAlterTableSqls) {
            sqlQuery = this.entityManager.createNativeQuery(groupAlterTableSql);
            sqlQuery.executeUpdate();
        }
        for (String oneToOneSql : oneToOneSqls) {
            sqlQuery = this.entityManager.createNativeQuery(oneToOneSql);
            sqlQuery.executeUpdate();
        }
        for (String oneToManySql : oneToManySqls) {
            sqlQuery = this.entityManager.createNativeQuery(oneToManySql);
            sqlQuery.executeUpdate();
        }
        for (String mappingTableUpgradeSql : mappingTableUpgradeSqls) {
            sqlQuery = this.entityManager.createNativeQuery(mappingTableUpgradeSql);
            sqlQuery.executeUpdate();
        }
    }

    @Override
    @Transactional
    public void executeNativeSQL(String sql) {
        Query sqlQuery = this.entityManager.createNativeQuery(sql);
        sqlQuery.executeUpdate();
    }

    @Override
    public List<?> executeQuerySql(String querySql) {
        Query query = this.entityManager.createNativeQuery(querySql);
        return query.getResultList();
    }

    private void compareGroups(String resouceTableName, TemplateGroupEntity sourceGroup, TemplateGroupEntity targetGroup, List<String> groupAlterTableSqls, List<String> manyToManyMappingSqls, List<String> oneToOneSqls, List<String> oneToManySqls) {
        Validate.notNull((Object)targetGroup, (String)"\u4e0d\u652f\u6301\u5bf9\u4e00\u4e2a\u5df2\u6709\u5206\u7ec4\u4fe1\u606f\u8fdb\u884c\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u4e3b\u8868\u3010%s\u3011\u4e0b\u7684\u5206\u7ec4\u8bbe\u5b9a", (Object[])new Object[]{resouceTableName});
        if (sourceGroup == null) {
            this.createGroups(Sets.newHashSet((Object[])new TemplateGroupEntity[]{targetGroup}), manyToManyMappingSqls, oneToOneSqls, oneToManySqls);
            return;
        }
        Set sourceProperties = sourceGroup.getProperties();
        Set sourceRelations = sourceGroup.getRelations();
        if (sourceRelations == null) {
            sourceRelations = Sets.newHashSet();
        }
        Set targetProperties = targetGroup.getProperties();
        Set targetRelations = targetGroup.getRelations();
        if (targetRelations == null) {
            targetRelations = Sets.newHashSet();
        }
        this.compareProperties(resouceTableName, sourceProperties, targetProperties, groupAlterTableSqls);
        this.compareRelations(resouceTableName, sourceRelations, targetRelations, groupAlterTableSqls, manyToManyMappingSqls);
        Set sourceItems = sourceGroup.getItemRelations();
        Set targetItems = targetGroup.getItemRelations();
        if ((sourceItems == null || sourceItems.isEmpty()) && (targetItems == null || targetItems.isEmpty())) {
            return;
        }
        if (sourceItems == null) {
            sourceItems = Sets.newHashSet();
        }
        Set sourceTableNameItems = sourceItems.stream().map(TemplateItemEntity::getTableName).collect(Collectors.toSet());
        Set targetTableNameItems = targetItems.stream().map(TemplateItemEntity::getTableName).collect(Collectors.toSet());
        Validate.isTrue((boolean)Sets.difference(sourceTableNameItems, targetTableNameItems).isEmpty(), (String)"\u4e0d\u5141\u8bb8\u5bf9\u5206\u7ec4\u4e0b\u7684\u660e\u7ec6\u7f16\u8f91\u9879\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8868\u3010%s\u3011\u4e0b\u7684\u660e\u7ec6\u7f16\u8f91\u9879\u8bbe\u5b9a", (Object[])new Object[]{resouceTableName});
        Map<String, TemplateItemEntity> sourceMappingItems = sourceItems.stream().collect(Collectors.toMap(TemplateItemEntity::getTableName, item -> item));
        for (TemplateItemEntity targetItem : targetItems) {
            String tableName = targetItem.getTableName();
            TemplateItemEntity sourceItem = sourceMappingItems.get(tableName);
            this.compareItems(tableName, sourceItem, targetItem, groupAlterTableSqls, manyToManyMappingSqls, oneToManySqls);
        }
    }

    private void compareItems(String resouceTableName, TemplateItemEntity sourceItem, TemplateItemEntity targetItem, List<String> alterTablesSqls, List<String> manyToManyMappingSqls, List<String> oneToManySqls) {
        if (sourceItem == null) {
            this.createItems(Sets.newHashSet((Object[])new TemplateItemEntity[]{targetItem}), manyToManyMappingSqls, oneToManySqls);
            return;
        }
        Set sourceProperties = sourceItem.getProperties();
        Set sourceRelations = sourceItem.getRelations();
        if (sourceRelations == null) {
            sourceRelations = Sets.newHashSet();
        }
        Set targetProperties = targetItem.getProperties();
        Set targetRelations = targetItem.getRelations();
        if (targetRelations == null) {
            targetRelations = Sets.newHashSet();
        }
        this.compareProperties(resouceTableName, sourceProperties, targetProperties, alterTablesSqls);
        this.compareRelations(resouceTableName, sourceRelations, targetRelations, alterTablesSqls, manyToManyMappingSqls);
    }

    private void compareProperties(String resouceTableName, Set<TemplatePropertyEntity> sourceProperties, Set<TemplatePropertyEntity> targetProperties, List<String> alterTablesSqls) {
        String propertyDbName;
        Validate.notBlank((CharSequence)resouceTableName, (String)"\u9519\u8bef\u7684\u6570\u636e\u8868\u540d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set targetPropertyDbNames = targetProperties.stream().map(TemplatePropertyEntity::getPropertyDbName).collect(Collectors.toSet());
        Set sourcePropertyDbNames = sourceProperties.stream().map(TemplatePropertyEntity::getPropertyDbName).collect(Collectors.toSet());
        Validate.isTrue((boolean)Sets.difference(sourcePropertyDbNames, targetPropertyDbNames).isEmpty(), (String)"\u5728\u8c03\u6574\u5206\u7ec4\u8868\u3010%s\u3011\u65f6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5df2\u6709\u7684\u4e00\u822c\u5c5e\u6027,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{resouceTableName});
        Map<String, TemplatePropertyEntity> targetPropertiesMapping = targetProperties.stream().collect(Collectors.toMap(TemplatePropertyEntity::getPropertyDbName, item -> item));
        List sourceStringProperties = sourceProperties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyClassName(), (CharSequence)"java.lang.String")).collect(Collectors.toList());
        for (Object sourceStringProperty : sourceStringProperties) {
            TemplatePropertyEntity targetTemplateProperty;
            Integer targetMaxLen;
            Integer sourceMaxLen = sourceStringProperty.getMaxLen();
            if (sourceMaxLen == null) {
                sourceMaxLen = 255;
            }
            if ((targetMaxLen = (targetTemplateProperty = targetPropertiesMapping.get(propertyDbName = sourceStringProperty.getPropertyDbName())).getMaxLen()) == null) {
                targetMaxLen = 255;
            }
            Validate.isTrue((sourceMaxLen <= targetMaxLen ? 1 : 0) != 0, (String)"\u5728\u9a8c\u8bc1%s[%s]\u5c5e\u6027\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u957f\u5ea6\u53d8\u5316\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{propertyDbName, resouceTableName});
            if (targetMaxLen <= sourceMaxLen) continue;
            String alterSql = String.format("alter table %s modify column %s varchar(%d);", resouceTableName, propertyDbName, targetMaxLen);
            alterTablesSqls.add(alterSql);
        }
        List sourceNotNullProperties = sourceProperties.stream().filter(item -> item.getNullable() == false).collect(Collectors.toList());
        for (TemplatePropertyEntity sourceNotNullProperty : sourceNotNullProperties) {
            propertyDbName = sourceNotNullProperty.getPropertyDbName();
            boolean sourceNullable = sourceNotNullProperty.getNullable();
            TemplatePropertyEntity targetTemplateProperty = targetPropertiesMapping.get(propertyDbName);
            boolean targetNullable = targetTemplateProperty.getNullable();
            String sourcePropertyClassName = sourceNotNullProperty.getPropertyClassName();
            String targetPropertyClassName = targetTemplateProperty.getPropertyClassName();
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)sourcePropertyClassName, (CharSequence)targetPropertyClassName), (String)"\u6570\u636e\u8868\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5%s\u3010%s\u3011", (Object[])new Object[]{propertyDbName, resouceTableName});
            Integer maxlen = targetTemplateProperty.getMaxLen();
            if (maxlen == null) {
                maxlen = 255;
            }
            String dbType = classTypeMapping.get(sourcePropertyClassName);
            Validate.isTrue((!sourceNullable || targetNullable ? 1 : 0) != 0, (String)"\u4e3anull\u7684\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4fee\u6539\u4e3anot null\uff0c\u8bf7\u68c0\u67e5%s[%s]", (Object[])new Object[]{propertyDbName, resouceTableName});
            if (sourceNullable || !targetNullable) continue;
            String alterSql = null;
            alterSql = StringUtils.equals((CharSequence)dbType, (CharSequence)MESS_REF_VARCHAR) ? String.format("alter table %s modify column %s %s (%d) null ;", resouceTableName, propertyDbName, dbType, maxlen) : String.format("alter table %s modify column %s %s null ;", resouceTableName, propertyDbName, dbType);
            alterTablesSqls.add(alterSql);
        }
        Sets.SetView diffTargetPropertyDbNames = Sets.difference(targetPropertyDbNames, sourcePropertyDbNames);
        for (String diffTargetPropertyDbName : diffTargetPropertyDbNames) {
            TemplatePropertyEntity targetProperty = targetPropertiesMapping.get(diffTargetPropertyDbName);
            String targetPropertyClassName = targetProperty.getPropertyClassName();
            String propertyDbName2 = targetProperty.getPropertyDbName();
            Integer maxlen = targetProperty.getMaxLen();
            if (maxlen == null) {
                maxlen = 255;
            }
            String dbType = classTypeMapping.get(targetPropertyClassName);
            String alterSql = null;
            alterSql = StringUtils.equals((CharSequence)dbType, (CharSequence)MESS_REF_VARCHAR) ? String.format("alter table %s add %s %s (%d) null ;", resouceTableName, propertyDbName2, dbType, maxlen) : String.format("alter table %s add %s %s null ;", resouceTableName, propertyDbName2, dbType);
            alterTablesSqls.add(alterSql);
        }
    }

    private void compareRelations(String resouceTableName, Set<TemplateRelationEntity> sourceRelations, Set<TemplateRelationEntity> targetRelations, List<String> alterTablesSqls, List<String> mappingTableSqls) {
        Set<TemplateRelationEntity> diffManyToManyRelations;
        if (sourceRelations == null || sourceRelations.isEmpty()) {
            return;
        }
        if (targetRelations == null || targetRelations.isEmpty()) {
            return;
        }
        if (!sourceRelations.isEmpty() && targetRelations.isEmpty()) {
            throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u5bf9\u5173\u8054\u5c5e\u6027\u8fdb\u884c\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8868\u3010%s\u3011\u4e2d\u7684\u5173\u8054\u5c5e\u6027\u8bbe\u5b9a!!", resouceTableName));
        }
        Set targetRelationNames = targetRelations.stream().map(TemplateRelationEntity::getPropertyName).collect(Collectors.toSet());
        Set sourceRelationNames = sourceRelations.stream().map(TemplateRelationEntity::getPropertyName).collect(Collectors.toSet());
        Sets.SetView targetDiddRelations = Sets.difference(targetRelationNames, sourceRelationNames);
        Sets.SetView sourceDiddRelations = Sets.difference(sourceRelationNames, targetRelationNames);
        Validate.isTrue((boolean)sourceDiddRelations.isEmpty(), (String)"\u8fdb\u884c\u5173\u8054\u5c5e\u6027\u4fee\u6539\u65f6\uff0c\u53ea\u80fd\u65b0\u589e\u5173\u8054\u4fe1\u606f\uff0c\u4e0d\u80fd\u5220\u9664\u6216\u66f4\u6539\u5df2\u6709\u7684\u5173\u8054\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8868\u3010%s\u3011", (Object[])new Object[]{resouceTableName});
        if (targetDiddRelations.isEmpty()) {
            return;
        }
        List diffManyToOneRelations = targetRelations.stream().filter(item -> targetDiddRelations.contains((Object)item.getPropertyName()) && StringUtils.equals((CharSequence)item.getRelationType(), (CharSequence)MESS_REF_MANYTOONE)).collect(Collectors.toList());
        if (diffManyToOneRelations != null) {
            for (TemplateRelationEntity diffRelation : diffManyToOneRelations) {
                String propertyClassName = diffRelation.getPropertyClassName();
                if (StringUtils.isBlank((CharSequence)propertyClassName)) {
                    propertyClassName = "java.lang.String";
                }
                String dbType = classTypeMapping.get(propertyClassName);
                String propertyDbName = diffRelation.getPropertyDbName();
                Integer maxlen = 255;
                String targetTableName = diffRelation.getTargetTableName();
                Validate.notBlank((CharSequence)targetTableName, (String)"\u5b57\u6bb5%s\u3010%s\u3011\u7684\u76ee\u6807\u6570\u636e\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{propertyDbName, resouceTableName});
                String propertyAlterPropertySql = null;
                propertyAlterPropertySql = StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.String") ? String.format(" alter table %s add %s %s (%d) null;", resouceTableName, propertyDbName, dbType, maxlen) : String.format(" alter table %s add %s %s null;", resouceTableName, propertyDbName, dbType);
                alterTablesSqls.add(propertyAlterPropertySql);
                String fkName = String.format("FK_%s_%s", resouceTableName, propertyDbName);
                String propertyAlterUkSql = String.format("alter table %s add constraint `%s` foreign key (`%s`) references %s (`id`);", resouceTableName, fkName, propertyDbName, targetTableName);
                alterTablesSqls.add(propertyAlterUkSql);
            }
        }
        if ((diffManyToManyRelations = targetRelations.stream().filter(item -> targetDiddRelations.contains((Object)item.getPropertyName()) && StringUtils.equals((CharSequence)item.getRelationType(), (CharSequence)MESS_REF_MANYTOMANY)).collect(Collectors.toSet())) != null && !diffManyToManyRelations.isEmpty()) {
            this.createManyToManyRelations(resouceTableName, diffManyToManyRelations, mappingTableSqls);
        }
    }

    static {
        classTypeMapping.put("java.lang.String", MESS_REF_VARCHAR);
        classTypeMapping.put("java.lang.Integer", "int");
        classTypeMapping.put("java.lang.Long", "bigint");
        classTypeMapping.put("java.lang.Float", "float");
        classTypeMapping.put("java.math.BigDecimal", "double");
        classTypeMapping.put("java.lang.Double", "double");
        classTypeMapping.put("java.lang.Boolean", "bit");
        classTypeMapping.put("java.util.Date", "timestamp");
    }
}

