/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.instances.handle;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.service.DynamicInstanceService;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import com.bizunited.platform.kuiper.starter.service.instances.handle.AbstractDynamicFormDetailsHandle;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="DynamicFormDetailsRequestHandle")
public class DynamicFormDetailsRequestHandle
extends AbstractDynamicFormDetailsHandle
implements InvokeRequestHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormDetailsRequestHandle.class);
    private static final String BEFORE_DETAILS = "_beforeDetails";
    @Autowired
    private DynamicInstanceService dynamicInstanceService;
    @Autowired
    private InstanceActivityService instanceActivityService;

    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        if (context.isException()) {
            return;
        }
        InvokeParams invokeParams = context.getParams();
        JSONObject formDateJson = null;
        Object[] variables = invokeParams.getVariables();
        JSONObject formData = (JSONObject)variables[0];
        Validate.notNull((Object)formData, (String)"\u9519\u8bef\u7684\u52a8\u6001\u6570\u636e\u5165\u53c2\u4fe1\u606f!!", (Object[])new Object[0]);
        String instanceId = null;
        String instanceActivityId = formData.getString("instanceActivityId");
        if (StringUtils.isBlank((CharSequence)instanceActivityId)) {
            instanceId = formData.getString("formInstanceId");
            instanceActivityId = this.instanceActivityService.findIdByMaxCreateTime(instanceId);
        } else {
            InstanceActivityEntity instanceActivity = this.instanceActivityService.findDetailsById(instanceActivityId);
            instanceId = instanceActivity.getInstance().getId();
        }
        Validate.notBlank((CharSequence)instanceActivityId, (String)"\u6839\u636e\u6307\u5b9a\u7684\u5b9e\u4f8b\u6d3b\u52a8[%s]\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{instanceId});
        invokeParams.putInvokeParam("instanceId", (Object)instanceId);
        invokeParams.putInvokeParam("instanceActivityId", (Object)instanceActivityId);
        formDateJson = this.dynamicInstanceService.findDetailsByFormInstanceId(instanceId);
        if (formDateJson == null) {
            formDateJson = new JSONObject();
        }
        LOGGER.debug("\u524d\u7f6e\u6570\u636e\uff1a{}", (Object)formDateJson);
        invokeParams.putInvokeParam(BEFORE_DETAILS, (Object)formDateJson);
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }
}

