/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.instances.handle;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import com.bizunited.platform.kuiper.starter.service.instances.handle.AbstractInstanceDetailsLogUpdateHandle;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="StaticInstanceDetailsLogUpdateHandle")
public class StaticInstanceDetailsLogUpdateHandle
extends AbstractInstanceDetailsLogUpdateHandle {
    @Autowired
    private InstanceActivityService instanceActivityService;
    @Autowired
    private ServicableMethodService servicableMethodService;

    public boolean handleException(InvokeProxyContext context) {
        return false;
    }

    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        InvokeParams invokeParams = context.getParams();
        Object serviceNameValue = invokeParams.getInvokeParam("serviceName");
        if (serviceNameValue == null || StringUtils.isBlank((CharSequence)serviceNameValue.toString())) {
            chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
            return;
        }
        String serviceName = serviceNameValue.toString();
        ServicableMethodInfo methodInfo = this.servicableMethodService.findDetailsByName(serviceName);
        Validate.notNull((Object)methodInfo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u670d\u52a1\u65b9\u6cd5\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{serviceName});
        Object principalValue = invokeParams.getInvokeParam("principal");
        Validate.notNull((Object)principalValue, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u767b\u5f55\u4fe1\u606f!!", (Object[])new Object[0]);
        String account = principalValue.toString();
        Object instanceActivityIdValue = invokeParams.getInvokeParam("instanceActivityId");
        Validate.notNull((Object)instanceActivityIdValue, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6d3b\u52a8\u5b9e\u4f8b\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String instanceActivityId = instanceActivityIdValue.toString();
        InstanceActivityEntity activity = this.instanceActivityService.findById(instanceActivityId);
        Validate.notNull((Object)activity, (String)"\u6839\u636e\u4f20\u5165\u7684\u6d3b\u52a8id\uff0c\u672a\u80fd\u67e5\u8be2\u5230\u76f8\u5e94\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity template = activity.getTemplate();
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u5f53\u524d\u6d3b\u52a8\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f\uff08\u4e5f\u5c31\u662f\u8868\u5355\u5b9e\u4f8b\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\uff0c\u8bf7\u68c0\u67e5\u606f\uff09", (Object[])new Object[0]);
        JSONObject beforeDetails = (JSONObject)invokeParams.getInvokeParam("_beforeDetails");
        JSONObject afterDetails = (JSONObject)invokeParams.getInvokeParam("_afterDetails");
        Validate.isTrue((beforeDetails != null && afterDetails != null ? 1 : 0) != 0, (String)"\u6ca1\u6709\u53d1\u73b0\u53ef\u7528\u7684\u5bf9\u6bd4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2!!", (Object[])new Object[0]);
        this.handle(beforeDetails, afterDetails, template.getId(), account, instanceActivityId);
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }
}

