/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.ZipFileUtils;
import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import com.bizunited.platform.kuiper.starter.repository.FrontFileRepository;
import com.bizunited.platform.kuiper.starter.service.FrontFileSevice;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="FrontFileServiceImpl")
public class FrontFileServiceImpl
implements FrontFileSevice {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontFileServiceImpl.class);
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private FrontFileRepository frontFileRepository;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public FrontFileEntity create(String frontFileEntityStr, String fileContent) {
        FrontFileEntity entity;
        Validate.notBlank((CharSequence)frontFileEntityStr, (String)"\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53json\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileContent, (String)"\u524d\u7aef\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            JSONObject json = JSON.parseObject((String)frontFileEntityStr);
            entity = (FrontFileEntity)JSON.toJavaObject((JSON)json, FrontFileEntity.class);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
        Validate.notNull((Object)entity, (String)"\u524d\u7aef\u6587\u4ef6json\u8f6c\u5316\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getName(), (String)"\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FrontFileEntity existNameEntity = this.frontFileRepository.findByNameAndProjectName(entity.getName(), this.platformContext.getAppName());
        Validate.isTrue((null == existNameEntity ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        this.saveFile(entity, fileContent);
        entity.setCreateTime(new Date());
        entity.setFileStatus(Integer.valueOf(0));
        entity.setProjectName(this.platformContext.getAppName());
        return (FrontFileEntity)this.frontFileRepository.saveAndFlush(entity);
    }

    private FrontFileEntity saveFile(FrontFileEntity entity, String fileContent) {
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String uuid = UUID.randomUUID().toString();
        String fileRename = uuid + ".txt";
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/frontFile/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        byte[] content = fileContent.getBytes(StandardCharsets.UTF_8);
        this.venusFileService.saveFile(relativePath, fileRename, fileRename, content);
        entity.setFilePath(relativePath);
        entity.setFileName(fileRename);
        return entity;
    }

    @Override
    @Transactional
    public FrontFileEntity update(String frontFileEntityStr, String fileContent) {
        FrontFileEntity entity;
        Validate.notBlank((CharSequence)frontFileEntityStr, (String)"\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53json\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileContent, (String)"\u524d\u7aef\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            JSONObject json = JSON.parseObject((String)frontFileEntityStr);
            entity = (FrontFileEntity)JSON.toJavaObject((JSON)json, FrontFileEntity.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        Validate.notNull((Object)entity, (String)"\u524d\u7aef\u6587\u4ef6json\u8f6c\u5316\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getId(), (String)"\u66f4\u65b0\u65f6\uff0c\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.frontFileRepository.findById(entity.getId());
        FrontFileEntity existEntity = op.orElse(null);
        Validate.notNull((Object)existEntity, (String)"\u672a\u6839\u636eID\u627e\u5230\u73b0\u6709\u5b9e\u4f53\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getName(), (String)"\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getFileStatus(), (String)"\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.saveFile(existEntity, fileContent);
        existEntity.setName(entity.getName());
        existEntity.setFileClassify(entity.getFileClassify());
        existEntity.setFileDesc(entity.getFileDesc());
        return (FrontFileEntity)this.frontFileRepository.saveAndFlush(existEntity);
    }

    @Override
    @Transactional
    public FrontFileEntity saveEntity(FrontFileEntity frontFileEntity) {
        Validate.notNull((Object)frontFileEntity, (String)"\u524d\u7aef\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)frontFileEntity.getId()), (String)"\u524d\u7aef\u6587\u4ef6\u65b0\u5efa\u65f6ID\u5fc5\u987b\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)frontFileEntity.getName(), (String)"\u524d\u7aef\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FrontFileEntity existName = this.frontFileRepository.findByNameAndProjectName(frontFileEntity.getName(), this.platformContext.getAppName());
        Validate.isTrue((null == existName ? 1 : 0) != 0, (String)"\u524d\u7aef\u6587\u4ef6\u540d\u4e0d\u80fd\u91cd\u590d\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)frontFileEntity.getFilePath(), (String)"\u524d\u7aef\u6587\u4ef6\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)frontFileEntity.getFileName(), (String)"\u524d\u7aef\u6587\u4ef6\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)frontFileEntity.getFileStatus(), (String)"\u524d\u7aef\u6587\u4ef6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        frontFileEntity.setCreateTime(new Date());
        frontFileEntity.setProjectName(this.platformContext.getAppName());
        return (FrontFileEntity)this.frontFileRepository.saveAndFlush(frontFileEntity);
    }

    @Override
    @Transactional
    public FrontFileEntity updateEntity(FrontFileEntity frontFileEntity) {
        Validate.notNull((Object)frontFileEntity, (String)"\u524d\u7aef\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)frontFileEntity.getId()), (String)"\u66f4\u65b0\u6587\u4ef6\u65b0\u5efa\u65f6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FrontFileEntity existFront = this.frontFileRepository.findById(frontFileEntity.getId()).orElse(null);
        Validate.notNull((Object)existFront, (String)"\u524d\u7aef\u6587\u4ef6\u6839\u636eID\u67e5\u8be2\u4e0d\u5230\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)frontFileEntity.getName(), (String)"\u524d\u7aef\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!StringUtils.equals((CharSequence)frontFileEntity.getName(), (CharSequence)existFront.getName())) {
            FrontFileEntity existName = this.frontFileRepository.findByNameAndProjectName(frontFileEntity.getName(), this.platformContext.getAppName());
            Validate.isTrue((existName == null ? 1 : 0) != 0, (String)"\u4fee\u6539\u540e\u7684\u524d\u7aef\u6587\u4ef6\u540d\u5df2\u91cd\u590d\uff0c\u8bf7\u4fee\u6539", (Object[])new Object[0]);
        }
        existFront.setName(frontFileEntity.getName());
        existFront.setFileClassify(frontFileEntity.getFileClassify());
        existFront.setFileDesc(frontFileEntity.getFileDesc());
        existFront.setFilePath(frontFileEntity.getFilePath());
        existFront.setFileName(frontFileEntity.getFileName());
        existFront.setCreateTime(frontFileEntity.getCreateTime());
        existFront.setFileStatus(frontFileEntity.getFileStatus());
        return (FrontFileEntity)this.frontFileRepository.save(existFront);
    }

    @Override
    @Transactional
    public FrontFileEntity disable(String frontFileId) {
        Validate.notBlank((CharSequence)frontFileId, (String)"\u4f20\u5165\u524d\u7aef\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Optional op = this.frontFileRepository.findById(frontFileId);
        FrontFileEntity entity = op.orElse(null);
        Validate.notNull((Object)entity, (String)"\u67e5\u8be2\u524d\u7aef\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        entity.setFileStatus(Integer.valueOf(1));
        return (FrontFileEntity)this.frontFileRepository.save(entity);
    }

    @Override
    @Transactional
    public FrontFileEntity enable(String frontFileId) {
        Validate.notBlank((CharSequence)frontFileId, (String)"\u4f20\u5165\u524d\u7aef\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.frontFileRepository.findById(frontFileId);
        FrontFileEntity entity = op.orElse(null);
        Validate.notNull((Object)entity, (String)"\u67e5\u8be2\u524d\u7aef\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        entity.setFileStatus(Integer.valueOf(0));
        return (FrontFileEntity)this.frontFileRepository.save(entity);
    }

    @Override
    @Transactional
    public void deleteByName(String frontFileName) {
        FrontFileEntity frontFileEntity = this.frontFileRepository.findByNameAndProjectName(frontFileName, this.platformContext.getAppName());
        if (null == frontFileEntity) {
            return;
        }
        this.frontFileRepository.delete(frontFileEntity);
        this.frontFileRepository.flush();
        this.venusFileService.deleteFile(frontFileEntity.getFilePath(), frontFileEntity.getFileName(), frontFileEntity.getFileName());
    }

    @Override
    public String findContentById(String frontFileId) {
        Validate.notBlank((CharSequence)frontFileId, (String)"\u4f20\u5165\u524d\u7aef\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.frontFileRepository.findById(frontFileId);
        FrontFileEntity entity = op.orElse(null);
        Validate.notNull((Object)entity, (String)"\u67e5\u8be2\u524d\u7aef\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        byte[] content = this.venusFileService.readFileContent(entity.getFilePath(), entity.getFileName());
        return new String(content, StandardCharsets.UTF_8);
    }

    @Override
    public String findContentByName(String frontFileName) {
        Validate.notBlank((CharSequence)frontFileName, (String)"\u4f20\u5165\u524d\u7aef\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FrontFileEntity entity = this.frontFileRepository.findByNameAndProjectName(frontFileName, this.platformContext.getAppName());
        if (null == entity) {
            return null;
        }
        byte[] content = this.venusFileService.readFileContent(entity.getFilePath(), entity.getFileName());
        if (null != content) {
            return new String(content, StandardCharsets.UTF_8);
        }
        return "";
    }

    @Override
    public FrontFileEntity findByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.frontFileRepository.findByNameAndProjectName(name, this.platformContext.getAppName());
    }

    @Override
    public FrontFileEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.frontFileRepository.findById(id).orElse(null);
    }

    @Override
    public Page<FrontFileEntity> queryPage(Pageable pageable, String name, String fileClassify, Integer fileStatus) {
        Validate.notNull((Object)pageable, (String)"\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            conditions.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)fileClassify)) {
            conditions.put("fileClassify", fileClassify);
        }
        if (null != fileStatus) {
            conditions.put("fileStatus", fileStatus);
        }
        return this.frontFileRepository.queryPage(pageable, conditions);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return this.frontFileRepository.countByIds(ids);
    }

    @Override
    public Set<FrontFileEntity> findByIds(String[] frontFileIds) {
        if (ArrayUtils.isEmpty((Object[])frontFileIds)) {
            return Sets.newHashSet();
        }
        return this.frontFileRepository.findByIds(frontFileIds);
    }

    @Override
    public List<FrontFileEntity> findAll() {
        List frontFileEntities = this.frontFileRepository.findAll();
        if (!CollectionUtils.isEmpty((Collection)frontFileEntities)) {
            frontFileEntities = frontFileEntities.stream().filter(frontFileEntity -> StringUtils.equals((CharSequence)frontFileEntity.getProjectName(), (CharSequence)this.platformContext.getAppName())).collect(Collectors.toList());
        }
        return frontFileEntities;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void importData(MigrateImportModel importModel) {
        Validate.notNull((Object)importModel, (String)"\u5bfc\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ZipFile zipFile = importModel.getZipFile();
        Validate.notNull((Object)zipFile, (String)"\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)importModel.getExecuteMode(), (String)"\u6267\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
        ZipEntry frontFile = zipFile.getEntry("frontFile.in");
        if (frontFile == null) {
            importModel.appendLine("\u5bfc\u5165\u538b\u7f29\u5305\u4e2d\u672a\u53d1\u73b0\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        try (InputStream is = zipFile.getInputStream(frontFile);){
            ObjectInputStream ois = new ObjectInputStream(is);
            List frontFiles = (List)ois.readObject();
            for (FrontFileEntity item : frontFiles) {
                ZipEntry scriptFile = ZipFileUtils.getZipEntry((ZipFile)zipFile, (String)item.getFilePath(), (String)item.getFileName());
                InputStream inputStream = zipFile.getInputStream(scriptFile);
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                String content = new String(bytes, StandardCharsets.UTF_8);
                item.setContent(content);
            }
            if (CollectionUtils.isEmpty((Collection)frontFiles)) {
                importModel.appendLine("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
            } else {
                this.importData(frontFiles, importModel);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            importModel.append("\u8bfb\u53d6\u4e1a\u52a1\u6570\u636e\u5931\u8d25\uff1a").append(e.getMessage()).append("<br/>");
        }
    }

    private void importData(List<FrontFileEntity> frontFiles, MigrateImportModel importModel) {
        importModel.setTotalCount(frontFiles.size());
        for (int i = 0; i < frontFiles.size(); ++i) {
            FrontFileEntity frontFile = frontFiles.get(i);
            importModel.appendLine(StringUtils.join((Object[])new Serializable[]{"--------[", Integer.valueOf(i + 1), "]----------"}));
            this.importData(frontFile, importModel);
        }
    }

    private void importData(FrontFileEntity frontFile, MigrateImportModel importModel) {
        importModel.appendLine(String.format("\u5f00\u59cb\u5bfc\u5165\u6570\u636e\uff1a\u6587\u4ef6\u540d\u79f0=%s", frontFile.getName()));
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        FrontFileEntity dbFrontFile = this.frontFileRepository.findByNameAndProjectName(frontFile.getName(), this.platformContext.getAppName());
        frontFile.setId(null);
        if (dbFrontFile != null && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u9875\u9762\u51fd\u6570\u5df2\u5b58\u5728\uff0c\u6267\u884c\u8df3\u8fc7");
            importModel.addSkipCount();
            return;
        }
        if (dbFrontFile != null && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u7f16\u7801\u89c4\u5219\u5df2\u5b58\u5728\uff0c\u8fdb\u884c\u66f4\u65b0\u8986\u76d6");
            this.handleUpdateData(frontFile, dbFrontFile, importModel);
            return;
        }
        if (dbFrontFile == null) {
            this.handleCreateData(frontFile, importModel);
        }
    }

    private void handleCreateData(FrontFileEntity frontFile, MigrateImportModel importModel) {
        importModel.appendLine("\u5bfc\u5165\u9875\u9762\u51fd\u6570");
        importModel.appendLine("\u5f00\u59cb\u65b0\u589e\u9875\u9762\u51fd\u6570");
        String frontFileEntityStr = JSON.toJSONString((Object)frontFile);
        this.create(frontFileEntityStr, frontFile.getContent());
        importModel.addCreateCount();
    }

    private void handleUpdateData(FrontFileEntity frontFile, FrontFileEntity dbFrontFile, MigrateImportModel importModel) {
        frontFile.setId(dbFrontFile.getId());
        String frontFileEntityStr = JSON.toJSONString((Object)frontFile);
        this.update(frontFileEntityStr, frontFile.getContent());
        importModel.appendLine("\u66f4\u65b0\u6210\u529f");
        importModel.addUpdateCount();
    }

    @Override
    public List<FrontFileEntity> findAllByConditions(String name, String fileClassify, Integer fileStatus) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            conditions.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)fileClassify)) {
            conditions.put("fileClassify", fileClassify);
        }
        if (null != fileStatus) {
            conditions.put("fileStatus", fileStatus);
        }
        return this.frontFileRepository.findAllByConditions(conditions);
    }

    @Override
    public FrontFileEntity findByFilePathAndFileName(String filePath, String fileName) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{filePath, fileName})) {
            return null;
        }
        return this.frontFileRepository.findByFilePathAndFileName(filePath, fileName);
    }
}

