/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.starter.repository.InstanceActivityRepository;
import com.bizunited.platform.kuiper.starter.repository.InstanceRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateVisibilityRepository;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="InstanceActivityServiceImpl")
public class InstanceActivityServiceImpl
implements InstanceActivityService {
    @Autowired
    private InstanceActivityRepository instanceActivityRepository;
    @Autowired
    private InstanceRepository instanceRepository;
    @Autowired
    private TemplateVisibilityRepository templateVisibilityRepository;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public InstanceActivityEntity create(InstanceActivityEntity activity, String account) {
        Validate.notNull((Object)activity, (String)"\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6d3b\u52a8\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)activity.getId()), (String)"\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4f20\u5165!!", (Object[])new Object[0]);
        activity.setId(null);
        InstanceEntity currentInstance = activity.getInstance();
        Validate.notNull((Object)currentInstance, (String)"\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u5fc5\u987b\u6709\u76f8\u5173\u7684\u5b9e\u4f8b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String instanceId = currentInstance.getId();
        Validate.notBlank((CharSequence)instanceId, (String)"\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u672a\u53d1\u73b0\u76f8\u5173\u5b9e\u4f8b\u7684\u6570\u636e\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Optional op = this.instanceRepository.findById(instanceId);
        InstanceEntity dbInstance = op.orElse(null);
        Validate.notNull((Object)dbInstance, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355\u5b9e\u4f8b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity dbTemplate = dbInstance.getTemplate();
        Validate.notNull((Object)dbTemplate, (String)"\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u672a\u5728\u6570\u636e\u5e93\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        TemplateVisibilityEntity templateVisibility = activity.getTemplateVisibility();
        Validate.notNull((Object)templateVisibility, (String)"\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u6307\u5b9a\u7684\u6a21\u677f\u53ef\u89c1\u6027\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String templateVisibilityId = templateVisibility.getId();
        Validate.notBlank((CharSequence)templateVisibilityId, (String)"\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u6307\u5b9a\u7684\u6a21\u677f\u53ef\u89c1\u6027\u7684\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Optional opVisibility = this.templateVisibilityRepository.findById(templateVisibilityId);
        TemplateVisibilityEntity dbTemplateVisibility = opVisibility.orElse(null);
        Validate.notNull((Object)dbTemplateVisibility, (String)"\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u6307\u5b9a\u7684\u6a21\u677f\u53ef\u89c1\u6027\u672a\u5728\u6570\u636e\u5e93\u4e2d\u53d1\u73b0!!", (Object[])new Object[0]);
        TemplateVisibilityEntity currentTemplateVisibility = this.templateVisibilityRepository.findByTemplateIdAndVisibilityName(dbTemplate.getId(), dbTemplateVisibility.getVisibilityName());
        Validate.notNull((Object)currentTemplateVisibility, (String)"\u521b\u5efa\u6d3b\u52a8\u6307\u5b9a\u7684\u6d3b\u52a8\u4e0d\u5c5e\u4e8e\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\uff0c\u8bf7\u68c0\u6d4b!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String visibilityName = dbTemplateVisibility.getVisibilityName();
        Validate.notBlank((CharSequence)visibilityName, (String)"\u6307\u5b9a\u7684\u6d3b\u52a8\u53ef\u89c1\u6027\u7684\u540d\u79f0\u5fc5\u987b\u6709\u503c!!", (Object[])new Object[0]);
        InstanceActivityEntity previousActivity = null;
        if (activity.getPreviousActivity() == null) {
            Object[][] results = this.instanceActivityRepository.findByInstanceIdAndMaxCreateTime(instanceId);
            if (results != null && results.length > 0) {
                String maxActivityId = results[0][0].toString();
                Optional opActivity = this.instanceActivityRepository.findById(maxActivityId);
                previousActivity = opActivity.orElse(null);
            }
        } else {
            String previousInstanceActivityId = activity.getPreviousActivity().getId();
            Validate.notBlank((CharSequence)previousInstanceActivityId, (String)"\u6307\u5b9a\u7684\u524d\u5e8f\u6d3b\u52a8\u5fc5\u987b\u6307\u5b9a\u6d3b\u52a8\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
            Optional optional = this.instanceActivityRepository.findById(previousInstanceActivityId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u524d\u5e8f\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        if (previousActivity != null) {
            Validate.isTrue((!StringUtils.equals((CharSequence)visibilityName, (CharSequence)"create") ? 1 : 0) != 0, (String)"\u5f53\u524d\u6d3b\u52a8\u5b58\u5728\u524d\u9a71\u6d3b\u52a8\uff0c\u4e0d\u80fd\u4f7f\u7528create\u53ef\u89c1\u6027\u8fdb\u884c\u6d3b\u52a8\u521b\u5efa!!", (Object[])new Object[0]);
        }
        Date time = new Date();
        activity.setCreateTime(time);
        activity.setCreator(account);
        activity.setModifyer(account);
        activity.setModifyTime(time);
        InstanceActivityEntity currentActivity = null;
        if (previousActivity != null) {
            currentActivity = new InstanceActivityEntity();
            currentActivity.setCreateTime(previousActivity.getCreateTime());
            currentActivity.setCreator(previousActivity.getCreator());
            currentActivity.setId(previousActivity.getId());
            currentActivity.setModifyer(previousActivity.getModifyer());
            currentActivity.setModifyTime(previousActivity.getModifyTime());
        }
        activity.setPreviousActivity(currentActivity);
        activity.setTemplate(dbTemplate);
        activity.setTemplateVisibility(dbTemplateVisibility);
        if (StringUtils.isBlank((CharSequence)activity.getTaskCode())) {
            activity.setTaskCode(UUID.randomUUID().toString());
        }
        activity.setProjectName(this.platformContext.getAppName());
        this.instanceActivityRepository.save(activity);
        return activity;
    }

    @Override
    @Transactional
    public InstanceActivityEntity create(String taskCode, String instanceId, String visibilityName, String account) {
        if ("create".equals(visibilityName)) {
            if (StringUtils.isBlank((CharSequence)instanceId)) {
                return null;
            }
            Set<InstanceActivityEntity> activities = this.instanceActivityRepository.findDetailsByInstanceIdAndVisibility(instanceId, visibilityName);
            if (CollectionUtils.isEmpty(activities)) {
                return null;
            }
            return activities.iterator().next();
        }
        Validate.notBlank((CharSequence)taskCode, (String)"\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7684\u552f\u4e00\u6d3b\u52a8\u8bc6\u522b\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        InstanceActivityEntity instanceActivity = this.instanceActivityRepository.findDetailsByTaskCode(taskCode);
        if (instanceActivity != null) {
            return instanceActivity;
        }
        Validate.notBlank((CharSequence)instanceId, (String)"\u5728\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u5b9e\u4f8b\u7f16\u53f7\u540d\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visibilityName, (String)"\u5728\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u53ef\u89c1\u6027\u540d\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Optional op = this.instanceRepository.findById(instanceId);
        InstanceEntity instance = op.orElse(null);
        Validate.notNull((Object)instance, (String)"\u5728\u521b\u5efa\u6d3b\u52a8\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355\u5b9e\u4f8b\u4fe1\u606f!!", (Object[])new Object[0]);
        TemplateEntity currentTemplate = instance.getTemplate();
        Validate.isTrue((!StringUtils.equals((CharSequence)visibilityName, (CharSequence)"create") ? 1 : 0) != 0, (String)"\u540d\u4e3acreate\u7684\u53ef\u89c1\u6027\u4e0d\u5141\u8bb8\u72ec\u7acb\u521b\u5efa\u4e3a\u4e00\u4e2a\u6d3b\u52a8\u5b9e\u4f8b", (Object[])new Object[0]);
        TemplateVisibilityEntity currentTemplateVisibility = this.templateVisibilityRepository.findByTemplateIdAndVisibilityName(currentTemplate.getId(), visibilityName);
        Validate.notNull((Object)currentTemplateVisibility, (String)"\u5728\u6307\u5b9a\u7684\u8868\u5355\u5b9e\u4f8b\u4e0b\u672a\u627e\u5230\u6307\u5b9a\u7684\u53ef\u89c1\u6027\u4fe1\u606f,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        InstanceActivityEntity currentActivity = new InstanceActivityEntity();
        currentActivity.setInstance(instance);
        currentActivity.setTemplateVisibility(currentTemplateVisibility);
        currentActivity.setTaskCode(taskCode);
        return this.create(currentActivity, account);
    }

    @Override
    @Transactional
    public InstanceActivityEntity updateModifyer(String activityId, String account) {
        Validate.notBlank((CharSequence)activityId, (String)"\u4fee\u6539\u6d3b\u52a8\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Optional op = this.instanceActivityRepository.findById(activityId);
        InstanceActivityEntity activity = op.orElse(null);
        Validate.notNull((Object)activity, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6d3b\u52a8\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u7528\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        activity.setModifyer(account);
        activity.setModifyTime(new Date());
        this.instanceActivityRepository.save(activity);
        return activity;
    }

    @Override
    @Transactional
    public void updateTemplate(List<InstanceActivityEntity> activities, TemplateEntity template) {
        Validate.notNull(activities, (String)"\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)template, (String)"\u6a21\u677f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)template.getCode(), (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)template.getId(), (String)"\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        for (InstanceActivityEntity activity : activities) {
            TemplateVisibilityEntity visibility = activity.getTemplateVisibility();
            TemplateVisibilityEntity newVisibility = this.templateVisibilityRepository.findByTemplateIdAndVisibilityName(template.getId(), visibility.getVisibilityName());
            Validate.notNull((Object)newVisibility, (String)"\u672a\u627e\u5230\u6a21\u7248[%s]\u53ef\u89c1\u6027\uff1a%s", (Object[])new Object[]{template.getCode(), visibility.getVisibilityName()});
            activity.setTemplate(template);
            activity.setTemplateVisibility(newVisibility);
            activity.setProjectName(this.platformContext.getAppName());
            this.instanceActivityRepository.save(activity);
        }
    }

    @Override
    public Set<InstanceActivityEntity> findDetailsByInstanceId(String instanceId) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return Sets.newHashSet();
        }
        Set<InstanceActivityEntity> instanceActivities = this.instanceActivityRepository.findDetailsByInstanceId(instanceId);
        if (instanceActivities != null && !instanceActivities.isEmpty()) {
            instanceActivities.forEach(instanceActivityItem -> {
                InstanceActivityEntity previous = instanceActivityItem.getPreviousActivity();
                if (previous != null) {
                    InstanceActivityEntity currentActivity = new InstanceActivityEntity();
                    currentActivity.setCreateTime(previous.getCreateTime());
                    currentActivity.setCreator(previous.getCreator());
                    currentActivity.setId(previous.getId());
                    currentActivity.setModifyer(previous.getModifyer());
                    currentActivity.setModifyTime(previous.getModifyTime());
                    instanceActivityItem.setPreviousActivity(currentActivity);
                } else {
                    instanceActivityItem.setPreviousActivity(null);
                }
            });
        }
        return instanceActivities;
    }

    @Override
    public Set<InstanceActivityEntity> findByInstanceId(String instanceId) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return Sets.newHashSet();
        }
        return this.instanceActivityRepository.findByInstanceId(instanceId);
    }

    @Override
    public InstanceActivityEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.instanceActivityRepository.findDetailsById(id);
    }

    @Override
    public InstanceActivityEntity findById(String id) {
        Optional op = this.instanceActivityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public InstanceActivityEntity findByTaskCode(String taskCode) {
        if (StringUtils.isBlank((CharSequence)taskCode)) {
            return null;
        }
        return this.instanceActivityRepository.findByTaskCode(taskCode);
    }

    @Override
    public InstanceActivityEntity findByInstanceIdAndTaskCode(String instanceId, String taskCode) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)taskCode)) {
            return null;
        }
        return this.instanceActivityRepository.findByInstanceIdAndTaskCode(instanceId, taskCode);
    }

    @Override
    public Set<InstanceActivityEntity> findByInstanceIdAndVisibility(String instanceId, String visibility) {
        if (StringUtils.isBlank((CharSequence)instanceId) || StringUtils.isBlank((CharSequence)visibility)) {
            return Sets.newHashSet();
        }
        return this.instanceActivityRepository.findByInstanceIdAndVisibility(instanceId, visibility);
    }

    @Override
    public String findIdByMaxCreateTime(String instanceId) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return null;
        }
        Object[][] results = this.instanceActivityRepository.findByInstanceIdAndMaxCreateTime(instanceId);
        if (results == null || results.length == 0) {
            return null;
        }
        return results[0][0].toString();
    }
}

