/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.entity.InstanceViewEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.service.InstanceService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.InstanceRepository;
import com.bizunited.platform.kuiper.starter.repository.internal.InstanceViewRepositoryCustom;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="InstanceServiceImpl")
public class InstanceServiceImpl
implements InstanceService {
    @Autowired
    private InstanceRepository instanceRepository;
    @Autowired
    private InstanceViewRepositoryCustom instanceViewRepositoryCustom;
    @Autowired
    private UserService userService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;
    @Autowired
    private TemplateLayoutService templateLayoutService;
    @Autowired
    private InstanceActivityService instanceActivityService;
    @Autowired
    private ServicableMethodService servicableMethodService;
    @Autowired
    private PlatformContext platformContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceServiceImpl.class);

    @Transactional
    public InstanceEntity createByTemplateId(String templateId, String taskCode, String account) {
        Validate.notBlank((CharSequence)account, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u7528\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u53d1\u73b0\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity currentTemplate = this.templateService.findById(templateId);
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u8bbe\u5b9a\u7684\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        return this.createInstance(templateId, taskCode, account);
    }

    @Transactional
    public InstanceEntity createByTemplateCode(String templateCode, String cversion, String taskCode, String account) {
        Validate.notBlank((CharSequence)templateCode, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cversion, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u677f\u4e1a\u52a1\u7248\u672c\u53f7", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u7528\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u53d1\u73b0\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity template = this.templateService.findByCodeAndCversion(templateCode, cversion);
        Validate.notNull((Object)template, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u7248", (Object[])new Object[0]);
        return this.createInstance(template.getId(), taskCode, account);
    }

    @Transactional
    public InstanceEntity createByTemplateCode(String templateCode, String taskCode, String account) {
        Validate.notBlank((CharSequence)templateCode, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        List templates = this.templateService.findByCode(templateCode);
        Validate.notEmpty((Collection)templates, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7\u7684\u4efb\u4f55\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u7528\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u53d1\u73b0\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (templates.size() == 1) {
            return this.createInstance(((TemplateEntity)templates.get(0)).getId(), taskCode, account);
        }
        TemplateEntity currentTemplate = templates.stream().filter(TemplateEntity::getDefaultVersion).findFirst().orElse(null);
        if (currentTemplate == null) {
            currentTemplate = templates.stream().sorted(Comparator.comparing(TemplateEntity::getCreateTime).reversed()).findFirst().orElse(null);
        }
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return this.createInstance(currentTemplate.getId(), taskCode, account);
    }

    private InstanceEntity createInstance(String currentTemplateId, String taskCode, String account) {
        Validate.notBlank((CharSequence)currentTemplateId, (String)"\u672a\u627e\u8bbe\u5b9a\u7684\u6a21\u677f\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        TemplateEntity currentTemplate = this.templateService.findById(currentTemplateId);
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u6a21\u677fid\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        JSONObject templateLayout = this.templateLayoutService.findDetailsByTemplateId(currentTemplateId, 1);
        Validate.notNull((Object)templateLayout, (String)"\u5f53\u524d\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\uff0c\u8fd8\u672a\u786e\u8ba4\u5e03\u5c40\u4fe1\u606f\uff0c\u65e0\u6cd5\u521b\u5efa\u5b9e\u4f8b\u3002\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((currentTemplate.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u6a21\u677f\u7684\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff08\u6a21\u677f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7981\u7528\uff09!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u521b\u5efa\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u53d1\u73b0\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Date currentTime = new Date();
        InstanceEntity currentInstance = new InstanceEntity();
        currentInstance.setCreateTime(currentTime);
        currentInstance.setCreator(account);
        currentInstance.setDomain(currentTemplate.getDomain());
        currentInstance.setProjectName(currentTemplate.getProjectName());
        currentInstance.setTemplate(currentTemplate);
        currentInstance.setProjectName(this.platformContext.getAppName());
        this.instanceRepository.save(currentInstance);
        TemplateVisibilityEntity visibility = this.templateVisibilityService.findByTemplateIdAndVisibilityName(currentTemplate.getId(), "create");
        Validate.notNull((Object)visibility, (String)"\u8868\u5355\u5b9e\u4f8b\u53c2\u8003\u7684\u6a21\u677f\u4e0b\uff0c\u6ca1\u6709\u540d\u79f0\u4e3a\u201ccreate\u201d\u7684\u53ef\u89c1\u6027\u914d\u7f6e(\u6d3b\u52a8)\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        InstanceActivityEntity activity = new InstanceActivityEntity();
        activity.setInstance(currentInstance);
        activity.setCreateTime(currentTime);
        activity.setCreator(user.getAccount());
        activity.setModifyer(user.getAccount());
        activity.setModifyTime(currentTime);
        activity.setPreviousActivity(null);
        activity.setTemplate(currentTemplate);
        activity.setTemplateVisibility(visibility);
        if (!StringUtils.isBlank((CharSequence)taskCode)) {
            activity.setTaskCode(taskCode);
        }
        this.instanceActivityService.create(activity, account);
        currentInstance.setActivities(Arrays.asList(activity));
        return currentInstance;
    }

    @Transactional
    public InstanceEntity createByTemplateCode(String templateCode, String taskCode, String account, String serviceName, JSONObject formData, Map<String, Object> params) {
        Validate.notNull((Object)formData, (String)"\u4f20\u5165\u7684\u8868\u5355\u6570\u636e\u4e0d\u53ef\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateCode, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        TemplateEntity template = this.templateService.findByDefaultVersion(templateCode);
        Validate.notNull((Object)template, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7\u7684\u9ed8\u8ba4\u6a21\u677f\u4fe1\u606f\uff0c\u6700\u53ef\u80fd\u7684\u60c5\u51b5\u662f\u6ca1\u6709\u8bbe\u5b9a\u9ed8\u8ba4\u6a21\u677f!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account, (String)"\u521b\u5efa\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u53d1\u73b0\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)serviceName, (String)"\u670d\u52a1\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ServicableMethodInfo servicableMethodInfo = this.servicableMethodService.findDetailsByName(serviceName);
        Validate.notNull((Object)servicableMethodInfo, (String)"\u6839\u636e\u670d\u52a1\u540d%s\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u670d\u52a1\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{serviceName});
        InstanceEntity currentInstance = this.createInstance(template.getCode(), taskCode, account);
        String currentInstanceId = currentInstance.getId();
        List activities = currentInstance.getActivities();
        Validate.notNull((Object)activities, (String)"\u6ca1\u6709\u6210\u529f\u521b\u5efa\u8868\u5355\u6d3b\u52a8\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((activities.size() == 1 ? 1 : 0) != 0, (String)"\u672a\u77e5\u7684\u5b9e\u4f8b\u521d\u59cb\u5316\u9519\u8bef\uff08\u521b\u5efa\u4e86\u591a\u4e2a\u6d3b\u52a8\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        InstanceActivityEntity currentActivity = (InstanceActivityEntity)activities.get(0);
        String currentActivityId = currentActivity.getId();
        TemplateEntity currentTemplate = currentInstance.getTemplate();
        Validate.notNull((Object)currentTemplate, (String)"\u9519\u8bef\u7684\u521b\u5efa\u8fc7\u7a0b\uff0c\u672a\u53d1\u73b0\u5173\u8054\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        String templateId = currentTemplate.getId();
        Validate.notBlank((CharSequence)templateId, (String)"\u9519\u8bef\u7684\u521b\u5efa\u8fc7\u7a0b\uff0c\u672a\u53d1\u73b0\u5173\u8054\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        String templateType = currentTemplate.getType();
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)templateType, (CharSequence)"static"), (String)"\u9519\u8bef\u7684\u6a21\u677f\u7c7b\u578b[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateType});
        InvokeParams invokeParams = new InvokeParams();
        if (params != null) {
            invokeParams.putInvokeParams(params);
        }
        invokeParams.putInvokeParam("opType", (Object)"create");
        invokeParams.putInvokeParam("instanceActivityId", (Object)currentActivityId);
        invokeParams.putInvokeParam("instanceId", (Object)currentInstanceId);
        if (formData != null) {
            invokeParams.setJsonData(formData);
        }
        try {
            this.servicableMethodService.invoke(serviceName, null, invokeParams);
        }
        catch (InvokeProxyException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return currentInstance;
    }

    @Transactional
    public void updateTemplate(TemplateEntity template) {
        Validate.notNull((Object)template, (String)"\u6a21\u677f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)template.getCode(), (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)template.getId(), (String)"\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        Set<InstanceEntity> instances = this.instanceRepository.findByTemplateCode(template.getCode());
        if (CollectionUtils.isEmpty(instances)) {
            return;
        }
        for (InstanceEntity instance : instances) {
            instance.setTemplate(template);
            List activities = instance.getActivities();
            if (!CollectionUtils.isEmpty((Collection)activities)) {
                this.instanceActivityService.updateTemplate(activities, template);
            }
            this.instanceRepository.save(instance);
        }
    }

    public InstanceEntity findDetailsById(String instanceId) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return null;
        }
        return this.instanceRepository.findDetailsById(instanceId);
    }

    public Page<InstanceViewEntity> findByConditions(String code, String instanceId, String cversion, String domain, String templateName, String projectName, Date beginCreateTime, Date endCreateTime, String userName, Pageable pageable) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        conditions.put("projectName", this.platformContext.getAppName());
        if (StringUtils.isNotBlank((CharSequence)code)) {
            conditions.put("code", code);
        }
        if (StringUtils.isNotBlank((CharSequence)instanceId)) {
            conditions.put("instanceId", instanceId);
        }
        if (StringUtils.isNotBlank((CharSequence)cversion)) {
            conditions.put("cversion", cversion);
        }
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            conditions.put("domain", domain);
        }
        if (StringUtils.isNotBlank((CharSequence)templateName)) {
            conditions.put("templateName", templateName);
        }
        if (beginCreateTime != null) {
            conditions.put("beginCreateTime", beginCreateTime);
        }
        if (endCreateTime != null) {
            conditions.put("endCreateTime", endCreateTime);
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            conditions.put("userName", userName);
        }
        conditions.put("projectName", this.platformContext.getAppName());
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.instanceViewRepositoryCustom.queryPage(pageable, conditions);
    }

    public InstanceEntity findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4f20\u5165\u7684\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Optional op = this.instanceRepository.findById(id);
        return op.orElse(null);
    }

    public Page<InstanceEntity> findByTemplateId(String templateId, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        return this.instanceRepository.findByTemplateId(templateId, pageable);
    }

    public int countByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return 0;
        }
        return this.instanceRepository.countByTemplateId(templateId);
    }
}

