/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.PageEntity;
import com.bizunited.platform.kuiper.entity.PageEventEntity;
import com.bizunited.platform.kuiper.starter.repository.PageEventRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.PageEventService;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="PageEventServiceImpl")
public class PageEventServiceImpl
implements PageEventService {
    @Autowired
    private PageEventRepository pageEventRepository;
    @Autowired
    private VenusFileService kuiperFileService;
    @Autowired
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public Set<PageEventEntity> save(PageEntity page, Set<PageEventEntity> events) {
        this.saveValidation(page, events);
        Set<PageEventEntity> oldEvents = this.pageEventRepository.findByPageId(page.getId());
        if (CollectionUtils.isEmpty(events)) {
            this.deleteByPageId(page.getId());
            return Sets.newHashSet();
        }
        if (CollectionUtils.isEmpty(oldEvents)) {
            return this.create(page, events);
        }
        HashSet<PageEventEntity> createEvents = new HashSet<PageEventEntity>();
        HashSet<PageEventEntity> updateEvents = new HashSet<PageEventEntity>();
        HashSet<PageEventEntity> deleteEvents = new HashSet<PageEventEntity>();
        this.kuiperToolkitService.collectionDiscrepancy(events, oldEvents, PageEventEntity::getEventId, deleteEvents, updateEvents, createEvents);
        this.create(page, createEvents);
        this.update(updateEvents, events);
        this.delete(deleteEvents);
        createEvents.addAll(updateEvents);
        return createEvents;
    }

    @Override
    public Set<PageEventEntity> findByPageId(String pageId) {
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return Sets.newHashSet();
        }
        return this.pageEventRepository.findByPageId(pageId);
    }

    @Override
    public Set<PageEventEntity> findDetailsByPageId(String pageId) {
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return Sets.newHashSet();
        }
        Set<PageEventEntity> events = this.pageEventRepository.findByPageId(pageId);
        this.loadEventContent(events);
        return events;
    }

    @Override
    public PageEventEntity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PageEventEntity event = this.pageEventRepository.findById(id).orElse(null);
        if (event != null) {
            this.loadEventContent(event);
        }
        return event;
    }

    @Override
    public PageEventEntity findDetailByPageFlowCodeAndPageCodeAndEventId(String pageFlowCode, String pageCode, String eventId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{pageFlowCode, pageCode, eventId})) {
            return null;
        }
        PageEventEntity event = this.pageEventRepository.findDetailByPageFlowCodeAndPageCodeAndEventId(pageFlowCode, pageCode, eventId);
        if (event != null) {
            this.loadEventContent(event);
        }
        return event;
    }

    @Override
    @Transactional
    public void deleteByPageId(String pageId) {
        Validate.notBlank((CharSequence)pageId, (String)"\u4e8b\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Set<PageEventEntity> events = this.pageEventRepository.findByPageId(pageId);
        this.delete(events);
    }

    private void delete(Set<PageEventEntity> events) {
        if (!CollectionUtils.isEmpty(events)) {
            for (PageEventEntity event : events) {
                this.kuiperFileService.deleteFile(event.getRelativePath(), event.getFileName(), event.getFileName());
                this.pageEventRepository.delete(event);
            }
        }
    }

    private Set<PageEventEntity> update(Set<PageEventEntity> events, Set<PageEventEntity> updateEvents) {
        if (CollectionUtils.isEmpty(events)) {
            return Sets.newHashSet();
        }
        Map<String, PageEventEntity> updateEventMap = updateEvents.stream().collect(Collectors.toMap(PageEventEntity::getEventId, e -> e));
        for (PageEventEntity event : events) {
            PageEventEntity updateEvent = updateEventMap.get(event.getEventId());
            this.loadEventContent(event);
            if (updateEvent.getEventContent().equals(event.getEventContent())) continue;
            event.setEventContent(updateEvent.getEventContent());
            this.saveFile(event);
        }
        return events;
    }

    private Set<PageEventEntity> loadEventContent(Set<PageEventEntity> events) {
        if (CollectionUtils.isEmpty(events)) {
            return events;
        }
        for (PageEventEntity event : events) {
            this.loadEventContent(event);
        }
        return events;
    }

    private PageEventEntity loadEventContent(PageEventEntity event) {
        byte[] bytes = this.kuiperFileService.readFileContent(event.getRelativePath(), event.getFileName());
        if (bytes != null) {
            String content = new String(bytes, StandardCharsets.UTF_8);
            event.setEventContent(content);
        }
        return event;
    }

    private Set<PageEventEntity> create(PageEntity page, Set<PageEventEntity> events) {
        if (CollectionUtils.isEmpty(events)) {
            return Sets.newHashSet();
        }
        for (PageEventEntity event : events) {
            event.setPage(page);
            this.saveFile(event);
            event.setProjectName(this.platformContext.getAppName());
            this.pageEventRepository.save(event);
        }
        return events;
    }

    private PageEventEntity saveFile(PageEventEntity event) {
        if (StringUtils.isBlank((CharSequence)event.getId())) {
            String folderName = new SimpleDateFormat("yyyyMMdd").format(new Date());
            String rename = UUID.randomUUID().toString();
            String fileRename = StringUtils.join((Object[])new String[]{rename, ".", "js"});
            String relativePath = StringUtils.join((Object[])new Serializable[]{"/page/event/", folderName, "/", Integer.valueOf(new Random().nextInt(10))});
            event.setRelativePath(relativePath);
            event.setFileName(fileRename);
        }
        byte[] content = event.getEventContent().getBytes(StandardCharsets.UTF_8);
        this.kuiperFileService.saveFile(event.getRelativePath(), event.getFileName(), event.getFileName(), content);
        return event;
    }

    private void saveValidation(PageEntity page, Set<PageEventEntity> events) {
        Validate.notNull((Object)page, (String)"\u9875\u9762\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)page.getId(), (String)"\u9875\u9762\u5bf9\u8c61\u7684ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(events)) {
            return;
        }
        HashSet<String> eventIds = new HashSet<String>();
        for (PageEventEntity event : events) {
            Validate.notBlank((CharSequence)event.getEventId(), (String)"\u4e8b\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)eventIds.add(event.getEventId()), (String)"\u4e8b\u4ef6ID\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            Validate.notNull((Object)event.getEventContent(), (String)"\u4e8b\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

