/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.ZipFileUtils;
import com.bizunited.platform.kuiper.entity.PageEntity;
import com.bizunited.platform.kuiper.entity.PageEventEntity;
import com.bizunited.platform.kuiper.entity.PageFlowEntity;
import com.bizunited.platform.kuiper.starter.repository.PageFlowRepository;
import com.bizunited.platform.kuiper.starter.service.PageFlowService;
import com.bizunited.platform.kuiper.starter.service.PageService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="PageFlowServiceImpl")
public class PageFlowServiceImpl
implements PageFlowService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageFlowServiceImpl.class);
    private static final String JSON_FILE_SUFFIX = "json";
    private static final String SAVE_LOCATION = "/pageFlow/json/";
    @Autowired
    private PageFlowRepository pageFlowRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private VenusFileService kuiperFileService;
    @Autowired
    private PageService pageService;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public PageFlowEntity create(PageFlowEntity pageFlowEntity, Principal principal) {
        this.createValidation(pageFlowEntity, principal);
        UserVo user = SecurityUtils.getCurrentUser();
        Date nowDate = new Date();
        pageFlowEntity.setCreateTime(nowDate);
        pageFlowEntity.setModifyTime(nowDate);
        pageFlowEntity.setCreateUser(user);
        pageFlowEntity.setModifyUser(user);
        pageFlowEntity.setCreator(user.getAccount());
        pageFlowEntity.setModifier(user.getAccount());
        pageFlowEntity.setProjectName(this.platformContext.getAppName());
        this.saveFile(pageFlowEntity);
        this.pageFlowRepository.saveAndFlush(pageFlowEntity);
        if (!CollectionUtils.isEmpty((Collection)pageFlowEntity.getPages())) {
            this.pageService.save(pageFlowEntity, pageFlowEntity.getPages());
        }
        return pageFlowEntity;
    }

    @Override
    @Transactional
    public PageFlowEntity update(PageFlowEntity pageFlowEntity, Principal principal) {
        this.updateValidation(pageFlowEntity, principal);
        UserVo user = SecurityUtils.getCurrentUser();
        PageFlowEntity updatePageFlow = this.findDetailsById(pageFlowEntity.getId());
        Validate.notNull((Object)updatePageFlow, (String)"\u5f53\u524d\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        updatePageFlow.setModifyTime(new Date());
        updatePageFlow.setModifyUser(user);
        updatePageFlow.setModifier(user.getAccount());
        updatePageFlow.setName(pageFlowEntity.getName());
        if (StringUtils.isNotBlank((CharSequence)pageFlowEntity.getComment())) {
            updatePageFlow.setComment(pageFlowEntity.getComment());
        }
        updatePageFlow.setPageCount(pageFlowEntity.getPageCount());
        updatePageFlow.setLineCount(pageFlowEntity.getLineCount());
        if (!pageFlowEntity.getPageFlowContent().equals(updatePageFlow.getPageFlowContent())) {
            updatePageFlow.setPageFlowContent(pageFlowEntity.getPageFlowContent());
            byte[] pageFlowContent = pageFlowEntity.getPageFlowContent().getBytes(StandardCharsets.UTF_8);
            String fileName = updatePageFlow.getFileName();
            this.kuiperFileService.saveFile(updatePageFlow.getRelativePath(), fileName, fileName, pageFlowContent);
        }
        this.pageFlowRepository.saveAndFlush(updatePageFlow);
        this.pageService.save(pageFlowEntity, pageFlowEntity.getPages());
        return updatePageFlow;
    }

    private void saveFile(PageFlowEntity pageFlow) {
        String folderName = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String renameImage = UUID.randomUUID().toString();
        String fileRename = renameImage + "." + JSON_FILE_SUFFIX;
        String relativePath = StringUtils.join((Object[])new Serializable[]{SAVE_LOCATION, folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        byte[] pageFlowContent = pageFlow.getPageFlowContent().getBytes(StandardCharsets.UTF_8);
        pageFlow.setFileName(fileRename);
        pageFlow.setRelativePath(relativePath);
        this.kuiperFileService.saveFile(relativePath, fileRename, fileRename, pageFlowContent);
    }

    @Override
    public PageFlowEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PageFlowEntity pageFlow = this.pageFlowRepository.findDetailsById(id);
        return this.loadDetails(pageFlow);
    }

    @Override
    public PageFlowEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.pageFlowRepository.findById(id).orElse(null);
    }

    @Override
    public PageFlowEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.pageFlowRepository.findByCode(code);
    }

    @Override
    public PageFlowEntity findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        PageFlowEntity entity = this.pageFlowRepository.findDetailsByCode(code);
        return this.loadDetails(entity);
    }

    @Override
    public Page<PageFlowEntity> findByConditions(PageFlowEntity pageFlow, Pageable pageable) {
        return this.pageFlowRepository.findByConditions(pageFlow, pageable);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        PageFlowEntity pageFlow = this.pageFlowRepository.findById(id).orElse(null);
        if (null != pageFlow) {
            this.pageService.deleteByPageFlowId(id);
            this.pageFlowRepository.delete(pageFlow);
            this.kuiperFileService.deleteFile(pageFlow.getRelativePath(), pageFlow.getFileName(), pageFlow.getFileName());
        }
    }

    @Override
    public List<PageFlowEntity> findAll() {
        return this.pageFlowRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
    }

    @Override
    public long countByIds(String[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return 0L;
        }
        return this.pageFlowRepository.countByIds(ids);
    }

    @Override
    public List<PageFlowEntity> findDetailsByIds(String[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return Lists.newArrayList();
        }
        return this.pageFlowRepository.findDetailsByids(ids);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void importData(MigrateImportModel importModel) {
        Validate.notNull((Object)importModel, (String)"\u5bfc\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ZipFile zipFile = importModel.getZipFile();
        Validate.notNull((Object)zipFile, (String)"\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)importModel.getExecuteMode(), (String)"\u6267\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
        ZipEntry templateEntry = zipFile.getEntry("pageFlow.in");
        if (templateEntry == null) {
            importModel.appendLine("\u5bfc\u5165\u538b\u7f29\u5305\u4e2d\u672a\u53d1\u73b0\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        try (InputStream is = zipFile.getInputStream(templateEntry);
             ObjectInputStream ois = new ObjectInputStream(is);){
            List pageFlows = (List)ois.readObject();
            if (CollectionUtils.isEmpty((Collection)pageFlows)) {
                importModel.appendLine("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
                return;
            }
            this.importData(pageFlows, importModel);
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            importModel.append("\u8bfb\u53d6\u6a21\u7248\u6570\u636e\u5931\u8d25\uff1a").appendLine(e.getMessage());
        }
    }

    private void importData(List<PageFlowEntity> pageFlows, MigrateImportModel importModel) {
        importModel.setTotalCount(pageFlows.size());
        for (int i = 0; i < pageFlows.size(); ++i) {
            PageFlowEntity pageFlow = pageFlows.get(i);
            importModel.appendLine(StringUtils.join((Object[])new Serializable[]{"--------[", Integer.valueOf(i + 1), "]----------"}));
            this.importData(pageFlow, importModel);
        }
    }

    private void importData(PageFlowEntity pageFlow, MigrateImportModel importModel) {
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u9875\u9762\u6d41\uff1aname=%s,code=%s", new Object[]{pageFlow.getName(), pageFlow.getCode()});
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        PageFlowEntity dbPageFlow = this.pageFlowRepository.findByCode(pageFlow.getCode());
        if (dbPageFlow != null && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u9875\u9762\u6d41\u6570\u636e\u5df2\u5b58\u5728\uff0c\u6267\u884c\u8df3\u8fc7");
            importModel.addSkipCount();
            return;
        }
        if (dbPageFlow != null && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u9875\u9762\u6d41\u6570\u636e\u5df2\u5b58\u5728\uff0c\u6267\u884c\u66f4\u65b0\u5bfc\u5165");
            this.handleUpdateData(pageFlow, dbPageFlow, importModel);
            return;
        }
        if (dbPageFlow != null && ImportExecuteModeEnum.ADD == executeMode) {
            importModel.appendLine("\u4e0d\u652f\u6301\u7684\u6267\u884c\u6a21\u5f0f");
            importModel.addSkipCount();
            return;
        }
        if (dbPageFlow == null) {
            this.handleCreateData(pageFlow, importModel);
            return;
        }
    }

    private void handleCreateData(PageFlowEntity pageFlow, MigrateImportModel importModel) {
        importModel.appendLine("\u5bfc\u5165\u65b0\u589e\u6570\u636e");
        this.handleImportDataId(pageFlow);
        this.loadFileContentFromZip(pageFlow, importModel);
        this.create(pageFlow, SecurityUtils.getPrincipal());
        importModel.addCreateCount();
    }

    private void handleUpdateData(PageFlowEntity pageFlow, PageFlowEntity dbPageFlow, MigrateImportModel importModel) {
        this.handleImportDataId(pageFlow);
        pageFlow.setId(dbPageFlow.getId());
        this.loadFileContentFromZip(pageFlow, importModel);
        this.update(pageFlow, SecurityUtils.getPrincipal());
        importModel.addUpdateCount();
        importModel.appendLine("\u66f4\u65b0\u6570\u636e\u6210\u529f");
    }

    private PageFlowEntity loadFileContentFromZip(PageFlowEntity pageFlow, MigrateImportModel importModel) {
        ZipFile zipFile = importModel.getZipFile();
        byte[] bytes = this.getBytesFromZip(zipFile, pageFlow.getRelativePath(), pageFlow.getFileName());
        pageFlow.setPageFlowContent(new String(bytes, StandardCharsets.UTF_8));
        Set pages = pageFlow.getPages();
        if (CollectionUtils.isEmpty((Collection)pages)) {
            return pageFlow;
        }
        for (PageEntity page : pages) {
            byte[] pageBytes = this.getBytesFromZip(zipFile, page.getRelativePath(), page.getFileName());
            page.setPageContent(new String(pageBytes, StandardCharsets.UTF_8));
            Set events = page.getEvents();
            if (CollectionUtils.isEmpty((Collection)events)) continue;
            for (PageEventEntity event : events) {
                byte[] eventBytes = this.getBytesFromZip(zipFile, event.getRelativePath(), event.getFileName());
                event.setEventContent(new String(eventBytes, StandardCharsets.UTF_8));
            }
        }
        return pageFlow;
    }

    private byte[] getBytesFromZip(ZipFile zipFile, String relativePath, String fileName) {
        byte[] bytes;
        try {
            bytes = ZipFileUtils.readZipFile((ZipFile)zipFile, (String)relativePath, (String)fileName);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u8bfb\u53d6\u538b\u7f29\u5305\u6587\u4ef6\u51fa\u9519:%s/%s", relativePath, fileName), e);
        }
        Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])bytes), (String)"\u672a\u4ece\u538b\u7f29\u5305\u4e2d\u8bfb\u53d6\u5230\u6587\u4ef6\uff1a%s/%s", (Object[])new Object[]{relativePath, fileName});
        return bytes;
    }

    private void handleImportDataId(PageFlowEntity pageFlow) {
        pageFlow.setId(null);
        if (!CollectionUtils.isEmpty((Collection)pageFlow.getPages())) {
            for (PageEntity page : pageFlow.getPages()) {
                page.setId(null);
                if (CollectionUtils.isEmpty((Collection)page.getEvents())) continue;
                for (PageEventEntity event : page.getEvents()) {
                    event.setId(null);
                }
            }
        }
    }

    private PageFlowEntity loadDetails(PageFlowEntity pageFlow) {
        if (Objects.isNull(pageFlow)) {
            return null;
        }
        Set<PageEntity> pages = this.pageService.findDetailsByPageFlowId(pageFlow.getId());
        pageFlow.setCreateUser(this.userService.findByAccount(pageFlow.getCreator()));
        pageFlow.setModifyUser(this.userService.findByAccount(pageFlow.getModifier()));
        pageFlow.setPageFlowContent(this.readFileContent(pageFlow.getRelativePath(), pageFlow.getFileName()));
        pageFlow.setPages(pages);
        return pageFlow;
    }

    private String readFileContent(String relativePath, String fileRename) {
        byte[] bytes = this.kuiperFileService.readFileContent(relativePath, fileRename);
        String str = null;
        if (bytes != null) {
            str = new String(bytes, StandardCharsets.UTF_8);
        }
        return str;
    }

    private void updateValidation(PageFlowEntity pageFlow, Principal principal) {
        Validate.notNull((Object)principal, (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\u5931\u8d25\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u7684\u7528\u6237\u540d\u5931\u8d25!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)pageFlow.getId(), (String)"\u66f4\u65b0\u6570\u636e\u5fc5\u987b\u8981\u6709ID", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)pageFlow.getName(), (String)"\u9875\u9762\u6d41\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)pageFlow.getCode(), (String)"\u9875\u9762\u6d41\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)pageFlow.getPageCount(), (String)"\u9875\u9762\u6d41\u9875\u9762\u6570\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)pageFlow.getLineCount(), (String)"\u9875\u9762\u6d41\u89c4\u5219\u8fde\u7ebf\u6570\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)pageFlow.getPageFlowContent(), (String)"\u4fdd\u5b58\u7684\u9875\u9762\u6d41\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        long countByName = this.pageFlowRepository.countByNameWithoutIdAndProjectName(pageFlow.getName(), pageFlow.getId(), this.platformContext.getAppName());
        Validate.isTrue((countByName == 0L ? 1 : 0) != 0, (String)"\u9875\u9762\u6d41\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u66ff\u6362", (Object[])new Object[0]);
        long countByCode = this.pageFlowRepository.countByCodeWithoutId(pageFlow.getCode(), pageFlow.getId());
        Validate.isTrue((countByCode == 0L ? 1 : 0) != 0, (String)"\u9875\u9762\u6d41\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u66ff\u6362", (Object[])new Object[0]);
    }

    private void createValidation(PageFlowEntity pageFlow, Principal principal) {
        Validate.notNull((Object)principal, (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\u5931\u8d25\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)principal.getName(), (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u7684\u7528\u6237\u540d\u5931\u8d25!", (Object[])new Object[0]);
        Validate.notNull((Object)pageFlow, (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((pageFlow.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u6570\u636e\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)pageFlow.getName(), (String)"\u9875\u9762\u6d41\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)pageFlow.getCode(), (String)"\u9875\u9762\u6d41\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)pageFlow.getPageCount(), (String)"\u9875\u9762\u6d41\u9875\u9762\u6570\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)pageFlow.getLineCount(), (String)"\u9875\u9762\u6d41\u89c4\u5219\u8fde\u7ebf\u6570\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)pageFlow.getPageFlowContent(), (String)"\u4fdd\u5b58\u7684\u9875\u9762\u6d41\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        long countByName = this.pageFlowRepository.countByNameAndProjectName(pageFlow.getName(), this.platformContext.getAppName());
        Validate.isTrue((countByName == 0L ? 1 : 0) != 0, (String)"\u9875\u9762\u6d41\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u66ff\u6362", (Object[])new Object[0]);
        long countByCode = this.pageFlowRepository.countByCode(pageFlow.getCode());
        Validate.isTrue((countByCode == 0L ? 1 : 0) != 0, (String)"\u9875\u9762\u6d41\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u66ff\u6362", (Object[])new Object[0]);
    }
}

