/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import com.bizunited.platform.kuiper.entity.TemplateMaintainerEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityAttributesEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityButtonsEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.FormTemplateTypeEnum;
import com.bizunited.platform.kuiper.starter.model.StaticTemplateMergeModel;
import com.bizunited.platform.kuiper.starter.repository.TemplateGroupRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateItemRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplatePropertyRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateRelationRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateVisibilityAttributesRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateVisibilityButtonRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.StaticTemplateMergeService;
import com.bizunited.platform.kuiper.starter.service.TemplateEventService;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.bizunited.platform.kuiper.starter.service.TemplateMaintainerService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentRelation;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StaticTemplateMergeServiceImpl
implements StaticTemplateMergeService {
    @Autowired
    private TemplateService templateService;
    @Autowired
    private UserService userService;
    @Autowired
    private NebulaStaticPersistentService nebulaStaticPersistentService;
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    @Qualifier(value="KuiperToolkitService")
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private TemplatePropertyRepository templatePropertyRepository;
    @Autowired
    private TemplateRelationRepository templateRelationRepository;
    @Autowired
    private TemplateItemRepository templateItemRepository;
    @Autowired
    private TemplateGroupRepository templateGroupRepository;
    @Autowired
    private TemplateLayoutService templateLayoutService;
    @Autowired
    private TemplateEventService templateEventService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;
    @Autowired
    private TemplateVisibilityAttributesRepository templateVisibilityAttributesRepository;
    @Autowired
    private TemplateVisibilityButtonRepository templateVisibilityButtonRepository;
    @Autowired
    private TemplateMaintainerService templateMaintainerService;
    @Autowired
    private PlatformContext platformContext;
    private static final String EXTEND_PATTERN = "extend\\d+";
    private static final String EXT_PATTERN = "ext\\d+";
    private static final Set<String> INNER_EVENT_NAME = Sets.newHashSet((Object[])new String[]{"onLoad", "beforeSubmit", "afterSubmit"});

    @Override
    @Transactional
    public TemplateEntity merge(StaticTemplateMergeModel model) {
        this.validate(model);
        this.buildTemplateProperties(model);
        Set refProperties = model.getReferenceTemplate().getProperties();
        Set mergedProperties = model.getMergedTemplate().getProperties();
        this.processProerties(model, refProperties, mergedProperties, model.getReferenceTemplate().getPersistentClassName(), model.getNewTemplate());
        Set refRelations = model.getReferenceTemplate().getRelations();
        Set mergedRelations = model.getMergedTemplate().getRelations();
        if (!CollectionUtils.isEmpty((Collection)refRelations) || !CollectionUtils.isEmpty((Collection)mergedRelations)) {
            this.processRelations(model, refRelations, mergedRelations, model.getReferenceTemplate().getPersistentClassName(), model.getNewTemplate());
        }
        Set refItems = model.getReferenceTemplate().getItemRelations();
        Set mergedItems = model.getMergedTemplate().getItemRelations();
        if (!CollectionUtils.isEmpty((Collection)refItems) || !CollectionUtils.isEmpty((Collection)mergedItems)) {
            this.processItems(model, refItems, mergedItems, model.getReferenceTemplate().getPersistentClassName(), model.getNewTemplate());
        }
        Set refGroups = model.getReferenceTemplate().getGroupRelations();
        Set mergedGroups = model.getMergedTemplate().getGroupRelations();
        if (!CollectionUtils.isEmpty((Collection)refGroups) || !CollectionUtils.isEmpty((Collection)mergedGroups)) {
            this.processGroup(model, refGroups, mergedGroups, model.getReferenceTemplate().getPersistentClassName(), model.getNewTemplate());
        }
        this.processTemplateLayouts(model);
        this.processEvents(model);
        this.processVisibilities(model);
        Set<TemplateMaintainerEntity> maintainers = this.templateMaintainerService.findByTemplateId(model.getMergedTemplateId());
        if (!CollectionUtils.isEmpty(maintainers)) {
            String[] accounts = maintainers.stream().map(TemplateMaintainerEntity::getUserAccount).collect(Collectors.toList()).toArray(new String[maintainers.size()]);
            this.templateMaintainerService.binding(model.getNewTemplate().getId(), accounts);
        }
        return model.getNewTemplate();
    }

    private void validate(StaticTemplateMergeModel model) {
        Validate.notBlank((CharSequence)model.getReferenceTemplateId(), (String)"\u57fa\u51c6\u8868\u5355\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)model.getMergedTemplateId(), (String)"\u5f85\u5408\u5e76\u8868\u5355\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)model.getNewTemplateName(), (String)"\u65b0\u8868\u5355\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)model.getNewTemplateVersion(), (String)"\u65b0\u8868\u5355\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)model.getReferenceTemplateId(), (CharSequence)model.getMergedTemplateId()) ? 1 : 0) != 0, (String)"\u57fa\u51c6\u8868\u5355\u6a21\u677fid\u548c\u5f85\u5408\u5e76\u8868\u5355\u6a21\u677fid\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity refTemplateEntity = this.templateService.findDetailsById(model.getReferenceTemplateId());
        Validate.notNull((Object)refTemplateEntity, (String)"\u6839\u636e\u57fa\u51c6\u8868\u5355\u6a21\u677fid\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u8868\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{model.getReferenceTemplateId()});
        TemplateEntity templateEntity = this.templateService.findDetailsById(model.getMergedTemplateId());
        Validate.notNull((Object)templateEntity, (String)"\u6839\u636e\u5f85\u5408\u5e76\u8868\u5355\u6a21\u677fid\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u8868\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{model.getMergedTemplateId()});
        Validate.isTrue((StringUtils.equals((CharSequence)refTemplateEntity.getType(), (CharSequence)FormTemplateTypeEnum.STATIC.getType()) && StringUtils.equals((CharSequence)templateEntity.getType(), (CharSequence)FormTemplateTypeEnum.STATIC.getType()) ? 1 : 0) != 0, (String)"\u76ee\u524d\u672c\u63a5\u53e3\u53ea\u652f\u6301\u57fa\u4e8e\u9759\u6001\u6a21\u578b\u7684\u9759\u6001\u6a21\u677f\u5408\u5e76", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)refTemplateEntity.getPersistentClassName(), (CharSequence)templateEntity.getPersistentClassName()), (String)"\u5408\u5e76\u8868\u5355\u6a21\u677f\u7684\u6a21\u578b\u63cf\u8ff0\u540d\u79f0\u5fc5\u987b\u4e00\u81f4", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)refTemplateEntity.getCode(), (CharSequence)templateEntity.getCode()), (String)"\u5408\u5e76\u8868\u5355\u6a21\u677f\u7684\u7f16\u7801\u5fc5\u987b\u4e00\u81f4", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)refTemplateEntity.getCversion(), (CharSequence)templateEntity.getCversion()) ? 1 : 0) != 0, (String)"\u5408\u5e76\u8868\u5355\u6a21\u677f\u7684\u7248\u672c\u4e0d\u80fd\u76f8\u540c", (Object[])new Object[0]);
        Validate.isTrue((refTemplateEntity.getTstatus() == 1 && templateEntity.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u57fa\u51c6\u8868\u5355\u6a21\u677f \u6216 \u5f85\u5408\u5e76\u6a21\u677f\u7684\u72b6\u6001\u4e0d\u662f\u542f\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity entity = this.templateService.findByCodeAndCversion(refTemplateEntity.getCode(), model.getNewTemplateVersion());
        Validate.isTrue((entity == null ? 1 : 0) != 0, (String)"\u8bbe\u5b9a\u7684\u5408\u5e76\u8868\u5355\u6a21\u677f\u7248\u672c\u7f16\u53f7\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{model.getNewTemplateVersion()});
        Validate.notBlank((CharSequence)model.getAccount(), (String)"\u5fc5\u987b\u6307\u5b9a\u64cd\u4f5c\u8005\u4fe1\u606f!!", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(model.getAccount());
        Validate.notNull((Object)user, (String)"\u672a\u627e\u5230\u4efb\u4f55\u521b\u5efa\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        PersistentClass currentPersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(refTemplateEntity.getPersistentClassName());
        Validate.notNull((Object)currentPersistentClass, (String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u9759\u6001\u6a21\u578b\u63cf\u8ff0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        model.setReferenceTemplate(refTemplateEntity);
        model.setMergedTemplate(templateEntity);
        model.setCurrentPersistentClass(currentPersistentClass);
    }

    private void buildTemplateProperties(StaticTemplateMergeModel model) {
        TemplateEntity newTemplate = new TemplateEntity();
        model.setNewTemplate(newTemplate);
        TemplateEntity refTemplateEntity = model.getReferenceTemplate();
        newTemplate.setCode(refTemplateEntity.getCode());
        newTemplate.setCreateTime(new Date());
        newTemplate.setCreator(model.getAccount());
        newTemplate.setCversion(model.getNewTemplateVersion());
        newTemplate.setDomain(refTemplateEntity.getDomain());
        newTemplate.setFormStyle(refTemplateEntity.getFormStyle());
        newTemplate.setName(model.getNewTemplateName());
        newTemplate.setPersistentClassName(refTemplateEntity.getPersistentClassName());
        newTemplate.setProjectName(this.platformContext.getAppName());
        newTemplate.setRepositoryEntity(refTemplateEntity.getRepositoryEntity());
        newTemplate.setTstatus(refTemplateEntity.getTstatus());
        newTemplate.setType(refTemplateEntity.getType());
        newTemplate.setModifyTime(new Date());
        newTemplate.setProjectName(this.platformContext.getAppName());
        this.templateRepository.saveAndFlush(newTemplate);
    }

    private <E, R> Set<R> intersections(Collection<E> refCollections, Collection<E> mergedCollections, Function<E, R> uniqueKeyFunc) {
        Set refInfos = refCollections.stream().map(uniqueKeyFunc).collect(Collectors.toSet());
        Set infos = mergedCollections.stream().map(uniqueKeyFunc).collect(Collectors.toSet());
        return Sets.intersection(refInfos, infos);
    }

    private <E, R> Set<R> differences(Collection<E> refCollections, Collection<E> mergedCollections, Function<E, R> uniqueKeyFunc, boolean refMerged) {
        Set refInfos = refCollections.stream().map(uniqueKeyFunc).collect(Collectors.toSet());
        Set infos = mergedCollections.stream().map(uniqueKeyFunc).collect(Collectors.toSet());
        return refMerged ? Sets.difference(refInfos, infos) : Sets.difference(infos, refInfos);
    }

    private Set<TemplatePropertyEntity> processBaseFields(StaticTemplateMergeModel model, Set<TemplatePropertyEntity> refProperties, Set<TemplatePropertyEntity> mergedProperties, String persistentClassName, Object refObject) {
        TemplatePropertyEntity newTemplatePropertyEntity;
        this.buildPropertiesMap(model, refProperties, mergedProperties, persistentClassName);
        HashSet sets = Sets.newHashSet();
        Sets.SetView collections = Sets.union(model.getIntersections(), model.getMergedRefDiff());
        for (String key : collections) {
            TemplatePropertyEntity mergedProerty = model.getMergedMap().get(key);
            this.validateField(key, model.getPersistentPropertyMap().get(key), mergedProerty);
            newTemplatePropertyEntity = (TemplatePropertyEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedProerty, TemplatePropertyEntity.class, HashSet.class, ArrayList.class, new String[]{"currentTemplate", "currentGroup", "currentItem"});
            newTemplatePropertyEntity.setId(null);
            this.setTemplatePropertesRefObject(refObject, newTemplatePropertyEntity);
            sets.add(newTemplatePropertyEntity);
            this.mergeRecord(model, refObject, key, model.getMergedRefDiff().contains(key));
        }
        for (String key : model.getRefMergedDiff()) {
            TemplatePropertyEntity refProerty = model.getRefMap().get(key);
            this.validateField(key, model.getPersistentPropertyMap().get(key), refProerty);
            newTemplatePropertyEntity = (TemplatePropertyEntity)this.kuiperToolkitService.copyObjectByWhiteList(refProerty, TemplatePropertyEntity.class, HashSet.class, ArrayList.class, new String[]{"currentTemplate", "currentGroup", "currentItem"});
            newTemplatePropertyEntity.setId(null);
            this.setTemplatePropertesRefObject(refObject, newTemplatePropertyEntity);
            sets.add(newTemplatePropertyEntity);
        }
        return sets;
    }

    private Set<TemplatePropertyEntity> processExtFields(StaticTemplateMergeModel model, Set<TemplatePropertyEntity> refProperties, Set<TemplatePropertyEntity> mergedProperties, String persistentClassName, Object refObject) {
        TemplatePropertyEntity newTemplatePropertyEntity;
        this.buildPropertiesMap(model, refProperties, mergedProperties, persistentClassName);
        HashSet sets = Sets.newHashSet();
        model.getIntersections().addAll(model.getRefMergedDiff());
        for (String key : model.getIntersections()) {
            TemplatePropertyEntity refProerty = model.getRefMap().get(key);
            this.validateField(key, model.getPersistentPropertyMap().get(key), refProerty);
            newTemplatePropertyEntity = (TemplatePropertyEntity)this.kuiperToolkitService.copyObjectByWhiteList(refProerty, TemplatePropertyEntity.class, HashSet.class, ArrayList.class, new String[]{"currentTemplate", "currentGroup", "currentItem"});
            newTemplatePropertyEntity.setId(null);
            this.setTemplatePropertesRefObject(refObject, newTemplatePropertyEntity);
            sets.add(newTemplatePropertyEntity);
        }
        for (String key : model.getMergedRefDiff()) {
            TemplatePropertyEntity mergedProerty = model.getMergedMap().get(key);
            this.validateField(key, model.getPersistentPropertyMap().get(key), mergedProerty);
            newTemplatePropertyEntity = (TemplatePropertyEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedProerty, TemplatePropertyEntity.class, HashSet.class, ArrayList.class, new String[]{"currentTemplate", "currentGroup", "currentItem"});
            newTemplatePropertyEntity.setId(null);
            this.setTemplatePropertesRefObject(refObject, newTemplatePropertyEntity);
            sets.add(newTemplatePropertyEntity);
            this.mergeRecord(model, refObject, key, true);
        }
        return sets;
    }

    private void buildPropertiesMap(StaticTemplateMergeModel model, Set<TemplatePropertyEntity> refProperties, Set<TemplatePropertyEntity> mergedProperties, String persistentClassName) {
        Map<String, TemplatePropertyEntity> refMap = refProperties.stream().collect(Collectors.toMap(TemplatePropertyEntity::getPropertyName, e -> e));
        Map<String, TemplatePropertyEntity> mergedMap = mergedProperties.stream().collect(Collectors.toMap(TemplatePropertyEntity::getPropertyName, e -> e));
        PersistentClass currentPersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(persistentClassName);
        Validate.notNull((Object)currentPersistentClass, (String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u9759\u6001\u6a21\u578b\u63cf\u8ff0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, PersistentProperty> persistentClassMap = currentPersistentClass.getProperties().stream().collect(Collectors.toMap(PersistentProperty::getPropertyName, e -> e));
        model.setMaps(refMap, mergedMap, persistentClassMap);
    }

    private void setTemplatePropertesRefObject(Object refObject, TemplatePropertyEntity propertyEntity) {
        if (refObject instanceof TemplateEntity) {
            propertyEntity.setCurrentTemplate((TemplateEntity)refObject);
        } else if (refObject instanceof TemplateGroupEntity) {
            propertyEntity.setCurrentGroup((TemplateGroupEntity)refObject);
        } else if (refObject instanceof TemplateItemEntity) {
            propertyEntity.setCurrentItem((TemplateItemEntity)refObject);
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u578b\u6570\u636e\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!");
        }
    }

    private void setTemplateRelationRefObject(Object refObject, TemplateRelationEntity relationEntity) {
        if (refObject instanceof TemplateEntity) {
            relationEntity.setCurrentTemplate((TemplateEntity)refObject);
        } else if (refObject instanceof TemplateGroupEntity) {
            relationEntity.setCurrentGroup((TemplateGroupEntity)refObject);
        } else if (refObject instanceof TemplateItemEntity) {
            relationEntity.setCurrentItem((TemplateItemEntity)refObject);
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u578b\u6570\u636e\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!");
        }
    }

    private void setTemplateItemRefObject(Object refObject, TemplateItemEntity itemEntity) {
        if (refObject instanceof TemplateEntity) {
            itemEntity.setParentTemplate((TemplateEntity)refObject);
        } else if (refObject instanceof TemplateGroupEntity) {
            itemEntity.setParentGroup((TemplateGroupEntity)refObject);
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u578b\u6570\u636e\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!");
        }
    }

    private void setTemplateGroupRefObject(Object refObject, TemplateGroupEntity groupEntity) {
        if (!(refObject instanceof TemplateEntity)) {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u578b\u6570\u636e\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!");
        }
        groupEntity.setParentTemplate((TemplateEntity)refObject);
    }

    private void proertiesFields(StaticTemplateMergeModel model, Set<String> intersections, Set<String> refMergedDiff, Set<String> mergedRefDiff, Predicate<String> fieldFunc) {
        if (fieldFunc == null) {
            model.setSets(intersections, refMergedDiff, mergedRefDiff);
        } else {
            Set<String> intersectionFields = intersections.stream().filter(fieldFunc).collect(Collectors.toSet());
            Set<String> refMergedDiffFields = refMergedDiff.stream().filter(fieldFunc).collect(Collectors.toSet());
            Set<String> mergedRefDiffFields = mergedRefDiff.stream().filter(fieldFunc).collect(Collectors.toSet());
            model.setSets(intersectionFields, refMergedDiffFields, mergedRefDiffFields);
        }
    }

    private void validateField(String key, PersistentProperty persistentProperty, TemplatePropertyEntity templatePropertyEntity) {
        Validate.notNull((Object)persistentProperty, (String)"\u5b57\u6bb5\u3010%s\u3011\u672a\u80fd\u5728\u5f53\u524d\u6a21\u578b\u63cf\u8ff0\u4e2d\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{key});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)templatePropertyEntity.getPropertyClassName(), (CharSequence)persistentProperty.getPropertyClass()), (String)"\u8868\u5355\u6a21\u578b\u3010%s\u3011\u5b57\u6bb5\u7c7b\u578b\u4e0e\u5f53\u524d\u6a21\u578b\u63cf\u8ff0\u7c7b\u4fe1\u606f\u4e0d\u5339\u914d", (Object[])new Object[]{key});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)templatePropertyEntity.getPropertyDbName(), (CharSequence)persistentProperty.getPropertyDbName()), (String)"\u8868\u5355\u6a21\u578b\u3010%s\u3011\u5b57\u6bb5\u7c7b\u578b\u4e0e\u5f53\u524d\u6a21\u578b\u63cf\u8ff0\u6570\u636e\u5e93\u5b57\u6bb5\u4fe1\u606f\u4e0d\u5339\u914d", (Object[])new Object[]{key});
    }

    private void validateField(String key, PersistentRelation persistentRelation, TemplateRelationEntity templateRelationEntity) {
        Validate.notNull((Object)persistentRelation, (String)"\u5b57\u6bb5\u3010%s\u3011\u672a\u80fd\u5728\u5f53\u524d\u6a21\u578b\u63cf\u8ff0\u4e2d\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{key});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)templateRelationEntity.getPropertyClassName(), (CharSequence)persistentRelation.getPropertyClass()), (String)"\u8868\u5355\u6a21\u578b\u3010%s\u3011\u5b57\u6bb5\u7c7b\u578b\u4e0e\u5f53\u524d\u6a21\u578b\u63cf\u8ff0\u7c7b\u4fe1\u606f\u4e0d\u5339\u914d", (Object[])new Object[]{key});
    }

    private void validateField(String key, PersistentRelation persistentRelation, TemplateItemEntity templateItemEntity) {
        Validate.notNull((Object)persistentRelation, (String)"\u5b57\u6bb5\u3010%s\u3011\u672a\u80fd\u5728\u5f53\u524d\u6a21\u578b\u63cf\u8ff0\u4e2d\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{key});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)templateItemEntity.getPropertyClassName(), (CharSequence)persistentRelation.getPropertyClass()), (String)"\u8868\u5355\u6a21\u578b\u3010%s\u3011\u5b57\u6bb5\u7c7b\u578b\u4e0e\u5f53\u524d\u6a21\u578b\u63cf\u8ff0\u7c7b\u4fe1\u606f\u4e0d\u5339\u914d", (Object[])new Object[]{key});
    }

    private void validateField(String key, PersistentRelation persistentRelation, TemplateGroupEntity templateGroupEntity) {
        Validate.notNull((Object)persistentRelation, (String)"\u5b57\u6bb5\u3010%s\u3011\u672a\u80fd\u5728\u5f53\u524d\u6a21\u578b\u63cf\u8ff0\u4e2d\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{key});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)templateGroupEntity.getPropertyClassName(), (CharSequence)persistentRelation.getPropertyClass()), (String)"\u8868\u5355\u6a21\u578b\u3010%s\u3011\u5b57\u6bb5\u7c7b\u578b\u4e0e\u5f53\u524d\u6a21\u578b\u63cf\u8ff0\u7c7b\u4fe1\u606f\u4e0d\u5339\u914d", (Object[])new Object[]{key});
    }

    private Set<TemplateRelationEntity> processRelationsFields(StaticTemplateMergeModel model, Set<TemplateRelationEntity> refRelations, Set<TemplateRelationEntity> mergedRelations, String persistentClassName, Object refObject) {
        TemplateRelationEntity newTemplateRelationEntity;
        Map<String, TemplateRelationEntity> refMap = refRelations.stream().collect(Collectors.toMap(TemplateRelationEntity::getPropertyName, e -> e));
        Map<String, TemplateRelationEntity> mergedMap = mergedRelations.stream().collect(Collectors.toMap(TemplateRelationEntity::getPropertyName, e -> e));
        PersistentClass currentPersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(persistentClassName);
        Validate.notNull((Object)currentPersistentClass, (String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u9759\u6001\u6a21\u578b\u63cf\u8ff0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, PersistentRelation> persistentClassMap = currentPersistentClass.getRelations().stream().collect(Collectors.toMap(PersistentRelation::getPropertyName, e -> e));
        HashSet sets = Sets.newHashSet();
        Sets.SetView collections = Sets.union(model.getIntersections(), model.getMergedRefDiff());
        for (String key : collections) {
            TemplateRelationEntity mergedRelation = mergedMap.get(key);
            this.validateField(key, persistentClassMap.get(key), mergedRelation);
            newTemplateRelationEntity = (TemplateRelationEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedRelation, TemplateRelationEntity.class, HashSet.class, ArrayList.class, new String[]{"currentTemplate", "currentGroup", "currentItem", "currentView"});
            newTemplateRelationEntity.setId(null);
            this.setTemplateRelationRefObject(refObject, newTemplateRelationEntity);
            sets.add(newTemplateRelationEntity);
            this.mergeRecord(model, refObject, key, model.getMergedRefDiff().contains(key));
        }
        for (String key : model.getRefMergedDiff()) {
            TemplateRelationEntity refRelation = refMap.get(key);
            this.validateField(key, persistentClassMap.get(key), refRelation);
            newTemplateRelationEntity = (TemplateRelationEntity)this.kuiperToolkitService.copyObjectByWhiteList(refRelation, TemplateRelationEntity.class, HashSet.class, ArrayList.class, new String[]{"currentTemplate", "currentGroup", "currentItem", "currentView"});
            newTemplateRelationEntity.setId(null);
            this.setTemplateRelationRefObject(refObject, newTemplateRelationEntity);
            sets.add(newTemplateRelationEntity);
        }
        return sets;
    }

    private Set<TemplateItemEntity> processItemFields(StaticTemplateMergeModel model, Set<TemplateItemEntity> refItems, Set<TemplateItemEntity> mergedItems, String persistentClassName, Object refObject) {
        TemplateItemEntity newTemplateItemEntity;
        Map<String, TemplateItemEntity> refMap = refItems.stream().collect(Collectors.toMap(TemplateItemEntity::getPropertyName, e -> e));
        Map<String, TemplateItemEntity> mergedMap = mergedItems.stream().collect(Collectors.toMap(TemplateItemEntity::getPropertyName, e -> e));
        PersistentClass currentPersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(persistentClassName);
        Validate.notNull((Object)currentPersistentClass, (String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u9759\u6001\u6a21\u578b\u63cf\u8ff0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, PersistentRelation> persistentClassMap = currentPersistentClass.getRelations().stream().collect(Collectors.toMap(PersistentRelation::getPropertyName, e -> e));
        HashSet sets = Sets.newHashSet();
        Sets.SetView collections = Sets.union(model.getIntersections(), model.getMergedRefDiff());
        for (String key : collections) {
            TemplateItemEntity mergedItem = mergedMap.get(key);
            this.validateField(key, persistentClassMap.get(key), mergedItem);
            newTemplateItemEntity = (TemplateItemEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedItem, TemplateItemEntity.class, HashSet.class, ArrayList.class, new String[]{"parentTemplate", "parentGroup", "properties", "relations"});
            newTemplateItemEntity.setId(null);
            this.setTemplateItemRefObject(refObject, newTemplateItemEntity);
            sets.add(newTemplateItemEntity);
            this.mergeRecord(model, refObject, key, model.getMergedRefDiff().contains(key));
        }
        for (String key : model.getRefMergedDiff()) {
            TemplateItemEntity refItem = refMap.get(key);
            this.validateField(key, persistentClassMap.get(key), refItem);
            newTemplateItemEntity = (TemplateItemEntity)this.kuiperToolkitService.copyObjectByWhiteList(refItem, TemplateItemEntity.class, HashSet.class, ArrayList.class, new String[]{"parentTemplate", "parentGroup", "properties", "relations"});
            newTemplateItemEntity.setId(null);
            this.setTemplateItemRefObject(refObject, newTemplateItemEntity);
            sets.add(newTemplateItemEntity);
        }
        return sets;
    }

    private Set<TemplateGroupEntity> processGroupFields(StaticTemplateMergeModel model, Set<TemplateGroupEntity> refGroups, Set<TemplateGroupEntity> mergedGroups, String persistentClassName, Object refObject) {
        TemplateGroupEntity newTemplateGroupEntity;
        Map<String, TemplateGroupEntity> refMap = refGroups.stream().collect(Collectors.toMap(TemplateGroupEntity::getPropertyName, e -> e));
        Map<String, TemplateGroupEntity> mergedMap = mergedGroups.stream().collect(Collectors.toMap(TemplateGroupEntity::getPropertyName, e -> e));
        PersistentClass currentPersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(persistentClassName);
        Validate.notNull((Object)currentPersistentClass, (String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u9759\u6001\u6a21\u578b\u63cf\u8ff0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, PersistentRelation> persistentClassMap = currentPersistentClass.getRelations().stream().collect(Collectors.toMap(PersistentRelation::getPropertyName, e -> e));
        HashSet sets = Sets.newHashSet();
        Sets.SetView collections = Sets.union(model.getIntersections(), model.getMergedRefDiff());
        for (String key : collections) {
            TemplateGroupEntity mergedGroup = mergedMap.get(key);
            this.validateField(key, persistentClassMap.get(key), mergedGroup);
            newTemplateGroupEntity = (TemplateGroupEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedGroup, TemplateGroupEntity.class, HashSet.class, ArrayList.class, new String[]{"parentTemplate", "properties", "relations", "itemRelations"});
            newTemplateGroupEntity.setId(null);
            this.setTemplateGroupRefObject(refObject, newTemplateGroupEntity);
            sets.add(newTemplateGroupEntity);
            this.mergeRecord(model, refObject, key, model.getMergedRefDiff().contains(key));
        }
        for (String key : model.getRefMergedDiff()) {
            TemplateGroupEntity refGroup = refMap.get(key);
            this.validateField(key, persistentClassMap.get(key), refGroup);
            newTemplateGroupEntity = (TemplateGroupEntity)this.kuiperToolkitService.copyObjectByWhiteList(refGroup, TemplateGroupEntity.class, HashSet.class, ArrayList.class, new String[]{"parentTemplate", "properties", "relations", "itemRelations"});
            newTemplateGroupEntity.setId(null);
            this.setTemplateGroupRefObject(refObject, newTemplateGroupEntity);
            sets.add(newTemplateGroupEntity);
        }
        return sets;
    }

    private void processProerties(StaticTemplateMergeModel model, Set<TemplatePropertyEntity> refProperties, Set<TemplatePropertyEntity> mergedProperties, String persistentClassName, Object refObject) {
        Set<String> intersections = this.intersections(refProperties, mergedProperties, TemplatePropertyEntity::getPropertyName);
        Set<String> refMergedDiff = this.differences(refProperties, mergedProperties, TemplatePropertyEntity::getPropertyName, true);
        Set<String> mergedRefDiff = this.differences(refProperties, mergedProperties, TemplatePropertyEntity::getPropertyName, false);
        this.proertiesFields(model, intersections, refMergedDiff, mergedRefDiff, e -> this.matchExt(false, (String)e));
        Set<TemplatePropertyEntity> properties = this.processBaseFields(model, refProperties, mergedProperties, persistentClassName, refObject);
        this.proertiesFields(model, intersections, refMergedDiff, mergedRefDiff, e -> this.matchExt(true, (String)e));
        Set<TemplatePropertyEntity> extProperties = this.processExtFields(model, refProperties, mergedProperties, persistentClassName, refObject);
        properties.addAll(extProperties);
        if (!CollectionUtils.isEmpty(properties)) {
            properties.forEach(p -> p.setProjectName(this.platformContext.getAppName()));
        }
        this.templatePropertyRepository.saveAll(properties);
        this.templatePropertyRepository.flush();
        if (refObject instanceof TemplateEntity) {
            ((TemplateEntity)refObject).setProperties(properties);
        } else if (refObject instanceof TemplateGroupEntity) {
            ((TemplateGroupEntity)refObject).setProperties(properties);
        } else if (refObject instanceof TemplateItemEntity) {
            ((TemplateItemEntity)refObject).setProperties(properties);
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u578b\u6570\u636e\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!");
        }
    }

    private void processRelations(StaticTemplateMergeModel model, Set<TemplateRelationEntity> refRelations, Set<TemplateRelationEntity> mergedRelations, String persistentClassName, Object refObject) {
        Set<String> intersectionRelations = this.intersections(refRelations, mergedRelations, TemplateRelationEntity::getPropertyName);
        Set<String> refMergedDiffRelations = this.differences(refRelations, mergedRelations, TemplateRelationEntity::getPropertyName, true);
        Set<String> mergedRefDiffRelations = this.differences(refRelations, mergedRelations, TemplateRelationEntity::getPropertyName, false);
        this.proertiesFields(model, intersectionRelations, refMergedDiffRelations, mergedRefDiffRelations, null);
        Set<TemplateRelationEntity> relations = this.processRelationsFields(model, refRelations, mergedRelations, persistentClassName, refObject);
        if (!CollectionUtils.isEmpty(relations)) {
            relations.forEach(r -> r.setProjectName(this.platformContext.getAppName()));
        }
        this.templateRelationRepository.saveAll(relations);
        this.templateRelationRepository.flush();
        if (refObject instanceof TemplateEntity) {
            ((TemplateEntity)refObject).setRelations(relations);
        } else if (refObject instanceof TemplateGroupEntity) {
            ((TemplateGroupEntity)refObject).setRelations(relations);
        } else if (refObject instanceof TemplateItemEntity) {
            ((TemplateItemEntity)refObject).setRelations(relations);
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u578b\u6570\u636e\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!");
        }
    }

    private void processItems(StaticTemplateMergeModel model, Set<TemplateItemEntity> refItems, Set<TemplateItemEntity> mergedItems, String persistentClassName, Object refObject) {
        Set<String> intersectionItems = this.intersections(refItems, mergedItems, TemplateItemEntity::getPropertyName);
        Set<String> refMergedDiffItems = this.differences(refItems, mergedItems, TemplateItemEntity::getPropertyName, true);
        Set<String> mergedRefDiffItems = this.differences(refItems, mergedItems, TemplateItemEntity::getPropertyName, false);
        this.proertiesFields(model, intersectionItems, refMergedDiffItems, mergedRefDiffItems, null);
        Set<TemplateItemEntity> items = this.processItemFields(model, refItems, mergedItems, persistentClassName, refObject);
        for (TemplateItemEntity item : items) {
            Set mergedRelations;
            item.setProjectName(this.platformContext.getAppName());
            this.templateItemRepository.saveAndFlush(item);
            TemplateItemEntity ref = refItems.stream().filter(e -> StringUtils.equals((CharSequence)e.getPropertyName(), (CharSequence)item.getPropertyName())).findFirst().orElse(null);
            TemplateItemEntity merged = mergedItems.stream().filter(e -> StringUtils.equals((CharSequence)e.getPropertyName(), (CharSequence)item.getPropertyName())).findFirst().orElse(null);
            Set refProperties = ref == null ? Sets.newHashSet() : ref.getProperties();
            Set mergedProperties = merged == null ? Sets.newHashSet() : merged.getProperties();
            this.processProerties(model, refProperties, mergedProperties, item.getPropertyClassName(), item);
            Set refRelations = ref == null ? Sets.newHashSet() : ref.getRelations();
            Set set = mergedRelations = merged == null ? Sets.newHashSet() : merged.getRelations();
            if (CollectionUtils.isEmpty((Collection)refRelations) && CollectionUtils.isEmpty((Collection)mergedRelations)) continue;
            this.processRelations(model, refRelations, mergedRelations, item.getPropertyClassName(), item);
        }
        if (refObject instanceof TemplateEntity) {
            ((TemplateEntity)refObject).setItemRelations(items);
        } else if (refObject instanceof TemplateGroupEntity) {
            ((TemplateGroupEntity)refObject).setItemRelations(items);
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u578b\u6570\u636e\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!");
        }
    }

    private void processGroup(StaticTemplateMergeModel model, Set<TemplateGroupEntity> refGroups, Set<TemplateGroupEntity> mergedGroups, String persistentClassName, Object refObject) {
        Set<String> intersectionGroups = this.intersections(refGroups, mergedGroups, TemplateGroupEntity::getPropertyName);
        Set<String> refMergedDiffGroups = this.differences(refGroups, mergedGroups, TemplateGroupEntity::getPropertyName, true);
        Set<String> mergedRefDiffGroups = this.differences(refGroups, mergedGroups, TemplateGroupEntity::getPropertyName, false);
        this.proertiesFields(model, intersectionGroups, refMergedDiffGroups, mergedRefDiffGroups, null);
        Set<TemplateGroupEntity> groups = this.processGroupFields(model, refGroups, mergedGroups, persistentClassName, refObject);
        for (TemplateGroupEntity group : groups) {
            Set mergedItems;
            Set mergedRelations;
            group.setProjectName(this.platformContext.getAppName());
            this.templateGroupRepository.saveAndFlush(group);
            TemplateGroupEntity ref = refGroups.stream().filter(e -> StringUtils.equals((CharSequence)e.getPropertyName(), (CharSequence)group.getPropertyName())).findFirst().orElse(null);
            TemplateGroupEntity merged = mergedGroups.stream().filter(e -> StringUtils.equals((CharSequence)e.getPropertyName(), (CharSequence)group.getPropertyName())).findFirst().orElse(null);
            Set refProperties = ref == null ? Sets.newHashSet() : ref.getProperties();
            Set mergedProperties = merged == null ? Sets.newHashSet() : merged.getProperties();
            this.processProerties(model, refProperties, mergedProperties, group.getPropertyClassName(), group);
            Set refRelations = ref == null ? Sets.newHashSet() : ref.getRelations();
            Set set = mergedRelations = merged == null ? Sets.newHashSet() : merged.getRelations();
            if (!CollectionUtils.isEmpty((Collection)refRelations) || !CollectionUtils.isEmpty((Collection)mergedRelations)) {
                this.processRelations(model, refRelations, mergedRelations, group.getPropertyClassName(), group);
            }
            Set refItems = ref == null ? Sets.newHashSet() : ref.getItemRelations();
            Set set2 = mergedItems = ref == null ? Sets.newHashSet() : ref.getItemRelations();
            if (CollectionUtils.isEmpty((Collection)refItems) && CollectionUtils.isEmpty((Collection)mergedItems)) continue;
            this.processItems(model, refItems, mergedItems, group.getPropertyClassName(), group);
        }
        if (!(refObject instanceof TemplateEntity)) {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u578b\u6570\u636e\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!");
        }
        ((TemplateEntity)refObject).setGroupRelations(groups);
    }

    private void mergeRecord(StaticTemplateMergeModel model, Object refObject, String propertyName, boolean isAdd) {
        String newPropertyName;
        if (refObject instanceof TemplatePropertyEntity || refObject instanceof TemplateEntity) {
            newPropertyName = propertyName;
        } else if (refObject instanceof TemplateRelationEntity) {
            newPropertyName = this.recordMergeRelations((TemplateRelationEntity)refObject, propertyName);
        } else if (refObject instanceof TemplateItemEntity) {
            newPropertyName = this.recordMergeItems((TemplateItemEntity)refObject, propertyName);
        } else if (refObject instanceof TemplateGroupEntity) {
            newPropertyName = this.recordMergeGroups((TemplateGroupEntity)refObject, propertyName);
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u578b\u6570\u636e\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!");
        }
        model.getMergeInfo().put(newPropertyName, (Object)isAdd);
    }

    private String recordMergeProperties(String propertyName) {
        return propertyName;
    }

    private String recordMergeRelations(TemplateRelationEntity refObject, String propertyName) {
        TemplateEntity template = refObject.getCurrentTemplate();
        TemplateItemEntity item = refObject.getCurrentItem();
        TemplateGroupEntity group = refObject.getCurrentGroup();
        if (template != null) {
            return this.recordMergeProperties(propertyName);
        }
        if (item != null) {
            return this.recordMergeItems(item, propertyName);
        }
        return this.recordMergeGroups(group, propertyName);
    }

    private String recordMergeItems(TemplateItemEntity refObject, String propertyName) {
        TemplateEntity parentTemplate = refObject.getParentTemplate();
        TemplateGroupEntity parentGroupTemplate = refObject.getParentGroup();
        if (parentTemplate != null) {
            return this.recordMergeProperties(StringUtils.join((Object[])new String[]{refObject.getPropertyName(), "-", propertyName}));
        }
        return this.recordMergeGroups(parentGroupTemplate, StringUtils.join((Object[])new String[]{refObject.getPropertyName(), "-", propertyName}));
    }

    private String recordMergeGroups(TemplateGroupEntity refObject, String propertyName) {
        return this.recordMergeProperties(StringUtils.join((Object[])new String[]{refObject.getPropertyName(), "-", propertyName}));
    }

    private void processTemplateLayouts(StaticTemplateMergeModel model) {
        JSONObject mergedLayout3;
        JSONObject refLayout3;
        JSONObject mergedLayout2;
        TemplateEntity refTemplate = model.getReferenceTemplate();
        TemplateEntity mergedTemplate = model.getMergedTemplate();
        Set<TemplateLayoutEntity> refLayouts = this.templateLayoutService.findByTemplateId(refTemplate.getId());
        Set<TemplateLayoutEntity> mergedLayouts = this.templateLayoutService.findByTemplateId(mergedTemplate.getId());
        Validate.isTrue((!CollectionUtils.isEmpty(refLayouts) && !CollectionUtils.isEmpty(mergedLayouts) ? 1 : 0) != 0, (String)"\u5408\u5e76\u6a21\u677f\u65f6\uff0c\u53d1\u73b0\u5e03\u5c40\u6587\u4ef6\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((refLayouts.size() == mergedLayouts.size() ? 1 : 0) != 0, (String)"\u5408\u5e76\u6a21\u677f\u65f6\uff0c\u53d1\u73b0\u5e03\u5c40\u6587\u4ef6\u6570\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        refLayouts.forEach(v -> Validate.isTrue((boolean)mergedLayouts.stream().anyMatch(e -> v.getLayoutType().equals(e.getLayoutType())), (String)"\u5408\u5e76\u6a21\u677f\u65f6\uff0c\u53d1\u73b0\u5e03\u5c40\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]));
        JSONObject refLayout1 = this.templateLayoutService.findDetailsByTemplateId(refTemplate.getId(), 1);
        Validate.notNull((Object)refLayout1, (String)"\u8868\u5355\u6a21\u578b\u3010%s\u3011\u7248\u672c\u3010%s\u3011  PC\u5e03\u5c40\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{refTemplate.getName(), refTemplate.getCversion()});
        JSONObject mergedLayout1 = this.templateLayoutService.findDetailsByTemplateId(mergedTemplate.getId(), 1);
        Validate.notNull((Object)mergedLayout1, (String)"\u8868\u5355\u6a21\u578b\u3010%s\u3011\u7248\u672c\u3010%s\u3011  PC\u5e03\u5c40\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{mergedTemplate.getName(), mergedTemplate.getCversion()});
        this.resolveLayout(model, refLayout1, true);
        this.resolveLayout(model, mergedLayout1, false);
        this.resolveJson(model, refLayout1);
        try {
            TemplateLayoutEntity layoutEntity = this.templateLayoutService.save(model.getNewTemplate().getId(), 1, refLayout1);
            model.getNewTemplate().setTemplateLayout((Object)layoutEntity);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("\u4fdd\u5b58PC\u5e03\u5c40\u6587\u4ef6\u5931\u8d25\uff1a%s", e.getMessage()));
        }
        JSONObject refLayout2 = this.templateLayoutService.findDetailsByTemplateId(refTemplate.getId(), 2);
        if (refLayout2 != null && (mergedLayout2 = this.templateLayoutService.findDetailsByTemplateId(mergedTemplate.getId(), 2)) != null) {
            this.resolveLayout(model, refLayout2, true);
            this.resolveLayout(model, mergedLayout2, false);
            this.resolveJson(model, refLayout2);
            try {
                TemplateLayoutEntity layoutEntity2 = this.templateLayoutService.save(model.getNewTemplate().getId(), 2, refLayout2);
                model.getNewTemplate().setMobileTemplateLayout((Object)layoutEntity2);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("\u4fdd\u5b58Mobile\u5e03\u5c40\u6587\u4ef6\u5931\u8d25\uff1a%s", e.getMessage()));
            }
        }
        if ((refLayout3 = this.templateLayoutService.findDetailsByTemplateId(refTemplate.getId(), 3)) != null && (mergedLayout3 = this.templateLayoutService.findDetailsByTemplateId(mergedTemplate.getId(), 3)) != null) {
            this.resolveLayout(model, refLayout3, true);
            this.resolveLayout(model, mergedLayout3, false);
            this.resolveJson(model, refLayout3);
            try {
                TemplateLayoutEntity layoutEntity3 = this.templateLayoutService.save(model.getNewTemplate().getId(), 3, refLayout3);
                model.getNewTemplate().setPrintTemplateLayout((Object)layoutEntity3);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("\u4fdd\u5b58Print\u5e03\u5c40\u6587\u4ef6\u5931\u8d25\uff1a%s", e.getMessage()));
            }
        }
    }

    private void resolveLayout(StaticTemplateMergeModel model, JSONObject layout, boolean isRefJson) {
        JSONObject fieldInfo;
        JSONObject labelInfo;
        JSONObject jsonResolveInfo;
        JSONObject layoutCells = layout.getJSONObject("cells");
        if (isRefJson) {
            jsonResolveInfo = model.getRefJsonResolveInfo();
            labelInfo = model.getRefLabelJsonInfo();
            fieldInfo = model.getRefFieldJsonInfo();
        } else {
            jsonResolveInfo = model.getMergedJsonResolveInfo();
            labelInfo = model.getMergedLabelJsonInfo();
            fieldInfo = model.getMergedFieldJsonInfo();
        }
        jsonResolveInfo.clear();
        labelInfo.clear();
        fieldInfo.clear();
        jsonResolveInfo.put("emptyCells", (Object)new JSONArray());
        jsonResolveInfo.put("buttons", (Object)new JSONArray());
        for (String cellKey : layoutCells.keySet()) {
            JSONObject cellValue = layoutCells.getJSONObject(cellKey);
            JSONObject json = new JSONObject();
            json.put("row,cell", (Object)cellKey);
            if (cellValue.isEmpty()) {
                json.put("value", (Object)cellValue);
                jsonResolveInfo.getJSONArray("emptyCells").add((Object)json);
                continue;
            }
            String controllerType = cellValue.getString("type");
            if (StringUtils.equals((CharSequence)controllerType, (CharSequence)"button")) {
                json.put("value", (Object)cellValue);
                jsonResolveInfo.getJSONArray("buttons").add((Object)json);
                continue;
            }
            if (StringUtils.equals((CharSequence)controllerType, (CharSequence)"table")) {
                String itemRelation = cellValue.getString("field");
                json.put("itemRelation", (Object)itemRelation);
                json.put("value", (Object)cellValue);
                jsonResolveInfo.put(itemRelation, (Object)json);
                continue;
            }
            String label = cellValue.getString("for");
            if (StringUtils.isNotBlank((CharSequence)label)) {
                json.put("label", (Object)label);
                json.put("value", (Object)cellValue);
                labelInfo.put(label, (Object)json);
                continue;
            }
            String field = cellValue.getString("field");
            if (StringUtils.isNotBlank((CharSequence)field)) {
                json.put("field", (Object)field);
                json.put("value", (Object)cellValue);
                fieldInfo.put(field, (Object)json);
                continue;
            }
            throw new IllegalArgumentException("\u672a\u77e5\u60c5\u51b5\u7684\u524d\u7aef\u5e03\u5c40\u6587\u4ef6\u89e3\u6790\uff0c\u8bf7\u68c0\u67e5!!");
        }
    }

    private void resolveJson(StaticTemplateMergeModel model, JSONObject refLayout) {
        JSONObject refJsonResolveInfo = model.getRefJsonResolveInfo();
        JSONObject mergedJsonResolveInfo = model.getMergedJsonResolveInfo();
        JSONObject refLabelInfo = model.getRefLabelJsonInfo();
        JSONObject mergedLabelInfo = model.getMergedLabelJsonInfo();
        JSONObject refFieldInfo = model.getRefFieldJsonInfo();
        JSONObject mergedFieldInfo = model.getMergedFieldJsonInfo();
        JSONArray refButtons = refJsonResolveInfo.getJSONArray("buttons");
        JSONArray mergedButtons = mergedJsonResolveInfo.getJSONArray("buttons");
        Set refButtonNames = refButtons.stream().map(e -> ((JSONObject)e).getJSONObject("value").getString("name")).collect(Collectors.toSet());
        Set mergedButtonNames = mergedButtons.stream().map(e -> ((JSONObject)e).getJSONObject("value").getString("name")).collect(Collectors.toSet());
        Sets.SetView needAddButtonNames = Sets.difference(mergedButtonNames, refButtonNames);
        for (Object mergedButton : mergedButtons) {
            JSONObject button = ((JSONObject)mergedButton).getJSONObject("value");
            if (!needAddButtonNames.contains(button.getString("name"))) continue;
            this.processLayoutButton(refLayout, button);
        }
        Set refLabelKeys = refLabelInfo.keySet();
        Set mergedLabelKeys = mergedLabelInfo.keySet();
        Sets.SetView intersections = Sets.intersection((Set)refLabelKeys, (Set)mergedLabelKeys);
        Sets.SetView mergedRefDifs = Sets.difference((Set)mergedLabelKeys, (Set)refLabelKeys);
        for (String addLabelKey : mergedRefDifs) {
            JSONObject label = mergedLabelInfo.getJSONObject(addLabelKey).getJSONObject("value");
            JSONObject field = mergedFieldInfo.getJSONObject(addLabelKey) == null ? null : mergedFieldInfo.getJSONObject(addLabelKey).getJSONObject("value");
            JSONObject item = mergedJsonResolveInfo.getJSONObject(addLabelKey) == null ? null : mergedJsonResolveInfo.getJSONObject(addLabelKey).getJSONObject("value");
            this.processLayoutLabel(label, refLayout, true, null);
            JSONObject cells = refLayout.getJSONObject("cells");
            JSONObject rows = refLayout.getJSONObject("rows");
            if (field != null) {
                cells.put(StringUtils.join((Object[])new Serializable[]{String.valueOf(rows.size() - 1), ",", Integer.valueOf(2)}), (Object)field);
            }
            if (item == null) continue;
            cells.put(StringUtils.join((Object[])new Serializable[]{String.valueOf(rows.size() - 1), ",", Integer.valueOf(2)}), (Object)item);
        }
        for (String updateLabelKey : intersections) {
            if (this.matchExt(false, updateLabelKey)) continue;
            String rowcell = refLabelInfo.getJSONObject(updateLabelKey).getString("row,cell");
            JSONObject label = mergedLabelInfo.getJSONObject(updateLabelKey).getJSONObject("value");
            this.processLayoutLabel(label, refLayout, false, rowcell);
        }
        Set refFieldKeys = refFieldInfo.keySet();
        Set mergedFieldKeys = mergedFieldInfo.keySet();
        intersections = Sets.intersection((Set)refFieldKeys, (Set)mergedFieldKeys);
        for (String updateFieldKey : intersections) {
            if (this.matchExt(false, updateFieldKey)) continue;
            String rowcell = refFieldInfo.getJSONObject(updateFieldKey).getString("row,cell");
            JSONObject field = mergedFieldInfo.getJSONObject(updateFieldKey).getJSONObject("value");
            this.processLayoutField(field, refLayout, false, rowcell);
        }
        Set refItemKeys = refJsonResolveInfo.keySet().stream().filter(e -> !StringUtils.equals((CharSequence)e, (CharSequence)"buttons") && !StringUtils.equals((CharSequence)e, (CharSequence)"emptyCells")).collect(Collectors.toSet());
        Set mergedItemKeys = mergedJsonResolveInfo.keySet().stream().filter(e -> !StringUtils.equals((CharSequence)e, (CharSequence)"buttons") && !StringUtils.equals((CharSequence)e, (CharSequence)"emptyCells")).collect(Collectors.toSet());
        intersections = Sets.intersection(refItemKeys, mergedItemKeys);
        for (String updateItemKey : intersections) {
            String refRowcell = refJsonResolveInfo.getJSONObject(updateItemKey).getString("row,cell");
            JSONObject item = mergedJsonResolveInfo.getJSONObject(updateItemKey).getJSONObject("value");
            this.processLayoutItem(item, refLayout, false, refRowcell);
        }
    }

    private void processLayoutButton(JSONObject refLayout, JSONObject button) {
        JSONObject rows = refLayout.getJSONObject("rows");
        JSONObject cells = refLayout.getJSONObject("cells");
        Set cellKeys = cells.keySet();
        Set lastRowCells = cellKeys.stream().filter(e -> StringUtils.startsWith((CharSequence)e, (CharSequence)StringUtils.join((Object[])new Serializable[]{Integer.valueOf(rows.size()), ","}))).collect(Collectors.toSet());
        for (String lastRowCell : lastRowCells) {
            String[] splits = lastRowCell.split(",");
            cells.put(StringUtils.join((Object[])new String[]{String.valueOf(rows.size() + 1), ",", splits[1]}), cells.remove((Object)lastRowCell));
        }
        rows.put(String.valueOf(rows.size() + 1), (Object)rows.getJSONObject(String.valueOf(rows.size())));
        cells.put(StringUtils.join((Object[])new Serializable[]{String.valueOf(rows.size() - 1), ",", Integer.valueOf(1)}), (Object)button);
        JSONObject newRowValue = new JSONObject();
        newRowValue.put("column", (Object)new Integer[]{24});
        rows.put(String.valueOf(rows.size() - 1), (Object)newRowValue);
    }

    private void processLayoutLabel(JSONObject label, JSONObject refLayout, boolean isAdd, String rowcell) {
        JSONObject rows = refLayout.getJSONObject("rows");
        JSONObject cells = refLayout.getJSONObject("cells");
        Set cellKeys = cells.keySet();
        if (!isAdd) {
            cells.replace((Object)rowcell, (Object)label);
            return;
        }
        Set lastRowCells = cellKeys.stream().filter(e -> StringUtils.startsWith((CharSequence)e, (CharSequence)StringUtils.join((Object[])new Serializable[]{Integer.valueOf(rows.size()), ","}))).collect(Collectors.toSet());
        for (String lastRowCell : lastRowCells) {
            String[] splits = lastRowCell.split(",");
            cells.put(StringUtils.join((Object[])new String[]{String.valueOf(rows.size() + 1), ",", splits[1]}), cells.remove((Object)lastRowCell));
        }
        rows.put(String.valueOf(rows.size() + 1), (Object)rows.getJSONObject(String.valueOf(rows.size())));
        cells.put(StringUtils.join((Object[])new Serializable[]{String.valueOf(rows.size() - 1), ",", Integer.valueOf(1)}), (Object)label);
        JSONObject newRowValue = new JSONObject();
        newRowValue.put("column", (Object)new Integer[]{3, 21});
        rows.put(String.valueOf(rows.size() - 1), (Object)newRowValue);
    }

    private void processLayoutField(JSONObject field, JSONObject refLayout, boolean isAdd, String rowcell) {
        JSONObject rows = refLayout.getJSONObject("rows");
        JSONObject cells = refLayout.getJSONObject("cells");
        Set cellKeys = cells.keySet();
        if (!isAdd) {
            cells.replace((Object)rowcell, (Object)field);
            return;
        }
        Set lastRowCells = cellKeys.stream().filter(e -> StringUtils.startsWith((CharSequence)e, (CharSequence)StringUtils.join((Object[])new Serializable[]{Integer.valueOf(rows.size()), ","}))).collect(Collectors.toSet());
        for (String lastRowCell : lastRowCells) {
            String[] splits = lastRowCell.split(",");
            cells.put(StringUtils.join((Object[])new String[]{String.valueOf(rows.size() + 1), ",", splits[1]}), cells.remove((Object)lastRowCell));
        }
        rows.put(String.valueOf(rows.size() + 1), (Object)rows.getJSONObject(String.valueOf(rows.size())));
        cells.put(StringUtils.join((Object[])new Serializable[]{String.valueOf(rows.size() - 1), ",", Integer.valueOf(1)}), (Object)field);
        if (StringUtils.equals((CharSequence)field.getString("controltype"), (CharSequence)"title")) {
            rows.getJSONObject(String.valueOf(rows.size() - 1)).put("group", (Object)field.getString("field"));
        }
    }

    private void processLayoutItem(JSONObject item, JSONObject refLayout, boolean isAdd, String rowcell) {
        JSONObject rows = refLayout.getJSONObject("rows");
        JSONObject cells = refLayout.getJSONObject("cells");
        Set cellKeys = cells.keySet();
        if (!isAdd) {
            cells.replace((Object)rowcell, (Object)item);
            return;
        }
        Set lastRowCells = cellKeys.stream().filter(e -> StringUtils.startsWith((CharSequence)e, (CharSequence)StringUtils.join((Object[])new Serializable[]{Integer.valueOf(rows.size()), ","}))).collect(Collectors.toSet());
        for (String lastRowCell : lastRowCells) {
            String[] splits = lastRowCell.split(",");
            cells.put(StringUtils.join((Object[])new String[]{String.valueOf(rows.size() + 1), ",", splits[1]}), cells.remove((Object)lastRowCell));
        }
        rows.put(String.valueOf(rows.size() + 1), (Object)rows.getJSONObject(String.valueOf(rows.size())));
        cells.put(StringUtils.join((Object[])new Serializable[]{String.valueOf(rows.size() - 1), ",", Integer.valueOf(1)}), (Object)item);
    }

    private void processEvents(StaticTemplateMergeModel model) {
        TemplateEventEntity refMergedEvent;
        TemplateEventEntity newEventEntity;
        TemplateEventEntity mergedEvent;
        TemplateEntity refTemplate = model.getReferenceTemplate();
        TemplateEntity mergedTemplate = model.getMergedTemplate();
        Set<TemplateEventEntity> refEvents = this.templateEventService.findDetailsByTemplateId(refTemplate.getId());
        Set<TemplateEventEntity> mergedEvents = this.templateEventService.findDetailsByTemplateId(mergedTemplate.getId());
        Set refInnerEvents = refEvents.stream().filter(e -> INNER_EVENT_NAME.contains(e.getOnEvent())).collect(Collectors.toSet());
        Set mergedInnerEvents = mergedEvents.stream().filter(e -> INNER_EVENT_NAME.contains(e.getOnEvent())).collect(Collectors.toSet());
        Set refContrllerEvents = refEvents.stream().filter(e -> !INNER_EVENT_NAME.contains(e.getOnEvent())).collect(Collectors.toSet());
        Set mergedContrllerEvents = mergedEvents.stream().filter(e -> !INNER_EVENT_NAME.contains(e.getOnEvent())).collect(Collectors.toSet());
        Set<String> intersections = this.intersections(refContrllerEvents, mergedContrllerEvents, TemplateEventEntity::getAttributeName);
        Set<String> refMergedDiff = this.differences(refContrllerEvents, mergedContrllerEvents, TemplateEventEntity::getAttributeName, true);
        Set<String> mergedRefDiff = this.differences(refContrllerEvents, mergedContrllerEvents, TemplateEventEntity::getAttributeName, false);
        ArrayList newEvents = Lists.newArrayList();
        for (String propertyName : intersections) {
            if (this.matchExt(true, propertyName)) {
                mergedEvent = mergedContrllerEvents.stream().filter(e -> StringUtils.equals((CharSequence)propertyName, (CharSequence)e.getAttributeName())).findFirst().orElse(null);
                Validate.notNull((Object)mergedEvent, (String)"\u672a\u627e\u5230\u5f85\u5408\u5e76\u6a21\u677f\u4e8b\u4ef6%s", (Object[])new Object[]{propertyName});
                newEventEntity = (TemplateEventEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedEvent, TemplateEventEntity.class, HashSet.class, ArrayList.class, new String[]{""});
                newEventEntity.setId(null);
                newEventEntity.setTemplate(model.getNewTemplate());
                newEvents.add(newEventEntity);
                continue;
            }
            refMergedEvent = refContrllerEvents.stream().filter(e -> StringUtils.equals((CharSequence)propertyName, (CharSequence)e.getAttributeName())).findFirst().orElse(null);
            Validate.notNull((Object)refMergedEvent, (String)"\u672a\u627e\u5230\u57fa\u51c6\u6a21\u677f\u4e8b\u4ef6%s", (Object[])new Object[]{propertyName});
            newEventEntity = (TemplateEventEntity)this.kuiperToolkitService.copyObjectByWhiteList(refMergedEvent, TemplateEventEntity.class, HashSet.class, ArrayList.class, new String[]{""});
            newEventEntity.setId(null);
            newEventEntity.setTemplate(model.getNewTemplate());
            newEvents.add(newEventEntity);
        }
        for (String propertyName : refMergedDiff) {
            refMergedEvent = refContrllerEvents.stream().filter(e -> StringUtils.equals((CharSequence)propertyName, (CharSequence)e.getAttributeName())).findFirst().orElse(null);
            Validate.notNull((Object)refMergedEvent, (String)"\u672a\u627e\u5230\u57fa\u51c6\u6a21\u677f\u4e8b\u4ef6%s", (Object[])new Object[]{propertyName});
            newEventEntity = (TemplateEventEntity)this.kuiperToolkitService.copyObjectByWhiteList(refMergedEvent, TemplateEventEntity.class, HashSet.class, ArrayList.class, new String[]{""});
            newEventEntity.setId(null);
            newEventEntity.setTemplate(model.getNewTemplate());
            newEvents.add(newEventEntity);
        }
        for (String propertyName : mergedRefDiff) {
            mergedEvent = mergedContrllerEvents.stream().filter(e -> StringUtils.equals((CharSequence)propertyName, (CharSequence)e.getAttributeName())).findFirst().orElse(null);
            Validate.notNull((Object)mergedEvent, (String)"\u672a\u627e\u5230\u5f85\u5408\u5e76\u6a21\u677f\u4e8b\u4ef6%s", (Object[])new Object[]{propertyName});
            newEventEntity = (TemplateEventEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedEvent, TemplateEventEntity.class, HashSet.class, ArrayList.class, new String[]{""});
            newEventEntity.setId(null);
            newEventEntity.setTemplate(model.getNewTemplate());
            newEvents.add(newEventEntity);
        }
        intersections = this.intersections(refInnerEvents, mergedInnerEvents, TemplateEventEntity::getOnEvent);
        refMergedDiff = this.differences(refInnerEvents, mergedInnerEvents, TemplateEventEntity::getOnEvent, true);
        mergedRefDiff = this.differences(refInnerEvents, mergedInnerEvents, TemplateEventEntity::getOnEvent, false);
        for (String eventName : Sets.union(intersections, mergedRefDiff)) {
            TemplateEventEntity mergedInnerEvent = mergedInnerEvents.stream().filter(e -> StringUtils.equals((CharSequence)eventName, (CharSequence)e.getOnEvent())).findFirst().orElse(null);
            Validate.notNull((Object)mergedInnerEvent, (String)"\u672a\u627e\u5230\u5f85\u5408\u5e76\u6a21\u677f\u4e8b\u4ef6%s", (Object[])new Object[]{eventName});
            newEventEntity = (TemplateEventEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedInnerEvent, TemplateEventEntity.class, HashSet.class, ArrayList.class, new String[]{""});
            newEventEntity.setId(null);
            newEventEntity.setTemplate(model.getNewTemplate());
            newEvents.add(newEventEntity);
        }
        for (String eventName : refMergedDiff) {
            TemplateEventEntity refInnerEvent = refInnerEvents.stream().filter(e -> StringUtils.equals((CharSequence)eventName, (CharSequence)e.getOnEvent())).findFirst().orElse(null);
            Validate.notNull((Object)refInnerEvent, (String)"\u672a\u627e\u5230\u57fa\u51c6\u6a21\u677f\u4e8b\u4ef6%s", (Object[])new Object[]{eventName});
            newEventEntity = (TemplateEventEntity)this.kuiperToolkitService.copyObjectByWhiteList(refInnerEvent, TemplateEventEntity.class, HashSet.class, ArrayList.class, new String[]{""});
            newEventEntity.setId(null);
            newEventEntity.setTemplate(model.getNewTemplate());
            newEvents.add(newEventEntity);
        }
        this.templateEventService.save(model.getNewTemplate().getId(), newEvents);
    }

    private void processVisibilities(StaticTemplateMergeModel model) {
        TemplateEntity refTemplate = model.getReferenceTemplate();
        TemplateEntity mergedTemplate = model.getMergedTemplate();
        Set<TemplateVisibilityEntity> refVisibilities = this.templateVisibilityService.findDetailsByTemplateId(refTemplate.getId());
        Validate.notEmpty(refVisibilities, (String)"\u57fa\u51c6\u8868\u5355\u6a21\u677f\u7684\u53ef\u89c1\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<TemplateVisibilityEntity> mergedVisibilities = this.templateVisibilityService.findDetailsByTemplateId(mergedTemplate.getId());
        Validate.notEmpty(mergedVisibilities, (String)"\u5f85\u5408\u5e76\u8868\u5355\u6a21\u677f\u7684\u53ef\u89c1\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateVisibilityEntity refVisibility = refVisibilities.stream().filter(e -> StringUtils.equals((CharSequence)e.getVisibilityName(), (CharSequence)"create")).findAny().orElse(null);
        TemplateVisibilityEntity mergedVisibility = mergedVisibilities.stream().filter(e -> StringUtils.equals((CharSequence)e.getVisibilityName(), (CharSequence)"create")).findAny().orElse(null);
        Validate.isTrue((refVisibility != null && mergedVisibility != null ? 1 : 0) != 0, (String)"\u5408\u5e76\u6a21\u677f\u65f6\uff0c\u672a\u53d1\u73b0create\u53ef\u89c1\u6027\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        HashSet newVisibilities = Sets.newHashSet();
        this.buildTemplateVisibility(newVisibilities, refVisibility, mergedVisibility, model.getNewTemplate());
        Set<TemplateVisibilityEntity> visibilities = this.templateVisibilityService.save(model.getNewTemplate(), newVisibilities);
        model.getNewTemplate().setVisibility(visibilities);
    }

    private void buildTemplateVisibility(Set<TemplateVisibilityEntity> sets, TemplateVisibilityEntity refVisibility, TemplateVisibilityEntity mergedVisibility, TemplateEntity template) {
        TemplateVisibilityButtonsEntity newButtonEntity;
        TemplateVisibilityAttributesEntity refAttribute;
        TemplateVisibilityAttributesEntity newAttributeEntity;
        TemplateVisibilityAttributesEntity mergedAttribute;
        TemplateVisibilityEntity newVisibility = (TemplateVisibilityEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedVisibility, TemplateVisibilityEntity.class, HashSet.class, ArrayList.class, new String[]{""});
        newVisibility.setId(null);
        newVisibility.setTemplate(template);
        newVisibility.setAttributes((Set)Sets.newHashSet());
        newVisibility.setButtons((Set)Sets.newHashSet());
        sets.add(newVisibility);
        Set<TemplateVisibilityAttributesEntity> refAttributes = this.templateVisibilityAttributesRepository.findByVisiblId(refVisibility.getId());
        Validate.notEmpty(refAttributes, (String)"\u57fa\u51c6\u8868\u5355\u6a21\u677f\u7684\u53ef\u89c1\u6027\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<TemplateVisibilityAttributesEntity> mergedAttributes = this.templateVisibilityAttributesRepository.findByVisiblId(mergedVisibility.getId());
        Validate.notEmpty(mergedAttributes, (String)"\u5f85\u5408\u5e76\u8868\u5355\u6a21\u677f\u7684\u53ef\u89c1\u6027\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<String> intersections = this.intersections(refAttributes, mergedAttributes, TemplateVisibilityAttributesEntity::getAttributeName);
        Set<String> refMergedDiff = this.differences(refAttributes, mergedAttributes, TemplateVisibilityAttributesEntity::getAttributeName, true);
        Set<String> mergedRefDiff = this.differences(refAttributes, mergedAttributes, TemplateVisibilityAttributesEntity::getAttributeName, false);
        for (String propertyName : intersections) {
            if (this.matchExt(true, propertyName)) {
                mergedAttribute = mergedAttributes.stream().filter(e -> StringUtils.equals((CharSequence)propertyName, (CharSequence)e.getAttributeName())).findFirst().orElse(null);
                Validate.notNull((Object)mergedAttribute, (String)"\u672a\u627e\u5230\u5f85\u5408\u5e76\u6a21\u677f\u53ef\u89c1\u6027\u5c5e\u6027%s", (Object[])new Object[]{propertyName});
                newAttributeEntity = (TemplateVisibilityAttributesEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedAttribute, TemplateVisibilityAttributesEntity.class, HashSet.class, ArrayList.class, new String[]{""});
                newAttributeEntity.setId(null);
                newAttributeEntity.setTemplateVisibility(newVisibility);
                newVisibility.getAttributes().add(newAttributeEntity);
                continue;
            }
            refAttribute = refAttributes.stream().filter(e -> StringUtils.equals((CharSequence)propertyName, (CharSequence)e.getAttributeName())).findFirst().orElse(null);
            Validate.notNull((Object)refAttribute, (String)"\u672a\u627e\u5230\u57fa\u51c6\u6a21\u677f\u53ef\u89c1\u6027\u5c5e\u6027%s", (Object[])new Object[]{propertyName});
            newAttributeEntity = (TemplateVisibilityAttributesEntity)this.kuiperToolkitService.copyObjectByWhiteList(refAttribute, TemplateVisibilityAttributesEntity.class, HashSet.class, ArrayList.class, new String[]{""});
            newAttributeEntity.setId(null);
            newAttributeEntity.setTemplateVisibility(newVisibility);
            newVisibility.getAttributes().add(newAttributeEntity);
        }
        for (String propertyName : refMergedDiff) {
            refAttribute = refAttributes.stream().filter(e -> StringUtils.equals((CharSequence)propertyName, (CharSequence)e.getAttributeName())).findFirst().orElse(null);
            Validate.notNull((Object)refAttribute, (String)"\u672a\u627e\u5230\u57fa\u51c6\u6a21\u677f\u53ef\u89c1\u6027\u5c5e\u6027%s", (Object[])new Object[]{propertyName});
            newAttributeEntity = (TemplateVisibilityAttributesEntity)this.kuiperToolkitService.copyObjectByWhiteList(refAttribute, TemplateVisibilityAttributesEntity.class, HashSet.class, ArrayList.class, new String[]{""});
            newAttributeEntity.setId(null);
            newAttributeEntity.setTemplateVisibility(newVisibility);
            newVisibility.getAttributes().add(newAttributeEntity);
        }
        for (String propertyName : mergedRefDiff) {
            mergedAttribute = mergedAttributes.stream().filter(e -> StringUtils.equals((CharSequence)propertyName, (CharSequence)e.getAttributeName())).findFirst().orElse(null);
            Validate.notNull((Object)mergedAttribute, (String)"\u672a\u627e\u5230\u5f85\u5408\u5e76\u6a21\u677f\u53ef\u89c1\u6027\u5c5e\u6027%s", (Object[])new Object[]{propertyName});
            newAttributeEntity = (TemplateVisibilityAttributesEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedAttribute, TemplateVisibilityAttributesEntity.class, HashSet.class, ArrayList.class, new String[]{""});
            newAttributeEntity.setId(null);
            if (this.matchExt(false, propertyName)) {
                newAttributeEntity.setVisibilityType(Integer.valueOf(3));
            }
            newAttributeEntity.setTemplateVisibility(newVisibility);
            newVisibility.getAttributes().add(newAttributeEntity);
        }
        Set<TemplateVisibilityButtonsEntity> refButtons = this.templateVisibilityButtonRepository.findByVisiblId(refVisibility.getId());
        Validate.notEmpty(refAttributes, (String)"\u57fa\u51c6\u8868\u5355\u6a21\u677f\u7684\u53ef\u89c1\u6027\u6309\u94ae\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<TemplateVisibilityButtonsEntity> mergedButtons = this.templateVisibilityButtonRepository.findByVisiblId(mergedVisibility.getId());
        Validate.notEmpty(mergedAttributes, (String)"\u5f85\u5408\u5e76\u8868\u5355\u6a21\u677f\u7684\u53ef\u89c1\u6027\u6309\u94ae\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        intersections = this.intersections(refButtons, mergedButtons, TemplateVisibilityButtonsEntity::getControllerId);
        refMergedDiff = this.differences(refButtons, mergedButtons, TemplateVisibilityButtonsEntity::getControllerId, true);
        mergedRefDiff = this.differences(refButtons, mergedButtons, TemplateVisibilityButtonsEntity::getControllerId, false);
        for (String propertyName : Sets.union(intersections, mergedRefDiff)) {
            TemplateVisibilityButtonsEntity mergedButton = mergedButtons.stream().filter(e -> StringUtils.equals((CharSequence)propertyName, (CharSequence)e.getControllerId())).findFirst().orElse(null);
            Validate.notNull((Object)mergedButton, (String)"\u672a\u627e\u5230\u5f85\u5408\u5e76\u6a21\u677f\u6309\u94ae\u63a7\u4ef6%s", (Object[])new Object[]{propertyName});
            newButtonEntity = (TemplateVisibilityButtonsEntity)this.kuiperToolkitService.copyObjectByWhiteList(mergedButton, TemplateVisibilityButtonsEntity.class, HashSet.class, ArrayList.class, new String[]{""});
            newButtonEntity.setId(null);
            newButtonEntity.setTemplateVisibility(newVisibility);
            newVisibility.getButtons().add(newButtonEntity);
        }
        for (String propertyName : refMergedDiff) {
            TemplateVisibilityButtonsEntity refButton = refButtons.stream().filter(e -> StringUtils.equals((CharSequence)propertyName, (CharSequence)e.getControllerId())).findFirst().orElse(null);
            Validate.notNull((Object)refButton, (String)"\u672a\u627e\u5230\u57fa\u51c6\u6a21\u677f\u6309\u94ae\u63a7\u4ef6%s", (Object[])new Object[]{propertyName});
            newButtonEntity = (TemplateVisibilityButtonsEntity)this.kuiperToolkitService.copyObjectByWhiteList(refButton, TemplateVisibilityButtonsEntity.class, HashSet.class, ArrayList.class, new String[]{""});
            newButtonEntity.setId(null);
            newButtonEntity.setTemplateVisibility(newVisibility);
            newVisibility.getButtons().add(newButtonEntity);
        }
    }

    private boolean matchExt(boolean matchExt, String fieldName) {
        return matchExt ? Pattern.matches(EXT_PATTERN, fieldName) || Pattern.matches(EXTEND_PATTERN, fieldName) : !Pattern.matches(EXT_PATTERN, fieldName) && !Pattern.matches(EXTEND_PATTERN, fieldName);
    }
}

