/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateMaintainerEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.TemplateMaintainerRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateMaintainerService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TemplateMaintainerServiceImpl")
public class TemplateMaintainerServiceImpl
implements TemplateMaintainerService {
    @Autowired
    private UserService userService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private TemplateMaintainerRepository templateMaintainerRepository;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public void binding(String code, String[] maintainers, String[] maintainerAccounts, Principal principal) {
        Validate.notBlank((CharSequence)code, (String)"\u6388\u6743\u65f6\uff0c\u6307\u5b9a\u7684\u6a21\u677fcode\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String account = principal.getName();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (ArrayUtils.isEmpty((Object[])maintainerAccounts)) {
            maintainerAccounts = new String[]{"admin"};
        }
        ArrayList maintainerAccountList = Lists.newArrayList((Object[])maintainerAccounts);
        Validate.isTrue((boolean)maintainerAccountList.contains(account), (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6388\u6743\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
        List dbTemplates = this.templateService.findByCode(code);
        Validate.notEmpty((Collection)dbTemplates, (String)"\u6839\u636e\u6307\u5b9a\u7684\u6a21\u677fcode\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        for (TemplateEntity template : dbTemplates) {
            this.templateMaintainerRepository.unbindByTemplateId(template.getId());
        }
        if (ArrayUtils.isEmpty((Object[])maintainers)) {
            return;
        }
        for (String maintainer : maintainers) {
            for (TemplateEntity template : dbTemplates) {
                TemplateMaintainerEntity templateMaintainer = new TemplateMaintainerEntity();
                templateMaintainer.setCreateTime(new Date());
                templateMaintainer.setTemplate(template);
                templateMaintainer.setUserAccount(maintainer);
                templateMaintainer.setProjectName(this.platformContext.getAppName());
                this.templateMaintainerRepository.save(templateMaintainer);
            }
        }
    }

    @Override
    public Set<TemplateMaintainerEntity> findDetailsByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return Sets.newHashSet();
        }
        Set<TemplateMaintainerEntity> maintainers = this.templateMaintainerRepository.findByTemplateId(templateId);
        if (CollectionUtils.isEmpty(maintainers)) {
            return Sets.newHashSet();
        }
        for (TemplateMaintainerEntity maintainer : maintainers) {
            UserVo user = this.userService.findByAccount(maintainer.getUserAccount());
            maintainer.setUser(user);
        }
        return maintainers;
    }

    @Override
    public Set<TemplateMaintainerEntity> findByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return Sets.newHashSet();
        }
        return this.templateMaintainerRepository.findByTemplateId(templateId);
    }

    @Override
    @Transactional
    public void binding(String templateId, String[] accounts) {
        Validate.notEmpty((CharSequence)templateId, (String)"\u8868\u5355\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Object[])accounts, (String)"\u7ed1\u5b9a\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TemplateEntity template = this.templateService.findById(templateId);
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u6a21\u7248\u5bf9\u8c61\uff1a%s", (Object[])new Object[]{templateId});
        for (String account : accounts) {
            TemplateMaintainerEntity templateMaintainer = new TemplateMaintainerEntity();
            templateMaintainer.setCreateTime(new Date());
            templateMaintainer.setTemplate(template);
            templateMaintainer.setUserAccount(account);
            templateMaintainer.setProjectName(this.platformContext.getAppName());
            this.templateMaintainerRepository.save(templateMaintainer);
        }
    }
}

