/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityAttributesEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.starter.common.enums.TemplateLayoutTypeEnum;
import com.bizunited.platform.kuiper.starter.repository.TemplateVisibilityAttributesRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityAttributeService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TemplateVisibilityAttributeServiceImpl")
public class TemplateVisibilityAttributeServiceImpl
implements TemplateVisibilityAttributeService {
    @Autowired
    @Qualifier(value="KuiperToolkitService")
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private TemplateVisibilityAttributesRepository templateVisibilityAttributesRepository;
    @Autowired
    private PlatformContext platformContext;

    private void saveValidation(TemplateVisibilityEntity visibility, Set<TemplateVisibilityAttributesEntity> attributes) {
        Validate.notNull((Object)visibility, (String)"\u53ef\u89c1\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(attributes)) {
            return;
        }
        HashSet<String> controlIdSet = new HashSet<String>();
        for (TemplateVisibilityAttributesEntity attribute : attributes) {
            Validate.notBlank((CharSequence)attribute.getControllerId(), (String)"\u63a7\u4ef6\u5728\u8be5\u8868\u5355\u6a21\u677f\u4e0a\u7684\u552f\u4e00\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.notNull((Object)attribute.getNullable(), (String)"\u8be5\u63a7\u4ef6\u5728\u8fd9\u4e2a\u53ef\u89c1\u6027\u5b9a\u4e49\u4e0b\uff0c\u662f\u5426\u53ef\u4ee5\u4e0d\u586b\u5199\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.notNull((Object)attribute.getVisibilityType(), (String)"\u63a7\u4ef6\u7684\u53ef\u89c1\u6027\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Integer layoutType = attribute.getLayoutType() == null ? TemplateLayoutTypeEnum.PC.getType() : attribute.getLayoutType();
            Validate.isTrue((boolean)controlIdSet.add(StringUtils.join((Object[])new Serializable[]{layoutType, "|", attribute.getControllerId()})), (String)"\u5c5e\u6027controllerId\u7f16\u53f7\u91cd\u590d,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public Set<TemplateVisibilityAttributesEntity> save(TemplateVisibilityEntity visibility, Set<TemplateVisibilityAttributesEntity> attributes) {
        if (attributes == null) {
            attributes = new HashSet<TemplateVisibilityAttributesEntity>();
        }
        this.saveValidation(visibility, attributes);
        HashSet<TemplateVisibilityAttributesEntity> savedAttributes = new HashSet<TemplateVisibilityAttributesEntity>();
        Set<TemplateVisibilityAttributesEntity> oldAttributes = this.templateVisibilityAttributesRepository.findByVisiblId(visibility.getId());
        if (oldAttributes == null) {
            oldAttributes = new HashSet<TemplateVisibilityAttributesEntity>();
        }
        HashMap<String, TemplateVisibilityAttributesEntity> attributesMap = new HashMap<String, TemplateVisibilityAttributesEntity>(16);
        for (TemplateVisibilityAttributesEntity attribute2 : attributes) {
            Integer layoutType = attribute2.getLayoutType() == null ? TemplateLayoutTypeEnum.PC.getType() : attribute2.getLayoutType();
            attribute2.setLayoutType(layoutType);
            String key = StringUtils.join((Object[])new Serializable[]{layoutType, "|", attribute2.getControllerId()});
            attributesMap.put(key, attribute2);
        }
        HashSet addAttributes = new HashSet();
        HashSet updateAttributes = new HashSet();
        HashSet deleteAttributes = new HashSet();
        this.kuiperToolkitService.collectionDiscrepancy(attributes, oldAttributes, attribute -> {
            Integer layoutType = attribute.getLayoutType() == null ? TemplateLayoutTypeEnum.PC.getType() : attribute.getLayoutType();
            return StringUtils.join((Object[])new Serializable[]{layoutType, "|", attribute.getControllerId()});
        }, deleteAttributes, updateAttributes, addAttributes);
        for (TemplateVisibilityAttributesEntity attribute3 : addAttributes) {
            attribute3.setId(null);
            attribute3.setTemplateVisibility(visibility);
            attribute3.setProjectName(this.platformContext.getAppName());
            this.templateVisibilityAttributesRepository.save(attribute3);
            savedAttributes.add(attribute3);
        }
        for (TemplateVisibilityAttributesEntity attribute3 : updateAttributes) {
            Integer layoutType = attribute3.getLayoutType() == null ? TemplateLayoutTypeEnum.PC.getType() : attribute3.getLayoutType();
            String key = StringUtils.join((Object[])new Serializable[]{layoutType, "|", attribute3.getControllerId()});
            TemplateVisibilityAttributesEntity newAttribute = (TemplateVisibilityAttributesEntity)attributesMap.get(key);
            attribute3.setLayoutType(layoutType);
            attribute3.setTemplateVisibility(visibility);
            attribute3.setNullable(newAttribute.getNullable());
            attribute3.setVisibilityType(newAttribute.getVisibilityType());
            attribute3.setControllerId(newAttribute.getControllerId());
            attribute3.setProjectName(this.platformContext.getAppName());
            this.templateVisibilityAttributesRepository.save(attribute3);
            savedAttributes.add(attribute3);
        }
        return savedAttributes;
    }

    @Override
    @Transactional
    public void deleteByVisibilityId(String visibilityId) {
        Set<TemplateVisibilityAttributesEntity> attributes = this.templateVisibilityAttributesRepository.findByVisiblId(visibilityId);
        if (!CollectionUtils.isEmpty(attributes)) {
            this.templateVisibilityAttributesRepository.deleteAll(attributes);
        }
    }

    @Override
    public Set<TemplateVisibilityAttributesEntity> findByVisibilityIdAndLayoutType(String visibilityId, Integer layoutType) {
        if (StringUtils.isBlank((CharSequence)visibilityId)) {
            return Sets.newHashSet();
        }
        if (layoutType == null) {
            layoutType = TemplateLayoutTypeEnum.PC.getType();
        }
        return this.templateVisibilityAttributesRepository.findByVisibilityIdAndLayoutType(visibilityId, layoutType);
    }
}

